//=============================================================================
// Bot_GuntherHermann.
//=============================================================================
class Bot_GuntherHermann extends Bot;

function SpawnGibbedCarcass()
{
  	local FleshFragment chunk;
  	local float size;
  	local vector loc;
  	local int i;
	local DeusExFragment ss;

  	size = (CollisionRadius + CollisionHeight) / 2;
  	if (size > 10.0)
  	{
		for (i=0; i<size/4.0; i++)
		{
			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;
			chunk = spawn(class'FleshFragment', None,, loc);
			if (chunk != None)
			{
				chunk.DrawScale = size / 25;
				chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
				chunk.bFixedRotationDir = True;
				chunk.RotationRate = RotRand(False);
			}
			ss = Spawn(class'MetalFragment', Owner);
			if (ss != None)
			{
				ss.Instigator = Instigator;
				ss.CalcVelocity(Velocity, 256);
				ss.DrawScale = 0.5;
				ss.Skin = GetMeshTexture();
				if (FRand() < 0.75)
					ss.bSmoking = True;
			}                                                      
		}
  	}
}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
      	local FleshFragment chunk;
      	local float size;
      	local vector loc;
      	local int i;
	local DeusExFragment ss;
		
      	if (Gibbed('')) 
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				chunk = spawn(class'FleshFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
				ss = Spawn(class'MetalFragment', Owner);
				if (ss != None)
				{
					ss.Instigator = Instigator;
					ss.CalcVelocity(Velocity, 256);
					ss.DrawScale = 0.5;
					ss.Skin = GetMeshTexture();
					if (FRand() < 0.75)
						ss.bSmoking = True;
				}                           
			}
		}
		return None;
	}
	
	carc = DeusExCarcass(Spawn(CarcassType));

	if ( carc != None )
	{
		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;
	}
	return carc;
}

defaultproperties
{
     CarcassType=Class'DeusEx.GuntherHermannCarcass'
     BaseAggressiveness=0.500000
     TauntPortrait=Texture'DeusEx.Taunts.gh_tp'
     FavoriteWeapon=Class'DeusEx.WeaponFlamethrower'
     Drown=Sound'DeusEx.Player.MechUnconscious'
     breathagain=Sound'DeusEx.Player.MechHit1'
     GaspSound=Sound'DeusEx.Player.MechHit2'
     JumpSound=Sound'DeusEx.Player.MechJump'
     Die2=Sound'DeusEx.Player.MechDie'
     Die3=Sound'DeusEx.Player.MechDie'
     BaseEyeHeight=44.000000
     HitSound1=Sound'DeusEx.Player.MechHit1'
     HitSound2=Sound'DeusEx.Player.MechHit2'
     Land=Sound'DeusEx.Player.MechJump'
     Die=Sound'DeusEx.Player.MechDie'
     CombatStyle=0.200000
     Texture=Texture'DeusExItems.Skins.BlackMaskTex'
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt_B'
     DrawScale=1.100000
     MultiSkins(0)=Texture'DeusExCharacters.Skins.GuntherHermannTex1'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.PantsTex9'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.GuntherHermannTex0'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.GuntherHermannTex0'
     MultiSkins(4)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.BlackMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=24.200001
     CollisionHeight=55.660000
     BindName="GuntherHermann"
     FamiliarName="Gunther Hermann"
     UnfamiliarName="Gunther Hermann"
}
