//=============================================================================
// CageLight.
//=============================================================================
class CageLight extends DeusExDecoration;

enum ESkinColor
{
	SC_1,
	SC_2,
	SC_3,
	SC_4,
	SC_5,
	SC_6
};

var() ESkinColor SkinColor;
var() bool bOn;

//-----------------------------------
// Uses HDTP's models/textures if they exists ;)
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPCageLight",class'mesh', true));
     if(HDTPmesh != none)
     {
        mesh = HDTPmesh;
     }
 super.prebeginplay();
}
//----------------------------------------


function Trigger(Actor Other, Pawn Instigator)
{
	Super.Trigger(Other, Instigator);

	if (!bOn)
	{
		bOn = True;
		LightType = LT_Steady;
		bUnlit = True;
		ScaleGlow = 2.0;
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		bUnlit = False;
		ScaleGlow = 1.0;
	}
}

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_1:	

								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex1",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex1",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex1'; 
									}
								break;

		case SC_2:	
								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex2",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex2",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex2'; 
									}
								break;

		case SC_3:	
								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex3",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex3",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex3';
									}
								break;

		case SC_4:	
								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex4",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex4",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex4';
									}
								break;

		case SC_5:	
								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex5",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex5",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex5'; 
									}
								break;

		case SC_6:	
								Multiskins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex6",class'texture', true));
								Multiskins[2] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCageLightTex6",class'texture', true));
									If ((MultiSkins[1]==none) && (MultiSkins[2]==none))
									{
									Skin = Texture'CageLightTex6'; 
									}
								break;
	}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

	if (!bOn)
		LightType = LT_None;
}

defaultproperties
{
     bOn=True
     HitPoints=5
     bInvincible=True
     FragType=Class'DeusEx.GlassFragment'
     bHighlight=False
     bCanBeBase=True
     ItemName="Light Fixture"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'DeusExDeco.CageLight'
     ScaleGlow=2.000000
     CollisionRadius=17.139999
     CollisionHeight=17.139999
     LightType=LT_Steady
     LightBrightness=255
     LightHue=32
     LightSaturation=224
     LightRadius=8
     Mass=20.000000
     Buoyancy=10.000000
}
