//=============================================================================
// CeilingFan.
//=============================================================================
class CeilingFan extends DeusExDecoration;

enum ESkinColor
{
	SC_WoodBrass,
	SC_DarkWoodIron,
	SC_White,
	SC_WoodBrassFancy,
	SC_WoodPlastic
};

var() ESkinColor SkinColor;



//-----------------------------------
// Uses HDTP's models/textures if they exists ;)
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPceilingfan",class'mesh', true));
     if(HDTPmesh != none)
     {
        mesh = HDTPmesh;
        //default.mesh = HDTPmesh; //just in case
     }
 super.prebeginplay();
}
//----------------------------------------




function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_WoodBrass:		
										MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex1",class'texture'));
										if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex1'; 
													}
													break;
		case SC_DarkWoodIron:	
										MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex2",class'texture'));
										if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex2'; 
													}
													break;
		case SC_White:			
										MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex3",class'texture'));
										if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex3'; 
													}
													break;
		case SC_WoodBrassFancy:	
										MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex4",class'texture'));
										if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex4'; 
													}
													break;
		case SC_WoodPlastic:	
										MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex5",class'texture'));
										if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex5'; 
													}
													break;
	}
}

defaultproperties
{
     SkinColor=SC_DarkWoodIron
     FragType=Class'DeusEx.WoodFragment'
     bHighlight=False
     bCanBeBase=True
     ItemName="Ceiling Fan Blades"
     bPushable=False
     Physics=PHYS_Rotating
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.CeilingFan'
     CollisionRadius=45.750000
     CollisionHeight=3.300000
     bCollideWorld=False
     bFixedRotationDir=True
     Mass=50.000000
     Buoyancy=30.000000
     RotationRate=(Yaw=16384)
}
