//=============================================================================
// CeilingFanMotor.
//=============================================================================
class CeilingFanMotor extends DeusExDecoration;

enum ESkinColor
{
	SC_WoodBrass,
	SC_DarkWoodIron,
	SC_White,
	SC_WoodBrassFancy,
	SC_WoodPlastic
};

var() ESkinColor SkinColor;



//-----------------------------------
// Uses HDTP's models/textures if they exists ;)
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPceilingfanmotor",class'mesh', true));
     if(HDTPmesh != none)
     {
        mesh = HDTPmesh;
        //default.mesh = HDTPmesh; //just in case
     }
 super.prebeginplay();
}
//----------------------------------------


function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_WoodBrass:		
													MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex1",class'texture', true));
													if (MultiSkins[1]==none)
													{
														Skin = Texture'CeilingFanTex1'; 
													}
													break;

		case SC_DarkWoodIron:	
													MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex2",class'texture', true));
													if (MultiSkins[1]==none)
													{
														Skin = Texture'CeilingFanTex2'; 
													}
													break;

		case SC_White:				
													MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex3",class'texture', true));
													if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex3'; 
													}
													break;

		case SC_WoodBrassFancy:	
													MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex4",class'texture', true));
													if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex4'; 
													}
													break;

		case SC_WoodPlastic:	
													MultiSkins[1] = texture(dynamicloadObject("HDTPDecos.Skins.HDTPCeilingFanTex5",class'texture', true));
													if (MultiSkins[1]==none)
													{
													Skin = Texture'CeilingFanTex5'; 
													}
													break;
	}
}

defaultproperties
{
     SkinColor=SC_DarkWoodIron
     bInvincible=True
     bHighlight=False
     bCanBeBase=True
     ItemName="Ceiling Fan Motor"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'DeusExDeco.CeilingFanMotor'
     SoundRadius=12
     SoundVolume=160
     AmbientSound=Sound'DeusExSounds.Generic.MotorHum'
     CollisionRadius=12.000000
     CollisionHeight=4.420000
     bCollideWorld=False
     Mass=50.000000
     Buoyancy=30.000000
}
