//=============================================================================
// ChargedPickup.
//=============================================================================
class ChargedPickup extends DeusExPickup
	abstract;

var() class<Skill> skillNeeded;
var() bool bOneUseOnly;
var() sound ActivateSound;
var() sound DeactivateSound;
var() sound LoopSound;
var travel bool bIsActive;
var localized String ChargeRemainingLabel;
var Texture EffectTexture;
var travel int MaxCharge;

// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------
simulated function PreBeginPlay()
{
        Super.PreBeginPlay();
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local DeusExPlayer player;
	local String outText;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		winInfo.SetTitle(itemName);
		winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

		outText = ChargeRemainingLabel @ Int(GetCurrentCharge()) $ "%";
		winInfo.AppendText(outText);
	}

	return True;
}

// ----------------------------------------------------------------------
// GetCurrentCharge()
// ----------------------------------------------------------------------

simulated function Float GetCurrentCharge()
{
	return (Float(Charge) / Float(Default.Charge)) * 100.0;
}

// ----------------------------------------------------------------------
// ChargedPickupBegin()
// ----------------------------------------------------------------------

function ChargedPickupBegin(DeusExPlayer Player)
{
	Player.AddChargedDisplay(Self);
	PlaySound(ActivateSound, SLOT_None);
	if (LoopSound != None)
		AmbientSound = LoopSound;
   
      	if (DeusExRootWindow(Player.rootWindow) != None)
         		DeusExRootWindow(Player.rootWindow).DeleteInventory(self);

      	bInObjectBelt=False;
      	BeltPos=default.BeltPos;

      	bIsActive = True;
}

// ----------------------------------------------------------------------
// ChargedPickupEnd()
// ----------------------------------------------------------------------

function ChargedPickupEnd(DeusExPlayer Player)
{
	Player.RemoveChargedDisplay(Self);
	PlaySound(DeactivateSound, SLOT_None);
	if (LoopSound != None)
		AmbientSound = None;

	// remove it from our inventory if this is a one
	// use item
	if (bOneUseOnly)
		Player.DeleteInventory(Self);

	bIsActive = False;
}

// ----------------------------------------------------------------------
// IsActive()
// ----------------------------------------------------------------------

simulated function bool IsActive()
{
	return bIsActive;
}

// ----------------------------------------------------------------------
// ChargedPickupUpdate()
// ----------------------------------------------------------------------

function ChargedPickupUpdate(DeusExPlayer Player)
{
}

// ----------------------------------------------------------------------
// CalcChargeDrain()
// ----------------------------------------------------------------------

simulated function int CalcChargeDrain(DeusExPlayer Player)
{
	local float skillValue;
	local float drain;

	drain = 4.0;
	skillValue = 1.0;

	if (skillNeeded != None)
		skillValue = Player.SkillSystem.GetSkillLevelValue(skillNeeded);
	drain *= skillValue;

	return Int(drain);
}

// ----------------------------------------------------------------------
// function UsedUp()
//
// copied from Pickup, but modified to keep items from
// automatically switching
// ----------------------------------------------------------------------

function UsedUp()
{
	local DeusExPlayer Player;

	if ( Pawn(Owner) != None )
	{
		bActivatable = false;
		Pawn(Owner).ClientMessage(ExpireMessage);	
	}
	Owner.PlaySound(DeactivateSound);
	Player = DeusExPlayer(Owner);

	if (Player != None)
	{
		if (Player.inHand == Self)
			ChargedPickupEnd(Player);
	}

	Destroy();
}

// ----------------------------------------------------------------------
// state DeActivated
// ----------------------------------------------------------------------

state DeActivated
{
}

// ----------------------------------------------------------------------
// state Activated
// ----------------------------------------------------------------------

state Activated
{
	function Timer()
	{
		local DeusExPlayer Player;

		Player = DeusExPlayer(Owner);
		if (Player != None)
		{
			ChargedPickupUpdate(Player);
		}
			if (Charge <= 0)
				UsedUp();
	}

	function BeginState()
	{
		local DeusExPlayer Player;

		Super.BeginState();
                		SetTimer(0.1, True);
		Player = DeusExPlayer(Owner);
		if (Player != None)
		{
			// remove it from our inventory, but save our owner info
			if (bOneUseOnly)
			{
//				Player.DeleteInventory(Self);	
				SetOwner(Player);
			}
			ChargedPickupBegin(Player);
		}
	}

	function EndState()
	{
		local DeusExPlayer Player;

		Super.EndState();
                		SetTimer(0.1, False);
		Player = DeusExPlayer(Owner);
		if (Player != None)
		{
			ChargedPickupEnd(Player);
		}
	}

	function Activate()
	{
		// if this is a single-use item, don't allow the player to turn it off
		if (bOneUseOnly)
			return;

		Super.Activate();
	}
}

function ArmorImpactEffect(vector HitLocation)
{
        	local DeusExPlayer player;

        	player = DeusExPlayer(Owner);
   
        	if (player != None)
	{
		player.SetDamagePercent(Float(ArmorAbsorption)/100);
                		player.ClientFlash(0.01, vect(0, 0, 100));
	}
}

function bool HandlePickupQuery( inventory Item )
{
	local Pawn player;
	local Inventory anItem;
	local Bool bAlreadyHas;
	local Bool bResult;

	if ( Item.Class == Class )
	{
		player = Pawn(Owner);
		bResult = False;
		
		anItem = player.FindInventoryType(Item.Class);

     		if ( anItem != None ) 
		{
                        		if ( bCanHaveMultipleCopies )
			{
			     	Charge += Item.Charge;
				if ( Charge >= MaxCharge )
					Charge = MaxCharge;
			}
			else if ( Charge <= Item.Charge )
			{
				if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )	
                             				Charge = Item.Charge;
				else
				{
					Charge += Item.Charge;
					if ( Charge >= MaxCharge )
						Charge = MaxCharge;
				}
			}        
			bResult = True;
		}
                
		if ( bResult )
		{
                        		player.PlaySound(ActivateSound,SLOT_None);
			player.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
                        
	                		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
                                 			Item.SetRespawn();
                        		else				
                                 			Item.Destroy();
		}
		else
		{
			bResult = Super.HandlePickupQuery(Item);
		}

		// Update object belt text
		if ( bResult )			
			UpdateBeltText();	

		return bResult;
	}

	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function BecomePickup()
{
	if ( Physics != PHYS_Falling )
		RemoteRole    = ROLE_SimulatedProxy;
	Mesh          = PickupViewMesh;
	DrawScale     = PickupViewScale;
	bOnlyOwnerSee = false;
	bHidden       = false;
	bCarriedItem  = false;
	NetPriority   = 1.4;
	if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
           		SetCollision( true, false, false );	
        	else
           		SetCollision( true, true, false );
}

auto state Pickup
{
	function Touch( actor Other )
	{
		local Inventory Copy;               
                		local DeusExPlayer Player;

                		Player = DeusExPlayer(GetPlayerPawn());

	        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || Player.bAutoPickup )
                		{       

            	    		if ( ValidTouch(Other) ) 
		    	{
				Copy = SpawnCopy(Pawn(Other));
                        			if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
				if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) 
                                			Copy.Activate();
                        			if ( PickupMessageClass == None )
					Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
				else
					Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
				Pawn(Other).PlaySound (ActivateSound,SLOT_None);
                      			ChargedPickup(Copy).PickupFunction(Pawn(Other));
		     	}
                 		}
	}		
}

function ApplySkillUpgrade(Pawn Other)
{
	local int SkillLevel;
	local DeusExPlayer P;

	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
		return;

	P = DeusExPlayer(Other);
	
	if ( (P != None) && (P.SkillSystem != None) )
	{
		if ( skillNeeded != None )
		{
			SkillLevel = Int(P.SkillSystem.GetSkillLevel(skillNeeded));
			MaxCharge = Default.MaxCharge * (SkillLevel +1);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     bOneUseOnly=True
     ActivateSound=Sound'DeusExSounds.Pickup.PickupActivate'
     DeActivateSound=Sound'DeusExSounds.Pickup.PickupDeactivate'
     ChargeRemainingLabel="Charge remaining:"
     MaxCharge=5000
     bCanHaveMultipleCopies=True
     bActivatable=True
     bDisplayableInv=False
     RespawnTime=60.000000
     Charge=2000
}
