//=============================================================================
// Cigarettes.
//=============================================================================
class Cigarettes extends DeusExPickup;

simulated function PreBeginPlay()
{
     local texture HDTPtex;

     Super.PreBeginPlay();

     HDTPtex = Texture(dynamicloadObject("HDTPitems.Skins.HDTPcigarettesTex2",class'texture', true));
     if(HDTPtex != none)
     {
	        skin = HDTPtex;
     }
 super.prebeginplay();
//----------------------------------------

    if ( Level.Game.Difficulty == 3 )
		MaxCopies = 5;
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer P;
		local vector loc;
		local rotator rot;
		local CigsSmoke puff;
		
		Super.BeginState();

		P = DeusExPlayer(Owner);
		if (P != None)
		{
			P.StopPoison();
                        P.drugEffectTimer = 0;
			loc = Owner.Location;
			rot = Owner.Rotation;
			loc += 2.0 * Owner.CollisionRadius * vector(P.ViewRotation);
			loc.Z += Owner.CollisionHeight * 0.9;
			puff = Spawn(class'CigsSmoke', Owner,, loc, rot);
			PlaySound(sound'MaleCough');
		}

		UseOnce();
	}
Begin:
}

defaultproperties
{
     maxCopies=10
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Cigarettes"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Cigarettes'
     PickupViewMesh=LodMesh'DeusExItems.Cigarettes'
     ThirdPersonMesh=LodMesh'DeusExItems.Cigarettes'
     Icon=Texture'DeusExUI.Icons.BeltIconCigarettes'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCigarettes'
     largeIconWidth=29
     largeIconHeight=43
     Description="'COUGHING NAILS -- when you've just got to have a cigarette.'"
     beltDescription="CIGS"
     bDifficulty3=False
     Mesh=LodMesh'DeusExItems.Cigarettes'
     CollisionRadius=5.200000
     CollisionHeight=1.320000
     Mass=2.000000
     Buoyancy=3.000000
}
