//=============================================================================
// CigsSmoke.
//=============================================================================
class CigsSmoke extends DeusExProjectile;

simulated function Tick(float deltaTime)
{
	local float value;
	local float sizeMult;

	time += deltaTime;

	value = 1.0+time;
	if (MinDrawScale > 0)
		sizeMult = MaxDrawScale/MinDrawScale;
	else
		sizeMult = 1;

	DrawScale = (-sizeMult/(value*value) + (sizeMult+1))*MinDrawScale;
	ScaleGlow = Default.ScaleGlow/(value*value*value);

}

function ZoneChange(ZoneInfo NewZone)
{
	Super.ZoneChange(NewZone);

	if (NewZone.bWaterZone)
		Destroy();
}

defaultproperties
{
     blastRadius=1.000000
     DamageType=TearGas
     AccurateRange=320
     maxRange=320
     maxDrawScale=2.000000
     bIgnoresNanoDefense=True
     speed=400.000000
     MaxSpeed=400.000000
     Damage=1.000000
     MomentumTransfer=10
     LifeSpan=1.000000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'Effects.Smoke.SmokePuff1'
     DrawScale=0.010000
     bUnlit=True
}
