//=============================================================================
// CleanerBot2.
//=============================================================================
class CleanerBot2 extends Robot;

var () Float ExplosionRadius;

function Tick( Float DeltaTime )
{
	local float dist;

	Super.Tick( DeltaTime );
	
	if ( bInvincible )
		return;

	if ( !bCollideActors && !bBlockActors && !bBlockPlayers )
		return;

	if ( EMPHitPoints > 0 )
	{
		if ( Enemy != None )
		{
			dist = VSize(Enemy.Location - Location); 
			if ( (dist < ExplosionRadius) && LineOfSightTo(Enemy, true) )
			{
				PlaySound(Sound'RatDie', SLOT_None,,, 2048);
				TakeDamage(Health*10, Self, Location, vect(0,0,0), 'Sabot');
			}
		}
	}
}

function Explode(vector HitLocation)
{
	local int i;
	local DeusExFragment s;
	local ExplosionLight light;

	PlaySound(explosionSound, SLOT_None, 2.0,, 2048);

	AISendEvent('LoudNoise', EAITYPE_Audio, , ExplosionRadius*16);

	light = Spawn(class'ExplosionLight',,, HitLocation);
	if ( light != None )
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location);
	
	for (i=0; i<5; i++)
	{
		s = Spawn(class'MetalFragment', Owner);
		if (s != None)
		{
			s.Instigator = Instigator;
			s.CalcVelocity(Velocity, ExplosionRadius);
			s.DrawScale = 0.5;
			s.Skin = GetMeshTexture();
			if (FRand() < 0.75)
				s.bSmoking = True;
		}
	}

	HurtRadius(20, ExplosionRadius, 'Exploded', 100*ExplosionRadius, Location);
}
		

defaultproperties
{
     explosionRadius=96.000000
     Orders=WaitingFor
     WalkingSpeed=0.200000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponCleanerBot')
     GroundSpeed=330.000000
     WaterSpeed=50.000000
     AirSpeed=144.000000
     AccelRate=1024.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.CleanerBot'
     SoundRadius=16
     SoundVolume=128
     AmbientSound=Sound'DeusExSounds.Robot.CleanerBotMove'
     CollisionRadius=18.000000
     CollisionHeight=11.210000
     Mass=70.000000
     Buoyancy=97.000000
     RotationRate=(Yaw=100000)
     BindName="DetonatorBot"
     FamiliarName="Detonator Bot"
     UnfamiliarName="Detonator Bot"
}
