//=============================================================================
// CombatKnife.
//=============================================================================
class CombatKnife extends DeusExProjectile;

var float		mpDamage;
var int		mpAccurateRange;
var int		mpMaxRange;

simulated function Tick(float deltaTime)
{
	local Rotator rot;

	if (bStuck)
		return;

	Super.Tick(deltaTime);

	if (Level.Netmode != NM_DedicatedServer)
	{
		rot = Rotation;
		rot.Roll += 16384;
		rot.Pitch -= 16384;
		SetRotation(rot);
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	if ( Level.Game.bDeathMatch )
	{
		Damage = mpDamage;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

simulated function Destroyed()
{
	if ( (damagee != None) && (damagee.IsA('Decoration') || damagee.IsA('ProdEffect')) )
		Spawn (spawnWeaponClass);
	Super.Destroyed();
}

defaultproperties
{
     mpDamage=45.000000
     mpAccurateRange=1200
     mpMaxRange=1600
     bBlood=True
     bStickToWall=True
     DamageType=shot
     spawnWeaponClass=Class'DeusEx.WeaponCombatKnife'
     bIgnoresNanoDefense=True
     ItemName="Combat Knife"
     ItemArticle="a"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=30.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Mesh=LodMesh'DeusExItems.CombatKnifePickup'
     CollisionRadius=12.000000
     CollisionHeight=1.000000
}
