//=============================================================================
// Crosshair.
//=============================================================================
class Crosshair extends Window;

var DeusExPlayer myPlayer;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local Color col;
	local DeusExRootWindow root;
	        
	Super.InitWindow();

	root = DeusExRootWindow(GetRootWindow());
	myPlayer = DeusExPlayer(root.parentPawn);
                
	SetBackgroundStyle(DSTY_Masked);

	if ( myPlayer.IsA('BotPlayer') )
		SetBackground(Texture'MyCross1');
	else if ( myPlayer.IsA('HardcorePlayer') )
		SetBackground(Texture'MyCross3');
	else
		SetBackground(Texture'CrossSquare');

	col.R = 255;
	col.G = 255;
	col.B = 255;
	SetCrosshairColor(col);    
}

// ----------------------------------------------------------------------
// SetCrosshair()
// ----------------------------------------------------------------------

function SetCrosshair( bool bShow )
{
	local bool bDrawCrosshair;

	if ( (myPlayer.Weapon != None) && myPlayer.Weapon.bOwnsCrossHair )
		bDrawCrosshair = False;	
	else 
		bDrawCrosshair = bShow;

	Show(bDrawCrosshair);
}

// ----------------------------------------------------------------------
// SetCrosshairColor()
// ----------------------------------------------------------------------

function SetCrosshairColor(color newColor)
{
	SetTileColor(newColor);
}

defaultproperties
{
}
