//=============================================================================
// CyborgDog.  Copyright (C) 2001 Hejhujka.
//=============================================================================
class CyborgDog extends Dog;

var(Sounds) sound SearchingSound;
var(Sounds) sound SpeechTargetAcquired;
var(Sounds) sound SpeechTargetLost;
var(Sounds) sound SpeechOutOfAmmo;
var(Sounds) sound SpeechCriticalDamage;
var(Sounds) sound SpeechScanning;
var(Sounds) sound SpeechAreaSecure;

var () travel int EMPHealth;
var localized String DogDeactivated;

function bool ShouldFlee()
{
        	return (Health <= MinHealth);
}

function bool ShouldDropWeapon()
{
	return false;
}

function Carcass SpawnCarcass()
{
	Explode();
	return None;
}

function bool WillTakeStompDamage(actor stomper)
{
	return false;
}

function Deactivate()
{
        	local Binoculars cd;
	local DeusExPlayer P;

	if ( (Owner != None) && Owner.IsA('DeusExPlayer') )
		P = DeusExPlayer(Owner);
	else
		P = DeusExPlayer(GetPlayerPawn());

        	cd = Spawn(class'Binoculars', Self,, Location, Rotation);
	Destroy();
	if ( P != None )
		P.ClientMessage(DogDeactivated);
}

function AcquireEnemy()
{
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( SetEnemy(P) )
			HandleEnemy();			
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
	PlaySound(Sound'CloakUp');
        	Deactivate();
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	if ( (damageType == 'Poison') || (damageType == 'PoisonEffect') || (damageType == 'PoisonGas')
           		|| (damageType == 'Radiation') || (damageType == 'HalonGas') )
		return 0.0;
	else if ( damageType == 'Shocked' )
                		return 0.5;
	else if ( (damageType == 'KnockedOut') || (damageType == 'Fell') )
		return 0.25;
	else if ( damageType == 'EMP' )
	{
		EMPHealth -= Damage;
		if ( EMPHealth <= 0 ) 
			Deactivate();  
		return 0.0;              		
	}
	else 
		return Super.ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);
}

function bool FilterDamageType(Pawn instigatedBy, Vector hitLocation,
                               Vector offset, Name damageType)
{
	if ( (instigatedBy != None) && (instigatedBy.IsA('DeusExPlayer') || instigatedBy.IsA('CyborgDog')) )
		return false;
	else
		return Super.FilterDamageType(instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if ( !bCollideActors && !bBlockActors && !bBlockPlayers )
		 return;
	else if ( CanShowPain() )
		TakeHit(hitPos);
	else
		GotoNextState();
}

function SupportActor(Actor standingActor)
{
}

function ComputeFallDirection(float totalTime, int numFrames, out vector moveDir, out float stopTime)
{
}

function Explode()
{
	local int i;
	local ExplosionLight light;
	local DeusExFragment s;
	       
	AISendEvent('LoudNoise', EAITYPE_Audio, , 4096);
	PlaySound(Sound'RobotExplode', SLOT_None,,, 4096);
	
	light = Spawn(class'ExplosionLight',,, Location);
	if ( light != None )
        		light.size = 8;
                			
	Spawn(class'ExplosionMedium',,, Location);

	for (i=0; i<10; i++)
	{
		s = Spawn(class'MetalFragment', Owner);
		if ( s != None )
		{
			s.Instigator = Instigator;
			s.CalcVelocity(Velocity, 256);
			s.DrawScale = 0.5;
			s.Skin = GetMeshTexture();
			if ( FRand() < 0.75 )
				s.bSmoking = True;
		}
	}
	
        	HurtRadius(150, 192, 'Exploded', 10000, Location);
        	Destroy();
}

function PlayTurning()
{
	LoopAnimPivot('Walk');
}

function PlayWeaponSwitch(Weapon newWeapon)
{
}

function PlayTargetAcquiredSound()
{
	PlaySound(SpeechTargetAcquired, SLOT_None,,, 2048, 2.0);
}

function PlayTargetLostSound()
{
	PlaySound(SpeechTargetLost, SLOT_None,,, 2048, 2.0);
}

function PlayGoingForAlarmSound()
{
}

function PlayOutOfAmmoSound()
{
	PlaySound(SpeechOutOfAmmo, SLOT_None,,, 2048, 2.0);
}

function PlayCriticalDamageSound()
{
	PlaySound(SpeechCriticalDamage, SLOT_None,,, 2048, 2.0);
}

function PlayAreaSecureSound()
{
	PlaySound(SpeechAreaSecure, SLOT_None,,, 2048, 2.0);
}

function TweenToRunningAndFiring(float tweentime)
{
	bIsWalking = False;
	TweenAnimPivot('Run', tweentime);
}

function PlayRunningAndFiring()
{
	bIsWalking = False;
	LoopAnimPivot('Run');
}

function TweenToShoot(float tweentime)
{
	TweenAnimPivot('Still', tweentime);
}

function PlayShoot()
{
	LoopAnimPivot('BreatheLight',3,0.01);
}

function TweenToAttack(float tweentime)
{
	TweenAnimPivot('Still', tweentime);
}

function PlayAttack()
{
	PlayAnimPivot('Still');
}

function PlayFalling()
{
}

function TweenToWalking(float tweentime)
{
	bIsWalking = True;
	TweenAnimPivot('Walk', tweentime);
}

function PlayWalking()
{
	bIsWalking = True;
	LoopAnimPivot('Walk');
}

function TweenToRunning(float tweentime)
{
	bIsWalking = False;
	PlayAnimPivot('Run',, tweentime);
}

function PlayRunning()
{
	bIsWalking = False;
	LoopAnimPivot('Run');
}

function PlayDuck()
{
	TweenAnimPivot('Still', 0.25);
}

function PlayRising()
{
	PlayAnimPivot('Still');
}

function PlayCrawling()
{
	LoopAnimPivot('Still');
}

function PlayFiring()
{
	LoopAnimPivot('Bark',2,0.01);
}

function PlayReloadBegin()
{
}

function PlayReload()
{
}

function PlayReloadEnd()
{
}

function PlayDogBark()
{
        	If (FRand() < 0.4)
               		PlaySound(SpeechScanning, SLOT_None,,, 2048, 2.0); 
        	else
               		PlaySound(sound'DogSmallBark1', SLOT_None,,, 2048);
}

function bool SwitchToBestWeapon()
{
	local float rating;
	local int usealt;
        
	if ( Inventory == None )
		return false;         

	PendingWeapon = Inventory.RecommendWeapon(rating, usealt);
        	SetWeapon(PendingWeapon);

	if ( PendingWeapon == Weapon )
		PendingWeapon = None;
	if ( PendingWeapon == None )
		return false;

        	if ( Weapon != PendingWeapon )
		Weapon.PutDown();

	return (usealt > 0);
}

defaultproperties
{
     SpeechTargetAcquired=Sound'DeusExSounds.Robot.SecurityBot3TargetAcquired'
     SpeechTargetLost=Sound'DeusExSounds.Robot.SecurityBot3TargetLost'
     SpeechOutOfAmmo=Sound'DeusExSounds.Robot.SecurityBot3OutOfAmmo'
     SpeechCriticalDamage=Sound'DeusExSounds.Robot.SecurityBot3CriticalDamage'
     SpeechScanning=Sound'DeusExSounds.Robot.SecurityBot3Scanning'
     SpeechAreaSecure=Sound'DeusExSounds.Robot.SecurityBot3AreaSecure'
     EMPHealth=250
     DogDeactivated="Cyborg Dog deactivated!"
     bPlayDying=False
     MinHealth=0.000000
     RandomWandering=0.150000
     Orders=Following
     WalkingSpeed=0.200000
     bShowPain=False
     bAvoidAim=True
     AvoidAccuracy=0.750000
     bReactAlarm=True
     bFearIndirectInjury=False
     bMustFaceTarget=False
     FireAngle=60.000000
     EnemyTimeout=15.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponDogMachinegun')
     InitialInventory(1)=(Inventory=Class'DeusEx.Ammo762mm',Count=100)
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponRobotShockGun')
     InitialInventory(3)=(Inventory=Class'DeusEx.AmmoBattery',Count=99)
     InitialInventory(4)=(Inventory=Class'DeusEx.WeaponDogBite')
     BurnPeriod=0.000000
     bCanStrafe=True
     bCanSwim=True
     GroundSpeed=300.000000
     WaterSpeed=50.000000
     AirSpeed=750.000000
     AccelRate=2048.000000
     JumpZ=400.000000
     Health=250
     UnderWaterTime=99999.000000
     HitSound1=Sound'DeusExSounds.Generic.Spark1'
     HitSound2=Sound'DeusExSounds.Generic.Spark1'
     Die=Sound'DeusExSounds.Generic.Spark1'
     Alliance=Player
     DrawType=DT_Mesh
     Mesh=LodMesh'DeusExCharacters.Mutt'
     SoundRadius=128
     SoundVolume=140
     SoundPitch=128
     AmbientSound=Sound'DeusExSounds.Robot.MedicalBotMove'
     CollisionRadius=18.000000
     CollisionHeight=26.000000
     Buoyancy=100.000000
     BindName="CyborgDog"
     FamiliarName="Cyborg Dog"
     UnfamiliarName="Cyborg Dog"
}
