//=============================================================================
// DarkMaiden.
//=============================================================================
class DarkMaiden extends HumanMilitary;

function Bool HasTwoHandedWeapon()
{
	return False;
}

function float ShieldDamage(name damageType)
{
	if ( (damageType == 'TearGas') || (damageType == 'HalonGas') || (damageType == 'PoisonGas') )
		return 0.0;
        	else if ( (damageType == 'Flamed') || (damageType == 'Poison') || (damageType == 'PoisonEffect') || (damageType == 'Radiation') )
                		return 0.1;
	else if ( (damageType == 'Shocked') || (damageType == 'KnockedOut') || (damageType == 'Fell') )
                		return 0.5;
      	else
		return Super.ShieldDamage(damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if ( !bCollideActors && !bBlockActors && !bBlockPlayers )
		return;
	else if ( CanShowPain() )
		TakeHit(hitPos);
	else
		GotoNextState();
}      

function float ComputeActorVisibility(actor seeActor)
{
        	return 1.0;
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	local Sound hitSound;
	local float volume;

	if (Level.TimeSeconds - LastPainSound < 0.25)
		return;

	if (Damage <= 0)
		return;

	LastPainSound = Level.TimeSeconds;

	if ( FRand() < 0.33 )
		hitSound = Sound'FemalePlayerHit1';
	else if ( FRand() < 0.67 )
		hitSound = Sound'FemalePlayerHit2';
	else 
		hitSound = Sound'FemalePlayerHit3';
	
	volume = FMax(Mult*TransientSoundVolume, Mult*2.0);

	SetDistressTimer();
	PlaySound(hitSound, SLOT_Pain, volume,,, RandomPitch());
	if ( (hitSound != None) && bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio, volume);
}


function PlayDyingSound()
{
	SetDistressTimer();

	if ( FRand() < 0.33 )
		PlaySound(sound'FemalePlayerDie1', SLOT_Pain,,,, RandomPitch());
	else if ( FRand() < 0.67 )
		PlaySound(sound'FemalePlayerDie2', SLOT_Pain,,,, RandomPitch());
	else
		PlaySound(sound'FemalePlayerDie3', SLOT_Pain,,,, RandomPitch());

	AISendEvent('LoudNoise', EAITYPE_Audio);

	if ( bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio);
}

defaultproperties
{
     Aggressiveness=0.250000
     BaseAccuracy=-0.250000
     CarcassType=Class'DeusEx.DarkMaidenCarcass'
     WalkingSpeed=0.280000
     bShowPain=False
     AvoidAccuracy=0.950000
     CloseCombatMult=1.000000
     bReactAlarm=False
     MaxProvocations=0
     SurprisePeriod=0.000000
     BaseAssHeight=-18.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponStealthPistol')
     InitialInventory(1)=(Inventory=Class'DeusEx.Ammo10mm',Count=24)
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponMiniCrossbow')
     InitialInventory(3)=(Inventory=Class'DeusEx.AmmoDartPoison',Count=24)
     InitialInventory(4)=(Inventory=Class'DeusEx.WeaponBaton')
     InitialInventory(5)=(Inventory=Class'DeusEx.BioelectricCell')
     BurnPeriod=0.000000
     bIsFemale=True
     GroundSpeed=375.000000
     AccelRate=2048.000000
     JumpZ=250.000000
     PeripheralVision=-0.200000
     HearingThreshold=0.010000
     BaseEyeHeight=38.000000
     Health=450
     Skill=1.500000
     CombatStyle=0.100000
     HealthHead=450
     HealthTorso=450
     HealthLegLeft=450
     HealthLegRight=450
     HealthArmLeft=450
     HealthArmRight=450
     Mesh=LodMesh'DeusExCharacters.GFM_TShirtPants'
     DrawScale=1.100000
     MultiSkins(0)=Texture'DeusExCharacters.Skins.NicoletteDuClareTex0'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.NicoletteDuClareTex0'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.LensesTex5'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.NicoletteDuClareTex0'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.TiffanySavageTex2'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.TiffanySavageTex1'
     CollisionHeight=47.299999
     BindName="DarkMaiden"
     FamiliarName="Dark Maiden"
     UnfamiliarName="Dark Maiden"
     bVisionImportant=False
}
