//=============================================================================
// DeusExAmmo.
//=============================================================================
class DeusExAmmo extends Ammo
	abstract;

var localized String msgInfoRounds;

// True if this ammo can be displayed in the Inventory screen
// by clicking on the "Ammo" button.

var bool bShowInfo;
var int MPMaxAmmo; //Max Ammo in multiplayer.

// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------
function PostBeginPlay()
{
   	Super.PostBeginPlay();
}

function PreBeginPlay()
{     
   	Super.PreBeginPlay();
   	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
   	{
		AmbientGlow = 128;
      		SetCollisionSize(FMin(30.0, CollisionRadius*3), FMin(10.0, CollisionHeight*3));
   	}
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

	// number of rounds left
	winInfo.AppendText(Sprintf(msgInfoRounds, AmmoAmount));

	return True;
}

// ----------------------------------------------------------------------
// PlayLandingSound()
// ----------------------------------------------------------------------

function PlayLandingSound()
{
	if (LandSound != None)
	{
		if (Velocity.Z <= -200)
		{
			PlaySound(LandSound, SLOT_None, TransientSoundVolume,, 768);
			AISendEvent('LoudNoise', EAITYPE_Audio, TransientSoundVolume, 768);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function BecomePickup()
{
	if ( Physics != PHYS_Falling )
		RemoteRole    = ROLE_SimulatedProxy;
	Mesh          = PickupViewMesh;
	DrawScale     = PickupViewScale;
	bOnlyOwnerSee = false;
	bHidden       = false;
	bCarriedItem  = false;
	NetPriority   = 1.4;
        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
           		SetCollision( true, false, false );	
        	else
           		SetCollision( true, true, false );	
}

auto state Pickup
{
	function Touch( actor Other )
	{
               		local DeusExPlayer Player;

               		Player = DeusExPlayer(GetPlayerPawn());

	        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || Player.bAutoPickup )
                		{       
		     	if ( ValidTouch(Other) )
		     	{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
				SpawnCopy(Pawn(Other));
				if ( PickupMessageClass == None )
					Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
				else
					Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
				PlaySound (PickupSound);		
				if ( Level.Game.Difficulty > 1 )
					Other.MakeNoise(0.1 * Level.Game.Difficulty);
				if ( Pawn(Other).MoveTarget == self )
					Pawn(Other).MoveTimer = -1.0;	
                     		}	
		}
		else if ( bTossedOut && (Other.Class == Class)
				&& Inventory(Other).bTossedOut )
  			           	Destroy();
	}
}

defaultproperties
{
     msgInfoRounds="%d Rounds remaining"
     bDisplayableInv=False
     PickupMessage="You found"
     ItemName="DEFAULT AMMO NAME - REPORT THIS AS A BUG"
     ItemArticle=""
     PickupSound=Sound'DeusExSounds.Weapons.RifleReloadEnd'
     LandSound=Sound'DeusExSounds.Generic.PaperHit1'
}
