//=============================================================================
// DeusExGameInfo.
//=============================================================================
class DeusExGameInfo expands GameInfo
	config;

// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------

event playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local DeusExPlayer player;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;

   	//DEUS_EX AMSD In non multiplayer games, force JCDenton.
   	if ( !ApproveClass(SpawnClass) )
   	{
      		if ( Difficulty == 3 )
          			SpawnClass=class'HardcorePlayer';
		else if ( Difficulty == 2 )
          			SpawnClass=class'JCDentonMale2';
      		else
          			SpawnClass=class'JCDentonMale';
   	}

	player = DeusExPlayer(Super.Login(Portal, Options, Error, SpawnClass));

	if ( (player != None) && (!HasOption(Options, "Loadgame")) )
	{
		player.ResetPlayerToDefaults();

		dump = player.CreateDumpLocationObject();

		if ((dump != None) && (dump.HasLocationBeenSaved()))
		{
			dump.LoadLocation();

			player.Pause();
			player.SetLocation(dump.currentDumpLocation.Location);
			player.SetRotation(dump.currentDumpLocation.ViewRotation);
			player.ViewRotation = dump.currentDumpLocation.ViewRotation;
			player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);

			CriticalDelete(dump);
		}
		else
		{
			InTeam    = GetIntOption( Options, "Team", 0 ); // Multiplayer now, defaults to Team_Unatco=0
                  		if (!Level.Game.bDeathMatch)			
                      			StartSpot = FindPlayerStart( None, InTeam, Portal );
                  		else
                      			StartSpot = FindPlayerStart( Player, InTeam, Portal );

			player.SetLocation(StartSpot.Location);
			player.SetRotation(StartSpot.Rotation);
			player.ViewRotation = StartSpot.Rotation;
			player.ClientSetRotation(player.Rotation);
                        		if (DeusExMPGame(self) != None) 
                            			StartSpot.PlayTeleportEffect(player,true);
		}
	}
	return player;
}

// ----------------------------------------------------------------------
// ApproveClass()
// Is this class allowed for this gametype?  Override if you want to be 
// other than JCDentonMale.  If it returns false, will force JCDenton spawn.
// ----------------------------------------------------------------------

function bool ApproveClass( class<playerpawn> SpawnClass)
{
	return false;
}

// ----------------------------------------------------------------------
// DiscardInventory()
// ----------------------------------------------------------------------

function DiscardInventory( Pawn Other )
{
        	// do nothing	
}

// ----------------------------------------------------------------------
// ScoreKill()
// ----------------------------------------------------------------------

function ScoreKill(pawn Killer, pawn Other)
{
	// do nothing	
}

// ----------------------------------------------------------------------
// ClientPlayerPossessed()
// ----------------------------------------------------------------------
function ClientPlayerPossessed(PlayerPawn CheckPlayer)
{
	CheckPlayerWindow(CheckPlayer);
	CheckPlayerConsole(CheckPlayer);
}

// ----------------------------------------------------------------------
// CheckPlayerWindow()
// ----------------------------------------------------------------------
function CheckPlayerWindow(PlayerPawn CheckPlayer)
{
	// do nothing.
}

// ----------------------------------------------------------------------
// CheckPlayerConsole()
// ----------------------------------------------------------------------
function CheckPlayerConsole(PlayerPawn CheckPlayer)
{
	// do nothing.
}

// ----------------------------------------------------------------------
// FailRootWindowCheck()
// ----------------------------------------------------------------------
function FailRootWindowCheck(PlayerPawn FailPlayer)
{
	// do nothing
}

// ----------------------------------------------------------------------
// FailConsoleCheck()
// ----------------------------------------------------------------------
function FailConsoleCheck(PlayerPawn FailPlayer)
{
	// do nothing
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// it's still the best way to add/delete starting inventory.  
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv;
        	local DeusExPlayer P;
        	local FlagBase Flags;

        	P = DeusExPlayer(PlayerPawn);
       
        	if (P == None || (Level.Netmode != NM_Standalone))
              		return;
       
        	if ((P.GetLevelInfo() != None) && (P.GetLevelInfo().Script != Class'Mission01'))
              		return;

        	Flags = P.FlagBase;

        	if (!flags.GetBool('HejhujkaInventory'))		
        	{
	      	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
                        		if (!Inv.IsA('NanoKeyRing'))
                  	     		Inv.Destroy();
	      	PlayerPawn.Weapon = None;
	      	PlayerPawn.SelectedItem = None;
	      	AddDefaultInventory( PlayerPawn );
              		flags.SetBool('HejhujkaInventory', True,, 16);
        }
}

function AddDefaultInventory( pawn PlayerPawn )
{
         	local inventory anItem;         
         	local DeusExPlayer P;
        
         	P = DeusExPlayer(PlayerPawn);

         	if ( P == None || (Level.Netmode != NM_Standalone) )
                		return;
       
         	anItem = Spawn(class'Ammo10mm');
         	if ( P.FindInventoryType(anItem.Class) == None )
         	{
                		anItem.Frob(P, None);
		anItem.bInObjectBelt = False;
		if ( anItem != None )
			Ammo10mm(anItem).AmmoAmount = Class'WeaponPistol'.Default.PickupAmmoCount;
         	}
         	else
                		anItem.Destroy();

         	anItem = Spawn(class'WeaponPistol');
         	if ( P.FindInventoryType(anItem.Class) == None )
         	{
                		if ( P.FindInventorySlot(anItem) )
                		{
		       anItem.Frob(P, None);
		       anItem.bInObjectBelt = True;
                		}
         	}
         	else
                 		anItem.Destroy();

	anItem = Spawn(class'WeaponProd');
         	if ( P.FindInventoryType(anItem.Class) == None )
         	{
                		if ( P.FindInventorySlot(anItem) )
                		{
		 	anItem.Frob(P, None);
		      	anItem.bInObjectBelt = True;
                		}
         	}
         	else
                 		anItem.Destroy();
		
	anItem = Spawn(class'MedKit');
         	if ( P.FindInventoryType(anItem.Class) == None )
         	{
                		if ( P.FindInventorySlot(anItem) )
                		{
			anItem.Frob(P, None);
		       	anItem.bInObjectBelt = True;
                		}
         	}
         	else
                 		anItem.Destroy();
         		
         	if ( Difficulty == 3 )
         	{
                 		anItem = Spawn(class'WeaponNanoKeyRing');
		if ( P.FindInventoryType(anItem.Class) == None )
                 		{
                       		if ( P.FindInventorySlot(anItem) )
                       		{
		               		anItem.Frob(P, None);
		               		anItem.bInObjectBelt = True;
                       		}
                 		}
                 		else
                        		anItem.Destroy();
          	}
}

defaultproperties
{
}
