//=============================================================================
// DeusExMultiplayerGame
//=============================================================================
class DeusExMPGame expands DeusExGameInfo;

//BotInfo
var int NumBots;
var() string BotName;
var int RemainingBots;
var() bool bThreePlus;
var() bool bNoviceMode;
var int TotalKills;
var() globalconfig bool bUseMapBotCount;
var() globalconfig bool bHardCoreMode;
var() globalconfig float AirControl;
var BotInfo BotConfig;
var class<BotInfo> BotConfigType;
var float LastTauntTime;

var globalconfig int ScoreToWin; 
var globalconfig string VictoryCondition; 
var() globalconfig string CurrentMap; 
var() globalconfig float  fFriendlyFireMult;

var() int  FragLimit; 
var() int  TimeLimit; 
var() int  GlobalUpgradesPerKill; 
var() globalconfig bool bMultiPlayerBots; 
var() bool bChangeLevels;
var() bool bAutoInstall; 
var() bool bDarkHiding; 
var() bool bSpawnEffects; 
var() bool bAugsAllowed; 
var() float StartHiding; 
var() float EndHiding; 
var() float CloakEffect; 
var NavigationPoint LastStartSpot;
var bool bCustomizable; 
var bool bStartWithPistol;
const NewMapDelay = 16.0;
var bool bCycleMap;
var bool bNewMap, bClientNewMap;
var float NewMapTime;
var bool bAlreadyChanged;
var bool bSecondaryNotice;
var bool bSecondaryNsf;
var bool bSecondaryUnatco;
var bool bPrimaryNotice;
var bool bPrimaryNsf;
var bool bPrimaryUnatco;
var localized String TooManyPlayers;
const TEAM_UNATCO = 0;
const TEAM_NSF = 1;
const TEAM_DRAW	= 2;
const TEAM_AUTO = 128;
var bool bFreezeScores;
var int SkillsTotal;
var int SkillsAvail;
var int SkillsPerKill; 
var int InitialAugs; 
var int AugsPerKill; 
var int MPSkillStartLevel; 

struct ScoreElement
{
	var String	PlayerName;
	var float	score;
	var float	deaths;
	var float	streak;
	var int		team;
	var int		PlayerID;
};

var ScoreElement scoreArray[32];
var int	scorePlayers;
var color WhiteColor, SilverColor, RedColor, GreenColor, GoldColor;
var localized String StreakString, KillsString, DeathsString, PlayerString, NewMapSecondsString, WonMatchString;
var localized String EscapeString;
var localized String MatchEnd1String, MatchEnd2String;
var localized String TeamNsfString, TeamUnatcoString, TeamDrawString, HeadShotString;
var localized String StrKilled, StrSpree, StrRampage, StrDominating, StrUnstoppable, StrGodlike, StrEndSpree;
const PlayerX	= 0.17;		
const KillsX	= 0.55;		
const DeathsX	= 0.65;		
const StreakX	= 0.75;		
const PlayerY	= 0.25;
const WinY	= 0.15;		
const FireContY = 0.80;
const NotifyMinutes = 1.0;

replication
{
	// Server to client
	reliable if ( Role == ROLE_Authority )
		ScoreToWin, bNewMap, VictoryCondition;
}

event string GetBeaconText()
{
	local string Result;
	Result = Super.GetBeaconText();
	Result = Result $ " (" $ NumPlayers $ "/" $ MaxPlayers $ ")";
	return Result;
}

function PostBeginPlay()
{
    BotConfig = spawn(BotConfigType);
    if ( Level.NetMode == NM_Standalone )
    {
       if (bUseMapBotCount)
       {
           MaxPlayers = 1;
           RemainingBots = Level.RecommendedTeammates;
       }
       else
       {
           MaxPlayers = MaxPlayers;
	   RemainingBots = MaxPlayers - 1;
       }
    }
    else
       RemainingBots = 0;

   Super.PostBeginPlay();
}

event InitGame( string Options, out string Error )
{
        Super.InitGame(Options, Error);
        SetGameSpeed(GameSpeed);
}

function SetGameSpeed( Float T )
{
	GameSpeed = FMax(T, 0.1);
	if ( bHardCoreMode )
	    Level.TimeDilation = 1.125 * GameSpeed;
	else
	    Level.TimeDilation = GameSpeed;
	SaveConfig();
	SetTimer(Level.TimeDilation, true);
}

event PreLogin
(
	string Options,
	string Address,
	out string Error,
	out string FailCode
)
{
	Super.PreLogin(Options, Address, Error, FailCode);
	bClientNewMap = False;

	if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
		Error = TooManyPlayers;
}

event PlayerPawn Login(string Portal, string Options, out string Error, class<playerpawn> SpawnClass)
{
	local PlayerPawn newPlayer;
	local DeusExPlayer dxPlayer;

	if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Error = TooManyPlayers;
		return None;
	}

	newPlayer = Super.Login(Portal, Options, Error, SpawnClass);

	newPlayer.bAutoActivate = true;

        if ( NewPlayer.IsA('BotPlayer') )
        {
	     BotPlayer(NewPlayer).StartSpot = LastStartSpot;
             BotPlayer(NewPlayer).AirControl = AirControl;
             BotPlayer(NewPlayer).PlayerReplicationInfo.TalkTexture = BotPlayer(NewPlayer).TauntPortrait;
             BotPlayer(NewPlayer).UnfamiliarName = BotPlayer(NewPlayer).PlayerReplicationInfo.PlayerName;
        }
			
	return newPlayer;
}

event PostLogin(playerpawn NewPlayer)
{
   local DeusExPlayer DXPlayer;

   DXPlayer = DeusExPlayer(NewPlayer);

   log("class of new player is "$DXPlayer.Class$", class of game is "$Class$".");
   
   if ( DXPlayer.PlayerIsListenClient() )
   {
	DXPlayer.CreatePlayerTracker();
	if (DXPlayer.ThemeManager == NONE)
	{
	  DXPlayer.CreateColorThemeManager();
	  DXPlayer.ThemeManager.SetOwner( DXPlayer );
	  DXPlayer.ThemeManager.SetCurrentHUDColorTheme(DXPlayer.ThemeManager.GetFirstTheme(1));		
	  DXPlayer.ThemeManager.SetCurrentMenuColorTheme(DXPlayer.ThemeManager.GetFirstTheme(0)); 
	  DXPlayer.ThemeManager.SetMenuThemeByName(DXPlayer.MenuThemeName);
	  DXPlayer.ThemeManager.SetHUDThemeByName(DXPlayer.HUDThemeName);
	  DeusExRootWindow(DXPlayer.rootWindow).ChangeStyle();
	}
	DXPlayer.ReceiveFirstOptionSync(DXPlayer.AugPrefs[0], DXPlayer.AugPrefs[1], DXPlayer.AugPrefs[2], DXPlayer.AugPrefs[3], DXPlayer.AugPrefs[4]);
        DXPlayer.ReceiveSecondOptionSync(DXPlayer.AugPrefs[5], DXPlayer.AugPrefs[6], DXPlayer.AugPrefs[7], DXPlayer.AugPrefs[8]);
	DXPlayer.ShieldStatus = SS_Off;
   }

   if ( Level.NetMode == NM_Standalone )
   {
	while ((RemainingBots > 0) && AddBot())
	    RemainingBots--;
   }
   else
	    RemainingBots = 0;

   Super.PostLogin(NewPlayer);
}

function bool IsRelevant(actor Other) 
{
     	if ( Other.IsA('DeusExMover') && DeusExMover(Other).bIsDoor )
             return false;

	return Super.IsRelevant(Other);
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	if (injured.Region.Zone.bNeutralZone)
		return 0;

	if ( instigatedBy == None)
		return Damage;

	if ( bHardCoreMode )
		Damage *= 1.5;
	
	return (Damage * instigatedBy.DamageScaling);
}

function SetupAbilities(DeusExPlayer aPlayer)
{
   if (aPlayer == None)
       return;

   aPlayer.SkillPointsAvail = 0;
   aPlayer.SkillPointsAvail = 0;
}

function bool TooManyBots()
{
	return (NumBots + NumPlayers > MaxPlayers);
}

function bool ShouldRespawn(Actor Other)
{
	return ( (Inventory(Other) != None) && (Inventory(Other).ReSpawnTime!=0.0) );
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
 	local SpawnEffect PTE;

	if ( Incoming.bIsPawn && (Incoming.Mesh != None) )
	{
		PTE = Spawn(class'SpawnEffect',Incoming,, Incoming.Location, Incoming.Rotation);
                  	if (PTE != None)
                  	{
			PTE.Initialize(Pawn(Incoming), bOut);
			PTE.PlayEffectSound();
                  	}
	}
}

function float PlaySpawnEffect(inventory Inv)
{
	spawn( class'ReSpawnEffect',Inv,, Inv.Location );
	return 0.3;
}

function AcceptInventory(pawn PlayerPawn)
{
	local inventory Inv;
		
	for( Inv=PlayerPawn.Inventory; Inv!=None; Inv=Inv.Inventory )
	     Inv.Destroy();
	PlayerPawn.Weapon = None;
	PlayerPawn.SelectedItem = None;
	AddDefaultInventory( PlayerPawn );
}

function bool OneOnOne()
{
	return ( NumPlayers + NumBots == 2 );
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	local float skillmod;

	if ( bNoviceMode )
		skillmod = 0.3;
	else
		skillmod = 0.2 - aBot.skill * 0.06;
	if ( aBot.bKamikaze )
		return 1;
	else if (aBot.RelativeStrength(Other) > aBot.Aggressiveness + skillmod)
		return 0;
	else
		return 1;
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
	return 0;
}

function bool NeverStakeOut(bot Other)
{
	return false;
}

function bool ApproveClass( class<playerpawn> SpawnClass)
{
	return true;
}

function Logout(pawn Exiting)
{
   Super.Logout(Exiting);
   if ( Exiting.IsA('Bot') )
	NumBots--;
   if ( (Level.NetMode != NM_Standalone) && NeedPlayers() && !AddBot() )
	RemainingBots++;
}

function bool RestartPlayer( pawn aPlayer )	
{
    local DeusExPlayer PlayerToRestart;
    local Bot aBot;
    local ScriptedBot myBot;
    local NavigationPoint startSpot;
    local bool foundStart;
    local bool SuperResult;

    startSpot = FindPlayerStart(aPlayer, 255);

    if (aPlayer.IsA('Bot'))
    {
        aBot = Bot(aPlayer);

	if( startSpot == None )
	{
		log(" Player start for bot not found!!!");
		return false;
	}	
	foundStart = aBot.SetLocation(startSpot.Location);
        if( foundStart )
	{
          aBot.bHidden = False;
          startSpot.PlayTeleportEffect(aBot, true);
          aBot.Health = aBot.Default.Health;
          aBot.GroundSpeed = aBot.Default.GroundSpeed;
          aBot.SetRotation(startSpot.Rotation);
          aBot.ViewRotation = aBot.Rotation;
          aBot.Acceleration = vect(0,0,0);
          aBot.Velocity = vect(0,0,0);
          aBot.SetCollision( true, true, true );
          AddDefaultInventory(aBot);
          aBot.ClientSetLocation( startSpot.Location, startSpot.Rotation );
          aBot.SoundDampening = aBot.Default.SoundDampening;
          aBot.DamageScaling = aBot.Default.DamageScaling;
        }
	else
		log(startspot$" Player start not useable!!!");

	return foundStart;
    }

    else if (aPlayer.IsA('ScriptedBot'))
    {
        myBot = ScriptedBot(aPlayer);

	if( startSpot == None )
	{
		log(" Player start for bot not found!!!");
		return false;
	}	
	foundStart = myBot.SetLocation(startSpot.Location);

      if( foundStart )
      {
           myBot.bHidden = False;
           startSpot.PlayTeleportEffect(myBot, true);
           myBot.Health = myBot.Default.Health;
           myBot.HealthHead = myBot.Default.HealthHead;
           myBot.HealthTorso = myBot.Default.HealthTorso;
           myBot.HealthLegLeft = myBot.Default.HealthLegLeft;
           myBot.HealthLegRight = myBot.Default.HealthLegRight;
           myBot.HealthArmLeft = myBot.Default.HealthArmLeft;
           myBot.HealthArmRight = myBot.Default.HealthArmRight;
           myBot.GroundSpeed = myBot.Default.GroundSpeed;
           myBot.SetRotation(startSpot.Rotation);
           myBot.ViewRotation = myBot.Rotation;
           myBot.Acceleration = vect(0,0,0);
           myBot.Velocity = vect(0,0,0);
           myBot.SetCollision( true, true, true );
           AddDefaultInventory(myBot);
           myBot.InitializePawn();
           myBot.ClientSetLocation( startSpot.Location, startSpot.Rotation );
           myBot.SoundDampening = myBot.Default.SoundDampening;
           myBot.DamageScaling = myBot.Default.DamageScaling;
      }
      else
	   log(startspot$" Player start not useable!!!");
  
      return foundStart;
   }  

   else if (aPlayer.IsA('DeusExPlayer'))
   {
      PlayerToRestart = DeusExPlayer(aPlayer);
      startSpot.PlayTeleportEffect(PlayerToRestart, true);
   } 

    PlayerToRestart.ShowHud(True);
    PlayerToRestart.AugmentationSystem.ResetAugmentations();
    PlayerToRestart.SkillSystem.ResetSkills();    
    PlayerToRestart.ResetPlayerToDefaults();
    PlayerToRestart.DamageScaling = PlayerToRestart.Default.DamageScaling;
    
    SuperResult = Super.RestartPlayer(aPlayer);       
        
    PlayerToRestart.ClearAugmentationDisplay();
    PlayerToRestart.AugmentationSystem.CreateAugmentations(PlayerToRestart);
    PlayerToRestart.AugmentationSystem.AddDefaultAugmentations();
    PlayerToRestart.Energy = PlayerToRestart.EnergyMax;
    PlayerToRestart.SkillSystem.CreateSkills(PlayerToRestart);
    PlayerToRestart.myProjKiller = None;
       
    return SuperResult;
}

function NavigationPoint FindPlayerStart(Pawn Player, optional byte InTeam, optional string incomingName)
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N, LastPlayerStartSpot;

	if ( (Player != None) && Player.IsA('TournamentPlayer') 
		&& (Level.NetMode == NM_Standalone)
		&& (BotPlayer(Player).StartSpot != None) )
		return BotPlayer(Player).StartSpot;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;
	
	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled && !Dest.Region.Zone.bWaterZone )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
		foreach AllActors( class 'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}

	if (num>16) num = 16;
	else if (num == 0)
		return None;

	if ( (Player != None) && Player.IsA('BotPlayer') 
		&& (BotPlayer(Player).StartSpot != None) )
		LastPlayerStartSpot = BotPlayer(Player).StartSpot;
	
	for (i=0;i<num;i++)
	{
		if ( (Candidate[i] == LastStartSpot) || (Candidate[i] == LastPlayerStartSpot) )
			Score[i] = -10000.0;
		else
			Score[i] = 3000 * FRand(); //randomize
	}		
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for ( i=0; i<num; i++ )
			{
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone )
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( NextDist < OtherPlayer.CollisionRadius + OtherPlayer.CollisionHeight )
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
				else if ( NumPlayers + NumBots == 2 )
				{
					Score[i] += 2 * VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= 10000;
				}
			}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1;i<num;i++)
	if (Score[i] > BestScore)
	{
		BestScore = Score[i];
		Best = Candidate[i];
	}

	LastStartSpot = Best;
	return Best;
}

function HandleDeathNotification( Pawn killer, Pawn killee )
{
	local bool killedSelf, valid;

	killedSelf = (killer == killee);

	if (( killee != None ) && killee.IsA('DeusExPlayer'))
	{
		valid = DeusExPlayer(killee).killProfile.bValid;

		if ( killedSelf )
			valid = False;

		DeusExPlayer(killee).MultiplayerDeathMsg( killer, killedSelf, valid, DeusExPlayer(killee).killProfile.name, DeusExPlayer(killee).killProfile.methodStr );
	}
}

function Killed( pawn Killer, pawn Other, name damageType )
{
	local bool NotifyDeath;
	local DeusExPlayer otherPlayer;
	local Pawn CurPawn;

        if ( bFreezeScores )
          return;

	NotifyDeath = False;
	
	if ( Other.bIsPlayer )
	{
		otherPlayer = DeusExPlayer(Other);
		Other.PlayerReplicationInfo.Deaths += 1;
		Other.PlayerReplicationInfo.Streak = 0;
		if ((Killer == Other) || (Killer == None) && ( Other.PlayerReplicationInfo.Score > 0 ))
		    Other.PlayerReplicationInfo.Score -= 1;
            NotifyDeath = True;
	}
  
        if ((Killer.bIsPlayer) && (Other.bIsPlayer))
        {
          BroadcastDeathMessage(Killer, Other, damageType);
 	                          
	    if (Killer != Other)
	    {
		if ((TeamDMGame(Self) != None) && (TeamDMGame(Self).ArePlayersAllied(Other,Killer)))
		{
			if ( Killer.PlayerReplicationInfo.Score > 0 )
				Killer.PlayerReplicationInfo.Score -= 1;
                  if (Killer.IsA('DeusExPlayer'))
                		DeusExPlayer(Killer).MultiplayerNotifyMsg( DeusExPlayer(Killer).MPMSG_KilledTeammate, 0, "" );
		}
		else
		{
		      Killer.PlayerReplicationInfo.Score += 1;
		      Killer.PlayerReplicationInfo.Streak += 1;	
                  Killer.Spree++;
		      if (Killer.Spree > 4)
			    NotifySpree(Killer.PlayerReplicationInfo.PlayerName, Killer.Spree);
                  if (Other.Spree > 4)
		          EndSpree(Killer.PlayerReplicationInfo.PlayerName, Other.PlayerReplicationInfo.PlayerName); 
	            Other.Spree = 0;
                  if (( Killer.Health > 0 ) && (Level.TimeSeconds - LastTauntTime > 3))
                  {
                       LastTauntTime = Level.TimeSeconds;
                       Killer.SendGlobalMessage(None, 'AUTOTAUNT', 0, 0);
                  }
                                      
                  if ( DeathMatchGame(Self) != None )
			{
        			if ( DeathMatchGame(Self).CheckVictoryConditions(Killer, Other, "") )
                                {
                                     bFreezeScores = True;
                                     NotifyDeath = False;
                                }
			}
			if ( TeamDMGame(Self) != None )
			{
				if ( TeamDMGame(Self).CheckVictoryConditions(Killer, Other, "") )
                                {
                                      bFreezeScores = True;
                                      NotifyDeath = False;
                                }
			}
		}
	    }
	    if ( NotifyDeath )
		 HandleDeathNotification( Killer, Other );
        }
        else
        {
	    if (NotifyDeath)
		HandleDeathNotification( Killer, Other );

             Super.Killed(Killer,Other,damageType);
        }
}

function NotifySpree(String PlayerName, int num)
{
   	local Pawn P;
   	local String str;
   
   	if ( num == 5 )
       		str = PlayerName$StrSpree;
   	else if ( num == 10 )
       		str = PlayerName$StrRampage;
   	else if ( num == 15 )
       		str = PlayerName$StrDominating;
   	else if ( num == 20 )
       		str = PlayerName$StrUnstoppable;
   	else if ( num == 25 )
       		str = PlayerName$StrGodlike;
   	else
       		return;

   	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
         		if (P.IsA('DeusExPlayer'))
             			DeusExPlayer(P).MultiplayerNotifyMsg( DeusExPlayer(P).MPMSG_StartSpree, , str );
}

function EndSpree(String Killer, String Other)
{
   local Pawn P;
   local String str;

   	str = Other$StrEndSpree$Killer;
   
   	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
         		if (P.IsA('DeusExPlayer'))
             			DeusExPlayer(P).MultiplayerNotifyMsg( DeusExPlayer(P).MPMSG_EndSpree, , str );
}

function BroadcastDeathMessage (Pawn Killer, Pawn Other, Name damageType)
{
    	/*if ( (damageType == 'PoisonGas') || (damageType == 'Poison') || (damageType == 'PoisonEffect') )
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName$" with deadly Poison", false, 'DeathMessage');
    	else if ( damageType == 'Flamed' )
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName$" with excessive burning", false, 'DeathMessage');
    	else if ( (damageType == 'Shot') && (Killer.Weapon != None) )
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName$" with the "$Killer.Weapon.ItemName, false, 'DeathMessage');
    	else if ( damageType == 'Burned' )
        		BroadcastMessage(Other.PlayerReplicationInfo.PlayerName$" ate "$Killer.PlayerReplicationInfo.PlayerName$"'s burning plasma death", false, 'DeathMessage');
    	else if ( damageType == 'Exploded' )
        		BroadcastMessage(Other.PlayerReplicationInfo.PlayerName$" was smacked down by "$Killer.PlayerReplicationInfo.PlayerName$"'s explosive round", false, 'DeathMessage');
    	else if ( damageType == 'SniperDeath' )
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" inflicted mortal damage upon "$Other.PlayerReplicationInfo.PlayerName$" with the Enhanced Plasma Rifle", false, 'DeathMessage');
    	else if ( damageType == 'Sabot' )
        		BroadcastMessage(Other.PlayerReplicationInfo.PlayerName$" was ripped to shreds by "$Killer.PlayerReplicationInfo.PlayerName$"'s Sabot Cannon", false, 'DeathMessage');
    	else if ( damageType == 'GrenadeDeath' )
        		BroadcastMessage(Other.PlayerReplicationInfo.PlayerName$" was smacked down by "$Killer.PlayerReplicationInfo.PlayerName$"'s 20mm Assault Grenade", false, 'DeathMessage');
    	else if ( (damageType == 'Shocked') && (Killer.Weapon != None) )
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" electrified "$Other.PlayerReplicationInfo.PlayerName$" with the "$Killer.Weapon.ItemName, false, 'DeathMessage');
    	else if ( damageType == 'Decapitated' )
    	{
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" put a bullet through "$Other.PlayerReplicationInfo.PlayerName$"'s head", false, 'DeathMessage');
        		if ( Killer.IsA('DeusExPlayer') )
            			DeusExPlayer(Killer).MultiplayerNotifyMsg( DeusExPlayer(Killer).MPMSG_HeadShot, , HeadShotString );
    	}
    	else
        		BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName$" with something", false, 'DeathMessage');*/
	
	BroadcastMessage(Killer.PlayerReplicationInfo.PlayerName$StrKilled$Other.PlayerReplicationInfo.PlayerName, false, 'DeathMessage');
	if ( (damageType == 'Decapitated') && Killer.IsA('DeusExPlayer') )
		DeusExPlayer(Killer).MultiplayerNotifyMsg( DeusExPlayer(Killer).MPMSG_HeadShot, , HeadShotString );
}

function bool NeedPlayers()
{
   	if ( Level.NetMode != NM_Standalone )
		return (!bFreezeScores && (NumPlayers + NumBots < 6) && bMultiPlayerBots);
   	else
         		return (!bFreezeScores && (NumPlayers + NumBots < MaxPlayers));
}

function bool ForceAddBot()
{
	if ( Level.NetMode != NM_Standalone )
		AddBot();
}

function Bot SpawnBot(out NavigationPoint StartSpot)
{
        local Bot NewBot;
        local int BotN;
        local Pawn P;
	
        Difficulty = BotConfig.Difficulty;

	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}

        BotN = BotConfig.SelectBots();
	
	// Find a start spot.
	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for Bot");
		return None;
	}

	// Try to spawn the bot.
	NewBot = Spawn(BotConfig.GetBotClass(BotN),,,StartSpot.Location,StartSpot.Rotation);

	if ( NewBot == None )
		log("Couldn't spawn bot at "$StartSpot);

	if ( (bHumansOnly || Level.bHumansOnly) && !NewBot.bIsHuman )
	{
		log("can't add non-human bot to this game");
		NewBot.Destroy();
		NewBot = None;
	}

	if ( NewBot != None )
	{
	    NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
            BotConfig.SetBotSkill(NewBot);
            BotName = NewBot.Default.FamiliarName;
            ChangeName(NewBot, BotName, false );
            NewBot.PlayerReplicationInfo.Team = TEAM_AUTO;
            NewBot.ViewRotation = StartSpot.Rotation;
	    BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );
            NewBot.AirControl = AirControl;
            ModifyBehaviour(NewBot);
            AddDefaultInventory( NewBot );
            NumBots++;	
	}

	return NewBot;
}

function ModifyBehaviour(Bot NewBot);

function AddDefaultInventory( pawn PlayerPawn )
{
	local Weapon NewWeapon;
	local Bot B;
        	local class<Weapon> WeapClass;

        	PlayerPawn.JumpZ = PlayerPawn.Default.JumpZ * PlayerJumpZScaling();
	 
	if( PlayerPawn.IsA('Spectator') )
		return;
      
        	// Spawn default weapon.
        	WeapClass = BaseMutator.MutatedDefaultWeapon();
	if( (WeapClass!=None) && (PlayerPawn.FindInventoryType(WeapClass)==None) )
	{
		newWeapon = Spawn(WeapClass);
		if( newWeapon != None )
		{
		    	newWeapon.RespawnTime = 0.0;
		    	newWeapon.GiveTo(PlayerPawn);
		    	newWeapon.bHeldItem = true;
		    	newWeapon.GiveAmmo(PlayerPawn);
                    		if ( newWeapon.IsA('WeaponAssaultGun') )
                         			WeaponAssaultGun(newWeapon).GiveAltAmmo(PlayerPawn);
		    	newWeapon.AmbientGlow = 0;
                    		newWeapon.SetSwitchPriority(PlayerPawn);
		    	newWeapon.WeaponSet(PlayerPawn);
		}
        	}
	GiveWeapon(PlayerPawn, "DeusEx.WeaponPistol");
        	BaseMutator.ModifyPlayer(PlayerPawn);		       
}	

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
              		newWeapon.RespawnTime = 0.0;
	      	newWeapon.GiveTo(PlayerPawn);
	      	newWeapon.bHeldItem = true;
	      	newWeapon.GiveAmmo(PlayerPawn);
              		if ( newWeapon.IsA('WeaponAssaultGun') )
                   		WeaponAssaultGun(newWeapon).GiveAltAmmo(PlayerPawn);
	      	newWeapon.AmbientGlow = 0;
              		newWeapon.SetSwitchPriority(PlayerPawn);
	      	newWeapon.WeaponSet(PlayerPawn);
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
	}
}
		
function bool AddBot()
{
	local Bot NewBot;
	local NavigationPoint StartSpot;

	NewBot = SpawnBot(StartSpot);
	if ( NewBot == None )
	{
		log("Failed to spawn bot.");
		return false;
	}

	StartSpot.PlayTeleportEffect(NewBot, true);
        SetBotOrders(NewBot);
	NewBot.PlayerReplicationInfo.bIsABot = True;

	// Log it.
	if (LocalLog != None)
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if (WorldLog != None)
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}

	return true;
}

function SetBotOrders(Bot NewBot);

function Tick( float deltaTime )
{
	local bool	bCheck;
	local float	timeLimit, notifySec;

	bCheck = False;

	if ( Role == ROLE_Authority )
	{
		timeLimit = float(ScoreToWin)*60.0;
		notifySec = timeLimit - NotifyMinutes * 60.0;

		bCheck = ((VictoryCondition ~= "Time") && (((Level.Timeseconds>timeLimit) && !bCycleMap) || ((Level.Timeseconds>notifySec) && ( timeLimit > NotifyMinutes*60.0*2.0 ) && !bPrimaryNotice)));

		if ( bCheck )
		{
			// Check for victory conditions and end the match if need be
			if ( DeathMatchGame(Self) != None )
				DeathMatchGame(Self).CheckVictoryConditions( None, None, "" );
			if ( TeamDMGame(Self) != None )
				TeamDMGame(Self).CheckVictoryConditions( None, None, "" );
		}
	}
	Super.Tick( deltaTime );
}

simulated function RefreshScoreArray( DeusExPlayer player )
{
	local PlayerReplicationInfo lpri;
	local PlayerPawn pp;
	local int i;

	pp = player.GetPlayerPawn();
	if ( pp == None )
		return;

	scorePlayers = 0;

	for ( i = 0; i < 32; i++ )
	{
		if ( pp.GameReplicationInfo.PRIArray[i] != None )
		{
			lpri = pp.GameReplicationInfo.PRIArray[i];
			if ( !lpri.bIsSpectator || lpri.bWaitingPlayer )
			{
				scoreArray[scorePlayers].PlayerName = lpri.PlayerName;
				scoreArray[scorePlayers].score = lpri.Score;
				scoreArray[scorePlayers].deaths = lpri.Deaths;
				scoreArray[scorePlayers].streak = lpri.Streak;
				scoreArray[scorePlayers].team = lpri.Team;
				scoreArray[scorePlayers].PlayerID = lpri.PlayerID;
				scorePlayers += 1;
				if ( scorePlayers == ArrayCount(scoreArray) )
					break;
			}
		}
	}
}

simulated function SortScores()
{
	local PlayerReplicationInfo tmpri;
	local int i, j, max;
	local ScoreElement tmpSE;
	
	for ( i = 0; i < scorePlayers-1; i++ )
	{
		max = i;
		for ( j = i+1; j < scorePlayers; j++ )
		{
			if ( scoreArray[j].score > scoreArray[max].score )
				max = j;
			else if (( scoreArray[j].score == scoreArray[max].score) && (scoreArray[j].deaths < scoreArray[max].deaths))
				max = j;
		}
		tmpSE = scoreArray[max];
		scoreArray[max] = scoreArray[i];
		scoreArray[i] = tmpSE;
	}
}

simulated function DrawNameAndScore( GC gc, ScoreElement se, float screenWidth, float yoffset )
{
	local float x, w, h, w2, xoffset, killcx, deathcx, streakcx;
	local String str;
	
	// Draw Name
	str = se.PlayerName;
	gc.GetTextExtent( 0, w, h, str );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, str );

	// Draw Kills
	str = "00";
	gc.GetTextExtent( 0, w, h, KillsString );
	killcx = screenWidth * KillsX + w * 0.5;
	gc.GetTextExtent( 0, w, h, str );
	str = int(se.Score) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = killcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );

	// Draw Deaths
	gc.GetTextExtent( 0, w2, h, DeathsString );
	deathcx = screenWidth * DeathsX + w2 * 0.5;
	str = int(se.Deaths) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = deathcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );

	// Draw Streak
	gc.GetTextExtent( 0, w2, h, StreakString );
	streakcx = screenWidth * StreakX + w2 * 0.5;
	str = int(se.Streak) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = streakcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );
}

simulated function DrawHeaders( GC gc, float screenWidth, float yoffset )
{
	local float x, w, h, barLen;

	// Player header
	gc.GetTextExtent( 0, w, h, PlayerString );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, PlayerString );

	// Kills header
	gc.GetTextExtent( 0, w, h, KillsString );
	x = screenWidth * KillsX;
	gc.DrawText( x, yoffset, w, h, KillsString );

	// Deaths header
	gc.GetTextExtent( 0, w, h, DeathsString );
	x = screenWidth * DeathsX;
	gc.DrawText( x, yoffset, w, h, DeathsString );

	// Deaths header
	gc.GetTextExtent( 0, w, h, StreakString );
	x = screenWidth * StreakX;
	gc.DrawText( x, yoffset, w, h, StreakString );

	gc.SetTileColorRGB(255,255,255);
	gc.DrawBox( PlayerX * screenWidth, yoffset+h, (x + w)-(PlayerX*screenWidth), 1, 0, 0, 1, Texture'Solid');
}

function NotifyGameStatus( int param, String winningStr, bool bTimeCondition, bool bPrimary )
{
	local Pawn curPawn;

	if (( TeamDMGame(Self) != None ) && (VictoryCondition ~= "Frags"))
	{
		if ( bPrimary )
		{
			if ( winningStr ~= TeamNsfString )
			{
				if ( bPrimaryNsf )
					return;
				else
					bPrimaryNsf = True;
			}
			if ( winningStr ~= TeamUnatcoString )
			{
				if ( bPrimaryUnatco )
					return;
				else
					bPrimaryUnatco = True;
			}
		}
		else
		{
			if ( winningStr ~= TeamNsfString )
			{
				if ( bSecondaryNsf )
					return;
				else
					bSecondaryNsf = True;
			}
			if ( winningStr ~= TeamUnatcoString )
			{
				if ( bSecondaryUnatco )
					return;
				else
					bSecondaryUnatco = True;
			}
		}
	}
	else
	{
		if ( bPrimary )
		{
			if ( bPrimaryNotice )
				return;
			else
				bPrimaryNotice = True;
		}
		else
		{
			if ( bSecondaryNotice )
				return;
			else
				bSecondaryNotice = True;
		}
	}

	for ( curPawn = Level.PawnList; curPawn != None; curPawn = curPawn.nextPawn )
	{
		if ( curPawn.IsA('DeusExPlayer') )
		{
			if ( bTimeCondition )
				DeusExPlayer(curPawn).MultiplayerNotifyMsg( DeusExPlayer(curPawn).MPMSG_TimeNearEnd, param, winningStr );
			else
				DeusExPlayer(curPawn).MultiplayerNotifyMsg( DeusExPlayer(curPawn).MPMSG_CloseKills, param, winningStr );
		}
	}
}

simulated function ContinueMsg( GC gc, float screenWidth, float screenHeight )
{
	local String str;
	local float x, y, w, h;
	local int t;

	if ( bNewMap && !bClientNewMap)
	{
		NewMapTime = Level.Timeseconds + NewMapDelay - 0.5;
		bClientNewMap = True;
	}
	t = int(NewMapTime - Level.Timeseconds);
	if ( t < 0 )
		t = 0;

	str = t $ NewMapSecondsString;

	gc.SetTextColor( WhiteColor );
	gc.SetFont(Font'FontMenuTitle');
	gc.GetTextExtent( 0, w, h, str );
	x = (screenWidth * 0.5) - (w * 0.5);
	y = screenHeight * FireContY;
	gc.DrawText( x, y, w, h, str );

	y += (h*2.0);
	str = EscapeString;
	gc.GetTextExtent( 0, w, h, str );
	x = (screenWidth * 0.5) - (w * 0.5);
	gc.DrawText( x, y, w, h, str );
}

function string GetRules()
{
   local string ResultSet;

   ResultSet = "";  

   if (VictoryCondition ~= "Frags")   
      ResultSet = ResultSet $ "\\KillsToWin\\" $ ScoreToWin;
   else if (VictoryCondition ~= "Time")
      ResultSet = ResultSet $ "\\TimeToWin\\" $ ScoreToWin;
   if(bHardcoreMode)
	Resultset = ResultSet$"\\gamestyle\\Hardcore";
   else
	Resultset = ResultSet$"\\gamestyle\\Classic";

   ResultSet = ResultSet $ Super.GetRules();

   return ResultSet;
}

function Timer()
{
      local string URLstr;
      local MapList myList;
      local DeusExPlayer player;

        player = DeusExPlayer(GetPlayerPawn());

	if ( bCycleMap )
	{
           myList = Spawn(MapListType);
           URLstr = myList.GetNextMap();
           myList.Destroy();
           bCycleMap = False;
           if (Level.NetMode == NM_Standalone)
           {
               SendPlayer(player, URLstr);
               player.ResetPlayerToDefaults();
           }
           else
           {
               Level.ServerTravel( URLstr, False );
           }
         
           bFreezeScores = False;
	}
       
        if ((NumPlayers + NumBots < MaxPlayers) && NeedPlayers())
		AddBot();
}

function PreGameOver()
{
}

function GameOver()
{
   local Pawn aPawn;

   bNewMap = True;
   bCycleMap = True;
   bGameEnded = True;
   SetTimer( NewMapDelay, false );
  
   for ( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.NextPawn )
       if ( aPawn.IsA('Bot') )
            aPawn.GotoState('GameEnded');
}

function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken 
			&& ((aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location))) )
				aBot.Ambushspot = Ambushpoint(N);
}

function ResetNonCustomizableOptions()
{
}

function CheckPlayerWindow(PlayerPawn CheckPlayer)
{
	if (DeusExPlayer(CheckPlayer) != None)
		DeusExPlayer(CheckPlayer).VerifyRootWindow(Class'DeusEx.DeusExRootWindow');
}

function CheckPlayerConsole(PlayerPawn CheckPlayer)
{
	if (DeusExPlayer(CheckPlayer) != None)
		DeusExPlayer(CheckPlayer).VerifyConsole(Class'Engine.Console');
}

function FailRootWindowCheck(PlayerPawn FailPlayer)
{
	if (DeusExPlayer(FailPlayer) != None)
		DeusExPlayer(FailPlayer).ForceDisconnect("Invalid RootWindow class, disconnecting");
}

function FailConsoleCheck(PlayerPawn FailPlayer)
{
	if (DeusExPlayer(FailPlayer) != None)
		DeusExPlayer(FailPlayer).ForceDisconnect("Invalid Console class, disconnecting");
}

function bool ChangeTeam(Pawn PawnToChange, int NewTeam)
{
        return Super.ChangeTeam(PawnToChange,NewTeam);
}

function bool CanSpectate( pawn Viewer, actor ViewTarget )
{
	return false;
}

function float SpawnWait(Bot B)
{
	return ( NumBots * FRand() );
}

function DiscardInventory( Pawn Other )
{
	local actor dropped;
	local inventory Inv;
	local weapon weap;
	local float speed;

	if( Other.DropWhenKilled != None )
	{
		dropped = Spawn(Other.DropWhenKilled,,,Other.Location);
		Inv = Inventory(dropped);
		if ( Inv != None )
		{ 
			Inv.RespawnTime = 0.0; //don't respawn
			Inv.BecomePickup();		
		}
		if ( dropped != None )
		{
			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Other.Velocity + VRand() * 280;
		}
		if ( Inv != None )
			Inv.GotoState('PickUp', 'Dropped');
	}	
				
	if( (Other.Weapon!=None) && (Other.Weapon.Class!=Level.Game.BaseMutator.MutatedDefaultWeapon()) 
		&& Other.Weapon.bCanThrow )
	{
		speed = VSize(Other.Velocity);
		weap = Other.Weapon;
		if (speed != 0)
			weap.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 280);
		else 
            {
			weap.Velocity.X = 0;
			weap.Velocity.Y = 0;
			weap.Velocity.Z = 0;
		}
		Other.TossWeapon();
            if ( (weap.Mass < 30) || weap.IsA('WeaponAssaultGun') )
            {
                  weap.SetCollisionSize(weap.CollisionRadius*2, weap.CollisionHeight*3);
                  if (weap.Mesh == weap.PickupViewMesh)
                      weap.SetRotation(rot(0,0,16384));
            }   
            if ( weap.PickupAmmoCount == 0 )
		      weap.PickupAmmoCount = Rand(4) + 1;
	}
	Other.Weapon = None;
	Other.SelectedItem = None;	
	for( Inv=Other.Inventory; Inv!=None; Inv=Inv.Inventory )
		Inv.Destroy();
}

defaultproperties
{
     bUseMapBotCount=True
     bHardCoreMode=True
     AirControl=0.400000
     BotConfigType=Class'DeusEx.BotInfo'
     ScoreToWin=20
     VictoryCondition="Frags"
     CurrentMap="DXMP_TheTown"
     bMultiPlayerBots=True
     bChangeLevels=True
     bAutoInstall=True
     bSpawnEffects=True
     EndHiding=0.010000
     bCustomizable=True
     TooManyPlayers="Too many players"
     MPSkillStartLevel=3
     WhiteColor=(R=255,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     RedColor=(R=255)
     GreenColor=(G=255)
     GoldColor=(R=255,G=255)
     StreakString="Current Streak"
     KillsString="Kills"
     DeathsString="Deaths"
     PlayerString="Player"
     NewMapSecondsString=" seconds to new map."
     WonMatchString=" has won the match!"
     EscapeString="Press <Escape> to disconnect."
     MatchEnd1String="The match ended with "
     MatchEnd2String=" taking out "
     TeamNsfString="Team NSF"
     TeamUnatcoString="Team Unatco"
     TeamDrawString="The match is a draw!"
     HeadShotString="HEADSHOT!"
     StrKilled=" killed "
     StrSpree=" is on a killing spree!"
     StrRampage=" is on a rampage!!"
     StrDominating=" is dominating!"
     StrUnstoppable=" is unstoppable!"
     StrGodlike=" is Godlike!"
     StrEndSpree="'s killing spree was ended by "
     bRestartLevel=False
     bDeathMatch=True
     DefaultPlayerClass=Class'DeusEx.BotPlayer'
     DefaultWeapon=Class'DeusEx.WeaponProd'
     MapListType=Class'DeusEx.dxmaplist'
     bAlwaysRelevant=True
}
