//=============================================================================
// DeusExPickup.
//=============================================================================
class DeusExPickup extends Pickup
	abstract;

var bool            bBreakable;		// true if we can destroy this item
var class<Fragment> fragType;		// fragments created when pickup is destroyed
var int		    maxCopies;		// 0 means unlimited copies

var localized String CountLabel;
var localized String msgTooMany;
var Texture ChargedIcon;

var bool bIsHealth;
var int HealPriority;

// ----------------------------------------------------------------------
// Networking Replication
// ----------------------------------------------------------------------

replication
{
   //client to server function
   reliable if ((Role < ROLE_Authority) && (bNetOwner))
      UseOnce;
}

// ----------------------------------------------------------------------
// HandlePickupQuery()
//
// If the bCanHaveMultipleCopies variable is set to True, then we want
// to stack items of this type in the player's inventory.
// ----------------------------------------------------------------------

function bool HandlePickupQuery( inventory Item )
{
	local Pawn player;
	local Inventory anItem;
	local Bool bAlreadyHas;
	local Bool bResult;

	if ( Item.Class == Class )
	{
		player = Pawn(Owner);
		bResult = False;

		// Check to see if the player already has one of these in 
		// his inventory
		anItem = player.FindInventoryType(Item.Class);

		if ((anItem != None) && (bCanHaveMultipleCopies))
		{
			// don't actually put it in the hand, just add it to the count
			NumCopies += DeusExPickup(item).NumCopies;

			if ((MaxCopies > 0) && (NumCopies > MaxCopies))
			{
				NumCopies -= DeusExPickup(item).NumCopies;
				player.ClientMessage(msgTooMany);

				// abort the pickup
				return True;
			}
			bResult = True;
		}

		if (bResult)
		{
			player.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
                        player.PlaySound(PickupSound,SLOT_None,0.5);
			if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
                            Item.SetRespawn();
                        else			
                            Item.Destroy();
		}
		else
		{
			bResult = Super.HandlePickupQuery(Item);
		}

		if (bResult)			
			UpdateBeltText();	

		return bResult;
	}

	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

// ----------------------------------------------------------------------
// UseOnce()
//
// Subtract a use, then destroy if out of uses
// ----------------------------------------------------------------------

function UseOnce()
{
	local DeusExPlayer player;

	player = DeusExPlayer(Owner);
	NumCopies--;

	if (!IsA('SkilledTool'))
		GotoState('DeActivated');

	if (NumCopies <= 0)
	{
		if (player.inHand == Self)
			player.PutInHand(None);
                Destroy();
	}
	else
	{
		UpdateBeltText();
	}
}

// ----------------------------------------------------------------------
// UpdateBeltText()
// ----------------------------------------------------------------------

function UpdateBeltText()
{
	local DeusExRootWindow root;

	if (DeusExPlayer(Owner) != None)
	{
		root = DeusExRootWindow(DeusExPlayer(Owner).rootWindow);

		// Update object belt text
		if ((bInObjectBelt) && (root != None) && (root.hud != None) && (root.hud.belt != None))
			root.hud.belt.UpdateObjectText(beltPos);
	}
}

// ----------------------------------------------------------------------
// BreakItSmashIt()
// ----------------------------------------------------------------------

simulated function BreakItSmashIt(class<fragment> FragType, float size) 
{
	local int i;
	local DeusExFragment s;

	for (i=0; i<Int(size); i++) 
	{
		s = DeusExFragment(Spawn(FragType, Owner));
		if (s != None)
		{
			s.Instigator = Instigator;
			s.CalcVelocity(Velocity,0);
			s.DrawScale = ((FRand() * 0.05) + 0.05) * size;
			s.Skin = GetMeshTexture();

			// play a good breaking sound for the first fragment
			if (i == 0)
				s.PlaySound(sound'GlassBreakSmall', SLOT_None,,, 768);
		}
	}

	Destroy();
}

singular function BaseChange()
{
	Super.BaseChange();

	// Make sure we fall if we don't have a base
	if ((base == None) && (Owner == None))
		SetPhysics(PHYS_Falling);
}

// ----------------------------------------------------------------------
// state Pickup
// ----------------------------------------------------------------------

auto state Pickup
{
	function Touch( actor Other )
	{
		local Inventory Copy;               
                local DeusExPlayer Player;

                Player = DeusExPlayer(GetPlayerPawn());

	        if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || Player.bAutoPickup)
                {       
            	     if ( ValidTouch(Other) ) 
		     {
                        if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
                        if (Other.IsA('DeusExPlayer') && !Other.IsA('BotPlayer') && !Other.IsA('HardcorePlayer'))
                        {
                                DeusExPlayer(Other).FrobTarget = Self;
                                DeusExPlayer(Other).ParseAutoPickup();
                                DeusExPlayer(Other).FrobTarget = None;
                                return;
                        }
                        else   
                        {
                                Copy = SpawnCopy(Pawn(Other));
                                if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) 
                                     Copy.Activate();
                                if ( PickupMessageClass == None )
				     Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
			        else
				     Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
			        Pawn(Other).PlaySound (PickupSound,SLOT_None);
                      	        DeusExPickup(Copy).PickupFunction(Pawn(Other));
                        }
                     }
		}
	}	

	function Landed(Vector HitNormal)
	{
		Super.Landed(HitNormal);

		if (bBreakable)
		    if (VSize(Velocity) > 400)
			BreakItSmashIt(fragType, (CollisionRadius + CollisionHeight) / 2);
	}
}

state DeActivated
{
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local string str;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

	if (bCanHaveMultipleCopies)
	{
		// Print the number of copies
		str = CountLabel @ String(NumCopies);
		winInfo.AppendText(str);
	}

	return True;
}

// ----------------------------------------------------------------------
// PlayLandingSound()
// ----------------------------------------------------------------------

function PlayLandingSound()
{
	if (LandSound != None)
	{
		if (Velocity.Z <= -200)
		{
			PlaySound(LandSound, SLOT_None, TransientSoundVolume,, 768);
			AISendEvent('LoudNoise', EAITYPE_Audio, TransientSoundVolume, 768);
                        if (Instigator != None)
                               MakeNoise(0.5);
		}
	}
}

function BecomeItem()
{
	local Bot B;
	local Pawn P;

	Super.BecomeItem();

	if ( Instigator.IsA('Bot') || Level.Game.bTeamGame || !Level.Game.IsA('DeusExMPGame')
		|| DeusExMPGame(Level.Game).bNoviceMode
		|| (DeusExMPGame(Level.Game).NumBots > 4) )
		return;

	// let high skill bots hear pickup if close enough
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		B = Bot(p);
		if ( (B != None)
			&& (VSize(B.Location - Instigator.Location) < 800 + 100 * B.Skill) )
		{
			B.HearPickup(Instigator);
			return;
		}
	}
}

function Float GetCurrentCharge();

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return ((BeltSpot <= 9) && (BeltSpot >= 0));
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     FragType=Class'DeusEx.GlassFragment'
     CountLabel="COUNT:"
     msgTooMany="You can't carry any more of those"
     NumCopies=1
     PickupMessage="You found"
     ItemName="DEFAULT PICKUP NAME - REPORT THIS AS A BUG"
     RespawnTime=30.000000
     PickupSound=Sound'DeusExSounds.Generic.WeaponPickup'
     LandSound=Sound'DeusExSounds.Generic.PaperHit1'
}
