//=============================================================================
// Fireball.
//=============================================================================
class Fireball extends DeusExProjectile;

var() float mpDamage;
var   int mpAccurateRange;
var   int mpMaxRange;


#exec OBJ LOAD FILE=Effects

simulated function Tick(float deltaTime)
{
	local float value;
	local float sizeMult;

	time += deltaTime;

	value = 1.0+time;
	if (MinDrawScale > 0)
		sizeMult = MaxDrawScale/MinDrawScale;
	else
		sizeMult = 1;

	DrawScale = (-sizeMult/(value*value) + (sizeMult+1))*MinDrawScale;
	ScaleGlow = Default.ScaleGlow/(value*value*value);

}

function ZoneChange(ZoneInfo NewZone)
{
	Super.ZoneChange(NewZone);

	if (NewZone.bWaterZone)
		Destroy();
}


simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
        	{
	     	Damage = mpDamage;
             		LifeSpan = 2.000000;
             		AccurateRange = mpAccurateRange;
             		maxRange = mpMaxRange;
        	}
}

defaultproperties
{
     mpDamage=8.000000
     mpAccurateRange=800
     mpMaxRange=800
     blastRadius=1.000000
     DamageType=Flamed
     AccurateRange=640
     maxRange=640
     maxDrawScale=1.500000
     bIgnoresNanoDefense=True
     ItemName="Fireball"
     ItemArticle="a"
     speed=800.000000
     MaxSpeed=800.000000
     Damage=5.000000
     MomentumTransfer=500
     ExplosionDecal=Class'DeusEx.BurnMark'
     LifeSpan=1.500000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'Effects.Fire.flame_b'
     DrawScale=0.050000
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=16
     LightSaturation=32
     LightRadius=2
}
