//=============================================================================
// Flare.
//=============================================================================
class Flare extends DeusExPickup;

var ParticleGenerator gen;
var bool bIgnited;

simulated function PreBeginPlay()
{
        	Super.PreBeginPlay();

        	if ( Level.Game.Difficulty == 3 )
	        	MaxCopies = 5;
}

function ExtinguishFlare()
{
	LightType = LT_None;
	AmbientSound = None;
	if (gen != None)
		gen.DelayedDestroy();
}

auto state Pickup
{
	function ZoneChange(ZoneInfo NewZone)
	{
		if (NewZone.bWaterZone)
			ExtinguishFlare();

		Super.ZoneChange(NewZone);
	}

        	function Landed(Vector HitNormal)
	{
		Super.Landed(HitNormal);
                	if (gen != None)
                    		MakeNoise(1.0);
	}

	function Frob(Actor Frobber, Inventory frobWith)
	{
		if (gen == None)
			Super.Frob(Frobber, frobWith);
		else if (Frobber.IsA('Pawn'))
			Pawn(Frobber).ClientMessage(ExpireMessage);
	}

        function Touch(Actor Other)
        {
                	if (bIgnited)
			return;
		else
                        		Super.Touch(Other); 
        }
}

state Activated
{
	function ZoneChange(ZoneInfo NewZone)
	{
		if (NewZone.bWaterZone)
			ExtinguishFlare();

		Super.ZoneChange(NewZone);
	}

        	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local Flare flare;

		Super.BeginState();
                	flare = Spawn(class'Flare', Owner);
                	flare.bIgnited = True;
		flare.LightFlare();
                	UseOnce();
	}
Begin:
}

function LightFlare()
{
	local Vector X, Y, Z, dropVect;
	local Pawn P;

	if (gen == None)
	{	
                	SetTimer(5, false);
		bUnlit = True;
		LightType = LT_Steady;
		AmbientSound = Sound'Flare';

		P = Pawn(Owner);
		if (P != None)
		{
			GetAxes(P.ViewRotation, X, Y, Z);
			dropVect = P.Location + 0.8 * P.CollisionRadius * X;
			dropVect.Z += P.BaseEyeHeight;
			Velocity = Vector(P.ViewRotation) * 800 + vect(0,0,220);
			bFixedRotationDir = True;
			RotationRate = RotRand(False);
			DropFrom(dropVect);

			// increase our collision height so we light up the ground better
			//SetCollisionSize(CollisionRadius, CollisionHeight*2);
		}

		gen = Spawn(class'ParticleGenerator', Self,, Location, rot(16384,0,0));
		if (gen != None)
		{
			gen.attachTag = Name;
			gen.SetBase(Self);
			gen.LifeSpan = 30;
			gen.bRandomEject = True;
			gen.ejectSpeed = 20;
			gen.riseRate = 20;
			gen.checkTime = 0.3;
			gen.particleLifeSpan = 10;
			gen.particleDrawScale = 0.5;
			gen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		}
	}
}

function Timer()
{
     	BlowUp();
}

function BlowUp()
{
     	local ExplosionMedium exp;
     	local ExplosionLight light;

     	light = Spawn(class'ExplosionLight',,, Location);
     	if (light != None)
     	{	
         		light.size = 12;
         		light.RemoteRole = ROLE_None;
     	}
		
     	exp = Spawn(class'ExplosionMedium',,, Location);
     	if (exp != None) 
         		exp.RemoteRole = ROLE_None; 
     	HurtRadius(250, 384, 'Exploded', 120000, Location);
     	PlaySound(Sound'LAMExplode', SLOT_None, 2.0,, 2048);
     	MakeNoise(1.0);
     	Destroy();
}

defaultproperties
{
     maxCopies=10
     bCanHaveMultipleCopies=True
     ExpireMessage="It's already been ignited"
     bActivatable=True
     ItemName="Dynamite"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Flare'
     PickupViewMesh=LodMesh'DeusExItems.Flare'
     ThirdPersonMesh=LodMesh'DeusExItems.Flare'
     Icon=Texture'DeusExUI.Icons.BeltIconFlare'
     largeIcon=Texture'DeusExUI.Icons.LargeIconFlare'
     largeIconWidth=42
     largeIconHeight=43
     Description="A Dynamite."
     beltDescription="DYNAMITE"
     Mesh=LodMesh'DeusExItems.Flare'
     SoundRadius=96
     SoundVolume=96
     CollisionRadius=6.200000
     CollisionHeight=3.000000
     LightEffect=LE_TorchWaver
     LightBrightness=255
     LightHue=16
     LightSaturation=96
     LightRadius=8
     Mass=2.000000
     Buoyancy=1.000000
}
