//=============================================================================
// GravityBeam.  
//=============================================================================
class GreenBeam extends Effects;

var vector MoveAmount;
var int NumPuffs;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		MoveAmount, NumPuffs;
}

simulated function Tick( float DeltaTime )
{
	if ( Level.NetMode  != NM_DedicatedServer )
	{
		ScaleGlow = (Lifespan/Default.Lifespan)*1.0;
		AmbientGlow = ScaleGlow * 210;
	}
}


simulated function PostBeginPlay()
{
	if ( Level.NetMode != NM_DedicatedServer )
		SetTimer(0.015, false);
}

simulated function Timer()
{
	local GreenBeam r;
	
	if (NumPuffs>0)
	{
		r = Spawn(class'GreenBeam',,,Location+MoveAmount);
		r.RemoteRole = ROLE_None;
		r.NumPuffs = NumPuffs - 1;
		r.MoveAmount = MoveAmount;
	}
}

defaultproperties
{
     LifeSpan=0.280000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'DeusEx.Effects.GreenRing'
     DrawScale=0.200000
     bUnlit=True
}
