//=============================================================================
// GreenSphere.  
//=============================================================================
class GreenSphere extends Effects;

var float size;

simulated function PostBeginPlay()
{
       	if ( Level.NetMode != NM_DedicatedServer )
       	{
	       	SpawnEffects();
               		MakeSound();  
               		SpawnComets();
       	}
       	if ( Instigator != None )
	       	MakeNoise(0.5);
}

simulated function SpawnEffects()
{
       	local ScorchMark m;  
      
       	m = Spawn(class'ScorchMark');
       	if (m != None)  
       	{
               		m.Drawscale = FClamp(14/30, 0.5, 3.0);
               		m.ReattachDecal();
       	}  
}

simulated function SpawnComets()
{
       	local int i;
       	local FireComet c;
  
       	for (i=0; i<5; i++)
       	{
              		c= Spawn(class'FireComet', None);
              		if (c != None)
              		{
                   		c.Skin = Texture'phit_a00';
                   		c.bNoDecal =True;
              		}
       	}
}

function MakeSound()
{
        	PlaySound(EffectSound1,SLOT_None,,,2048);
}

simulated function Tick(float deltaTime)
{
	DrawScale = 3.0 * size * (Default.LifeSpan - LifeSpan) / Default.LifeSpan;
	ScaleGlow = 5.0 * (LifeSpan / Default.LifeSpan);
}

defaultproperties
{
     size=2.000000
     EffectSound1=Sound'DeusExSounds.Weapons.PlasmaRifleHit'
     Physics=PHYS_Rotating
     LifeSpan=0.500000
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=Texture'DeusEx.Effects.phit_a00'
     Skin=Texture'DeusEx.Effects.phit_a00'
     Mesh=LodMesh'DeusExItems.SphereEffect'
     AmbientGlow=200
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=83
     bFixedRotationDir=True
     RotationRate=(Pitch=337534679,Yaw=337534679,Roll=337534679)
}
