//=============================================================================
// GunSpark.
//=============================================================================
class GunSpark expands Effects;

#exec OBJ LOAD FILE=Effects

var Sound HitSounds[4];
var Rotator rot;

simulated function PostBeginPlay()
{
        Super.PostBeginPlay();       
        MakeSound();  
}

auto state Flying
{
	function BeginState()
	{
		Velocity = vect(0,0,0);
		rot = Rotation;
		rot.Roll += FRand() * 65535;
		SetRotation(rot);
	}
}

function MakeSound()
{
	local float rnd;
	local Sound ActualSound;
	local Name ImpactMaterial;

	rnd = FRand();
	ImpactMaterial = GetImpactMaterial();
		
	switch(ImpactMaterial)
	{
		case 'Textile':
		case 'Paper':
			ActualSound = Sound'PaperHit1';
			break;

		case 'Foliage':
		case 'Earth':
			ActualSound = HitSounds[Rand(4)];
			break;

		case 'Metal':
		case 'Ladder':
			if ( rnd < 0.9 )
				ActualSound = Sound'BulletImpactMetal1';
			else
				ActualSound = Sound'BulletImpactMetal2';
			break;

		case 'Ceramic':
		case 'Glass':
		case 'Tiles':
			ActualSound = Sound'GlassHit2';
			break;

		case 'Wood':
			if ( rnd < 0.5 )
				ActualSound = Sound'WoodHit1';
			else
				ActualSound = Sound'WoodHit2';
			break;

		case 'Brick':
		case 'Concrete':
		case 'Stone':
		case 'Stucco':
		default:
			ActualSound = HitSounds[Rand(4)];
			break;
	}
        	PlaySound(ActualSound, SLOT_None,,, 1024, 1.1 - 0.2*FRand());
}

function name GetImpactMaterial()
{
	local vector EndTrace, HitLocation, HitNormal;
	local actor target;
	local int texFlags;
	local name texName, texGroup;

	EndTrace = Location - (Vector(Rotation) * 5.0);

	foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, EndTrace)
	{
		if ((target == Level) || target.IsA('Mover'))
			break;
	}

	return texGroup;
}

defaultproperties
{
     HitSounds(0)=Sound'DeusExSounds.Generic.Ricochet1'
     HitSounds(1)=Sound'DeusExSounds.Generic.Ricochet2'
     HitSounds(2)=Sound'DeusExSounds.Generic.Ricochet3'
     HitSounds(3)=Sound'DeusExSounds.Generic.Ricochet4'
     bNetOptional=True
     LifeSpan=0.050000
     DrawType=DT_Mesh
     Style=STY_Translucent
     Skin=FireTexture'Effects.Fire.SparkFX1'
     Mesh=LodMesh'DeusExItems.FlatFX'
     DrawScale=0.100000
     bUnlit=True
     bCollideWorld=True
     bBounce=True
     bFixedRotationDir=True
}
