//=============================================================================
// HUDAmmoDisplay
//=============================================================================
class HUDAmmoDisplay expands HUDBaseWindow;

#exec obj load file=AV_Fonts_RUS

var Bool			bVisible;
var Color			colAmmoText;		// Ammo count text color
var Color			colAmmoLowText;		// Color when ammo low
var Color			colNormalText;		// color for normal weapon messages
var Color			colTrackingText;	// color when weapon is tracking
var Color			colLockedText;		// color when weapon is locked
var DeusExPlayer	player;
var int             infoX;

var localized String NotAvailable;
var localized String msgReloading;
var localized String AmmoLabel;
var localized String ClipsLabel;
var localized String MultitoolLabel;
var localized String LockpickLabel;
var localized String KeyRingLabel;

// Used by DrawWindow
var int clipsRemaining;
var int ammoRemaining;
var int ammoInClip;
var DeusExWeapon weapon;
var int numPicks;
var int numTools;
		
// Defaults
var Texture texBackground;
var Texture texBorder;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	bTickEnabled = TRUE;

	Hide();

	player = DeusExPlayer(DeusExRootWindow(GetRootWindow()).parentPawn);

	SetSize(95, 77);
}
 
// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	if ( (player.Weapon != None) && (bVisible) )
		Show();
	else if  ( ((Player.InHand != None) && Player.InHand.IsA('NanoKeyRing')) && (bVisible) )
		Show();
	else
		Hide();
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	local Multitool multitool;
	local Lockpick lockpick;
	local String smg;

	Super.DrawWindow(gc);

	// No need to draw anything if the player doesn't have
	// a weapon selected

	if (player != None)
		weapon = DeusExWeapon(player.Weapon);

	if ( weapon != None )
	{
		// Draw the weapon icon
		gc.SetStyle(DSTY_Masked);
		gc.SetTileColorRGB(255, 255, 255);
		gc.DrawTexture(22, 20, 40, 35, 0, 0, weapon.icon);
		
		// Draw the ammo count

		if (Player.bRussian)
  	  		gc.SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
		else
  	  		gc.SetFont(font'FontTiny');

		gc.SetAlignments(HALIGN_Center, VALIGN_Center);
		gc.EnableWordWrap(false);

		// how much ammo of this type do we have left?
		if (weapon.AmmoType != None)
			ammoRemaining = weapon.AmmoType.AmmoAmount;
		else
			ammoRemaining = 0;

		if ( ammoRemaining < weapon.LowAmmoWaterMark )
			gc.SetTextColor(colAmmoLowText);
		else
			gc.SetTextColor(colAmmoText);

		// Ammo count drawn differently depending on user's setting
		if (weapon.ReloadCount > 1 )
		{
			// how much ammo is left in the current clip?
			if ( weapon.IsA('WeaponPistol') )
                        			ammoInClip = weapon.AmmoLeftInTwoClip();
			else
				ammoInClip = weapon.AmmoLeftInClip();
			clipsRemaining = weapon.NumClips();

			if (weapon.IsInState('Reload'))
			{
				if ( weapon.IsA('WeaponSawedOffShotgun') || weapon.IsA('WeaponDXQuadShot') )
					gc.DrawText(infoX, 26, 20, 9, ammoInClip);
				else
					gc.DrawText(infoX, 26, 20, 9, msgReloading);
			}
			else
				gc.DrawText(infoX, 26, 20, 9, ammoInClip);

			// if there are no clips (or a partial clip) remaining, color me red
			if (((!weapon.IsA('WeaponPlasmaRifle')) && (!weapon.IsA('WeaponProd')) && (!weapon.IsA('WeaponHideAGun')) 
			&& (!weapon.IsA('WeaponLAW')) && ( clipsRemaining == 0 )) || (( clipsRemaining == 1 ) && ( ammoRemaining < 2 * weapon.ReloadCount )))
				gc.SetTextColor(colAmmoLowText);
			else
				gc.SetTextColor(colAmmoText);

			if (weapon.IsInState('Reload'))
				gc.DrawText(infoX, 38, 20, 9, msgReloading);
                        		else if ( weapon.IsA('WeaponProd') || weapon.IsA('WeaponPlasmaRifle') || weapon.IsA('WeaponHideAGun') || weapon.IsA('WeaponLAW') )
                                		gc.DrawText(infoX, 38, 20, 9, NotAvailable);
			else
				gc.DrawText(infoX, 38, 20, 9, clipsRemaining);
		}
		else
		{
			gc.DrawText(infoX, 38, 20, 9, NotAvailable);

			if (weapon.ReloadCount == 0)
			{
				gc.DrawText(infoX, 26, 20, 9, NotAvailable);
			}
			else
			{
				if (weapon.IsInState('Reload'))
					gc.DrawText(infoX, 26, 20, 9, msgReloading);
				else
					gc.DrawText(infoX, 26, 20, 9, ammoRemaining);
			}
		}

		// Now, let's draw the targetting information
		if (weapon.bCanTrack)
		{
			gc.SetFont(Font'FontTiny');
			if (weapon.LockMode == LOCK_Locked)
				gc.SetTextColor(colLockedText);
			else if (weapon.LockMode == LOCK_Acquire)
				gc.SetTextColor(colTrackingText);
			else
				gc.SetTextColor(colNormalText);
			gc.DrawText(25, 56, 65, 8, weapon.TargetMessage);
//			gc.DrawText(25, 56, 65, 8, weapon.TargetMessage);			
		}

        	if (weapon.IsA('WeaponAssaultGun'))
		{
            		gc.SetTextColor(colAmmoText);
				if (Player.bRussian)
					{
						gc.DrawText(25, 59, 65, 12, WeaponAssaultGun(weapon).AltAmmoType.AmmoAmount);
					}
						else
								gc.DrawText(25, 56, 65, 8, WeaponAssaultGun(weapon).AltAmmoType.AmmoAmount);
		}
		if (weapon.IsA('WeaponSMG'))
		{
			smg = WeaponSMG(weapon).AmmoLeftInAltClip() $ "/" $ WeaponSMG(weapon).AltAmmoType.AmmoAmount;
            		gc.SetTextColor(colAmmoText);
				if (Player.bRussian)
					{
						gc.DrawText(25, 59, 65, 12, smg);
					}
										else
			gc.DrawText(25, 56, 65, 8, smg);
		}
		if (weapon.FiringMode != "")
		{
			gc.SetFont(Font'FontTiny');
			gc.SetTextColor(colAmmoText);
			gc.DrawText(25, 56, 65, 8, weapon.FiringMode);
		}
	}

	else if ( (Player.InHand != None) && Player.InHand.IsA('NanoKeyRing') )
	{
		// Draw the "weapon" icon
		gc.SetStyle(DSTY_Masked);
		gc.SetTileColorRGB(255, 255, 255);
		gc.DrawTexture(22, 20, 40, 35, 0, 0, Class'NanoKeyRing'.Default.Icon);
		
		// Draw the "ammo count"
//--------
		if (Player.bRussian)
  	  		gc.SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
		else
//-----------------
		gc.SetFont(Font'FontTiny');
		gc.SetAlignments(HALIGN_Center, VALIGN_Center);
		gc.EnableWordWrap(false);

		multitool = Multitool(Player.FindInventoryType(Class'Multitool'));
  		if (multitool != None) 
  		{
			numTools = multitool.NumCopies;
		}
		else
			numTools = 0;

		gc.SetTextColor(colAmmoText);
		gc.DrawText(infoX, 26, 20, 9, numTools);

		lockpick = Lockpick(Player.FindInventoryType(Class'Lockpick'));
   		if (lockpick != None) 
			numPicks = lockpick.NumCopies;
		else
			numPicks = 0;


		gc.SetTextColor(colAmmoText);
		gc.DrawText(infoX, 38, 20, 9, numPicks);

		gc.SetTextColor(colAmmoText);
//----------
		if (Player.bRussian)
  	  		gc.SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
		else
//------------------
		gc.SetFont(Font'fonttiny');
		gc.DrawText(25, 56, 65, 8, KeyRingLabel);
	}		
}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
	gc.SetStyle(backgroundDrawStyle);
	gc.SetTileColor(colBackground);
	gc.DrawTexture(13, 13, 80, 54, 0, 0, texBackground);

	// Draw the Ammo and Clips text labels
	gc.SetFont(Font'FontTiny');
	gc.SetTextColor(colText);
	gc.SetAlignments(HALIGN_Center, VALIGN_Top);

	if ( (Player.InHand != None) && Player.InHand.IsA('NanoKeyRing') )
	{
		gc.DrawText(66, 17, 21, 8, MultitoolLabel);
		gc.DrawText(66, 48, 21, 8, LockpickLabel);
	}
	else
	{
		gc.DrawText(66, 17, 21, 8, AmmoLabel);
		gc.DrawText(66, 48, 21, 8, ClipsLabel);
	}
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
	if (bDrawBorder)
	{
		gc.SetStyle(borderDrawStyle);
		gc.SetTileColor(colBorder);
		gc.DrawTexture(0, 0, 95, 77, 0, 0, texBorder);
	}
}

// ----------------------------------------------------------------------
// SetVisibility()
// ----------------------------------------------------------------------

function SetVisibility( bool bNewVisibility )
{
	bVisible = bNewVisibility;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     colAmmoText=(G=255)
     colAmmoLowText=(R=255)
     colNormalText=(G=255)
     colTrackingText=(R=255,G=255)
     colLockedText=(R=255)
     infoX=66
     NotAvailable="N/A"
     msgReloading="---"
     AmmoLabel="AMMO"
     ClipsLabel="CLIPS"
     MultitoolLabel="TOOL"
     LockpickLabel="PICK"
     KeyRingLabel="KEY RING"
     texBackground=Texture'DeusExUI.UserInterface.HUDAmmoDisplayBackground_1'
     texBorder=Texture'DeusExUI.UserInterface.HUDAmmoDisplayBorder_1'
}
