//=============================================================================
// HUDBarkDisplayItem
//=============================================================================
class HUDBarkDisplayItem expands AlignWindow;

#exec obj load file=AV_Fonts_RUS

var DeusExPlayer player;

var TextWindow winName;
var TextWindow winBark;
var Window	winPortrait;

var Float timeToDisplay;
var Float timeDisplayed;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{    
        	Super.InitWindow();
       
	// Defaults for tile window
	SetChildVAlignment(VALIGN_Top);

        	player = DeusExPlayer(GetPlayerPawn());

        	if ( Player.Level.Game.bDeathMatch )
        	{
             		winPortrait = NewChild(Class'Window');
	     	winPortrait.SetSize(64, 64);
	     	winPortrait.SetPos(0, 0);
             		winPortrait.SetBackgroundStyle(DSTY_Translucent);
        	}

	winName = TextWindow(NewChild(Class'TextWindow'));
	winName.SetFont(Font'FontMenuHeaders_DS');
	winName.SetTextAlignments(HALIGN_Left, VALIGN_Top);
        	if (Player.Level.Game.bDeathMatch)
	        	winName.SetTextMargins(4, 0);
        	else
                		winName.SetTextMargins(0, 0);

	winBark = TextWindow(NewChild(Class'TextWindow'));
	winBark.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	//winBark.SetFont(Font'FontMenuSmall_DS');
//	winBark.SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
	if (Player.bRussian)
  	  WinBark.SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
	else
  	  winbark.SetFont(font'FontMenuSmall_DS');


        	if (Player.Level.Game.bDeathMatch)
	      	winBark.SetTextMargins(4, 1);
        	else
               		winBark.SetTextMargins(0, 1);
	winBark.SetWordWrap(True);        
	
	StyleChanged();
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	timeDisplayed += deltaSeconds;

	if (timeDisplayed > timeToDisplay)
	{
		bTickEnabled = False;
		Destroy();
	}
}

// ----------------------------------------------------------------------
// SetBarkSpeech()
// ----------------------------------------------------------------------

function SetBarkSpeech(string text, float newDisplayTime, Actor speakingActor)
{
	winName.SetText(speakingActor.UnfamiliarName $ ": ");
	winBark.SetText(text);
        	if (Player.Level.Game.bDeathMatch)
        	{
            		if ( speakingActor.bIsPawn && Pawn(speakingActor).bIsPlayer 
               		&& (Pawn(speakingActor).PlayerReplicationInfo.TalkTexture != None) )
                 			ShowPortrait(Pawn(speakingActor).PlayerReplicationInfo.TalkTexture);
        	}
	timeToDisplay = newDisplayTime;
	timeDisplayed = 0;
	bTickEnabled  = True;
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;
	local Color colNameText;
	local Color colText;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colNameText   = theme.GetColorFromName('HUDColor_HeaderText');
	colText       = theme.GetColorFromName('HUDColor_NormalText');

	winName.SetTextColor(colNameText);
	winBark.SetTextColor(colText);
}

function ShowPortrait(Texture portrait)
{
	winPortrait.SetBackground(portrait);
        	winPortrait.SetBackgroundStyle(DSTY_Normal);
	winPortrait.Show(True);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     timeToDisplay=3.000000
}
