//=============================================================================
// HardcorePlayer.
//=============================================================================
class HardcorePlayer extends Human;

var travel bool bNoWeapon;
var travel Weapon LastWeapon;
var travel int EnergyArmor;
var Weapon SelectedWeapon, NextWeapon;
var MachineGun GunWeapon;
var String MyClientMessage;
var Float MyMsgTime;
var bool bCanAirJump;
var localized String StrCredits;
var localized String StrHealth;
var localized String StrEnergy;
var localized String StrNothing;
var localized String StrAdaptive;
var localized String StrGoggles;

event TravelPostAccept()
{
	local DeusExLevelInfo info;
	
	Super.TravelPostAccept();

	switch(PlayerSkin)
	{
		case 0:	MultiSkins[0] = Texture'JCDentonTex0'; break;
		case 1:	MultiSkins[0] = Texture'JCDentonTex4'; break;
		case 2:	MultiSkins[0] = Texture'JCDentonTex5'; break;
		case 3:	MultiSkins[0] = Texture'JCDentonTex6'; break;
		case 4:	MultiSkins[0] = Texture'JCDentonTex7'; break;
	}
}

simulated event RenderOverlays( canvas Canvas )
{
        	Super(PlayerPawnExt).RenderOverlays(Canvas);
}

exec function Fire( optional float F )
{
	bJustFired = true;
	if ( bShowMenu || (Level.Pauser!="") || (Role < ROLE_Authority) )
	{
		if( (Role < ROLE_Authority) && (Weapon!=None) )
			bJustFired = Weapon.ClientFire(F);
		if ( !bShowMenu && (Level.Pauser == PlayerReplicationInfo.PlayerName)  )
			SetPause(False);
		return;
	}

        	if ( SelectedWeapon != None )
        	{
                		SwitchWeapon(SelectedWeapon.InventoryGroup);
                		SelectedWeapon = None;
                		bFire = 0;
                		return;
        	}

	if( Weapon!=None )
	{
		Weapon.bPointing = true;
		PlayFiring();
		if (( Level.NetMode == NM_Standalone ) || ( Level.NetMode == NM_ListenServer ))	
			Weapon.Fire(F);
	}
}

exec function AltFire( optional float F )
{
	bJustAltFired = true;
	if ( bShowMenu || (Level.Pauser!="") || (Role < ROLE_Authority) )
	{
		if( (Role < ROLE_Authority) && (Weapon!=None) )
			bJustAltFired = Weapon.ClientAltFire(F);
		if ( !bShowMenu && (Level.Pauser == PlayerReplicationInfo.PlayerName) )
			SetPause(False);
		return;
	}

        	if ( SelectedWeapon != None )
        	{
                		SelectedWeapon = None;
                		PlaySound(Sound'Menu_Activate',SLOT_Interface, 0.5);
                		bAltFire = 0;
                		return;
        	}

	if ( Weapon!=None )
	{
		Weapon.bPointing = true;
		PlayFiring();
		Weapon.AltFire(F);
	}
}

exec function bool SwitchToBestWeapon()
{
	local float rating;
	local int usealt;

        	if ( bNoWeapon )
                		return false;

	if ( Inventory == None )
		return false;

	PendingWeapon = Inventory.RecommendWeapon(rating, usealt);
	if ( PendingWeapon == Weapon )
		PendingWeapon = None;
	if ( PendingWeapon == None )
		return false;

	if ( Weapon == None )
		ChangedWeapon();
	if ( Weapon != PendingWeapon )
		Weapon.PutDown();

	return (usealt > 0);
}

exec function PrevBeltItem()
{
	local int prevGroup;
	local Inventory inv, inv2;
	local Weapon w, Prev;
        	local DeusExWeapon dw;
	local bool bFoundWeapon;
        
	if (RestrictInput())
                		return;

	if ( Weapon == None )
	{
		SwitchToBestWeapon();
		return;
	}

        	if ( (DeusExWeapon(Weapon) != None) && DeusExWeapon(Weapon).bZoomed && !DeusExWeapon(Weapon).bOwnsCrossHair )
        	{
                		UpdateZoomLevel(DeusExWeapon(Weapon), false);
                		return;
        	}

        	for (inv2=Inventory; inv2!=None; inv2=inv2.Inventory)
	{
                		dw = DeusExWeapon(inv2);
		if ( (dw != None) && (dw != Weapon) ) 
                	{
                        		if ((dw.AmmoType != None) && (dw.AmmoType.AmmoAmount <= 0)) 
                        		{
                                		dw.bAmmoMessage = True;
		                	dw.CycleAmmo();
                                		dw.bAmmoMessage = False;
                        		}
                	}
        	}

	prevGroup = 0;
	
	if ( SelectedWeapon == None )
		SelectedWeapon = Weapon;
       
	for (inv=Inventory; inv!=None; inv=inv.Inventory)
	{
		w = Weapon(inv);
		if ( w != None )
		{
			if ( w.InventoryGroup == SelectedWeapon.InventoryGroup )
			{
				if ( w == Weapon )
				{
					bFoundWeapon = true;
					if ( Prev != None )
					{
						NextWeapon = Prev;
						break;
					}
				}
				else if ( !bFoundWeapon && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
					Prev = W;
			}
			else if ( (w.InventoryGroup < SelectedWeapon.InventoryGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone') 
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) 
					&& (w.InventoryGroup >= prevGroup) )
			{
				prevGroup = w.InventoryGroup;
				NextWeapon = w;
			}
		}
	}
	bFoundWeapon = false;
	prevGroup = SelectedWeapon.InventoryGroup;
	if ( NextWeapon == None )
        	{
		for (inv=Inventory; inv!=None; inv=inv.Inventory)
		{
			w = Weapon(inv);
			if ( w != None )
			{
				if ( w.InventoryGroup == Weapon.InventoryGroup )
				{
					if ( w == Weapon )
						bFoundWeapon = true;
					else if ( bFoundWeapon && (NextWeapon == None) && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                                			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
						NextWeapon = W;
				}
				else if ( (w.InventoryGroup > PrevGroup) 
						&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                                			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) ) 
				{
					prevGroup = w.InventoryGroup;
					NextWeapon = w;
				}
			}
		}
	}
	if ( NextWeapon != None )
	{	
	     	SelectedWeapon = NextWeapon;
             		PlaySound(Sound'Menu_Cancel',SLOT_Interface, 0.5); 
             		NextWeapon = None;
        	}
}

exec function NextBeltItem()
{
	local int nextGroup;
	local Inventory inv, inv2;
	local Weapon w, Prev;
        	local DeusExWeapon dw;
	local bool bFoundWeapon;
        
	if (RestrictInput())
                 return;

	if ( Weapon == None )
	{
		SwitchToBestWeapon();
		return;
	}

        	if ( (DeusExWeapon(Weapon) != None) && DeusExWeapon(Weapon).bZoomed && !DeusExWeapon(Weapon).bOwnsCrossHair )
        	{
                		UpdateZoomLevel(DeusExWeapon(Weapon), true);
                		return;
        	}

        	for (inv2=Inventory; inv2!=None; inv2=inv2.Inventory)
	{
                		dw = DeusExWeapon(inv2);
		if ( (dw != None) && (dw != Weapon) ) 
                		{
                        		if ((dw.AmmoType != None) && (dw.AmmoType.AmmoAmount <= 0)) 
                        		{
                                			dw.bAmmoMessage = True;
		                		dw.CycleAmmo();
                                			dw.bAmmoMessage = False;
                        		}
                		}
        	}

       	nextGroup = 100;
	
	if ( SelectedWeapon == None )
		SelectedWeapon = Weapon;
        
	for (inv=Inventory; inv!=None; inv=inv.Inventory)
	{
		w = Weapon(inv);
		if ( w != None )
		{
			if ( w.InventoryGroup == SelectedWeapon.InventoryGroup )
			{
				if ( w == SelectedWeapon )
					bFoundWeapon = true;
				else if ( bFoundWeapon && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone') 
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
				{
					NextWeapon = W;
					break;
				}
			}
			else if ( (w.InventoryGroup > SelectedWeapon.InventoryGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) 
					&& (w.InventoryGroup < nextGroup) )
			{
				nextGroup = w.InventoryGroup;
				NextWeapon = w;
			}
		}
	}

	bFoundWeapon = false;
	nextGroup = SelectedWeapon.InventoryGroup;
	if ( NextWeapon == None )
        	{
		for (inv=Inventory; inv!=None; inv=inv.Inventory)
		{
			w = Weapon(Inv);
			if ( w != None )
			{
				if ( w.InventoryGroup == SelectedWeapon.InventoryGroup )
				{
					if ( w == SelectedWeapon )
					{
						bFoundWeapon = true;
						if ( Prev != None )
							NextWeapon = Prev;
					}
					else if ( !bFoundWeapon && (NextWeapon == None) && ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0)
                                                 			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) )
						Prev = W;
				}
				else if ( (w.InventoryGroup < nextGroup) 
					&& ((w.AmmoType == None) || (w.AmmoType.AmmoAmount>0) || (w.AmmoName == Class'AmmoNone')
                                        			|| (w.IsA('WeaponAssaultGun') && (WeaponAssaultGun(w).AltAmmoType != None) && (WeaponAssaultGun(w).AltAmmoType.AmmoAmount > 0))) ) 
				{
					nextGroup = w.InventoryGroup;
					NextWeapon = w;
				}
			}
		}
        	}
        	if ( NextWeapon != None )
	{	
	     	SelectedWeapon = NextWeapon;
             		PlaySound(Sound'Menu_Cancel',SLOT_Interface, 0.5); 
             		NextWeapon = None;
        	}
}

exec function ParseRightClick()
{
	if (RestrictInput())
		return;

       	if (FrobTarget != None)
	{
		if (FrobTarget.IsA('NanoKey'))
		{
			PickupNanoKey(NanoKey(FrobTarget));
			FrobTarget.Destroy();
			FrobTarget = None;
			return;
		}
		else if (FrobTarget.IsA('Decoration') && Decoration(FrobTarget).bPushable)
			GrabDecoration();
		else
			DoFrob(Self, None);
	}
	else
	{
	        	if (CarriedDecoration != None)
		        	DropDecoration();
	}
}

exec function GetNanoSword()
{
        	SwitchWeapon(Class'WeaponNanoSword'.Default.InventoryGroup);
}

exec function HideWeapon()
{
       	 if ( bNoWeapon )
	{
		bNoWeapon = False;
                		if (LastWeapon != None)
                		{
                    		SwitchWeapon(LastWeapon.InventoryGroup);
                    		LastWeapon = None;
                		}
		return;
	}

        	bNoWeapon = True;

        	if (Weapon != None)
        	{
                		LastWeapon = Weapon;
                		Weapon.PutDown();
                		Weapon = None;
        	}
}

exec function ActivateBelt(int objectNum)
{
        	if ( RestrictInput() || bNoWeapon )
                 		return;
        
        	if ( objectNum == 0 )
                 		SwitchWeapon(0);
}                

function ChangedWeapon()
{
	local Weapon OldWeapon;

	OldWeapon = Weapon;

	if ( Weapon == PendingWeapon )
	{
		if ( Weapon == None )
			SwitchToBestWeapon();
		else if ( Weapon.IsInState('DownWeapon') ) 
			Weapon.BringUp();
		if ( Weapon != None )
			Weapon.SetDefaultDisplayProperties();
		Inventory.ChangedWeapon(); 
		PendingWeapon = None;
		return;
	}

        	if ( !bNoWeapon )
        	{
	        	if ( PendingWeapon == None )
		        	PendingWeapon = Weapon;
        	}

	PlayWeaponSwitch(PendingWeapon);
	if ( (PendingWeapon != None) && (PendingWeapon.Mass > 20) && (carriedDecoration != None) )
		DropDecoration();
	if ( Weapon != None )
		Weapon.SetDefaultDisplayProperties();
		
	Weapon = PendingWeapon;
	Inventory.ChangedWeapon(); 
	if ( Weapon != None )
	{
		Weapon.RaiseUp(OldWeapon);
		if ( (Level.Game != None) && (Level.Game.Difficulty > 1) )
			MakeNoise(0.1 * Level.Game.Difficulty);		
	}
	PendingWeapon = None;
}

exec function GetWeapon(class<Weapon> NewWeaponClass )
{
	local Inventory Inv;

        	if (bNoWeapon)
                	return;

	if ( (Inventory == None) || (NewWeaponClass == None)
		|| ((Weapon != None) && (Weapon.Class == NewWeaponClass)) )
		return;

	for ( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
		if ( Inv.Class == NewWeaponClass )
		{
			PendingWeapon = Weapon(Inv);
			if ( (PendingWeapon.AmmoType != None) && (PendingWeapon.AmmoType.AmmoAmount <= 0) 
                           			&& (PendingWeapon.AmmoName != Class'AmmoNone'))
			{
				ClientMessage( PendingWeapon.ItemName$PendingWeapon.MessageNoAmmo );
				PendingWeapon = None;
				return;
			}
			Weapon.PutDown();
			return;
		}
}

function ClientMessage( coerce string S, optional Name Type, optional bool bBeep )
{
        	if (Player == None)
		return;

	if (Type == '')
		Type = 'Event';

        	MyNotifyMessage(S);

        	if (Level.Netmode != NM_Standalone)
            		if (Player.Console != None)
			Player.Console.Message( PlayerReplicationInfo, S, Type );

	if (bBeep && bMessageBeep)
		PlayBeepSound();
}

function MyNotifyMessage( coerce string S )
{
        	MyClientMessage = S;
        	MyMsgTime = Level.Timeseconds + mpMsgDelay;
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;
        	local bool bAlreadyDead;

	if ( Role < ROLE_Authority )
	{
		log(self$" client damage type "$damageType$" by "$instigatedBy);
		return;
	}

        	if ((instigatedBy != None) && (instigatedBy.IsA('CyborgDog')))
		return;
	
	bAlreadyDead = (Health <= 0);

	if (Physics == PHYS_None)
		SetMovementPhysics();
	if (Physics == PHYS_Walking)
		momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
	if ( instigatedBy == self )
		momentum *= 0.6;
	momentum = momentum/Mass;
	AddVelocity( momentum ); 
        
        	if (damageType == 'NanoVirus') 
		return;
        
	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;

	/*else if ((Weapon != None) && Weapon.IsA('WeaponProd') && (Weapon.AmmoType.AmmoAmount > 0) && (bAltFire != 0)) 
		actualDamage = Weapon.ReduceDamage(actualDamage, DamageType, HitLocation);*/
        	else if (Energy > 0)  
                		actualDamage = EnergyAbsorbDamage(actualDamage, DamageType, HitLocation);                
        	else
		actualDamage = Damage;

        	if (damageType == 'EMP')
	{
		PlayTakeHitSound(actualDamage, damageType, 1);
		return;
	}
		
	if ( Level.Game.DamageMutator != None )
		Level.Game.DamageMutator.MutatorTakeDamage( ActualDamage, Self, InstigatedBy, HitLocation, Momentum, DamageType );
	Health -= actualDamage;
	if (CarriedDecoration != None)
		DropDecoration();
	if ( HitLocation == vect(0,0,0) )
		HitLocation = Location;
	if (Health > 0)
	{
		if ( (instigatedBy != None) && (instigatedBy != Self) )
			damageAttitudeTo(instigatedBy);
		PlayHit(actualDamage, hitLocation, damageType, Momentum);					
		if (Health < 50)
			NanoHealing();
	}
	else if ( !bAlreadyDead )
	{
		NextState = '';
		PlayDeathHit(actualDamage, hitLocation, damageType, Momentum);
		if ( actualDamage > mass )
			Health = -1 * actualDamage;
		if ( (instigatedBy != None) && (instigatedBy != Self) )
			damageAttitudeTo(instigatedBy);
		Died(instigatedBy, damageType, HitLocation);
	}
	else
	{
		HidePlayer();
		GotoState('Dying');
		
	}
	MakeNoise(1.0); 
}

function NanoHealing()
{
	local Inventory Inv, Next;
	local DeusExPickup Current, NextCurrent, Heal;
	
	for ( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Inv.IsA('DeusexPickup') && DeusExPickup(Inv).bIsHealth )
		{
			Current = DeusExPickup(Inv);
			Next = Current.Inventory;
			if ( (Next != None) && (Next.IsA('DeusexPickup') && DeusExPickup(Next).bIsHealth) )
			{
				NextCurrent = DeusExPickup(Next);
				if ( NextCurrent.HealPriority > Current.HealPriority )
					Heal = NextCurrent;
				else
					Heal = Current;
			}
			else
				Heal = Current;	
												
			if ( Heal != None )
			{
				Heal.Activate();
				break;
			}						
		}
	}
}

function int EnergyAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	local int EnergyDamage;
	        	
	if (DamageType == 'Drowned') Return Damage;
	
	EnergyDamage = (Damage * EnergyArmor) / 100;

        	Energy -= EnergyDamage;
        
        	if (Energy <= 0)
                		Energy = 0.0; 
		
	return (Damage - EnergyDamage);
}

function int HealPlayer(int baseHealPoints, optional Bool bUseMedicineSkill)
{
	local int adjustedHealAmount;
	
        	if (Health > 100)
                	return 0;

	if (bUseMedicineSkill)
        	{
		adjustedHealAmount = CalculateSkillHealAmount(baseHealPoints);
                		PlaySound(sound'MedicalHiss', SLOT_None,,, 256);
        	}
	else
		adjustedHealAmount = baseHealPoints;

        	Health += adjustedHealAmount;
        	if (Health > 100)
                		Health = 100;	
        
	if (adjustedHealAmount == 1)
		ClientMessage(Sprintf(HealedPointLabel, adjustedHealAmount));
	else
		ClientMessage(Sprintf(HealedPointsLabel, adjustedHealAmount));
	
	return adjustedHealAmount;
}

exec function PrevItem()
{
	local Inventory Inv, LastItem;
	
	if (RestrictInput())
                 		return;
	if (SelectedItem==None)
        	{
		SelectedItem = Inventory.SelectNext();
		Return;
	}
	if (SelectedItem.Inventory!=None) 
        	{
		for( Inv=SelectedItem.Inventory; Inv!=None; Inv=Inv.Inventory ) 
                	{
			if (Inv==None) Break;
			if (Inv.bActivatable)
                                		LastItem=Inv;
		}
        	}
	for( Inv=Inventory; Inv!=SelectedItem; Inv=Inv.Inventory )
        	{
		if (Inv==None) Break;
		if (Inv.bActivatable) 
                        		LastItem=Inv;
	}
	if (LastItem!=None) 
        	{
		SelectedItem = LastItem;
		ClientMessage(SelectedItem.ItemName$SelectedItem.M_Selected);
                		PlaySound(Sound'Menu_Slider',SLOT_Interface, 0.5); 
	}
}

exec function ActivateItem()
{
	if ( RestrictInput() )
                		return;
	if ( SelectedItem != None ) 
        	{
		SelectedItem.Activate();
                		PlaySound(Sound'Menu_Cancel',SLOT_Interface, 0.5);
        	}
}

function bool CanBeLifted(Decoration deco)
{
	if ( !deco.bPushable || (deco.Mass > 150) || (deco.StandingCount > 0) )
	{
		if ( deco.bPushable )
			ClientMessage(TooHeavyToLift);
		else
			ClientMessage(CannotLift);

		return False;
	}

	return True;
}

function Bool FindInventorySlot(Inventory anItem, optional Bool bSearchOnly)
{
        	return true;
}

function Bool FindInventorySlotXY(int invSlotsX, int invSlotsY, out int newSlotX, out int newSlotY)
{
        	return true;
}

function bool AddInventory(inventory item)
{
        	return Super(Pawn).AddInventory(item);
}

function bool DeleteInventory(inventory item)
{
        	return Super(Pawn).DeleteInventory(item);
}

exec function ShowInventoryWindow()
{
        	ClientMessage(StrCredits$Credits);
}

exec function ShowSkillsWindow()
{
	ClientMessage(StrNothing);
}

exec function ShowHealthWindow()
{
	ClientMessage(StrHealth$Health);
}

exec function ShowAugmentationsWindow()
{
	ClientMessage(StrEnergy$EnergyArmor$" %");
}

exec function ShowLogsWindow()
{
}

exec function bool DropItem(optional Inventory inv, optional bool bDrop)
{
         	if (RestrictInput())
		return False;

         	if ( SelectedWeapon == None )
         	{
                		ThrowWeapon();
                		return true;
         	}
}

exec function AllAugs()
{
         	ClientMessage(StrNothing);
}

exec function AugAdd(class<Augmentation> aWantedAug)
{
         	ClientMessage(StrNothing);
}

exec function PutInHand(optional Inventory inv)
{        
}

function UpdateWarrenEMPField(float deltaTime)
{
}

function AddChargedDisplay(DeusExPickup item)
{
}

function RemoveChargedDisplay(DeusExPickup item)
{
}

function AddDamageDisplay(name damageType, vector hitOffset)
{
}

function ServerUpdateWeapons()
{
}

exec function ToggleScope()
{
}

function UpdateDynamicMusic(float deltaTime)
{
}

function Gasp()
{
	PlaySound(sound'MaleGasp', SLOT_Pain,,,, RandomPitch());
}

function PlayDyingSound()
{
	if (Region.Zone.bWaterZone)
		PlaySound(sound'MaleWaterDeath', SLOT_Pain,,,, RandomPitch());
	else
	{
		if ( FRand() < 0.33 )
			PlaySound(sound'HPlayerDie1', SLOT_Pain,,,, RandomPitch());
		else if ( FRand() < 0.67 )
			PlaySound(sound'HPlayerDie2', SLOT_Pain,,,, RandomPitch());
		else 
			PlaySound(sound'HPlayerDie3', SLOT_Pain,,,, RandomPitch());
	}
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local float rnd;

	if ( (Damage > 0) && (damageType == 'Shot') || (damageType == 'Exploded') || (damageType == 'AutoShot') || (damageType == 'GrenadeDeath') )
		SpawnBlood(HitLocation, Damage);

	rnd = FClamp(Damage, 20, 60);

	if ( damageType == 'Burned' )
		ClientFlash(rnd * 0.001, vect(0,500,100));
	else if ( damageType == 'Flamed' )
		ClientFlash(rnd * 0.001, vect(200,100,100));
	else if ( damageType == 'Radiation' )
		ClientFlash(rnd * 0.001, vect(100,100,0));
	else if ( damageType == 'PoisonGas' )
		ClientFlash(rnd * 0.001, vect(50,150,0));
	else if ( damageType == 'TearGas' )
		ClientFlash(rnd * 0.001, vect(150,150,0));
	else if ( damageType == 'Poison' )
		ClientFlash(rnd * 0.001, vect(0,150,50));
	else if ( damageType == 'Drowned' )
		ClientFlash(rnd * 0.001, vect(0,100,200));
	else if ( (damageType == 'EMP') || (damageType == 'Stunned') || (damageType == 'Shocked') )
		ClientFlash(rnd * 0.001, vect(0,100,500));
	else 
		ClientFlash(rnd * 0.001, vect(50,0,0));

	ShakeView(0.15 + 0.005 * Damage, Damage * 30, 0.3 * Damage); 
	PlayTakeHitSound(Damage, damageType, 1);
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	if ( Level.TimeSeconds - LastPainSound < FRand() + 0.5 )
		return;

	LastPainSound = Level.TimeSeconds;

	if ( Region.Zone.bWaterZone )
	{
		if ( damageType == 'Drowned' )
		{
			if (FRand() < 0.8)
				PlaySound(sound'MaleDrown', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
		else
			PlaySound(sound'HPlayerHit1', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
	}
	else
	{
		if ( (damageType=='Shot') || (damageType=='AutoShot') )
			PlaySound(sound'BodyHit', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		
		if ( (damageType == 'TearGas') || (damageType == 'HalonGas') || (damageType == 'PoisonGas') )
			PlaySound(sound'MaleCough', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		else
		{
			if ( FRand() < 0.33 )
				PlaySound(sound'HPlayerHit1', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			else if (FRand() < 0.67)
				PlaySound(sound'HPlayerHit2', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			else
				PlaySound(sound'HPlayerHit3', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
		AISendEvent('LoudNoise', EAITYPE_Audio, FMax(Mult * TransientSoundVolume, Mult * 2.0));
	}
}

function Died(pawn Killer, name damageType, vector HitLocation)
{
	Super.Died(Killer, damageType, HitLocation);

	if ( (Killer != None) && (Killer != Self) && (Killer.Health > 0) )
		MyKiller = Killer;
}

exec function NightVision()
{
  	local Inventory Tech;

  	Tech = FindInventoryType(Class'TechGoggles');
         	if ( Tech != None )
	{
             		Tech.Activate();
		if ( SelectedItem != None )
			SelectedItem = None;
		SelectedItem = Tech;
	}
         	else
             		ClientMessage(StrGoggles);
}

exec function Adaptive()
{
  	local Inventory Armor;
  	
  	Armor = FindInventoryType(Class'AdaptiveArmor');
         	if ( Armor != None )
	{
             		Armor.Activate();
		if ( SelectedItem != None )
			SelectedItem = None;
		SelectedItem = Armor;
	}
         	else
             		ClientMessage(StrAdaptive);
}

function UpdateInHand()
{
        	if (Weapon != None)
               		SetInHand(Weapon);
        	else
               		SetInHand(None);
}

function DoFrob(Actor Frobber, Inventory frobWith)
{
	local DeusExRootWindow root;
	local Ammo ammo;
	local Inventory item;
	local Actor A;

	if (FrobTarget.IsA('Inventory'))
		foreach FrobTarget.BasedActors(class'Actor', A)
			A.SetBase(None);

        	if ((FrobTarget != None) && FrobTarget.IsA('MachineGun'))
        	{
                		if (Weapon != None)
                        		Weapon.bHideWeapon = True; 
                   
                		MachineGun(FrobTarget).Controller = Self;
                		MachineGun(FrobTarget).MyBase.SetOwner(Self);
                		if (GunWeapon == None)
                        		GunWeapon = MachineGun(FrobTarget);
                		if (DeusExRootWindow(rootWindow) != None)
                		{
                        		DeusExRootWindow(rootWindow).hud.augDisplay.bShowGunAmmo = True;
                        		DeusExRootWindow(rootWindow).hud.augDisplay.GunAmmoCount = MachineGun(FrobTarget).MyBase.ammoAmount;
                		}
                		GotoState('Machinegunning');
                		return;
        	}

	FrobTarget.Frob(Frobber, frobWith);

	if (FrobTarget == None)
		return;

	if (FrobTarget.IsA('Inventory') && (FrobTarget.Owner != Self))
		return;

	if (FrobTarget.bOwned)
		AISendEvent('Futz', EAITYPE_Visual);

	PlayPickupAnim(FrobTarget.Location);

	if (FrobTarget.IsA('Inventory'))
		FrobTarget.SetBase(Frobber);
}

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ( (CarriedDecoration != None) && (CarriedDecoration.Mass > 20) )
		return;
	else if ( bForceDuck || IsLeaning() )
		return;

	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;
					
		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		bCanAirJump = True;
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}

	else if ( (Physics == PHYS_Falling) && bCanAirJump )
	{
		bCanAirJump = False;
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;	
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}
}

function Landed(vector HitNormal)
{
	PlayLanded(Velocity.Z);
	LandBob = FMin(50, 0.055 * Velocity.Z); 
	TakeFallingDamage();
        	bJustLanded = true;
	bCanAirJump = False;
}

function RotateMachinegun()
{
        	local vector lookDir, upDir;

	if (GunWeapon != None)
	{
		lookDir = Vector(Rotation);
		//lookDir.Z = 0;				
		upDir = vect(0,0,0);
		upDir.Z = CollisionHeight / -3;		
		
		if ( GunWeapon.MyBase.SetLocation(Location + upDir + (0.5 * CollisionRadius + GunWeapon.CollisionRadius) * lookDir) )
		{
			GunWeapon.MyBase.SetPhysics(PHYS_None);
			GunWeapon.MyBase.SetBase(self);
			GunWeapon.MyBase.SetCollision(False, False, False);
			GunWeapon.MyBase.bCollideWorld = False;
                        		GunWeapon.SetCollision(False, False, False);
			GunWeapon.bCollideWorld = False;
			FrobTarget = None;
		}
		else
		{
			ClientMessage(NoRoomToLift);
                        		GunWeapon.Controller = None;
			GunWeapon = None;
		}
	}
}

function ReleaseMachinegun()
{      
	if (GunWeapon != None)
	{		
		GunWeapon.MyBase.SetPhysics(PHYS_Falling);
		GunWeapon.MyBase.SetBase(None);
		GunWeapon.MyBase.SetCollision(True, True, True);
		GunWeapon.MyBase.bCollideWorld = True;
                		GunWeapon.SetCollision(True, True, True);
		GunWeapon.bCollideWorld = True;
                		if (DeusExRootWindow(rootWindow) != None)
                		{
                      		DeusExRootWindow(rootWindow).hud.augDisplay.bShowGunAmmo = False;
                      		DeusExRootWindow(rootWindow).hud.augDisplay.GunAmmoCount = 0;
                		}
                		if (GunWeapon.IsAnimating())
		      	GunWeapon.PlayIdleAnim();
                		GunWeapon.Controller = None;
		GunWeapon = None;
	}
}        
        
state Machinegunning extends PlayerWalking
{
ignores PlayFootStep, NextBeltItem, PrevBeltItem, AltFire, GetNanoSword, GetWeapon, SwitchWeapon, HideWeapon, SwitchToBestWeapon;

        	exec function Fire(optional float F)
	{
                		bJustFired = true;
	}

        	exec function ParseRightClick()
        	{
                		ReleaseMachinegun();
                		GotoState('PlayerWalking');
        	}

        	function UpdateInHand()
        	{
                		SetInHand(None);
        	}

        	function AnimEnd()
        	{
                		PlayWaiting();
        	}

        	function UpdateRotation(float DeltaTime, float maxPitch)
        	{
	        	local rotator newRotation;
	
	        	DesiredRotation = ViewRotation; 
	        	ViewRotation.Pitch += 32.0 * DeltaTime * aLookUp;
	        	ViewRotation.Pitch = ViewRotation.Pitch & 65535;
	        	If ((ViewRotation.Pitch > 18000) && (ViewRotation.Pitch < 62414))
	        	{
		        	If (aLookUp > 0) 
			        	ViewRotation.Pitch = 18000;
		        	else
			        	ViewRotation.Pitch = 62414;
	        	}
	        	ViewRotation.Yaw += 32.0 * DeltaTime * aTurn;
	        	ViewShake(deltaTime);
	        	ViewFlash(deltaTime);
		
	        	newRotation = Rotation;
	        	newRotation.Yaw = ViewRotation.Yaw;
	        	newRotation.Pitch = ViewRotation.Pitch;
	        	If ( (newRotation.Pitch > maxPitch * RotationRate.Pitch) && (newRotation.Pitch < 65536 - maxPitch * RotationRate.Pitch) )
	        	{
		        	If (ViewRotation.Pitch < 32768) 
			         	newRotation.Pitch = maxPitch * RotationRate.Pitch;
		        	else
			         	newRotation.Pitch = 65536 - maxPitch * RotationRate.Pitch;
	        	}

	        	newRotation.Pitch = 0;
	        	newRotation.Roll = 0;

	        	setRotation(newRotation);
        	}

        	function BeginState()
        	{
                		SetPhysics(Phys_None);
                		SelectedWeapon = None;
                		RotateMachinegun();
                		PlaySound(Sound'TurretLocked', SLOT_Interact);
        	}

        	function EndState()
        	{
                		SetPhysics(Phys_Walking);
                		if (GunWeapon != None)
                        		ReleaseMachinegun(); 
                		if (Weapon != None)
                        		Weapon.bHideWeapon = False;
        	}        
}

state Dying
{
	ignores all;

	exec function Fire( optional float F )
	{
		if ( bFrozen )
			return;
		InvokeUIScreen(Class'MenuScreenLoadGame', True);
	}
	
	exec function AltFire( optional float F )
	{
		Fire(F);
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
	{
		if ( !bHidden )
			Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
	}

	function Timer()
	{
		bFrozen = false;
		bShowScores = true;
		bPressedJump = false;
	}

	function ViewFlash(float DeltaTime)
	{
		if ( Carcass(ViewTarget) != None )
		{
			InstantFlash = -0.3;
			InstantFog = vect(0.25, 0.03, 0.03);
		}
		Super.ViewFlash(DeltaTime);
	}

	function BeginState()
	{
		BaseEyeheight = Default.BaseEyeHeight;
		EyeHeight = BaseEyeHeight;
		/*if ( Carcass(ViewTarget) == None )
			bBehindView = true;*/
		bFrozen = true;
		bPressedJump = false;
		bJustFired = false;
		bJustAltFired = false;
		FrobTime = Level.TimeSeconds;
		//ShowHud(False);
            		ClientDeath();
            		EndZoom();
		FindGoodView();
		if ( (Role == ROLE_Authority) && !bHidden )
			Super(Pawn).Timer(); 
		SetTimer(2.0, false);
		while ( SavedMoves != None )
		{
			SavedMoves.Destroy();
			SavedMoves = SavedMoves.NextMove;
		}
		if ( PendingMove != None )
		{
			PendingMove.Destroy();
			PendingMove = None;
		}		
		mpMsgTime = Level.Timeseconds + mpMsgDelay;
		ClientSetMusic(Level.Song, 1, 255, MTRAN_FastFade);
	}

	function EndState()
	{
		Super.EndState();
		MyKiller = None;
		ClientSetMusic(Level.Song, Level.SongSection, 255, MTRAN_FastFade);
	}

	function PlayerCalcView(out actor ViewActor, out vector CameraLocation, out rotator CameraRotation )
	{
		local vector View,HitLocation,HitNormal, FirstHit, spot;
		local float DesiredDist, ViewDist, WallOutDist, time;
		local actor HitActor;
		local Pawn PTarget;
		
		if ( ViewTarget != None )
		{
			ViewActor = ViewTarget;
			CameraLocation = ViewTarget.Location;
			CameraRotation = ViewTarget.Rotation;
			PTarget = Pawn(ViewTarget);
			if ( PTarget != None )
			{
				if ( Level.NetMode == NM_Client )
				{
					if ( PTarget.bIsPlayer )
						PTarget.ViewRotation = TargetViewRotation;
					PTarget.EyeHeight = TargetEyeHeight;
					if ( PTarget.Weapon != None )
						PTarget.Weapon.PlayerViewOffset = TargetWeaponViewOffset;
				}
				if ( PTarget.bIsPlayer )
					CameraRotation = PTarget.ViewRotation;
				CameraLocation.Z += PTarget.EyeHeight;
			}

			if ( Carcass(ViewTarget) != None )
			{
				if ( bBehindView || (ViewTarget.Physics == PHYS_None) )
					CameraRotation = ViewRotation;
				else 
					ViewRotation = CameraRotation;
				if ( bBehindView )
					CalcBehindView(CameraLocation, CameraRotation, 190);
			}
			else if ( bBehindView )
				CalcBehindView(CameraLocation, CameraRotation, 180);

			return;
		}

		CameraRotation = ViewRotation;
		DesiredFOV = DefaultFOV;		
		ViewActor = self;
		if( bBehindView ) 
			CalcBehindView(CameraLocation, CameraRotation, 180);
		else
		{
			CameraLocation = Location;
			//CameraLocation.Z += Default.BaseEyeHeight;
			if ( (MyKiller != None) && !MyKiller.bDeleteMe )
			{
				CameraRotation = Rotator(MyKiller.Location - Location);
				return;
			}
			else
			{
				time = Level.TimeSeconds - FrobTime;
				CameraRotation.Pitch = 16384;
				CameraRotation.Yaw = (time * 4096.0) % 65536;
			}				
		}
	}

	function DropWeapon()
	{
		local Weapon oldWeapon;
      		local vector X,Y,Z;
      		local float speed;

      		GetAxes(ViewRotation,X,Y,Z);

		if ( (Weapon != None) && Weapon.bCanThrow )
		{
			oldWeapon = Weapon;
			Weapon = None;
			SelectedWeapon = None;
			SelectedItem = None;
                  		speed = VSize(Velocity);
                  		if ( speed != 0 )
			    	oldWeapon.Velocity = Normal(Velocity/speed + 0.5 * VRand()) * (speed + 280);
		      	else 
                  		{
			    	oldWeapon.Velocity.X = 0;
			      	oldWeapon.Velocity.Y = 0;
			      	oldWeapon.Velocity.Z = 0;
		      	}
                  		oldWeapon.DropFrom(Location + 0.8 * CollisionRadius * X + - 0.5 * CollisionRadius * Y);
		 }
	}

Begin:
	if ( DeusExWeapon(Weapon) != None )
	{
		DeusExWeapon(Weapon).bZoomed = False;
		DeusExWeapon(Weapon).RefreshScopeDisplay(Self, True, False);
	}

	if ( DeusExRootWindow(rootWindow).hud.augDisplay != None )
	{
		DeusExRootWindow(rootWindow).hud.augDisplay.bVisionActive = False;
		DeusExRootWindow(rootWindow).hud.augDisplay.activeCount = 0;
	}

	DropWeapon();
	ClientFlash(2.0, vect(500,0,0));
	bCrouchOn = False;
	bWasCrouchOn = False;
	bIsCrouching = False;
	bForceDuck = False;
	lastbDuck	 = 0;
	bDuck = 0;
	FrobTime = Level.TimeSeconds;
	DesiredFOV = Default.DesiredFOV;
	FinishAnim();
	KillShadow();
   	FlashTimer = 0;
}       

state Paralyzed
{
        	function BeginState()
        	{
               		if (Weapon != None)
                        		Weapon.bHideWeapon = True;
        	}

        	function EndState()
        	{
               		if (Weapon != None)
                        		Weapon.bHideWeapon = False;
        	}
}

state Interpolating
{
        	function BeginState()
        	{
               		if (Weapon != None)
                        		Weapon.bHideWeapon = True;
        	}

        	function EndState()
        	{
               		if (Weapon != None)
                        		Weapon.bHideWeapon = False;
        	}
}

defaultproperties
{
     StrCredits="Credits: "
     StrHealth="Health: "
     StrEnergy="Bio Energy Protection: "
     StrNothing="Strange...nothing happens..."
     StrAdaptive="No Thermoptic Camo available"
     StrGoggles="No Tech Goggles available"
     EnergyMax=500.000000
     CarcassType=Class'DeusEx.JCDentonMaleCarcass'
     JumpSound=Sound'DeusEx.Player.HPlayerJump1'
     bAutoActivate=True
     GroundSpeed=400.000000
     JumpZ=350.000000
     HitSound1=Sound'DeusEx.Player.HPlayerHit1'
     HitSound2=Sound'DeusEx.Player.HPlayerHit2'
     Land=Sound'DeusEx.Player.PlayerLand1'
     Die=Sound'DeusEx.Player.HPlayerDie1'
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.JCDentonTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.JCDentonTex3'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.JCDentonTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.JCDentonTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex5'
}
