//=============================================================================
// HazMatSuit.
//=============================================================================
class HazMatSuit extends ChargedPickup;

simulated function PreBeginPlay()
{
       	if ( Level.NetMode == NM_Standalone ) 
	{
		if ( !Level.Game.bDeathMatch )
       			bDifficulty3 = False; 
	}

       	Super.PreBeginPlay();
       	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
       	{
            		ArmorAbsorption = 50;
            		AmbientGlow = 255;
       	}
}

function ArmorImpactEffect(vector HitLocation)
{
        	local DeusExPlayer Player;

        	Player = DeusExPlayer(Owner);
   
        	if ( Player != None )
	{
		Player.SetDamagePercent(Float(ArmorAbsorption)/100);
                		Player.ClientFlash(0.01, vect(0, 0, 100));
		if ( Player.bOnFire || (Player.poisonCounter > 0) )
         		{	
			Player.StopPoison();
	   		Player.drugEffectTimer = 0;
			Player.ExtinguishFire();             
         		}
	}
}

function PickupFunction(Pawn Other)
{
       	ApplySkillUpgrade(Other);
}

defaultproperties
{
     skillNeeded=Class'DeusEx.SkillEnviro'
     MaxCharge=200
     ChargedIcon=Texture'DeusExUI.Icons.ChargedIconHazMatSuit'
     bCanHaveMultipleCopies=False
     ExpireMessage="HazMatSuit power supply used up"
     bAutoActivate=True
     ItemName="Hazmat Suit"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.HazMatSuit'
     PickupViewMesh=LodMesh'DeusExItems.HazMatSuit'
     ThirdPersonMesh=LodMesh'DeusExItems.HazMatSuit'
     ProtectionType1=Radiation
     ProtectionType2=TearGas
     Charge=200
     ArmorAbsorption=75
     bIsAnArmor=True
     AbsorptionPriority=8
     MaxDesireability=2.000000
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconHazMatSuit'
     largeIcon=Texture'DeusExUI.Icons.LargeIconHazMatSuit'
     largeIconWidth=46
     largeIconHeight=45
     Description="A standard hazardous materials suit that protects against a full range of environmental hazards including radiation, fire, biochemical toxins, electricity, and EMP. Hazmat suits contain an integrated bacterial oxygen scrubber that degrades over time and thus should be recharged."
     beltDescription="HAZMAT"
     Texture=Texture'DeusExItems.Skins.ReflectionMapTex1'
     Mesh=LodMesh'DeusExItems.HazMatSuit'
     CollisionRadius=17.000000
     CollisionHeight=11.520000
     Mass=20.000000
     Buoyancy=12.000000
}
