//=============================================================================
// HealthPickup.
//=============================================================================
class HealthPickup extends DeusExPickup;

var() int healAmount;
var() int mphealAmount;
var() bool bSuperHeal;
var localized String HardcoreHealthAmount;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
        	{
		SetPhysics(Phys_None);
                		AmbientGlow = 128;
		bSuperHeal = True;
		healAmount = mphealAmount;
                		SetCollisionSize(CollisionRadius*3, CollisionHeight*2);
                		bRotatingPickup = True;
                		PickupViewScale = 1.250000;
		return;
        	}

	if ( Level.Game.Difficulty > 1 )
		MaxCopies = 5;
}

auto state Pickup
{	
	function Touch( actor Other )
	{
	    	local int HealMax;
	    	local Pawn P;
		local DeusExPlayer Player;

            		Player = DeusExPlayer(GetPlayerPawn());

		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || Player.bAutoPickup )
            		{       			
		       if ( ValidTouch(Other) ) 
		       {	
			P = Pawn(Other);	
			HealMax = P.default.health;
			if ( bSuperHeal ) HealMax = Min(199, HealMax * 2.0);
			if (P.Health < HealMax) 
			{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, P);
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, P);
				if (Other.IsA('DeusExPlayer') && !Other.IsA('BotPlayer') )
                  			{
                        				
					if ( DeusExPlayer(Other).IsA('JCDentonMale2') )
						DeusExPlayer(Other).HealPlayer(healAmount, False);
					else if ( DeusExPlayer(Other).IsA('HardcorePlayer') )
					{
						DeusExPlayer(Other).Health += healAmount;
                                					if (DeusExPlayer(Other).Health > HealMax) DeusExPlayer(Other).Health = HealMax;
                                					DeusExPlayer(Other).ClientMessage(HardcoreHealthAmount$healAmount$" %");
					}
					else 
					{
                      					DeusExPlayer(Other).FrobTarget = Self;
                        					DeusExPlayer(Other).ParseAutoPickup();
                        					DeusExPlayer(Other).FrobTarget = None;
                        					return;
					}
                  			}			
				else
				{
					P.Health += healAmount;
                                				if (P.Health > HealMax) P.Health = HealMax;
                                					P.ClientMessage(HardcoreHealthAmount$healAmount$" %");
				}
				if ( Self.IsA('Sodacan') )
					PlaySound (sound'MaleBurp');
				else
					PlaySound (PickupSound);
				Other.MakeNoise(0.2);		
				SetRespawn();
			}
                        		else
			{
				if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
				{
				}
				else
                                				Super.Touch(Other);
			}
		       }
		}
            		else
                			Super.Touch(Other);
	}

        	function Frob(Actor Other, Inventory frobWith)
        	{
            		local int HealMax;
	    	local Pawn P; 

		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
                			return;

            		if ( Level.Game.Difficulty > 1 )
            		{      
			if ( ValidTouch(Other) ) 
			{	
				P = Pawn(Other);	
				HealMax = P.default.health;
				if (P.Health < HealMax) 
				{
					if (Level.Game.LocalLog != None)
						Level.Game.LocalLog.LogPickup(Self, P);
					if (Level.Game.WorldLog != None)
						Level.Game.WorldLog.LogPickup(Self, P);
					if ( P.IsA('JCDentonMale2') )
						JCDentonMale2(P).HealPlayer(healAmount, False);
					else
					{
						P.Health += healAmount;
                                					if (P.Health > HealMax) P.Health = HealMax;
                                						P.ClientMessage(HardcoreHealthAmount$healAmount$" %");
					}
					if ( Self.IsA('Sodacan') )
						PlaySound (sound'MaleBurp');
					else
						PlaySound (PickupSound);
					Other.MakeNoise(0.2);		
					SetRespawn();
				}
                        			else
                                				Super.Frob(Other, None);
			}
            		}
            		else
                			Super.Frob(Other, None);
	}    
}

function BecomePickup()
{
	if ( Physics != PHYS_Falling )
		RemoteRole    = ROLE_SimulatedProxy;
	Mesh          = PickupViewMesh;
	DrawScale     = PickupViewScale;
	bOnlyOwnerSee = false;
	bHidden       = false;
	bCarriedItem  = false;
	NetPriority   = 1.4;
	if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
           	SetCollision( true, false, false );	
        else
          	SetCollision( true, true, false );
}

event float BotDesireability(Pawn Bot)
{
	local float desire;
	local int HealMax;

	HealMax = Bot.Default.Health;

	if (bSuperHeal) HealMax = Min(199, HealMax * 2.0);
	desire = Min(mpHealAmount, HealMax - Bot.Health);

	if ( (Bot.Weapon != None) && (Bot.Weapon.AIRating > 0.5) )
		desire *= 1.7;
	if (( Bot.Health < 45 ) || Bot.bOnFire)
		return ( FMin(0.03 * desire, 2.2) );
	else
	{
		if ( desire > 6 )
			desire = FMax(desire,25);
		return ( FMin(0.017 * desire, 2.0) ); 
	}
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
			player.HealPlayer(healAmount, False);
		
		UseOnce();
	}
Begin:
}

function bool HandlePickupQuery( inventory Item )
{
        local HardcorePlayer P;
	local JCDentonMale2 M;
       
	if ( Item.Class == Class )
        {
             	P = HardcorePlayer(Owner);
		M = JCDentonMale2(Owner);
             	if ( (P != None) && (P.Health < 100) )
	         	return false;
		else if ( (M != None) && (M.Health < 100) )
	         	return false;
             	else
                 	return Super.HandlePickupQuery(Item);
        }
	return Super.HandlePickupQuery(Item);
}

defaultproperties
{
     healAmount=5
     mphealAmount=10
     HardcoreHealthAmount="Healed "
     maxCopies=10
     bIsHealth=True
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Health Pack"
     MaxDesireability=0.500000
     RotationRate=(Yaw=5000)
}
