//=============================================================================
// HejhujkaMutator
//=============================================================================
class HejhujkaMutator expands Mutator;

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;
	
	bSuperRelevant = 1;
	
	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		return true;
	}
	
	if ( Other.IsA('Weapon') )
	{
		if ( Other.IsA('DeusExWeapon') && !DeusExWeapon(Other).bTournamentWeapon )
			return false;

		if ( Other.IsA('WeaponStealthPistol') )
		{
			ReplaceWith(Other, "DeusEx.WeaponPistol");
			return false; 
		}
		if ( Other.IsA('WeaponLAW') )
		{
			ReplaceWith( Other, "DeusEx.WeaponGEPGun" );
			return false;
		}
		if ( Other.IsA('WeaponSawedOffShotgun') )
		{
			ReplaceWith( Other, "DeusEx.WeaponAssaultShotgun" );
//			ReplaceWith( Other, "DeusEx.WeaponDXQuadShot" );
			return false;
		}
		bSuperRelevant = 0;
		return true;
	}
	if ( Other.IsA('Ammo') )
	{
		if ( Other.IsA('AmmoBattery') )
		{
			ReplaceWith( Other, "DeusEx.AmmoPepper" );
			return false;
		}
		if ( Other.IsA('AmmoShell') )
		{
			ReplaceWith( Other, "DeusEx.AmmoSabot" );
			return false;
		}

		if ( Other.IsA('AmmoRocketWP') )
		{
			ReplaceWith( Other, "DeusEx.AmmoRocket" );
			return false;
		}
		bSuperRelevant = 0;
		return true;
	}
	
	if ( Other.IsA('HealthPickup') )
		return true;

	if ( Other.IsA('MedKit') )
		return true;

	if ( Other.IsA('AdaptiveArmor') )
		return true;

	if ( Other.IsA('BallisticArmor') )
		return true;
	
	if ( Other.IsA('HazMatSuit') )
		return true; 

	if ( Other.IsA('BioelectricCell') )
	{
		ReplaceWith( Other, "DeusEx.SoyFood" );
		return false;
	}
	if ( Other.IsA('Lockpick') )
	{
		ReplaceWith( Other, "DeusEx.SoyFood" );
		return false;
	}
	if ( Other.IsA('Multitool') )
	{
		ReplaceWith( Other, "DeusEx.SoyFood" );
		return false;
	}
	if ( Other.IsA('AugmentationCannister') )
	{
		ReplaceWith( Other, "DeusEx.WineBottle" );
		return false;
	}
	if ( Other.IsA('AugmentationUpgradeCannister') )
	{
		ReplaceWith( Other, "DeusEx.LiquorBottle" );
		return false;
	}
	bSuperRelevant = 0;
	return true;
}

function bool ReplaceWith(actor Other, string aClassName)
{
	local Actor A;
	local class<Actor> aClass;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);
	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				if ( !A.IsA('AmmoSabot') && !A.IsA('AmmoShell') )
				{
					A.SetLocation(A.Location + (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
				}
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
			Inventory(A).bHeldItem = true;
                        		Inventory(A).Respawntime = 0.0;
			//Inventory(A).Respawntime = Inventory(A).Default.Respawntime;
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;
                		if (A.IsA('Weapon') && !A.IsA('WeaponGEPGun')  && !A.IsA('WeaponMiniCrossbow')) 
                   		A.SetRotation(Rotation + rot(0,0,16384));
                		else
                   		A.SetRotation(Rotation);
		return true;
	}
	return false;
}

defaultproperties
{
}
