//=============================================================================
// HoloDenton.
//=============================================================================
class HoloDenton extends HumanMilitary;

function SetSkin(DeusExPlayer player)
{
	if (player != None)
	{
		switch(player.PlayerSkin)
		{
			case 0:	MultiSkins[0] = Texture'JCDentonTex0'; break;
			case 1:	MultiSkins[0] = Texture'JCDentonTex4'; break;
			case 2:	MultiSkins[0] = Texture'JCDentonTex5'; break;
			case 3:	MultiSkins[0] = Texture'JCDentonTex6'; break;
			case 4:	MultiSkins[0] = Texture'JCDentonTex7'; break;
		}
	}
}

function Explode()
{
	local SphereEffect sphere;
	local ExplosionLight light;
	local int i;
	local float explosionRadius;
	
	explosionRadius = 384;
       
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'NanoVirusGrenadeExplode', SLOT_None,,, explosionRadius*16);

	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
        	{
		light.size = 8;
                		light.LightHue = 165;
		light.LightSaturation = 96;
        	}
	
	sphere = Spawn(class'SphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;
	
	HurtRadius(50, explosionRadius, 'Stunned', 50000, Location);
        	HurtRadius(100, explosionRadius, 'EMP', 50000, Location);
        	Destroy();
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
}

defaultproperties
{
     WalkingSpeed=0.120000
     bCanBleed=False
     bShowPain=False
     bCanConverse=False
     bInvincible=True
     bAvoidAim=False
     bAvoidHarm=False
     bHateInjury=False
     bReactPresence=False
     bReactAlarm=False
     bReactProjectiles=False
     RaiseAlarm=RAISEALARM_Never
     BaseAssHeight=-23.000000
     bHighlight=False
     Alliance=Player
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.JCDentonTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.JCDentonTex3'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.JCDentonTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.JCDentonTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.JCDentonTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex5'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     bCollideActors=False
     BindName="JCDouble"
     FamiliarName="JC Denton"
     UnfamiliarName="JC Denton"
}
