//=============================================================================
// HowardStrong.
//=============================================================================
class HowardStrong extends HumanMilitary;

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	if ( (damageType == 'Flamed') || (damageType == 'Poison') || (damageType == 'PoisonEffect') )
		return 0.0;
	else if ( damageType == 'Fell' )
		return 0.1;
	else
		return Super.ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function UpdateFire()
{
}

defaultproperties
{
     Aggressiveness=1.000000
     BaseAccuracy=-0.250000
     CarcassType=Class'DeusEx.HowardStrongCarcass'
     WalkingSpeed=0.296000
     bShowPain=False
     bImportant=True
     AvoidAccuracy=1.000000
     CloseCombatMult=1.000000
     SurprisePeriod=0.000000
     EnemyTimeout=8.000000
     BurnPeriod=10.000000
     walkAnimMult=0.750000
     GroundSpeed=300.000000
     AccelRate=2048.000000
     JumpZ=250.000000
     PeripheralVision=-0.200000
     HearingThreshold=0.050000
     Health=1500
     Skill=1.000000
     HealthHead=1800
     HealthTorso=1500
     HealthLegLeft=1500
     HealthLegRight=1500
     HealthArmLeft=1500
     HealthArmRight=1500
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.HowardStrongTex0'
     MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(2)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.HowardStrongTex2'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.HowardStrongTex0'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.HowardStrongTex1'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex1'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="HowardStrong"
     FamiliarName="Howard Strong"
     UnfamiliarName="Howard Strong"
     bVisionImportant=False
}
