//=============================================================================
// HumanCivilian.
//=============================================================================
class HumanCivilian extends ScriptedPawn
	abstract;

function PostBeginPlay()
{
	Super.PostBeginPlay();

	CheckInventory();
        	// change the sounds for chicks
	if (bIsFemale)
	{
		HitSound1 = Sound'FemalePainMedium';
		HitSound2 = Sound'FemalePainLarge';
		Die = Sound'FemaleDeath';
	}

	// change the sounds for kids
	if (IsA('ChildMale') || IsA('ChildMale2'))
	{
		HitSound1 = Sound'ChildPainMedium';
		HitSound2 = Sound'ChildPainLarge';
		Die = Sound'ChildDeath';
	}

	// hejhujka 40: Now the PeripheralVision and SightRadius is difficulty dependable.
	ResetAbilities();
}

function bool WillTakeStompDamage(actor stomper)
{
	// This blows chunks!
	if (stomper.IsA('PlayerPawn') && (GetPawnAllianceType(Pawn(stomper)) != ALLIANCE_Hostile))
		return false;
	else
		return true;
}

function CheckInventory()
{
       	if ((InitialInventory[0].Inventory == Class'WeaponAssaultShotgun')
          		&& (InitialInventory[1].Inventory == Class'AmmoShell')) 
       	{
                	InitialInventory[0].Inventory = Class'WeaponAssaultShotgun';
                	InitialInventory[1].Inventory = Class'AmmoSabot';
                	InitialInventory[1].Count = 12;
       	}   
}

function ResetAbilities()
{
	if ( Default.PeripheralVision != 0.0 )
	{
		//log("No changes for "$Self$"");
		return;
	}

	if ( Level.Game.Difficulty == 0 )
	{
		PeripheralVision = 0.6;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else if ( Level.Game.Difficulty == 1 )
	{
		PeripheralVision = 0.5;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else if ( Level.Game.Difficulty == 2 )
	{
		PeripheralVision = 0.4;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else
	{
		PeripheralVision = Default.PeripheralVision;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
}

defaultproperties
{
     BaseAccuracy=0.250000
     maxRange=1200.000000
     MinHealth=10.000000
     bPlayIdle=True
     bAvoidAim=False
     bReactProjectiles=False
     bFearShot=True
     bFearIndirectInjury=True
     bFearCarcass=True
     bFearDistress=True
     bFearAlarm=True
     FireAngle=60.000000
     EnemyTimeout=3.500000
     bCanTurnHead=True
     bCanStrafe=False
     WaterSpeed=80.000000
     AirSpeed=160.000000
     AccelRate=500.000000
     BaseEyeHeight=40.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     VisibilityThreshold=0.010000
     DrawType=DT_Mesh
     Mass=150.000000
     Buoyancy=155.000000
     BindName="HumanCivilian"
}
