//=============================================================================
// HumanMilitary.
//=============================================================================
class HumanMilitary extends ScriptedPawn
	abstract;

var bool bCanDuck;
var bool bAssaultAttack;
var bool bDefendPosition;
var(Sounds) sound JumpSound;
var(Combat) float HelpDistance;
var(Combat) float Aggressiveness; 
var NavigationPoint DefendPoint;

function PostBeginPlay()
{
	Super.PostBeginPlay();

	ResetAbilities();
        	CheckInventory();
}

function CallForHelp()
{
	local Pawn P;

	if ( Level.Game.Difficulty != 3 )
		return;

        	if ( !bCanCommunicate )
           		return;
      	
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('ScriptedPawn') && (P.Alliance == Alliance) )
		     	P.HandleHelpMessageFrom(self);
}

function HandleHelpMessageFrom(Pawn Other)
{
	if ( Level.Game.Difficulty != 3 )
		return;
	if ( !bCanCommunicate || bImportant || bDefendHome )
                		return;
       	if ( IsInState('Attacking') || IsInState('Fleeing') || IsInState('Seeking') || IsInState('Alerting') || IsInState('DefendPosition') || IsInState('TakeCover') )
                		return;
        	if ( (Other.Enemy != None) && SetEnemy(Other.Enemy) && (VSize(Other.Enemy.Location - Location) < HelpDistance)
           		&& (ActorReachable(Other.Enemy) || (FindPathToward(Other.Enemy) != None)) ) 
                		HandleEnemy();
}

function float RelativeStrength(Pawn Other)
{
	local float compare;
	local int adjustedStrength, adjustedOther;
	local int bTemp;

	adjustedStrength = health;
	adjustedOther = 0.5 * (Other.health + Other.Default.Health);	
	compare = 0.01 * float(adjustedOther - adjustedStrength);

	if ( bMoraleBoosted )
                		compare -= 1000.0;

	if ( bAssaultAttack )
		compare -= Aggressiveness;

	if ( Weapon != None )
        		compare -= (Weapon.RateSelf(bTemp) - 0.3);
		
	if ( Other.Weapon != None )
		compare += (Other.Weapon.RateSelf(bTemp) - 0.3);
        	
	return compare;
}

function bool WillTakeStompDamage(actor stomper)
{
	if ( stomper.IsA('PlayerPawn') && (GetPawnAllianceType(Pawn(stomper)) != ALLIANCE_Hostile) )
		return false;
	else
		return true;
}

function CheckInventory()
{
       	if ( (InitialInventory[0].Inventory == Class'WeaponAssaultShotgun')
           		&& (InitialInventory[1].Inventory == Class'AmmoShell') ) 
       	{
                		InitialInventory[0].Inventory = Class'WeaponAssaultShotgun';
                		InitialInventory[1].Inventory = Class'AmmoSabot';
                		InitialInventory[1].Count = 12;
       	}   
}

function ResetAbilities()
{	
	if ( bIsFemale )
	{
		JumpSound=Sound'FemaleJump';
		HitSound1 = Sound'FemalePainMedium';
		HitSound2 = Sound'FemalePainLarge';
		Die = Sound'FemaleDeath';
	}
	else
	{
		if ( Level.Game.Difficulty == 3 )
			JumpSound=Sound'HPlayerJump1';
	}

	if ( FRand() < CombatStyle )
		 bAssaultAttack = True;    
        		
	if ( Level.Game.Difficulty == 0 )
	{
		bCanDuck = False;
		if ( Default.PeripheralVision == 0.0 )
		{
			PeripheralVision = 0.4;
			SightRadius = 4000.0;
		}
	}

	else if ( Level.Game.Difficulty == 1 )
	{
		bCanDuck = False;
		if ( Default.PeripheralVision == 0.0 )
		{
			PeripheralVision = 0.3;
			SightRadius = 5000.0;
		}
	}

	else if ( Level.Game.Difficulty == 2 )
	{
		bCanDuck = (FRand() < 0.1);
		if ( Default.PeripheralVision == 0.0 )
		{
			PeripheralVision = 0.2;
			SightRadius = 5500.0;
		}
	}

	else 
	{
		bCanDuck = True;
		PeripheralVision = Default.PeripheralVision;
		SightRadius = Default.SightRadius;				
	}
}

function bool ShouldStrafe()
{
       	return true;
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	local Sound hitSound;
	local float volume;

	if (Level.TimeSeconds - LastPainSound < 0.25)
		return;

	if (Damage <= 0)
		return;

	LastPainSound = Level.TimeSeconds;

	if ( Level.Game.Difficulty == 3 )
	{
		if ( bIsFemale )
		{
			if ( Damage <= 30 )
				hitSound = Sound'FemalePainMedium';
			else
				hitSound = Sound'FemalePainLarge';
		}
		else
		{
			if ( FRand() < 0.33 )
				hitSound = Sound'HPlayerHit1';
			else if ( FRand() < 0.67 )
				hitSound = Sound'HPlayerHit2';
			else
				hitSound = Sound'HPlayerHit3';
		}
	}
	else
	{
		if ( Damage <= 30 )
			hitSound = HitSound1;
		else
			hitSound = HitSound2;
	}

	volume = FMax(Mult*TransientSoundVolume, Mult*2.0);

	SetDistressTimer();
	PlaySound(hitSound, SLOT_Pain, volume,,, RandomPitch());
	if ( (hitSound != None) && bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio, volume);
}

function PlayDyingSound()
{
	SetDistressTimer();
	if ( Level.Game.Difficulty == 3 )
	{
		if ( bIsFemale )
		{
			PlaySound(sound'FemaleDeath', SLOT_Pain,,,, RandomPitch());
		}
		else
		{
			if ( FRand() < 0.33 )
				PlaySound(sound'HPlayerDie1', SLOT_Pain,,,, RandomPitch());
			else if ( FRand() < 0.67 )
				PlaySound(sound'HPlayerDie2', SLOT_Pain,,,, RandomPitch());
			else 
				PlaySound(sound'HPlayerDie3', SLOT_Pain,,,, RandomPitch());
		}
	}
	else
		PlaySound(Die, SLOT_Pain,,,, RandomPitch());

	AISendEvent('LoudNoise', EAITYPE_Audio);
	if ( bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio);
}

function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
{
	local float enemyDist;
	local vector X,Y,Z, enemyDir;
	
	if ( health <= 0 )
		return;

	if ( IsInState('Stunned') || IsInState('Burning') )
		return;
			
	// AI controlled creatures may duck if not falling
	if ( !bCanDuck || (Enemy == None) || (Physics == PHYS_Falling) || (Physics == PHYS_Swimming) )
		return;

	if ( FRand() > 0.55 + 0.15 * skill )
		return;

	// and projectile time is long enough
	enemyDist = VSize(shooter.Location - Location);
	if (enemyDist/projSpeed < 0.11 + 0.15 * FRand()) 
		return;
					
	// only if tight FOV
	GetAxes(Rotation,X,Y,Z);
	enemyDir = (shooter.Location - Location)/enemyDist;
	if ((enemyDir Dot X) < 0.8)
		return;

	if ( (FireDir Dot Y) > 0 )
	{
		Y *= -1;
		TryToDuck(Y, true);
	}
	else
		TryToDuck(Y, false);
}

function TryToDuck(vector duckDir, bool bReversed)
{
	local vector HitLocation, HitNormal, Extent;
	local actor HitActor;
	local bool bSuccess, bDuckLeft;

	if ( Region.Zone.bWaterZone || (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z) )
		return;

	duckDir.Z = 0;
	bDuckLeft = !bReversed;
	Extent.X = CollisionRadius;
	Extent.Y = CollisionRadius;
	Extent.Z = CollisionHeight;
	HitActor = Trace(HitLocation, HitNormal, Location + 240 * duckDir, Location, false, Extent);
	bSuccess = ( (HitActor == None) || (VSize(HitLocation - Location) > 150) );
	if ( !bSuccess )
	{
		bDuckLeft = !bDuckLeft;
		duckDir *= -1;
		HitActor = Trace(HitLocation, HitNormal, Location + 240 * duckDir, Location, false, Extent);
		bSuccess = ( (HitActor == None) || (VSize(HitLocation - Location) > 150) );
	}
	if ( !bSuccess )
		return;
	
	if ( HitActor == None )
		HitLocation = Location + 240 * duckDir; 

	HitActor = Trace(HitLocation, HitNormal, HitLocation - MaxStepHeight * vect(0,0,1), HitLocation, false, Extent);
	if (HitActor == None)
		return;
		
	SetFall();
	Velocity = duckDir * GroundSpeed;
	Velocity.Z = 170;
	PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 - 0.1*FRand() );
	SetPhysics(PHYS_Falling);
	if ( (Weapon != None) && Weapon.bSplashDamage
		&& ((bFire != 0) || (bAltFire != 0)) && (Enemy != None) 
		&& !FastTrace(Enemy.Location, HitLocation) 
		&& FastTrace(Enemy.Location, Location) )
	{
		bFire = 0;
		bAltFire = 0;
	}
	GotoState('FallingState','Ducking');
}

function PlayFalling()
{
       	if ( Weapon != None )
	{
		if ( bCrouching )
			PlayCrouchShoot();
		else
		{
			if (HasTwoHandedWeapon())
				LoopAnimPivot('RunShoot2H',runAnimMult,0.1);
			else
				LoopAnimPivot('RunShoot',runAnimMult,0.1);
		}
	}
       	else
             		PlayAnimPivot('Jump', 3, 0.1);
}

function PlayLanded(float impactVel)
{
	bIsWalking = True;
	if (impactVel < -12*CollisionHeight)
		PlayAnimPivot('Land');
}

state FallingState
{
        	function adjustJump()
	{
		local float velZ;
		local vector FullVel;

		velZ = Velocity.Z;
		FullVel = Normal(Velocity) * GroundSpeed;
		Acceleration = vect(0,0,0);
		If (Location.Z > Destination.Z + CollisionHeight + 2 * MaxStepHeight)
		{
			Velocity = FullVel;
			Velocity.Z = velZ;
			Velocity = EAdjustJump();
			Velocity.Z = 0;
			if ( VSize(Velocity) < 0.9 * GroundSpeed )
			{
				Velocity.Z = velZ;
				return;
			}
		}

		PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 - 0.2*FRand());
		Velocity = FullVel;
		Velocity.Z = Default.JumpZ + velZ;
		Velocity = EAdjustJump();
	}

        	function Tick(float DeltaTime)
	{
                		Global.Tick(DeltaTime);
		if ( Enemy != None )
		{
			if (AICanShoot(Enemy, true, false, 0.025))
                        		{
                                			FireWeapon();
				GotoState('FallingState', 'FireWhileFalling');
                        		} 
		}
	}
    
        	function Landed(vector HitNormal)
	{
		local float landVol, minJumpZ;
		local vector legLocation;

		minJumpZ = FMax(JumpZ, 150.0);

		if ( (Velocity.Z < -0.8 * minJumpZ) || bUpAndOut)
		{
			PlayLanded(Velocity.Z);
			if (Velocity.Z < -1600)
			{
				legLocation = Location + vect(-1,0,-1);			// damage left leg
				TakeDamage(-0.14 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
				legLocation = Location + vect(1,0,-1);			// damage right leg
				TakeDamage(-0.14 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
				legLocation = Location + vect(0,0,1);			// damage torso
				TakeDamage(-0.04 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
			}
			landVol = Velocity.Z/JumpZ;
			landVol = 0.005 * Mass * FMin(5, landVol * landVol);
			if ( !FootRegion.Zone.bWaterZone )
				PlaySound(Land, SLOT_Interact, FMin(20, landVol));
		}
		else if ( Velocity.Z < -0.8 * JumpZ )
			PlayLanded(Velocity.Z);
	}

        	function SeePlayer(Actor SeenPlayer)
	{
		Global.SeePlayer(SeenPlayer);
		disable('SeePlayer');
		disable('HearNoise');
	}

	function EnemyNotVisible()
	{
		enable('SeePlayer');
		enable('HearNoise');
	}

        	function FindNewJumpDest()
	{
		local NavigationPoint N, Best;
		local float BestRating, Rating;
		local vector Dist;

		// look for pathnode below current location and visible
		BestRating = 1;
		for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
			if ( N.Location.Z + 100 < Location.Z )
			{
				Dist = Location - N.Location;
				Rating = Dist.Z * Dist.Z/(Dist.X * Dist.X + Dist.Y * Dist.Y); 
				if ( (Rating > BestRating) && FastTrace(N.Location, Location) )
				{
					BestRating = Rating;
					Best = N;
				}
			}
				
		if ( Best != None )
			Destination = Best.Location;
	}
      
FireWhileFalling:

	Disable('HearNoise');
	Disable('SeePlayer');
	if ( Physics != PHYS_Falling )
		Goto('Done');
	if ( Enemy == None )
		Goto('LongFall');
	TurnToward(Enemy);
	FireIfClearShot();

	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		if ( (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
			FindNewJumpDest();			
		StrafeFacing(Destination, Enemy);
	}
	else
		Sleep(0.5 + 0.2 * FRand());
	if ( LineOfSightTo(Enemy) )
		Goto('FireWhileFalling');
LongFall:
        	if ( (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z)
		&& (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
	{
		FindNewJumpDest();
		MoveTo(Destination);
	}			
	if ( bCanFly )
	{
		SetPhysics(PHYS_Flying);
		Goto('Done');
	}
	Sleep(0.7);
	PlayFalling();
        	if ( Enemy != None )
	    	TurnToward(Enemy);
	if ( (Velocity.Z > -150) && (Region.Zone.ZoneGravity.Z <= Region.Zone.Default.ZoneGravity.Z) ) //stuck
	{
		SetPhysics(PHYS_Falling);
		if ( Enemy != None )
			Velocity = groundspeed * normal(Enemy.Location - Location);
		else
			Velocity = groundspeed * VRand();

		Velocity.Z = FMax(JumpZ, 250);
	}
	Goto('LongFall');

FastLanded:
	FinishAnim();
	TweenToWaiting(0.15);
	Goto('Done');

Landed:
	FinishAnim();
	TweenToWaiting(0.2);
	
Done:
	bUpAndOut = false;
	if (HasNextState())
		GotoNextState();
	else
		GotoState('Wandering');

Splash:
	bUpAndOut = false;
	FinishAnim();
	if (HasNextState())
		GotoNextState();
	else
		GotoState('Wandering');

Begin:
	if (Enemy == None)
		Disable('EnemyNotVisible');
	else
	{
		Disable('HearNoise');
		Disable('SeePlayer');
	}
	if (bUpAndOut) //water jump
	{
		DesiredRotation = Rotation;
		DesiredRotation.Pitch = 0;
		Velocity.Z = 440; 		
	}
	else
	{	
		if (Region.Zone.bWaterZone)
		{
			SetPhysics(PHYS_Swimming);
			GotoNextState();
		}	
		if ( !bJumpOffPawn )
			AdjustJump();
		else
			bJumpOffPawn = false;

PlayFall:
		PlayFalling();
		FinishAnim();
	}
	
	if (Physics != PHYS_Falling)
		Goto('Done');
	Sleep(0.0);
        	if ((Enemy != None) && (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z))
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		Goto('FireWhileFalling');
	}

	Goto('LongFall');

Ducking:
	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		PlayFalling();
		if ( Enemy != None )
			Goto('FireWhileFalling');
	}

}

state HandlingEnemy
{
	function BeginState()
	{
		if (Enemy == None)
			GotoState('Seeking');
		else if ( bDefendPosition && (DefendPoint != None) )
		{
			GotoState('DefendPosition');
			return;
		}
		else if (RaiseAlarm == RAISEALARM_BeforeAttacking)
			GotoState('Alerting');
		else
			GotoState('Attacking');
	}
Begin:
}

State DefendPosition
{
      	ignores seeplayer, hearnoise;

	function ReactToInjury(Pawn instigatedBy, Name damageType, EHitLocation hitPos)
	{
		local Pawn oldEnemy;
		local bool bHateThisInjury;
		local bool bFearThisInjury;

		if ((health > 0) && (bLookingForInjury || bLookingForIndirectInjury))
		{
			oldEnemy = Enemy;

			bHateThisInjury = ShouldReactToInjuryType(damageType, bHateInjury, bHateIndirectInjury);
			bFearThisInjury = ShouldReactToInjuryType(damageType, bFearInjury, bFearIndirectInjury);

			if (bHateThisInjury)
				IncreaseAgitation(instigatedBy, 1.0);
			if (bFearThisInjury)
				IncreaseFear(instigatedBy, 2.0);

			if (ReadyForNewEnemy())
				SetEnemy(instigatedBy);

			if (ShouldFlee())
			{
				SetDistressTimer();
				PlayCriticalDamageSound();
				if (RaiseAlarm == RAISEALARM_BeforeFleeing)
					SetNextState('Alerting');
				else
					SetNextState('Fleeing');
			}
			else
			{
				SetDistressTimer();
				if (oldEnemy != Enemy)
					PlayNewTargetSound();
				SetNextState('DefendPosition', 'ContinueAttack');
			}
			GotoDisabledState(damageType, hitPos);
		}
	}

	function SetFall()
	{
		StartFalling('DefendPosition', 'ContinueAttack');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}

	function Reloading(DeusExWeapon reloadWeapon, float reloadTime)
	{
		Global.Reloading(reloadWeapon, reloadTime);
		if (bReadyToReload)
			if (IsWeaponReloading())
				if (!IsHandToHand())
					TweenToShoot(0);
	}

	function EDestinationType PickDestination()
	{
		local vector               distVect;
		local vector               tempVect;
		local rotator              enemyDir;
		local float                magnitude;
		local float                calcMagnitude;
		local int                  iterations;
		local EDestinationType     destType;
		local NearbyProjectileList projList;

		destPoint = None;
		if ( bDefendPosition && (DefendPoint != None) )
			destLoc = DefendPoint.Location;
		else
			destLoc = vect(0, 0, 0);
		destType  = DEST_Failure;

		if ( enemy == None )
			return (destType);

		if ( bCrouching && (CrouchTimer > 0) )
			destType = DEST_SameLocation;
		else
			destType  = DEST_Failure;

		if ( DefendPoint != None )
		{
			if ( LineOfSightTo(DefendPoint) )
			{
				if ( AICanShoot(enemy, true, false, 0.025) || ActorReachable(enemy) )
				{
					destType = ComputeBestFiringPosition(tempVect);
					if ( destType == DEST_NewLocation )
						destLoc = tempVect;
				}
				else 
					destType = DEST_SameLocation;
			}
			else
				destType  = DEST_Failure;
		}
		else
		{
			enemyDir = Rotator(Enemy.Location - Location);
			if ( AIPickRandomDestination(60, 150, enemyDir.Yaw, 0.5, enemyDir.Pitch, 0.5, 2, FRand()*0.4+0.35, tempVect) )
			{
				if ( !bDefendHome || IsNearHome(tempVect) )
				{
					destType = DEST_NewLocation;
					destLoc  = tempVect;
				}
			}
		}
		if (destType == DEST_Failure)
		{
			MoveTarget = GetNextWaypoint(DefendPoint);
			if (MoveTarget != None)
			{
				destPoint = MoveTarget;
				destType  = DEST_NewLocation;
				destLoc = DefendPoint.Location;
			}
		}
		
		return (destType);
	}

      	function bool FireIfClearShot()
	{
	     	Global.FireIfClearShot();	
	}
		
	function CheckAttack(bool bPlaySound)
	{
		local bool bCriticalDamage;
		local bool bOutOfAmmo;
		local Pawn oldEnemy;
		local bool bAllianceSwitch;

		oldEnemy = enemy;

		bAllianceSwitch = false;
		if (!IsValidEnemy(enemy))
		{
			if (IsValidEnemy(enemy, false))
				bAllianceSwitch = true;
			SetEnemy(None, 0, true);
		}

		if (enemy == None)
		{
			if ( (Orders == 'Attacking') || (Orders == 'DefendPosition') )
			{
				FindOrderActor();
				SetEnemy(Pawn(OrderActor), 0, true);
			}
		}
		if (ReadyForNewEnemy())
			FindBestEnemy(false);
		if (enemy == None)
		{
			Enemy = oldEnemy;  
			if (bPlaySound)
			{
				if (bAllianceSwitch)
					PlayAllianceFriendlySound();
				else 
					PlayAreaSecureSound();
			}
			Enemy = None;
			if ( (Orders != 'Attacking') && (Orders != 'DefendPosition') )
				FollowOrders();
			else
				GotoState('Wandering');
			return;
		}

		SwitchToBestWeapon();
		if (bCrouching && (CrouchTimer <= 0) && !ShouldCrouch())
		{
			EndCrouch();
			TweenToShoot(0.15);
		}
		bCriticalDamage = False;
		bOutOfAmmo      = False;
		if (ShouldFlee())
		{
			bCriticalDamage = True;
			bDefendPosition = False;
		}
		else if (Weapon == None)
            		{
			bOutOfAmmo = True;
			bDefendPosition = False;
                  		bAdvancedCombat = False;
            		}
		else if (Weapon.ReloadCount > 0)
		{
			if (Weapon.AmmoType == None)
                  	{
				bOutOfAmmo = True;
				bDefendPosition = False;
                        			bAdvancedCombat = False;
                  	}
			else if (Weapon.AmmoType.AmmoAmount < 1)
                  		{
				bOutOfAmmo = True;
				bDefendPosition = False;
                        			bAdvancedCombat = False;
                  		}
		}
		if ( bCriticalDamage || bOutOfAmmo )
		{	
			if (bPlaySound)
			{
				if (bCriticalDamage)
					PlayCriticalDamageSound();
				else if (bOutOfAmmo)
					PlayOutOfAmmoSound();
			}
                  		if (RaiseAlarm == RAISEALARM_BeforeFleeing)
			       	GotoState('Alerting');
			else
			      	GotoState('Fleeing');
		}
		else if ( bPlaySound && (oldEnemy != Enemy) )
			PlayNewTargetSound();
	}

	function Tick(float deltaSeconds)
	{
		local bool   bCanSee;
		local float  yaw;
		local vector lastLocation;
		local Pawn   lastEnemy;
		local float  surpriseTime;

		Global.Tick(deltaSeconds);
            
		if (CrouchTimer > 0)
		{
			CrouchTimer -= deltaSeconds;
			if (CrouchTimer < 0)
				CrouchTimer = 0;
		}
		EnemyTimer += deltaSeconds;
		UpdateActorVisibility(Enemy, deltaSeconds, 1.0, false);
		if ((Enemy != None) && HasEnemyTimedOut())
		{
			lastLocation = Enemy.Location;
			lastEnemy    = Enemy;
			FindBestEnemy(true);
			if (Enemy == None)
			{
				//SetSeekLocation(lastEnemy, lastLocation, SEEKTYPE_Guess, true);
				//GotoState('Seeking');
				GotoState('Standing');
			}
		}
		else if (bCanFire && (Enemy != None))
		{
			ViewRotation = Rotator(Enemy.Location-Location);
			if (bFacingTarget)
				FireIfClearShot();
			else if (!bMustFaceTarget)
			{
				yaw = (ViewRotation.Yaw-Rotation.Yaw) & 0xFFFF;
				if (yaw >= 32768)
					yaw -= 65536;
				yaw = Abs(yaw)*360/32768;  // 0-180 x 2
				if (yaw <= FireAngle)
					FireIfClearShot();
			}
		}
	}

	function bool IsHandToHand()
	{
		if (Weapon != None)
		{
			if (DeusExWeapon(Weapon) != None)
			{
				if (DeusExWeapon(Weapon).bHandToHand)
					return true;
				else
					return false;
			}
			else
				return false;
		}
		else
			return false;
	}

	function bool ReadyForWeapon()
	{
		local bool bReady;

		bReady = false;
		if (DeusExWeapon(weapon) != None)
		{
			if (DeusExWeapon(weapon).bReadyToFire)
				if (!IsWeaponReloading())
					bReady = true;
		}
		if (!bReady)
			if (enemy == None)
				bReady = true;
		if (!bReady)
			if (!AICanShoot(enemy, true, false, 0.025))
				bReady = true;

		return (bReady);
	}

	function bool ShouldCrouch()
	{
		if (bCanCrouch && !Region.Zone.bWaterZone && !IsHandToHand() &&
		    ((enemy != None) && (VSize(enemy.Location-Location) > 1200)) &&
		    ((DeusExWeapon(Weapon) == None) || DeusExWeapon(Weapon).bUseWhileCrouched))
			return true;
		else
			return false;
	}

	function StartCrouch()
	{
		if (!bCrouching)
		{
			bCrouching = true;
			SetBasedPawnSize(CollisionRadius, GetCrouchHeight());
			CrouchTimer = 1.0+FRand()*0.5;
		}
	}

	function EndCrouch()
	{
		if (bCrouching)
		{
			bCrouching = false;
			ResetBasedPawnSize();
		}
	}

	function BeginState()
	{
		StandUp();

		if (MaxRange < MinRange+10)
			MaxRange = MinRange+10;
		bCanFire      = false;
		bFacingTarget = false;

		SwitchToBestWeapon();
            		CallForHelp();
		BlockReactions();
		bCanConverse = False;
		bAttacking = True;
		bStasis = False;
		SetDistress(true);

		CrouchTimer = 0;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		bCanFire      = false;
		bFacingTarget = false;

		ResetReactions();
		bCanConverse = True;
		bAttacking = False;
		bStasis = True;
		bReadyToReload = false;
		EndCrouch();
	}

Begin:
	if (Enemy == None)
		GotoState('Standing');
	CheckAttack(false);

Surprise:
	if ((1.0-ReactionLevel)*SurprisePeriod < 0.25)
		Goto('BeginAttack');
      	Acceleration = vect(0,0,0);
	PlaySurpriseSound();
      	PlayWaiting();
      	while (ReactionLevel < 1.0)
	{
		TurnToward(Enemy);
		Sleep(0);
	}

BeginAttack:
      	EnemyReadiness = 1.0;
      	ReactionLevel  = 1.0;
	if (PlayerAgitationTimer > 0)
		PlayAllianceHostileSound();
	else
		PlayTargetAcquiredSound();
	if (PlayBeginAttack())
	{
		Acceleration = vect(0,0,0);
		TurnToward(enemy);
		FinishAnim();
	}

RunToRange:
	bCanFire       = false;
	bFacingTarget  = false;
	bReadyToReload = false;
	EndCrouch();
	if (Physics == PHYS_Falling)
		TweenToRunning(0.05);
	WaitForLanding();
	if (!IsWeaponReloading() || bCrouching)
	{
		if (ShouldPlayTurn(Enemy.Location))
			PlayTurning();
		TurnToward(enemy);
	}
	else
		Sleep(0);
	bCanFire = true;
	while (PickDestination() == DEST_NewLocation)
	{
		if (bCanStrafe && ShouldStrafe())
		{
			PlayRunningAndFiring();
			if (destPoint != None)
				StrafeFacing(destPoint.Location, enemy);
			else
				StrafeFacing(destLoc, enemy);
			bFacingTarget = true;
		}
		else
		{
			bFacingTarget = false;
                  			PlayRunning();
			if (destPoint != None)
				MoveToward(destPoint, MaxDesiredSpeed);
			else
				MoveTo(destLoc, MaxDesiredSpeed);
		}
		CheckAttack(true);
	}

Fire:
	bCanFire      = false;
	bFacingTarget = false;
	Acceleration = vect(0, 0, 0);

	SwitchToBestWeapon();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	if (IsHandToHand())
		TweenToAttack(0.15);
	else if (ShouldCrouch() && (FRand() < CrouchRate))
	{
		TweenToCrouchShoot(0.15);
		FinishAnim();
		StartCrouch();
	}
	else
		TweenToShoot(0.15);
	if (!IsWeaponReloading() || bCrouching)
		TurnToward(enemy);
	FinishAnim();
	bReadyToReload = true;

ContinueFire:
	while (!ReadyForWeapon())
	{
		if (PickDestination() != DEST_SameLocation)
			Goto('RunToRange');
		CheckAttack(true);
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
	}
	CheckAttack(true);
	if (!FireIfClearShot())
		Goto('ContinueAttack');
	bReadyToReload = false;
	if (bCrouching)
		PlayCrouchShoot();
	else if (IsHandToHand())
		PlayAttack();
	else
		PlayShoot();
	FinishAnim();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	bReadyToReload = true;
	if (!IsHandToHand())
	{
		if (bCrouching)
			TweenToCrouchShoot(0);
		else
			TweenToShoot(0);
	}
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
	{
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
		Goto('ContinueFire');
	}
	Goto('RunToRange');

ContinueAttack:
ContinueFromDoor:
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
		Goto('Fire');
	else
		Goto('RunToRange');
}

defaultproperties
{
     bCanDuck=True
     JumpSound=Sound'DeusExSounds.Player.MaleJump'
     HelpDistance=2400.000000
     Aggressiveness=0.500000
     maxRange=2400.000000
     MinHealth=0.000000
     bCanCommunicate=True
     bPlayIdle=True
     bCanCrouch=True
     bSprint=True
     AvoidAccuracy=0.500000
     HarmAccuracy=0.900000
     CrouchRate=1.000000
     SprintRate=1.000000
     bReactAlarm=True
     bAdvancedCombat=True
     SurprisePeriod=0.100000
     EnemyTimeout=10.000000
     bCanTurnHead=True
     WaterSpeed=80.000000
     AirSpeed=160.000000
     AccelRate=1024.000000
     JumpZ=200.000000
     SightRadius=7500.000000
     BaseEyeHeight=40.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     Skill=0.500000
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Land=Sound'DeusExSounds.Player.MaleLand'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     CombatStyle=0.500000
     VisibilityThreshold=0.010000
     DrawType=DT_Mesh
     Mass=150.000000
     Buoyancy=155.000000
     BindName="HumanMilitary"
}
