//=============================================================================
// HumanThug.
//=============================================================================
class HumanThug extends ScriptedPawn
	abstract;

function PostBeginPlay()
{
	Super.PostBeginPlay();

        	CheckInventory();
        	// change the sounds for chicks
	if (bIsFemale)
	{
		HitSound1 = Sound'FemalePainMedium';
		HitSound2 = Sound'FemalePainLarge';
		Die = Sound'FemaleDeath';
	}
	// hejhujka 40: Now the PeripheralVision and SightRadius is difficulty dependable.
	ResetAbilities();
}

function bool WillTakeStompDamage(actor stomper)
{
	// This blows chunks!
	if (stomper.IsA('PlayerPawn') && (GetPawnAllianceType(Pawn(stomper)) != ALLIANCE_Hostile))
		return false;
	else
		return true;
}

function CheckInventory()
{
        	if ((InitialInventory[0].Inventory == Class'WeaponAssaultShotgun')
           		&& (InitialInventory[1].Inventory == Class'AmmoShell')) 
        	{
                	InitialInventory[0].Inventory = Class'WeaponAssaultShotgun';
                	InitialInventory[1].Inventory = Class'AmmoSabot';
                	InitialInventory[1].Count = 12;
        	}   
}

function CallForHelp()
{
	local Pawn P;

	if ( Level.Game.Difficulty != 3 )
		return;

        	if (!bCanCommunicate)
           		return;
      	
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('ScriptedPawn') && (P.Alliance == Alliance) )
		     		P.HandleHelpMessageFrom(self);
}

function HandleHelpMessageFrom(Pawn Other)
{
	if ( Level.Game.Difficulty != 3 )
		return;
	if (!bCanCommunicate || bImportant || bDefendHome)
                		return;
        	if ( IsInState('Attacking') || IsInState('Fleeing') || IsInState('Seeking') || IsInState('Alerting') )
                		return;
        	if ( (Other.Enemy != None) && SetEnemy(Other.Enemy) && (VSize(Other.Enemy.Location - Location) < 1200)
           		&& (ActorReachable(Other.Enemy) || (FindPathToward(Other.Enemy) != None)) /*&& (RelativeStrength(Other.Enemy) <= 0)*/) 
                		HandleEnemy();
}

function ResetAbilities()
{
	if ( Default.PeripheralVision != 0.0 )
	{
		//log("No changes for "$Self$"");
		return;
	}

	if ( Level.Game.Difficulty == 0 )
	{
		PeripheralVision = 0.5;
		SightRadius = 3600.0;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else if ( Level.Game.Difficulty == 1 )
	{
		PeripheralVision = 0.4;
		SightRadius = 4000.0;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else if ( Level.Game.Difficulty == 2 )
	{
		PeripheralVision = 0.3;
		SightRadius = 4500.0;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
	else
	{
		PeripheralVision = Default.PeripheralVision;
		SightRadius = Default.SightRadius;
		//log(""$Self$" PeripheralVision = "$PeripheralVision$"");
	}
}

defaultproperties
{
     BaseAccuracy=0.050000
     maxRange=1800.000000
     MinHealth=5.000000
     bPlayIdle=True
     bAvoidAim=False
     bCanCrouch=True
     bSprint=True
     CrouchRate=0.200000
     SprintRate=0.500000
     bReactAlarm=True
     EnemyTimeout=5.000000
     bCanTurnHead=True
     WaterSpeed=80.000000
     AirSpeed=160.000000
     AccelRate=500.000000
     SightRadius=5000.000000
     BaseEyeHeight=40.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     VisibilityThreshold=0.010000
     DrawType=DT_Mesh
     Mass=150.000000
     Buoyancy=155.000000
     BindName="HumanThug"
}
