//=============================================================================
// JCDentonMale2.
//=============================================================================
class JCDentonMale2 extends JCDentonMale;

var bool bCombatMusic;

event TravelPostAccept()
{
	local DeusExLevelInfo info;

	Super.TravelPostAccept();

	musicCheckTimer = 0.0;
	musicChangeTimer = 0.0;
	musicMode = MUS_None;
}

function Bool FindInventorySlot(Inventory anItem, optional Bool bSearchOnly)
{
	local bool bPositionFound;
	local int row;
	local int col;
	local int newSlotX;
	local int newSlotY;
   	local int beltpos;
	local ammo foundAmmo;

	if (anItem == None)
		return False;

	/*if ( (Energy < EnergyMax) && anItem.IsA('BioelectricCell') )
		return True;*/

	if ( (Health < 100) && (anItem.IsA('HealthPickup') && HealthPickup(anItem).bIsHealth) )
		return True;
		
	if ( (anItem.IsA('DataVaultImage')) || (anItem.IsA('NanoKey')) || (anItem.IsA('Credits')) || (anItem.IsA('Ammo')) || (anItem.IsA('ChargedPickup'))  
           	|| (anItem.IsA('LockPick')) || (anItem.IsA('Multitool')) || (anItem.IsA('BioelectricCell')) || (anItem.IsA('AugmentationUpgradeCannister')) || ((anItem.IsA('DeusExPickup')) && DeusExPickup(anItem).bAutoActivate) )
		return True;

   	bPositionFound = False;
      	if ((anItem.invPosX != -1) && (anItem.invPosY != -1) && (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone)) && (!bSearchOnly))
   	{
      		SetInvSlots(anItem,1);
      		log("Trying to place item "$anItem$" when already placed at "$anItem.invPosX$", "$anItem.invPosY$".");
      		return True;
   	}

	for (row=0; row<maxInvRows; row++)
	{	
		if (row + anItem.invSlotsY > maxInvRows)
			break;

		// Make sure the item can fit vertically
		for(col=0; col<maxInvCols; col++)
		{
			if (IsEmptyItemSlot(anItem, col, row ))
			{
				bPositionFound = True;
				break;
			}
		}

		if (bPositionFound)
			break;
	}

   	if ((Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone)) && (bBeltIsMPInventory))
   	{
      		bPositionFound = False;
      		beltpos = 0;
      		if (DeusExRootWindow(rootWindow) != None)
      		{
         			for (beltpos = 0; beltpos < ArrayCount(DeusExRootWindow(rootWindow).hud.belt.objects); beltpos++)
         			{
            				if ( (DeusExRootWindow(rootWindow).hud.belt.objects[beltpos].item == None) && (anItem.TestMPBeltSpot(beltpos)) )
            				{
               					bPositionFound = True;
            				}
         			}
      		}
      		else
      		{
         			log("no belt to check");
      		}
   	}

   	if ((bPositionFound) && (!bSearchOnly))
   	{
		PlaceItemInSlot(anItem, col, row);
   	}
   
	return bPositionFound;
}

function UpdateDynamicMusic(float deltaTime)
{
	local Pawn P;
	local ScriptedPawn S;
	local DeusExLevelInfo info;

        	if ( Level.Song == None )
		return;

	musicCheckTimer += deltaTime;
	musicChangeTimer += deltaTime;

	if ( !PlayerIsClient() )
   	{
      		if ( (musicMode == MUS_Dying) || (musicMode == MUS_Outro) )
         			return;
   	}
   	else
   	{
      		if ( musicMode == MUS_Outro )
         			return;
   	}

	if ( IsInState('Interpolating') )
	{
		info = GetLevelInfo();
		if ( (info != None) && (info.MissionNumber < 0) )
		{
			musicMode = MUS_Outro;
			return;
		}

		if ( musicMode != MUS_Outro )
		{
			ClientSetMusic(Level.Song, 5, 255, MTRAN_FastFade);
			musicMode = MUS_Outro;
		}
	}

        	else if ( IsInState('Dying') )
	{
	       	if ( musicMode != MUS_Dying )
	       	{
		       	ClientSetMusic(Level.Song, 1, 255, MTRAN_Fade);
		       	musicMode = MUS_Dying;
	       	}
	}

        	else 
        	{
		if ( musicCheckTimer >= 1.0 )
		{
			musicCheckTimer = 0.0;
			bCombatMusic = False;
			for ( P = Level.PawnList; P != None; P = P.NextPawn )
			{
				S = ScriptedPawn(P);
				if ( (S != None) && (S.GetPawnAllianceType(Self) == ALLIANCE_Hostile) )
				{
					bCombatMusic = True;
                  				break;
				}
			}
		
			if (bCombatMusic )
			{
				musicChangeTimer = 0.0;
				if ( musicMode != MUS_Combat )
				{
					if (musicMode == MUS_Ambient)
						savedSection = SongSection;
					else
						savedSection = 255;
					ClientSetMusic(Level.Song, 3, 255, MTRAN_FastFade);
					musicMode = MUS_Combat;
				}	 
			}

               			else if ( musicMode != MUS_Ambient )
	       		{	
				if (musicChangeTimer >= 5.0)
				{
					if (savedSection == 255)
						savedSection = Level.SongSection;
					if (musicMode == MUS_Combat)
						ClientSetMusic(Level.Song, savedSection, 255, MTRAN_SlowFade);
					else
						ClientSetMusic(Level.Song, savedSection, 255, MTRAN_Fade);
					savedSection = 255;		
		            			musicMode = MUS_Ambient;
					musicChangeTimer = 0.0;
				}
               			}
		}
	}				
}

defaultproperties
{
     maxInvRows=3
     maxInvCols=3
}
