//=============================================================================
// Kill the leader
//=============================================================================
class KTLGame expands TeamDMGame;

var int UNleaders;
var int NSFleaders;
var localized String EnemyKillString, FriendKillString;
var int UnatcoScore, NSFScore;

replication
{
	// Server to client
	reliable if ( Role == ROLE_Authority )
		UnatcoScore, NSFScore;
}

function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N;
	local byte Team;

	if ( (Player != None) && (Player.PlayerReplicationInfo != None) )
		Team = Player.PlayerReplicationInfo.Team;
	else
		Team = InTeam;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;
	if ( Team == 255 )
		Team = 0;
	
	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled
			&& (!bSpawnInTeamArea || (Team == Dest.TeamNumber)) )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
	{
		log("Didn't find any player starts in list for team"@Team@"!!!"); 
		foreach AllActors( class'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
		if ( num == 0 )
			return None;
	}

	if (num>16) 
		num = 16;
	
	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( Candidate[i] == LastStartSpot )
			Score[i] = -6000.0;
		else
			Score[i] = 4000 * FRand(); //randomize
	}		
	
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for (i=0; i<num; i++)
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone ) 
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if (NextDist < 2 * (CollisionRadius + CollisionHeight))
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && (OtherPlayer.PlayerReplicationInfo.Team != Team)
							&& FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1; i<num; i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}

        	LastStartSpot = Best;
	
	return Best;
}

function bool AddUNLeader()
{
	local LeaderBot NewBot;
	local NavigationPoint StartSpot, OldStartSpot;

	NewBot = SpawnUNLeaderBot(StartSpot);
	if ( NewBot == None )
	{
		log("Failed to spawn leaderbot.");
		return false;
	}

        	if ( bSpawnInTeamArea )
	{      
            		OldStartSpot = StartSpot;
	    	StartSpot = FindPlayerStart(NewBot,255);
	    	if ( StartSpot != None )
	    	{
			NewBot.SetLocation(StartSpot.Location);
			NewBot.SetRotation(StartSpot.Rotation);
			NewBot.ViewRotation = StartSpot.Rotation;
			NewBot.SetRotation(NewBot.Rotation);
			StartSpot.PlayTeleportEffect( NewBot, true );
	    	}
	    	else
			StartSpot = OldStartSpot;
         	}

	StartSpot.PlayTeleportEffect(NewBot, true);
	NewBot.PlayerReplicationInfo.bIsABot = True;

	// Log it.
	if (LocalLog != None)
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if (WorldLog != None)
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}

	return true;
}

function LeaderBot SpawnUNLeaderBot(out NavigationPoint StartSpot)
{
	local LeaderBot NewBot;
        	local Pawn P;
        	
	// Find a start spot.
	StartSpot = FindPlayerStart(NewBot, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for LeaderBot");
		return None;
	}

	// Try to spawn the bot.
        	NewBot = Spawn(Class'UN_Leader',,,StartSpot.Location,StartSpot.Rotation);
                
	if ( NewBot == None )
		log("Couldn't spawn leaderbot at "$StartSpot);

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
                		BotName = NewBot.Default.FamiliarName;
                		ChangeName(NewBot, BotName, false );
                		AddDefaultInventory(NewBot);
                		NewBot.PlayerReplicationInfo.Team = TEAM_UNATCO; 
                		NewBot.PlayerReplicationInfo.TalkTexture = NewBot.TauntPortrait;                          
		NewBot.ViewRotation = StartSpot.Rotation;
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );
                		NewBot.AirControl = AirControl;
                		unleaders++;
	}
	return NewBot;
}

function bool AddNSFLeader()
{
	local LeaderBot NewBot;
	local NavigationPoint StartSpot, OldStartSpot;

	NewBot = SpawnNSFLeaderBot(StartSpot);
	if ( NewBot == None )
	{
		log("Failed to spawn leaderbot.");
		return false;
	}

        	if ( bSpawnInTeamArea )
	{      
            		OldStartSpot = StartSpot;
	    	StartSpot = FindPlayerStart(NewBot,255);
	    	if ( StartSpot != None )
	    	{
			NewBot.SetLocation(StartSpot.Location);
			NewBot.SetRotation(StartSpot.Rotation);
			NewBot.ViewRotation = StartSpot.Rotation;
			NewBot.SetRotation(NewBot.Rotation);
			StartSpot.PlayTeleportEffect( NewBot, true );
	    	}
	    	else
			StartSpot = OldStartSpot;
         	}

	StartSpot.PlayTeleportEffect(NewBot, true);
	NewBot.PlayerReplicationInfo.bIsABot = True;

	// Log it.
	if (LocalLog != None)
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if (WorldLog != None)
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}

	return true;
}

function LeaderBot SpawnNSFLeaderBot(out NavigationPoint StartSpot)
{
	local LeaderBot NewBot;
        	local Pawn P;
        	
	// Find a start spot.
	StartSpot = FindPlayerStart(NewBot, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for LeaderBot");
		return None;
	}

	// Try to spawn the bot.
        	NewBot = Spawn(Class'NSF_Leader',,,StartSpot.Location,StartSpot.Rotation);
                
	if ( NewBot == None )
		log("Couldn't spawn leaderbot at "$StartSpot);

	if ( NewBot != None )
	{
		// Set the player's ID.
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
                		BotName = NewBot.Default.FamiliarName;
                		ChangeName(NewBot, BotName, false );
                		AddDefaultInventory(NewBot);
                		NewBot.PlayerReplicationInfo.Team = TEAM_NSF;   
                		NewBot.PlayerReplicationInfo.TalkTexture = NewBot.TauntPortrait;                           
		NewBot.ViewRotation = StartSpot.Rotation;
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );
                		NewBot.AirControl = AirControl;
                		nsfleaders++;
	}
	return NewBot;
}

function Killed( pawn Killer, pawn Other, name damageType )
{
	local bool NotifyDeath;
	local DeusExPlayer otherPlayer;
	local Pawn CurPawn;

        	if ( bFreezeScores )
            		return;

	NotifyDeath = False;
	
        	if ( (Killer.bIsPlayer) && (Other.bIsPlayer) )
        	{
                		BroadcastDeathMessage(Killer, Other, damageType);

		if ( Killer != Other )
		{     
                   		Killer.Spree++;
		   	if ( Killer.Spree > 4 )
		        		NotifySpree(Killer.PlayerReplicationInfo.PlayerName, Killer.Spree);
                   		if ( Other.Spree > 4 )
		        		EndSpree(Killer.PlayerReplicationInfo.PlayerName, Other.PlayerReplicationInfo.PlayerName); 
	           		Other.Spree = 0;
                   		if (( Killer.Health > 0 ) && (Level.TimeSeconds - LastTauntTime > 3))
                   		{
                        			LastTauntTime = Level.TimeSeconds;
                        			Killer.SendGlobalMessage(None, 'AUTOTAUNT', 0, 0);
                   		}

                   		if (Other.IsA('LeaderBot'))
                   		{
				if (ArePlayersAllied(Other,Killer))
				{
					if ( Killer.PlayerReplicationInfo.Score > 0 )
						Killer.PlayerReplicationInfo.Score -= 1;
                                				if (Killer.IsA('DeusExPlayer'))
				        		DeusExPlayer(Killer).MultiplayerNotifyMsg( DeusExPlayer(Killer).MPMSG_KilledTeammate, 0, "" );
		        		}
                        			else
                        			{
					Killer.PlayerReplicationInfo.Score += 1;
					Killer.PlayerReplicationInfo.Streak += 1;
                                				Other.PlayerReplicationInfo.Deaths += 1;
		                			Other.PlayerReplicationInfo.Streak = 0;
                                				PlayWinningSound();                                                                 
				
					if (CheckVictoryConditions(Killer, Other, "") )
                                				{
                                   					bFreezeScores = True;
                                   					NotifyDeath = False;
                                				}
                    								
	          			}
                        			NotifyLeaderKill(Killer.PlayerReplicationInfo.PlayerName, Other);
                   		}
                   		else
                   		{
                       			NotifyDeath = !bFreezeScores;
                   		}
		}
		if ( NotifyDeath )
			HandleDeathNotification( Killer, Other );
        	}
        	else
        	{
		if (NotifyDeath)
			HandleDeathNotification( Killer, Other );      
        	} 
}

function NotifyLeaderKill(String KillerName, Pawn Leader)
{
  	local Pawn P;
  	local String str;

	UnatcoScore = TeamScore[TEAM_UNATCO];
	NSFScore = TeamScore[TEAM_NSF];
  
  	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
  	{
        		if ( P.IsA('DeusExPlayer') )
        		{
            			if ( ArePlayersAllied(Leader, DeusExPlayer(P)) )
                				str = KillerName $ FriendKillString;
            			else
                				str = KillerName $ EnemyKillString; 
            			DeusExPlayer(P).MultiplayerNotifyMsg( DeusExPlayer(P).MPMSG_LeaderKill, , str );
        		}
   	}
}
		
function bool AddBot()
{
	local Bot NewBot;
	local NavigationPoint StartSpot, OldStartSpot;

	NewBot = SpawnBot(StartSpot);
	if ( NewBot == None )
	{
		log("Failed to spawn bot.");
		return false;
	}

        	if ( bSpawnInTeamArea )
	{      
            		OldStartSpot = StartSpot;
	    	StartSpot = FindPlayerStart(NewBot,255);
	    	if ( StartSpot != None )
	    	{
			NewBot.SetLocation(StartSpot.Location);
			NewBot.SetRotation(StartSpot.Rotation);
			NewBot.ViewRotation = StartSpot.Rotation;
			NewBot.SetRotation(NewBot.Rotation);
			StartSpot.PlayTeleportEffect( NewBot, true );
	    	}
	    	else
			StartSpot = OldStartSpot;
         	}

	StartSpot.PlayTeleportEffect(NewBot, true);
        	SetBotOrders(NewBot);
	NewBot.PlayerReplicationInfo.bIsABot = True;

	// Log it.
	if (LocalLog != None)
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if (WorldLog != None)
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}

	return true;
}

function Timer()
{    
    	Super.Timer();   
   
    	if (UNleaders < 1)
        		AddUNLeader(); 
    	if (NSFleaders < 1)
        		AddNSFLeader();        
}

function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken && ((N.OwnerTeam != '') && (N.OwnerTeam == aBot.Alliance))
			&& ((aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location))) )
				aBot.Ambushspot = Ambushpoint(N);
}

function PickLeaderBaseFor(LeaderBot aLeader)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		if ( N.IsA('HomeBase') && ((N.OwnerTeam != '') && (N.OwnerTeam == aLeader.Alliance)) )
		{
			aLeader.LeaderSpot = HomeBase(N);
			log(Self$" assigned "$aLeader$"'s base at "$aLeader.LeaderSpot);
		}
	}
}

function PlayWinningSound()
{
  	local Pawn P;

  	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
  		if ( P.IsA('PlayerPawn') )
	     		PlayerPawn(P).ClientPlaySound(Sound'LeaderSound');
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
   	if ( Other.IsA('LeaderBot') && (Other.Alliance != aBot.Alliance) )
		return 10;
   	else
		return 0;
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if ( aBot.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team )
		return 3; 
	else if ( Other.IsA('LeaderBot') && (Other.Alliance != aBot.Alliance) )
		return 1;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function SetBotOrders(Bot NewBot)
{
	local Pawn P, L, M;
	local int num;
	local bool bAvailable;

	if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance' )
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Attack';
	else if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Defend' )
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Freelance';
	else 
	{
		CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Defend';		
		if ( bNoviceMode )
			for ( P=Level.PawnList; P!=None; P= P.NextPawn )
				if ( P.bIsPlayer && (P != NewBot) && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
					&& P.IsA('Bot') && (BotReplicationInfo(P.PlayerReplicationInfo).RealOrders == 'Defend') && (FRand() < 0.5) )
					{	
						CurrentOrders[NewBot.PlayerReplicationInfo.Team] = 'Attack';
						break;
					}
	}		

	if ( ((CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Attack') || (CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance'))	
		&& (NumSupportingPlayer == 0) )
	{
		For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('PlayerPawn') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
				&& !P.IsA('Spectator') )
		{
			num++;
			if ( (L == None) || (FRand() < 1.0/float(num)) )
				L = P;
		}

		if ( L != None )
		{
			NumSupportingPlayer++;
			NewBot.SetOrders('Follow',L, true);
			return;
		}
		else if ( FRand() < 0.8 )
		{
			// no players on this team - possibly support other bot
			num = 0;
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('Bot') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) 
					&& (Bot(P).Orders == 'Attack') )
			{
				num++;
				if ( (L == None) || (FRand() < 1.0/float(num)) )
				{
					// make sure P doesn't already have a follower
					bAvailable = true;
					for ( M=Level.PawnList; M!=None; M=M.NextPawn )
						if ( M.IsA('Bot') && (M.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) 
							&& (Bot(M).Orders == 'Follow') && (Bot(M).OrderObject == P) )
							bAvailable = false;
					if ( bAvailable )
						L = P;
				}
			}

			if ( L != None )
			{
				NewBot.SetOrders('Follow',L, true);
				return;
			}
		}
	}
	
	if ( CurrentOrders[NewBot.PlayerReplicationInfo.Team] == 'Freelance' )
		NewBot.SetOrders('Attack', None, true);
	else	
		NewBot.SetOrders(CurrentOrders[NewBot.PlayerReplicationInfo.Team], None, true);
}

function Actor SetDefenseFor(Bot aBot)
{
   	local Actor Result;
   	local NavigationPoint N;

   	Result = None;

   	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
          		if ( N.IsA('HomeBase') && ((N.OwnerTeam != '') && (N.OwnerTeam == aBot.Alliance)) )
               			Result = N;
  
   	return Result;	
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	local NavigationPoint N;
	local bool bOrdered;

	if ( aBot.LastAttractCheck == Level.TimeSeconds )
		return false;
	aBot.LastAttractCheck = Level.TimeSeconds;
	
	bOrdered = (aBot.Orders == 'Follow') || (aBot.Orders == 'Hold') || (aBot.Orders == 'Defend'); 
					
	if ( !bOrdered )
	{
           		for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
               			if ( N.IsA('HomeBase') && ((N.OwnerTeam != '') && (N.OwnerTeam != aBot.Alliance)) )
               			{
              	  			if ( aBot.ActorReachable(N) )
					aBot.MoveTarget = N;
                  			else
					aBot.MoveTarget = aBot.FindPathToward(N);
                  			SetAttractionStateFor(aBot);
               			}
               			return true;
        	} 
        	else  		
	    	return false;
}

function SetAttractionStateFor(Bot aBot)
{
	if ( aBot.Enemy != None )
	{
		if ( !aBot.IsInState('FallBack') )
		{
			aBot.bNoClearSpecial = true;
			aBot.TweenToRunning(0.1);
			aBot.GotoState('FallBack','SpecialNavig');
		}
	}
	else if ( !aBot.IsInState('Roaming') )
	{
		aBot.bNoClearSpecial = true;
		aBot.TweenToRunning(0.1);
		aBot.GotoState('Roaming', 'SpecialNavig');
	}
}

defaultproperties
{
     EnemyKillString=" killed the Enemy Leader!"
     FriendKillString=" killed the Friendly Leader!"
     VictoryConString2=" 'leader kills' wins the match."
     bSpawnInTeamArea=True
     CurrentOrders(0)=Freelance
     CurrentOrders(1)=Freelance
     bCoopWeaponMode=True
     MapListType=Class'DeusEx.KtlMaplist'
}
