//=============================================================================
// DXMapList.
//
// contains a list of maps to cycle through
//
//=============================================================================
class KTLMapList extends Maplist;

var(Maps) globalconfig string Maps[64];
var globalconfig string MapSizes[64];
var globalconfig int MapNum;
var localized string CycleNames[10];
var int CycleType;
const MCT_STATIC = 0;
const MCT_RANDOM = 1;
const MCT_CYCLE = 2;

var int NumTypes;

function string GetNextMap()
{
	local string CurrentMap;
        local int NumMaps;
	local int i;

	CurrentMap = GetURLMap();
	if ( CurrentMap != "" )
	{
      		if ( Right(CurrentMap,3) ~= ".dx" )
			CurrentMap = Left(CurrentMap,Len(CurrentMap)-3);
		else
			CurrentMap = CurrentMap;

		for ( i=0; i<ArrayCount(Maps); i++ )
		{
			if ( CurrentMap ~= Maps[i] )
			{
				MapNum = i;
				break;
			}
		}
	}

        for (i = 0; ( (i < ArrayCount(Maps)) && (Maps[i] != "") ); i++);
        NumMaps = i;
        MapNum++;
        if (MapNum >= NumMaps)
            MapNum = 0;

        SaveConfig();

        return Maps[MapNum];
}

defaultproperties
{
     Maps(0)="KTL_HongKong"
     Maps(1)="KTL_Training"
     Maps(2)="KTL_Deck17"
     Maps(3)="KTL_AV_Memory_1"
     MapNum=0
     CycleNames(0)="Repeat map"
     CycleNames(1)="Random map"
     CycleNames(2)="Loop maps"
     NumTypes=3
}
