//=============================================================================
// LastManStanding.
//=============================================================================
class LastManStanding extends DeathMatchGame;

var() int Lives;
var int NumGhosts;
var bool bNoAmbush;
var PlayerPawn LocalPlayer;
var localized String LivesString;

event InitGame( string Options, out string Error )
{
	local string InOpt;

	Super.InitGame(Options, Error);
	if ( ScoreToWin == 0 )
		Lives = 10;
	else
		Lives = ScoreToWin;

        VictoryCondition = "Frags";
}

function float GameThreatAdd(Bot aBot, Pawn Other)
{
	if ( !Other.bIsPlayer ) 
		return 0;
	else
		return 0.1 * Other.PlayerReplicationInfo.Score;
}

event playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local playerpawn NewPlayer;
	local Pawn P;

	// if more than 15% of the game is over, must join as spectator.
	if ( TotalKills > 0.15 * (NumPlayers + NumBots) * Lives )
	{
		SpawnClass = class'Spectator';
		if ( (NumSpectators >= MaxSpectators)
			&& ((Level.NetMode != NM_ListenServer) || (NumPlayers > 0)) )
		{
			MaxSpectators++;
		}
	}
	NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);

	if ( (NewPlayer != None) && !NewPlayer.IsA('Spectator') )
		NewPlayer.PlayerReplicationInfo.Score = Lives;

	return NewPlayer;
}

event PostLogin( playerpawn NewPlayer )
{
	if( NewPlayer.Player != None && Viewport(NewPlayer.Player) != None)
		LocalPlayer = NewPlayer;

	Super.PostLogin(NewPlayer);
}
 
function bool NeedPlayers()
{
	if ( bFreezeScores || (TotalKills > 0.15 * (NumPlayers + NumBots) * Lives) )
		return false;
	return Super.NeedPlayers();
}

function bool IsRelevant(actor Other) 
{
	local Mutator M;
	local bool bArenaMutator;

	for (M = BaseMutator; M != None; M = M.NextMutator)
	{
		if (M.IsA('Arena'))
			bArenaMutator = True;
	}

	if ( bArenaMutator )
	{
		if ( Other.IsA('Inventory') && (Inventory(Other).MyMarker != None) && !Other.IsA('Ammo'))
		{
			Inventory(Other).MyMarker.markedItem = None;
			return false;
		}
	}
        else
        {
		if ( Other.IsA('Inventory') && (Inventory(Other).MyMarker != None) )
		{
			Inventory(Other).MyMarker.markedItem = None;
			return false;
		}
	}

	return Super.IsRelevant(Other);
}

function bool RestartPlayer( pawn aPlayer )	
{
	local NavigationPoint startSpot;
	local bool foundStart;
        local DeusExPlayer PlayerToRestart;
	local Pawn P;

	if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		return true;

	if ( aPlayer.PlayerReplicationInfo.Score < 1 )
	{
		NotifyOut (aPlayer.PlayerReplicationInfo.PlayerName);
		For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.bIsPlayer && (P.PlayerReplicationInfo.Score >= 1) )
				P.PlayerReplicationInfo.Score += 0.00001;
		if ( aPlayer.IsA('Bot') )
		{
			aPlayer.PlayerReplicationInfo.bIsSpectator = true;
			aPlayer.PlayerReplicationInfo.bWaitingPlayer = true;
			aPlayer.GotoState('GameEnded');
			return false; // bots don't respawn when ghosts
		}
	}

	startSpot = FindPlayerStart(None, 255);
	if( startSpot == None )
		return false;
		
	foundStart = aPlayer.SetLocation(startSpot.Location);
	if( foundStart )
	{
		startSpot.PlayTeleportEffect(aPlayer, true);
		aPlayer.SetRotation(startSpot.Rotation);
		aPlayer.ViewRotation = aPlayer.Rotation;
                aPlayer.GroundSpeed = aPlayer.Default.GroundSpeed;
		aPlayer.Acceleration = vect(0,0,0);
		aPlayer.Velocity = vect(0,0,0);
		aPlayer.Health = aPlayer.Default.Health;
		aPlayer.ClientSetRotation( startSpot.Rotation );
		aPlayer.bHidden = false;
		aPlayer.SoundDampening = aPlayer.Default.SoundDampening;
                aPlayer.DamageScaling = aPlayer.Default.DamageScaling;
		if ( aPlayer.PlayerReplicationInfo.Score < 1 )
		{
			aPlayer.bHidden = true;
			aPlayer.PlayerRestartState = 'PlayerSpectating';
		} 
		else
		{
			aPlayer.SetCollision( true, true, true );
                        AddDefaultInventory(aPlayer);
			if (aPlayer.IsA('DeusExPlayer'))
                        {
                             PlayerToRestart = DeusExPlayer(aPlayer);
                             PlayerToRestart.ShowHud(True);
                             PlayerToRestart.AugmentationSystem.ResetAugmentations();
                             PlayerToRestart.SkillSystem.ResetSkills();    
                             PlayerToRestart.ResetPlayerToDefaults();
                             PlayerToRestart.ClearAugmentationDisplay();
                             PlayerToRestart.AugmentationSystem.CreateAugmentations(PlayerToRestart);
                             PlayerToRestart.AugmentationSystem.AddDefaultAugmentations();
                             PlayerToRestart.Energy = PlayerToRestart.EnergyMax;
                             PlayerToRestart.SkillSystem.CreateSkills(PlayerToRestart);
                             PlayerToRestart.myProjKiller = None;
                             AddDefaultInventory(PlayerToRestart);
                        } 
		}
	}
        
	return foundStart;
}

function Logout( pawn Exiting )
{
        local Pawn winner;

	Super.Logout(Exiting);
	
	if( LocalPlayer == None || Exiting != LocalPlayer )
		CheckEndGame(winner);
}

function Killed( pawn Killer, pawn Other, name damageType )
{
	local bool NotifyDeath;
	local Pawn CurPawn;

        if ( bFreezeScores )
             return;

	NotifyDeath = False;
	
	if ( Other.bIsPlayer )
	{
            if (Other.PlayerReplicationInfo.Score > 0)
		Other.PlayerReplicationInfo.Score -= 1;
            TotalKills++;
            NotifyDeath = True;
	}
  
        if ((Killer.bIsPlayer) && (Other.bIsPlayer))
        {
            BroadcastDeathMessage(Killer, Other, damageType);
 	                          
	    if (Killer != Other)
	    {
		 Killer.Spree++;
		 if (Killer.Spree > 4)
		     NotifySpree(Killer.PlayerReplicationInfo.PlayerName, Killer.Spree);
                 if (Other.Spree > 4)
		     EndSpree(Killer.PlayerReplicationInfo.PlayerName, Other.PlayerReplicationInfo.PlayerName); 
	         Other.Spree = 0;
                 if (( Killer.Health > 0 ) && (Level.TimeSeconds - LastTauntTime > 3))
                 {
                      LastTauntTime = Level.TimeSeconds;
                      Killer.SendGlobalMessage(None, 'AUTOTAUNT', 0, 0);
                 }
	    }
            if ( CheckVictoryConditions(Killer, Other, "") )
            {
                 bFreezeScores = True;
                 NotifyDeath = False;
            }
            if ( NotifyDeath )
		 HandleDeathNotification( Killer, Other );
	}

        else
        {
	    if ( NotifyDeath )
	         HandleDeathNotification( Killer, Other ); 
        }
}

function bool CheckVictoryConditions( Pawn Killer, Pawn Killee, String Method )
{
	local Pawn winner;

	CheckEndGame ( winner );

	if ( winner != None )
	{
		if ( winner.PlayerReplicationInfo.Score >= 1 )
		{
			PlayerHasWon( winner, Killer, Killee, Method );
			return True;
		}
	}

	return false;
}

function CheckEndGame ( out Pawn curWinner )
{
	local Pawn PawnLink;
        local Pawn FinalPawn;
        local Pawn BotLink;
        local bool bStillHuman;
	local Bot B, D;
	local int StillPlaying;
        	
        NumGhosts = 0;
        for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.nextPawn )
        {
		if ( PawnLink.bIsPlayer )
		{
			if ( PawnLink.PlayerReplicationInfo.Score < 1 )
				NumGhosts++;
			else
			{
				if ( PawnLink.IsA('DeusExPlayer') )
					bStillHuman = true;
                                StillPlaying++;
			}
		}
        }
        
        if ( !bStillHuman )
	{
		for ( BotLink=Level.PawnList; BotLink!=None; BotLink=BotLink.NextPawn )
		{
			B = Bot(BotLink);
			if ( B != None )
			{
                                bNoAmbush = True;
				B.CampingRate = 0;
				B.Aggressiveness += 5.0;
                                B.Ambushspot = None;
				if ( D == None )
					D = B;
				else if ( B.Enemy == None )
					B.SetEnemy(D);
			}
		}
	}	

        if (StillPlaying < 2) 
            for ( FinalPawn=Level.PawnList; FinalPawn!=None; FinalPawn=FinalPawn.nextPawn )
                  if ( FinalPawn.PlayerReplicationInfo.Score >= 1 )
		       curWinner = FinalPawn;
}

function bool PickupQuery( Pawn Other, Inventory item )
{
	if ( Other.PlayerReplicationInfo.Score < 1 )
		return false;
	
	return Super.PickupQuery( Other, item );
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	local float Adjust;

	if ( aBot.bNovice )
		Adjust = -0.2;
	else
		Adjust = -0.2 - 0.1 * aBot.Skill;
	if ( Other.bIsPlayer && (Other.PlayerReplicationInfo.Score < 1) )
		return 2; 
	else if ( aBot.bKamikaze )
		return 1;
	else if (aBot.RelativeStrength(Other) > aBot.Aggressiveness - Adjust) 
		return 0;
	else
		return 1;
}

function AddDefaultInventory( pawn PlayerPawn )
{
      local Weapon weap;
      local Bot B;
      local class<Weapon> WeapClass;
      local float F;
      local int i;
      local Inventory inv;
      local Ammo20mm ammo;
        
      if( PlayerPawn.IsA('Spectator') )
	  return;

      Super.AddDefaultInventory(PlayerPawn);

      GiveWeapon(PlayerPawn, "DeusEx.WeaponPepperGun");
      GiveWeapon(PlayerPawn, "DeusEx.WeaponMiniCrossbow");
      GiveWeapon(PlayerPawn, "DeusEx.WeaponFlamethrower");
      GiveWeapon(PlayerPawn, "DeusEx.WeaponAssaultGun");

      if ( PlayerPawn.IsA('DeusExPlayer'))
      {
           GiveWeapon(PlayerPawn, "DeusEx.WeaponAssaultShotgun");
           GiveWeapon(PlayerPawn, "DeusEx.WeaponRifle");
           GiveWeapon(PlayerPawn, "DeusEx.WeaponPlasmaRifle");
           GiveWeapon(PlayerPawn, "DeusEx.WeaponGEPGun");
      }

      else if ( PlayerPawn.IsA('Bot'))
      {     
           F = FRand();
	   if ( F < 0.7 ) 
	   {
		GiveWeapon(PlayerPawn, "DeusEx.WeaponRifle");
		GiveWeapon(PlayerPawn, "DeusEx.WeaponPlasmaRifle");
		if ( F < 0.4 )
		{
			GiveWeapon(PlayerPawn, "DeusEx.WeaponAssaultShotgun");
			GiveWeapon(PlayerPawn, "DeusEx.WeaponGEPGun");
		}
		else
		{
			GiveWeapon(PlayerPawn, "DeusEx.WeaponGEPGun");
			GiveWeapon(PlayerPawn, "DeusEx.WeaponAssaultShotgun");
		}
	    }
	    else
	    {
		GiveWeapon(PlayerPawn, "DeusEx.WeaponAssaultShotgun");
		GiveWeapon(PlayerPawn, "DeusEx.WeaponGEPGun");
		if ( F < 0.88 )
		{
			GiveWeapon(PlayerPawn, "DeusEx.WeaponRifle");
			GiveWeapon(PlayerPawn, "DeusEx.WeaponPlasmaRifle");
		}
		else
		{
			GiveWeapon(PlayerPawn, "DeusEx.WeaponPlasmaRifle");
			GiveWeapon(PlayerPawn, "DeusEx.WeaponRifle");
		}
	     }        
      }
     
      for ( inv=PlayerPawn.inventory; inv!=None; inv=inv.inventory )
      {
	  weap = Weapon(inv);
	  if ( (weap != None) && (weap.AmmoType != None) )
		weap.AmmoType.AmmoAmount = weap.AmmoType.MaxAmmo;
          ammo = Ammo20mm(inv);
          if ( ammo != None )
		ammo.AmmoAmount = ammo.MaxAmmo;
      }      
}	

function ModifyBehaviour(Bot NewBot)
{
	NewBot.PlayerReplicationInfo.Score = Lives;
	NewBot.CampingRate += FRand();
}

function bool OneOnOne()
{
	return ( NumPlayers + NumBots - NumGhosts == 2 );
}

function NotifyOut(String OutString)
{
  local Pawn curPawn;

  for ( curPawn = Level.PawnList; curPawn != None; curPawn = curPawn.nextPawn )
      if ( curPawn.IsA('DeusExPlayer') )
           DeusExPlayer(curPawn).MultiplayerNotifyMsg( DeusExPlayer(curPawn).MPMSG_LMSOut, , OutString );
}	

simulated function DrawNameAndScore( GC gc, ScoreElement se, float screenWidth, float yoffset )
{
	local float x, w, h, w2, xoffset, killcx, deathcx;
	local String str;
	
	// Draw Name
	str = se.PlayerName;
	gc.GetTextExtent( 0, w, h, str );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, str );

	// Draw Lives
	gc.GetTextExtent( 0, w2, h, LivesString );
	str = int(se.Score) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = screenWidth * StreakX;
	gc.DrawText( x, yoffset, w2, h, str );
}

simulated function DrawHeaders( GC gc, float screenWidth, float yoffset )
{
	local float x, w, h, barLen;

	// Player header
	gc.GetTextExtent( 0, w, h, PlayerString );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, PlayerString );
	
	// Lives header
	gc.GetTextExtent( 0, w, h, LivesString );
	x = screenWidth * StreakX;
        gc.DrawText( x, yoffset, w, h, LivesString );

	gc.SetTileColorRGB(255,255,255);
	gc.DrawBox( PlayerX * screenWidth, yoffset+h, (x + w)-(PlayerX*screenWidth), 1, 0, 0, 1, Texture'Solid');
}

simulated function ShowVictoryConditions( GC gc, float screenWidth, float yoffset, DeusExPlayer thisPlayer )
{
	local float x, y, w, h;
			
	gc.GetTextExtent( 0, w, h, VictoryConString1 );
	x = (screenWidth * 0.5) - (w * 0.5);
	gc.DrawText( x, yoffset, w, h, VictoryConString1 );
}

function PickAmbushSpotFor(Bot aBot)
{
	if(bNoAmbush)
            return;
        else
            Super.PickAmbushSpotFor(aBot);
}

defaultproperties
{
     LivesString="Lives"
     VictoryConString1="Objective: Be the last one alive"
}
