//=============================================================================
// LeaderBot.
//=============================================================================
class LeaderBot expands ScriptedBot
      abstract;

var HomeBase LeaderSpot;

function PostBeginPlay()
{
        	Super.PostBeginPlay();
	InitLeaderSpot();
}

function InitLeaderSpot()
{
	local NavigationPoint N;

	if ( (LeaderSpot == None) && Level.Game.IsA('KTLGame') )
		KTLGame(Level.Game).PickLeaderBaseFor(Self);

	if ( LeaderSpot != None ) 
		return;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		if ( N.IsA('HomeBase') && ((N.OwnerTeam != '') && (N.OwnerTeam == Alliance)) )
		{
			LeaderSpot = HomeBase(N);
			//log(Self$" find his base at "$LeaderSpot);
		}
	}
}	

function CheckAlliances()
{
}

function HearNoise(float Loudness, Actor NoiseMaker)
{
}

state HandlingEnemy
{
	function BeginState()
	{
		if (Enemy == None)
			GotoState('Seeking');
		else if ( LeaderSpot != None )
		{
			GotoState('LeaderAttacking');
			return;
		}
		else
			GotoState('Attacking');
	}
Begin:
}

State LeaderAttacking
{
      	ignores seeplayer, hearnoise;

	function ReactToInjury(Pawn instigatedBy, Name damageType, EHitLocation hitPos)
	{
		local Pawn oldEnemy;
		local bool bHateThisInjury;
		local bool bFearThisInjury;

		if ((health > 0) && (bLookingForInjury || bLookingForIndirectInjury))
		{
			oldEnemy = Enemy;

			bHateThisInjury = ShouldReactToInjuryType(damageType, bHateInjury, bHateIndirectInjury);
			bFearThisInjury = ShouldReactToInjuryType(damageType, bFearInjury, bFearIndirectInjury);

			if (bHateThisInjury)
				IncreaseAgitation(instigatedBy, 1.0);
			if (bFearThisInjury)
				IncreaseFear(instigatedBy, 2.0);

			if (ReadyForNewEnemy())
				SetEnemy(instigatedBy);

			if (ShouldFlee())
			{
				SetDistressTimer();
				PlayCriticalDamageSound();
				SetNextState('Fleeing');
			}
			else
			{
				SetDistressTimer();
				if (oldEnemy != Enemy)
					PlayNewTargetSound();
				SetNextState('LeaderAttacking', 'ContinueAttack');
			}
			GotoDisabledState(damageType, hitPos);
		}
	}

	function SetFall()
	{
		StartFalling('LeaderAttacking', 'ContinueAttack');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}

	function Reloading(DeusExWeapon reloadWeapon, float reloadTime)
	{
		Global.Reloading(reloadWeapon, reloadTime);
		if (bReadyToReload)
			if (IsWeaponReloading())
				if (!IsHandToHand())
					TweenToShoot(0);
	}

	function EDestinationType PickDestination()
	{
		local vector               distVect;
		local vector               tempVect;
		local rotator              enemyDir;
		local float                magnitude;
		local float                calcMagnitude;
		local int                  iterations;
		local EDestinationType     destType;
		local NearbyProjectileList projList;

		destPoint = None;
		if ( LeaderSpot != None )
			destLoc = LeaderSpot.Location;
		else
			destLoc = vect(0, 0, 0);
		destType  = DEST_Failure;

		if ( Enemy == None )
			return (destType);

		if ( bCrouching && (CrouchTimer > 0) )
			destType = DEST_SameLocation;
		
		if ( LeaderSpot != None )
		{
			if ( LineOfSightTo(LeaderSpot) )
			{
				if ( AICanShoot(enemy, true, false, 0.025) || ActorReachable(Enemy) )
				{
					destType = ComputeBestFiringPosition(tempVect);
					if ( destType == DEST_NewLocation )
						destLoc = tempVect;
				}
				else 
					destType = DEST_SameLocation;
			}
			else
				destType  = DEST_Failure;
		}
		else
		{
			enemyDir = Rotator(Enemy.Location - Location);
			if ( AIPickRandomDestination(60, 150, enemyDir.Yaw, 0.5, enemyDir.Pitch, 0.5, 2, FRand()*0.4+0.35, tempVect) )
			{
				if ( !bDefendHome || IsNearHome(tempVect) )
				{
					destType = DEST_NewLocation;
					destLoc  = tempVect;
				}
			}
		}
		if (destType == DEST_Failure)
		{
			MoveTarget = GetNextWaypoint(LeaderSpot);
			if (MoveTarget != None)
			{
				destPoint = MoveTarget;
				destType  = DEST_NewLocation;
				destLoc = LeaderSpot.Location;
			}
		}
		
		return (destType);
	}

      	function bool FireIfClearShot()
	{
	     	Global.FireIfClearShot();	
	}

	function Timer()
        	{
           		Global.Timer();
        	}
		
	function CheckAttack(bool bPlaySound)
	{
		local bool bCriticalDamage;
		local bool bOutOfAmmo;
		local Pawn oldEnemy;
		local bool bAllianceSwitch;

		oldEnemy = enemy;

		bAllianceSwitch = false;
		if (!IsValidEnemy(enemy))
		{
			if (IsValidEnemy(enemy, false))
				bAllianceSwitch = true;
			SetEnemy(None, 0, true);
		}

		if (enemy == None)
		{
			if ( Orders == 'LeaderAttacking' )
			{
				FindOrderActor();
				SetEnemy(Pawn(OrderActor), 0, true);
			}
		}
		if (ReadyForNewEnemy())
			FindBestEnemy(false);
		if (enemy == None)
		{
			Enemy = oldEnemy;  
			if (bPlaySound)
			{
				if (bAllianceSwitch)
					PlayAllianceFriendlySound();
				else 
					PlayAreaSecureSound();
			}
			Enemy = None;
			if ( (Orders != 'Attacking') && (Orders != 'LeaderAttacking') )
				FollowOrders();
			else
				GotoState('Wandering');
			return;
		}

		SwitchToBestWeapon();
		if (bCrouching && (CrouchTimer <= 0) && !ShouldCrouch())
		{
			EndCrouch();
			TweenToShoot(0.15);
		}
		bCriticalDamage = False;
		bOutOfAmmo      = False;
		if (ShouldFlee())
		{
			bCriticalDamage = True;
		}
		else if (Weapon == None)
            		{
			bOutOfAmmo = True;
            		}
		else if (Weapon.ReloadCount > 0)
		{
			if (Weapon.AmmoType == None)
                  		{
				bOutOfAmmo = True;
                  		}
			else if (Weapon.AmmoType.AmmoAmount < 1)
                  		{
				bOutOfAmmo = True;
                  		}
		}
		if ( bCriticalDamage || bOutOfAmmo )
		{	
			if (bPlaySound)
			{
				if (bCriticalDamage)
					PlayCriticalDamageSound();
				else if (bOutOfAmmo)
					PlayOutOfAmmoSound();
			}
                  		GotoState('Fleeing');
		}
		else if ( bPlaySound && (oldEnemy != Enemy) )
			PlayNewTargetSound();
	}

	function Tick(float deltaSeconds)
	{
		local bool   bCanSee;
		local float  yaw;
		local vector lastLocation;
		local Pawn   lastEnemy;
		local float  surpriseTime;

		Global.Tick(deltaSeconds);
		if (CrouchTimer > 0)
		{
			CrouchTimer -= deltaSeconds;
			if (CrouchTimer < 0)
				CrouchTimer = 0;
		}
		EnemyTimer += deltaSeconds;
                		UpdateActorVisibility(Enemy, deltaSeconds, 1.0, false);
                		if ((Enemy != None) && HasEnemyTimedOut())
		{
			lastLocation = Enemy.Location;
			lastEnemy    = Enemy;
			FindBestEnemy(true);
			if (Enemy == None)
			{
                             			SetSeekLocation(lastEnemy, lastLocation, SEEKTYPE_Guess, true);
			     	GotoState('Seeking');
			}
		}
		else if (bCanFire && (Enemy != None))
		{
			ViewRotation = Rotator(Enemy.Location-Location);
			if (bFacingTarget)
				FireIfClearShot();
			else if (!bMustFaceTarget)
			{
				yaw = (ViewRotation.Yaw-Rotation.Yaw) & 0xFFFF;
				if (yaw >= 32768)
					yaw -= 65536;
				yaw = Abs(yaw)*360/32768;  // 0-180 x 2
				if (yaw <= FireAngle)
					FireIfClearShot();
			}
		}
	  }

	function bool IsHandToHand()
	{
		if (Weapon != None)
		{
			if (DeusExWeapon(Weapon) != None)
			{
				if (DeusExWeapon(Weapon).bHandToHand)
					return true;
				else
					return false;
			}
			else
				return false;
		}
		else
			return false;
	}

	function bool ReadyForWeapon()
	{
		local bool bReady;

		bReady = false;
		if (DeusExWeapon(weapon) != None)
		{
			if (DeusExWeapon(weapon).bReadyToFire)
				if (!IsWeaponReloading())
					bReady = true;
		}
		if (!bReady)
			if (enemy == None)
				bReady = true;
		if (!bReady)
			if (!AICanShoot(enemy, true, false, 0.025))
				bReady = true;

		return (bReady);
	}

	function bool ShouldCrouch()
	{
                		if (bJumpy && !IsHandToHand() && !Region.Zone.bWaterZone && 
                   	((Enemy != None) && (VSize(Enemy.Location-Location) < 1600))) 
		                 return true;
                		else
                                 		return false;
	 }

	function StartCrouch()
	{ 
                 		SetPhysics(PHYS_Falling);
                 		FireIfClearShot();
	         	Acceleration = vect(0,0,0);
                 		Destination = Location + 400 * vect(0,0,1);
	         	NextState = 'LeaderAttacking'; 
	         	NextLabel = 'ContinueAttack';
	         	GotoState('FallingState');    
	}

          	function EndCrouch()
	{          
	} 

	function BeginState()
	{
		StandUp();

		if (MaxRange < MinRange+10)
			MaxRange = MinRange+10;
		bCanFire      = false;
		bFacingTarget = false;

		SwitchToBestWeapon();
            		CallForHelp();
		BlockReactions();
		bCanConverse = False;
		bAttacking = True;
		bStasis = False;
		SetDistress(true);

		CrouchTimer = 0;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		bCanFire      = false;
		bFacingTarget = false;
		Home = None;
		ResetReactions();
		bCanConverse = True;
		bAttacking = False;
		bStasis = True;
		bReadyToReload = false;
		EndCrouch();
	}

Begin:
	if (Enemy == None)
		GotoState('Seeking');
	CheckAttack(false);

Surprise:
	if ((1.0-ReactionLevel)*SurprisePeriod < 0.25)
		Goto('BeginAttack');
      	Acceleration = vect(0,0,0);
	PlaySurpriseSound();
      	PlayWaiting();
      	while (ReactionLevel < 1.0)
	{
		TurnToward(Enemy);
		Sleep(0);
	}

BeginAttack:
      	EnemyReadiness = 1.0;
      	ReactionLevel  = 1.0;
	if (PlayerAgitationTimer > 0)
		PlayAllianceHostileSound();
	else
		PlayTargetAcquiredSound();
	if (PlayBeginAttack())
	{
		Acceleration = vect(0,0,0);
		TurnToward(enemy);
		FinishAnim();
	}

RunToRange:
	bCanFire       = false;
	bFacingTarget  = false;
	bReadyToReload = false;
	EndCrouch();
	if (Physics == PHYS_Falling)
		TweenToRunning(0.05);
	WaitForLanding();
	if (!IsWeaponReloading() || bCrouching)
	{
		if (ShouldPlayTurn(Enemy.Location))
			PlayTurning();
		TurnToward(enemy);
	}
	else
		Sleep(0);
	bCanFire = true;
	while (PickDestination() == DEST_NewLocation)
	{
		if (bCanStrafe && ShouldStrafe())
		{
			PlayRunningAndFiring();
			if (destPoint != None)
				StrafeFacing(destPoint.Location, enemy);
			else
				StrafeFacing(destLoc, enemy);
			bFacingTarget = true;
		}
		else
		{
			bFacingTarget = false;
                  			PlayRunning();
			if (destPoint != None)
				MoveToward(destPoint, MaxDesiredSpeed);
			else
				MoveTo(destLoc, MaxDesiredSpeed);
		}
		CheckAttack(true);
	}

Fire:
	bCanFire      = false;
	bFacingTarget = false;
	Acceleration = vect(0, 0, 0);

	SwitchToBestWeapon();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	if (IsHandToHand())
		TweenToAttack(0.15);
	else if (ShouldCrouch() && (FRand() < CrouchRate))
	{
		TweenToCrouchShoot(0.15);
		FinishAnim();
		StartCrouch();
	}
	else
		TweenToShoot(0.15);
	if (!IsWeaponReloading() || bCrouching)
		TurnToward(enemy);
	FinishAnim();
	bReadyToReload = true;

ContinueFire:
	while (!ReadyForWeapon())
	{
		if (PickDestination() != DEST_SameLocation)
			Goto('RunToRange');
		CheckAttack(true);
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
	}
	CheckAttack(true);
	if (!FireIfClearShot())
		Goto('ContinueAttack');
	bReadyToReload = false;
	if (bCrouching)
		PlayCrouchShoot();
	else if (IsHandToHand())
		PlayAttack();
	else
		PlayShoot();
	FinishAnim();
	if (FRand() > 0.5)
		bUseSecondaryAttack = true;
	else
		bUseSecondaryAttack = false;
	bReadyToReload = true;
	if (!IsHandToHand())
	{
		if (bCrouching)
			TweenToCrouchShoot(0);
		else
			TweenToShoot(0);
	}
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
	{
		if (!IsWeaponReloading() || bCrouching)
			TurnToward(enemy);
		else
			Sleep(0);
		Goto('ContinueFire');
	}
	Goto('RunToRange');

ContinueAttack:
ContinueFromDoor:
	CheckAttack(true);
	if (PickDestination() != DEST_NewLocation)
		Goto('Fire');
	else
		Goto('RunToRange');
}

defaultproperties
{
     RestartWait=10.000000
     bIgnorePoison=True
     bSitAnywhere=True
     bUseFirstSeatOnly=False
     bHateShot=False
     BurnPeriod=0.000000
}
