//=============================================================================
// MJ12Commando.
//=============================================================================
class MJ12Commando extends HumanMilitary;

function Bool HasTwoHandedWeapon()
{
	return False;
}

function PlayReloadBegin()
{
	TweenAnimPivot('Shoot', 0.1);
}

function PlayReload()
{
}

function PlayReloadEnd()
{
}

function PlayIdle()
{
}

function TweenToShoot(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('TreadShoot', tweentime, GetSwimPivot());
	else if (!bCrouching)
		TweenAnimPivot('Shoot2', tweentime);
}

function PlayShoot()
{
	if (Region.Zone.bWaterZone)
		PlayAnimPivot('TreadShoot', , 0, GetSwimPivot());
	else
		PlayAnimPivot('Shoot2', , 0);
}

function bool IgnoreDamageType(Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'PoisonGas'))
		return True;
	else
		return False;
}

function float ShieldDamage(Name damageType)
{
	if (IgnoreDamageType(damageType))
		return 0.0;
	else if ((damageType == 'KnockedOut') || (damageType == 'Flamed'))
		return 0.5;
	else if ((damageType == 'Poison') || (damageType == 'PoisonEffect'))
		return 0.5;
	else
		return Super.ShieldDamage(damageType);
}


function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if (!IgnoreDamageType(damageType) && CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function Gasp()
{
	PlaySound(sound'MechHit1', SLOT_Pain,,,, RandomPitch());
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	local Sound hitSound;
	local float volume;

	if ( Level.TimeSeconds - LastPainSound < 0.25 )
		return;
	if ( Damage <= 0 )
		return;

	LastPainSound = Level.TimeSeconds;

	if ( FRand() > 0.5 )
		hitSound = HitSound1;
	else
		hitSound = HitSound2;
	volume = FMax(Mult*TransientSoundVolume, Mult*2.0);

	SetDistressTimer();
	PlaySound(hitSound, SLOT_Pain, volume,,, RandomPitch());
	if ( (hitSound != None) && bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio, volume);
}

function PlayDyingSound()
{
	SetDistressTimer();
	if ( FRand() > 0.5 )
		PlaySound(Die, SLOT_Pain,,,, RandomPitch());
	else
		PlaySound(Sound'MechUnconscious2', SLOT_Pain,,,, RandomPitch());

	AISendEvent('LoudNoise', EAITYPE_Audio);

	if ( bEmitDistress )
		AISendEvent('Distress', EAITYPE_Audio);
}

function PlayDying(name damageType, vector hitLoc)
{
	local Vector X, Y, Z;
	local float dotp;

	if (Region.Zone.bWaterZone)
		PlayAnimPivot('WaterDeath',, 0.1);
	else if (bSitting) 
		PlayAnimPivot('DeathFront',, 0.1);
	else
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - HitLoc) dot X;

		// die from the correct side
		if (dotp < 0.0)		
			PlayAnimPivot('DeathBack',, 0.1);
		else				
			PlayAnimPivot('DeathFront',, 0.1);
	}

	if ((damageType == 'Stunned') || (damageType == 'KnockedOut') ||
	    (damageType == 'Poison') || (damageType == 'PoisonEffect'))
	{
		bStunned = True;
		PlaySound(Sound'MechUnconscious2', SLOT_Pain,,,, RandomPitch());
	}
	else
	{
		bStunned = False;
		PlayDyingSound();
	}
}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
	local vector loc;
	local Inventory item, nextItem;
	local FleshFragment chunk;
	local int i;
	local float size;
	local DeusExFragment ss;

	// if we really got blown up good, gib us and don't display a carcass
	if ( Health < -100 )
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if ( size > 10.0 )
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				chunk = spawn(class'FleshFragment', None,, loc);
				if ( chunk != None )
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
				ss = Spawn(class'MetalFragment', Owner);
				if ( ss != None )
				{
					ss.Instigator = Instigator;
					ss.CalcVelocity(Velocity, 256);
					ss.DrawScale = 0.5;
					ss.Skin = GetMeshTexture();
					if ( FRand() < 0.75 )
						ss.bSmoking = True;
				}
			}
		}

		return None;
	}

	carc = DeusExCarcass(Spawn(CarcassType));

	if ( carc != None )
	{
		if (bStunned)
			carc.bNotDead = True;

		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;

		if ( Inventory != None )
		{
			do
			{
				item = Inventory;
				nextItem = item.Inventory;
				DeleteInventory(item);
				if ((DeusExWeapon(item) != None) && (DeusExWeapon(item).bNativeAttack))
					item.Destroy();
				else
					carc.AddInventory(item);
				item = nextItem;
			}
			until (item == None);
		}
	}

	return carc;
}

defaultproperties
{
     JumpSound=Sound'DeusEx.Player.MechJump'
     Aggressiveness=0.750000
     CarcassType=Class'DeusEx.MJ12CommandoCarcass'
     WalkingSpeed=0.296000
     bCanCrouch=False
     CloseCombatMult=0.500000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponMJ12Commando')
     InitialInventory(1)=(Inventory=Class'DeusEx.Ammo10mm',Count=24)
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponMJ12Rocket')
     InitialInventory(3)=(Inventory=Class'DeusEx.AmmoRocketMini',Count=10)
     InitialInventory(4)=(Inventory=Class'DeusEx.BioelectricCell')
     BurnPeriod=0.000000
     GroundSpeed=250.000000
     JumpZ=220.000000
     Health=300
     Skill=0.800000
     HitSound1=Sound'DeusEx.Player.MjcHit1'
     HitSound2=Sound'DeusEx.Player.MjcHit2'
     Die=Sound'DeusEx.Player.MechUnconscious'
     CombatStyle=1.000000
     HealthHead=300
     HealthTorso=300
     HealthLegLeft=300
     HealthLegRight=300
     HealthArmLeft=300
     HealthArmRight=300
     Mesh=LodMesh'DeusExCharacters.GM_ScaryTroop'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.MJ12CommandoTex1'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.MJ12CommandoTex1'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.MJ12CommandoTex0'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.MJ12CommandoTex1'
     CollisionRadius=28.000000
     CollisionHeight=49.880001
     BindName="MJ12Commando"
     FamiliarName="MJ12 Commando"
     UnfamiliarName="MJ12 Commando"
}
