//=============================================================================
// RiotCop.
//=============================================================================
class MPRiotCop extends BotPlayer;

event TravelPostAccept()
{
	Super.TravelPostAccept();
}

function PlayDyingSound()
{
	PlaySound(sound'MechDie', SLOT_Pain,,,, RandomPitch());
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{	
	if ( Level.TimeSeconds - LastPainSound < FRand() + 0.5)
		return;

	LastPainSound = Level.TimeSeconds;

	if (FRand() < 0.5)
		PlaySound(sound'MechHit1', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
	else
		PlaySound(sound'MechHit2', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
}

defaultproperties
{
     TauntPortrait=Texture'DeusEx.Taunts.riot_tp'
     CarcassType=Class'DeusEx.RiotCopCarcass'
     JumpSound=Sound'DeusEx.Player.MechJump'
     HitSound1=Sound'DeusEx.Player.MechHit1'
     HitSound2=Sound'DeusEx.Player.MechHit2'
     Land=Sound'DeusEx.Player.MechJump'
     Die=Sound'DeusEx.Player.MechDie'
     Texture=Texture'DeusExCharacters.Skins.VisorTex1'
     Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.MiscTex1'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.RiotCopTex1'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.RiotCopTex2'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.MiscTex1'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.MiscTex1'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.RiotCopTex3'
     BindName="MJ12TroopB"
}
