//=============================================================================
// MachineGunBase.
//=============================================================================
class MachineGunBase expands DeusExDecoration;

var MachineGun gun;
var() float fireRate;
var float fireTimer;
var() float gunAccuracy;
var() int gunDamage;     
var() int ammoAmount;                                			
var Rotator origRot;	
var Rotator AdjustedAim;
var vector FireOffset;		

function PreBeginPlay()
{
	local Vector v1, v2;
	local class<MachineGun> gunClass;
	local Rotator rot;
  
  local mesh HDTPmesh;
//---------------------------

	Super.PreBeginPlay();

	gunClass = class'MachineGun';

	rot = Rotation;
	rot.Pitch = 0;
	rot.Roll = 0;
	origRot = rot;
	gun = Spawn(gunClass, Self,, Location, rot);
	if (gun != None)
	{
		v1.X = 0;
		v1.Y = 0;
		v1.Z = CollisionHeight + gun.Default.CollisionHeight;
		v2 = v1 >> Rotation;
		v2 += Location;
		gun.SetLocation(v2);
		gun.SetBase(Self);
                		gun.myBase = Self;
	}
//------------------------------------------------------
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPAutoturretbase",class'mesh', true));
     if(HDTPmesh != none)
     {
	        mesh = HDTPmesh;
     }
//------------------------------------------------------
}

function Tick(float deltaTime)
{
    	if (gun.Controller != None)
    	{
        		if (Gun.Controller.IsA('HardcorePlayer')) 
        		{
              			RotateWithOwner(deltaTime);
              			return;  
        		}
        		gun.SetRotation(gun.Controller.ViewRotation);
        		if ((VSize(gun.Controller.Location - Location) > 80) || (gun.Controller.Health <= 0) 
           		|| gun.Controller.bIsCrouching || (!gun.PlayerCanSeeMe()))
        		{
              			if (DeusExRootWindow(gun.Controller.rootWindow) != None)
              			{
                  			DeusExRootWindow(gun.Controller.rootWindow).hud.augDisplay.bShowGunAmmo = False;
                  			DeusExRootWindow(gun.Controller.rootWindow).hud.augDisplay.GunAmmoCount = 0;
              			}
              		gun.Controller = None;
              		AmbientSound = None;
              		SetOwner(None);
              		if (gun.IsAnimating())
			gun.PlayIdleAnim();
              		return;
        	}

        	if (!gun.IsAnimating())
	     	gun.PlayFiring();

        	fireTimer += deltaTime;
        	if (gun.Controller.InHand == None) 
        	{
             		if (gun.Controller.bFire != 0) 
             		{
                  		if (ammoAmount > 0)
                  		{
                      			if (fireTimer > fireRate)
	              			{
		           			Fire();
		           			fireTimer = 0;
	              			}
                      			AmbientSound = Sound'MGunFire';
                      			if (DeusExRootWindow(gun.Controller.rootWindow) != None)
                          				DeusExRootWindow(gun.Controller.rootWindow).hud.augDisplay.GunAmmoCount = ammoAmount;
                  			}
                  			else
                      				AmbientSound = Sound'DryClick';
             			}
             			else
                  			AmbientSound = None;
        		}   
    	}
}

function RotateWithOwner(float DeltaTime)
{
        	local Vector v1, v2;

        	if (gun.Controller != None)
        	{
             		v1.X = 0;
	     	v1.Y = 0;
	     	v1.Z = CollisionHeight + gun.Default.CollisionHeight;
	     	v2 = v1 >> Rotation;
	     	v2 += Location;
	     	gun.SetLocation(v2);
	     	gun.SetBase(Self);
             		gun.SetRotation(gun.Controller.ViewRotation);
             
             		if (!gun.IsAnimating())
	           		gun.PlayFiring();

             		fireTimer += deltaTime;

             		if (gun.Controller.bFire != 0) 
             		{
                  		if (ammoAmount > 0)
                  		{
                      			if (fireTimer > fireRate)
	              			{
		           			Fire();
		           			fireTimer = 0;
	              			}
                      			AmbientSound = Sound'MGunFire';
                      			if (DeusExRootWindow(gun.Controller.rootWindow) != None)
                          				DeusExRootWindow(gun.Controller.rootWindow).hud.augDisplay.GunAmmoCount = ammoAmount;
                  		}
                  		else
                      			AmbientSound = Sound'DryFire';
             		}
             		else
                  		AmbientSound = None;
        	}
        	else
        	{
             		AmbientSound = None;
             		SetOwner(None);
             		if (gun.IsAnimating())
		  	gun.PlayIdleAnim();
        	}
}

function vector CalcDrawOffset()
{
	local vector DrawOffset;
	
	DrawOffset = ((0.9/gun.Controller.Default.FOVAngle * vect(0,0,0)) >> gun.Controller.ViewRotation);
	DrawOffset += (gun.Controller.EyeHeight * vect(0,0,1));

	return DrawOffset;
}

function Fire()
{
	local Vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local Actor hit;
	local ShellCasing shell;
        	
	if (ammoAmount > 0)
	{
		ammoAmount--;
	        	GetAxes(gun.Controller.ViewRotation, X, Y, Z);
	        	StartTrace = gun.Controller.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	        	EndTrace = StartTrace + gunAccuracy * (FRand()-0.5)*Y*1000 + gunAccuracy * (FRand()-0.5)*Z*1000 ;
                		AdjustedAim = gun.Controller.AdjustAim(1000000, StartTrace, 100, False, False);	
                		X = vector(AdjustedAim);
	        	EndTrace += 20000 * X;
	        	hit = gun.Controller.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
                		shell = Spawn(class'ShellCasing',,, gun.Location);
      	        	if (shell != None)
                		{
	            		shell.Velocity = Vector(gun.Rotation - rot(0,16384,0)) * 100 + VRand() * 30;
                    		shell.Velocity.Z += 150; 
                    		shell.DrawScale = 2.0;
                		}
	        	gun.Controller.MakeNoise(1.0);
                		gun.Controller.AISendEvent('WeaponFire', EAITYPE_Audio, 1.0, 1600);
	        	gun.Controller.AISendEvent('LoudNoise', EAITYPE_Audio, 1.0, 1600 );
                		gun.Controller.ShakeView(0.1, 300.0, 5.0);
	        	gun.LightType = LT_Steady;
	        	gun.MultiSkins[2] = Texture'Muzzleflash02';
	        	SetTimer(0.1, False);
	        	if (VSize(HitLocation - StartTrace) > 200)
	        	{
		    	rot = Rotator(EndTrace - StartTrace);
		    	Spawn(class'Tracer',,, gun.Location + 64 * Vector(rot), rot);
	        	}
	        	if (hit != None)
                		{
                    		if ((hit != Self) && (hit != Owner))
                         			hit.TakeDamage(gunDamage, gun.Controller, HitLocation, 1000.0*X, 'AutoShot');
                    		if (hit.IsA('Pawn') && !hit.IsA('Robot') && !hit.IsA('CyborgDog') && !hit.IsA('HoloDenton'))
	                 			SpawnBlood(HitLocation, HitNormal);
	            		else if ((hit == Level) || hit.IsA('Mover'))
	                 			SpawnEffects(HitLocation, HitNormal, hit);
                		}
        	}
        	else
	{
		PlaySound(sound'DryFire', SLOT_None);
	}
}

function SpawnBlood(Vector HitLocation, Vector HitNormal)
{
	local rotator rot;

	rot = Rotator(Location - HitLocation);
	rot.Pitch = 0;
	rot.Roll = 0;
   
	spawn(class'BloodSpurt',,,HitLocation+HitNormal, rot);
	spawn(class'BloodDrop',,,HitLocation+HitNormal);
	if (FRand() < 0.5)
		spawn(class'BloodDrop',,,HitLocation+HitNormal);
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local SmokeTrail puff;
	local int i;
	local BulletHole hole;
        	local GunSpark spark;
	local Rotator rot;

        	puff = spawn(class'SmokeTrail',,,HitLocation+HitNormal*1.5, Rotator(HitNormal));
	if (puff != None)
	{
		puff.DrawScale = 0.15;
		puff.OrigScale = puff.DrawScale;
		puff.LifeSpan = 0.75;
		puff.OrigLifeSpan = puff.LifeSpan;
	}

        	spark = spawn(class'GunSpark',,,Location+Vector(Rotation), Rotation);
	if (spark != None)
	{
		spark.RemoteRole = ROLE_None;
		spark.DrawScale = 0.25;
	}
        	
	hole = spawn(class'BulletHole', Other,, HitLocation, Rotator(HitNormal));
	if (GetWallMaterial(HitLocation, HitNormal) == 'Glass')
	{
		if (FRand() < 0.5)
			hole.Texture = Texture'FlatFXTex29';
		else
			hole.Texture = Texture'FlatFXTex30';

		hole.DrawScale = 0.1;
		hole.ReattachDecal();
	}
}

function name GetWallMaterial(vector HitLocation, vector HitNormal)
{
	local vector EndTrace, StartTrace;
	local actor newtarget;
	local int texFlags;
	local name texName, texGroup;

	StartTrace = HitLocation + HitNormal*16;		
	EndTrace = HitLocation - HitNormal;

	foreach TraceTexture(class'Actor', newtarget, texName, texGroup, texFlags, StartTrace, HitNormal, EndTrace)
		if ((newtarget == Level) || newtarget.IsA('Mover'))
			break;

	return texGroup;
}

function PlayHitSound(actor destActor, Actor hitActor)
{
	local float rnd;
	local sound snd;

	rnd = FRand();

	if (rnd < 0.25)
		snd = sound'Ricochet1';
	else if (rnd < 0.5)
		snd = sound'Ricochet2';
	else if (rnd < 0.75)
		snd = sound'Ricochet3';
	else
		snd = sound'Ricochet4';

	if (hitActor != None) 
	{
		if (hitActor.IsA('DeusExDecoration') && (DeusExDecoration(hitActor).minDamageThreshold > 10))
			snd = sound'ArmorRicochet';
		else if ( hitActor.IsA('CrateUnbreakableSmall') || hitActor.IsA('CrateUnbreakableMed') || hitActor.IsA('CrateUnbreakableLarge') )
		{
			if (rnd < 0.75)
				snd = sound'BulletImpactMetal1';
	     		else
				snd = sound'BulletImpactMetal2';
		}		
		else if (hitActor.IsA('Robot') || hitActor.IsA('CyborgDog'))
			snd = sound'ArmorRicochet';
	}

	if (destActor != None)
		destActor.PlaySound(snd, SLOT_None,,, 1024, 1.1 - 0.2*FRand());
}

simulated function Timer()
{
	gun.LightType = LT_None;
	gun.MultiSkins[2] = None;
}

function Landed(vector HitNormal)
{
	local Rotator rot;
	
	bFixedRotationDir = False;
	rot = Rotation;
	rot.Pitch = 0;
	rot.Roll = 0;
	SetRotation(rot);
}

defaultproperties
{
     fireRate=0.100000
     gunAccuracy=0.200000
     gunDamage=35
     AmmoAmount=1000
     HitPoints=80
     minDamageThreshold=50
     bInvincible=True
     bHighlight=False
     ItemName="Machinegun Base"
     bPushable=False
     bStasis=False
     Mesh=LodMesh'DeusExDeco.AutoTurretBase'
     DrawScale=1.200000
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=14.000000
     CollisionHeight=23.200001
     Mass=50.000000
     Buoyancy=10.000000
}
