//=============================================================================
// MapInformation
//=============================================================================

class MapInformation expands MenuUIScreenWindow;

var localized string 	MapAuthorLabel;
var localized string 	MapNameLabel;
var localized string 	ScreenShot;
var localized string  MapCommentLabel;

var string           	DXMapName;
var string	       	  DXMapCreator;

var DeusExLevelInfo  	DXMapInfo;
var Texture          	MapScreenShot;
var Texture		        NoScreenShot;
var ButtonWindow     	MapImage;


// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------
event InitWindow()
{
	Super.InitWindow();
}
// ----------------------------------------------------------------------
function CreateControls()
{
	Super.CreateControls();

 	CreateMapAuthorLabel();
	CreateMapNameLabel();

	CreateScreenShotLabel();

	CreateDXMapName();
	CreateDXMapCreator();
	CreateScreenShotButton();
  
  CreateCommentTitle();
  CreateCommentText();
}
//-----------------------------------------------------------------------
//   (comment header)
Function CreateCommentTitle()
{
	local MenuUILabelWindow newLabel;

	newlabel = CreateMenuLabel( 10, 370, MapCommentLabel, winClient );
	newlabel.SetFont(font'FontMenuHeaders_DS');
}
//-----------------------------------------------------------------------
//   (comment itself)
Function CreateCommentText()
{
	local MenuUILabelWindow newLabel;
	local string GameType;
	local string MapName;
	local LevelSummary L;
  local String MapComment;
//------------------------
	GameType = player.ConsoleCommand("get MenuScreenHostGame CurrentGameType");
	if ( GameType == "DeusEx.KTLGame" )
      		MapName = GetKTLMapInfo();
   	else
      		MapName = GetDMMapInfo();
//-------------------------------
	L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	if(L != None)
		MapComment = L.LevelEnterText;
	else
		MapComment = "no comment";

	newlabel = CreateMenuLabel( 10, 385, MapComment, winClient );
	newlabel.SetFont(font'FontMenuSmall_DS');
}

// ----------------------------------------------------------------------
// MapCreator title
function CreateMapAuthorLabel()
{ 
	local MenuUILabelWindow newLabel;

	newLabel = CreateMenuLabel( 10, 310, MapAuthorLabel, winClient );
	newlabel.SetFont(font'FontMenuHeaders_DS');
}
// ----------------------------------------------------------------------
// MapName title
function CreateMapNameLabel()
{ 
	local MenuUILabelWindow newLabel;

	newlabel = CreateMenuLabel( 10, 340, MapNameLabel, winClient );
	newlabel.SetFont(font'FontMenuHeaders_DS');
}
// ----------------------------------------------------------------------
// MapCreator string
// ----------------------------------------------------------------------
function CreateDXMapCreator()
{ 
	local MenuUILabelWindow newLabel;
	local string GameType;
	local string MapName;
	local LevelSummary L;

	GameType = player.ConsoleCommand("get MenuScreenHostGame CurrentGameType");
	if ( GameType == "DeusEx.KTLGame" )
      		MapName = GetKTLMapInfo();
   	else
      		MapName = GetDMMapInfo();
	
	L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	if(L != None)
		DXMapCreator = L.Author;	
	else
		DXMapCreator = Default.DXMapCreator;		

	newlabel = CreateMenuLabel( 20, 325, DXMapCreator, winClient );
	newlabel.SetFont(font'FontFixedWidthSmall_DS');
}

function CreateDXMapName()
{ 
	local MenuUILabelWindow newLabel;
	local string GameType;
	local string MapName;

	GameType = player.ConsoleCommand("get MenuScreenHostGame CurrentGameType");
	if ( GameType == "DeusEx.KTLGame" )
      		MapName = GetKTLMapInfo();
   	else
      		MapName = GetDMMapInfo();

	DXMapName = MapName;

	newLabel = CreateMenuLabel( 20, 355, DXMapName, winClient );
	newlabel.SetFont(font'FontFixedWidthSmall_DS');
}
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
function CreateScreenShotLabel()
{ 
	local MenuUILabelWindow newLabel;

	newLabel = CreateMenuLabel( 45, 25, ScreenShot, winClient );
	newlabel.SetFont(font'FontMenuHeaders_DS');
}
// ----------------------------------------------------------------------
function CreateScreenShotButton()
{
	local string GameType;
	local string MapName;
	local LevelInfo L;
						
	MapImage = ButtonWindow(NewChild(Class'ButtonWindow'));
  MapImage.SetSize(256, 256);
	MapImage.SetPos(52, 63);

// 	MapImage.SetBackgroundStyle(DSTY_Masked);

	GameType = player.ConsoleCommand("get MenuScreenHostGame CurrentGameType");
	if ( GameType == "DeusEx.KTLGame" )
      		MapName = GetKTLMapInfo();
   	else
      		MapName = GetDMMapInfo();

	L = LevelInfo(DynamicLoadObject(MapName$".LevelInfo0", class'LevelInfo'));
	if(L != None)				
		MapScreenShot = L.Screenshot;
		
	if ( MapScreenShot != None )
		MapImage.SetBackground(MapScreenShot);
	else
		MapImage.SetBackground(NoScreenShot);	
}
// ----------------------------------------------------------------------

function string GetDMMapInfo()
{
   	local DXMapList MapList;
   	local string MapName;
	local string GameType;

   	MapList = player.Spawn(class'DXMapList');

   	if (MapList == None)
      		return "";

   	MapName = MapList.Maps[MapList.MapNum];
	
   	MapList.Destroy();

   	return mapname;
}

function string GetKTLMapInfo()
{
   	local KTLMapList MapList;
   	local string mapname;

   	MapList = player.Spawn(class'KTLMapList');

   	if (MapList == None)
      		return "";

   	MapName = MapList.Maps[MapList.MapNum];
	
   	MapList.Destroy();

   	return mapname;
}

defaultproperties
{
     MapAuthorLabel="Created by:"
     MapNameLabel="Map name:"
     Screenshot="ScreenShot:"
     MapCommentLabel="Comment for map:"
     DXMapName="<Map Name Here>"
     DXMapCreator="<Map creator info here>"
     NoScreenShot=Texture'DeusEx.NoScreenShot'
     actionButtons(0)=(Action=AB_OK)
     Title="Information about map"
     ClientWidth=343
     ClientHeight=415
     clientTextures(0)=Texture'DeusEx.UserInterface.MapDetailsBK__0_0'
     clientTextures(1)=Texture'DeusEx.UserInterface.MapDetailsBK__1_0'
     clientTextures(2)=Texture'DeusEx.UserInterface.MapDetailsBK__0_1'
     clientTextures(3)=Texture'DeusEx.UserInterface.MapDetailsBK__1_1'
     textureCols=2
}
