//=============================================================================
// MedKit.
//=============================================================================
class MedKit extends DeusExPickup;

//
// Healing order is head, torso, legs, then arms (critical -> less critical)
//
var int healAmount;
var int mphealAmount;
var bool bNoPrintMustBeUsed;
var() bool bSuperHeal;

var localized string MustBeUsedOn;
var localized string HealedString;
var localized string PointString;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
        	{
		SetPhysics(Phys_None);
                		AmbientGlow = 128;
                		SetCollisionSize(CollisionRadius*3, CollisionHeight*2);
                		bRotatingPickup = True;
                		PickupViewScale = 3.000000;
		return;
        	}

        	if ( Level.Game.Difficulty == 3 )
        	{
		MaxCopies = 5;
                		healAmount = 20;
        	}
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		local Pawn P;
			
            		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
            		{        
			if ( ValidTouch(Other) ) 
			{	
				P = Pawn(Other);	
				HealMax = P.default.health;
				if ( bSuperHeal ) HealMax = Min(199, HealMax * 2.0);
				if ( P.Health < HealMax ) 
				{
					if ( Level.Game.LocalLog != None )
						Level.Game.LocalLog.LogPickup(Self, P);
					if ( Level.Game.WorldLog != None )
						Level.Game.WorldLog.LogPickup(Self, P);
					P.Health += mphealAmount;
                                			if ( P.Health > HealMax ) P.Health = HealMax;
                                			P.ClientMessage(HealedString$mphealAmount$PointString);
					PlaySound (Sound'MedicalHiss',,2.5);
					Other.MakeNoise(0.2);		
					SetRespawn();
				}
			}
            		}
            		else
                		Super.Touch(Other);
	}

        	function Frob(Actor Other, Inventory frobWith)
        	{
            		if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
                 		return;
            		else
                 		Super.Frob(Other, frobWith);     
        	}
}

function BecomePickup()
{
	if ( Physics != PHYS_Falling )
		RemoteRole    = ROLE_SimulatedProxy;
	Mesh          = PickupViewMesh;
	DrawScale     = PickupViewScale;
	bOnlyOwnerSee = false;
	bHidden       = false;
	bCarriedItem  = false;
	NetPriority   = 1.4;
	if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
           		SetCollision( true, false, false );	
        	else
          		SetCollision( true, true, false );
}

event float BotDesireability(Pawn Bot)
{
	local float desire;
	local int HealMax;

	HealMax = Bot.Default.Health;

	if (bSuperHeal) HealMax = Min(199, HealMax * 2.0);
	desire = Min(mpHealAmount, HealMax - Bot.Health);

	if ( (Bot.Weapon != None) && (Bot.Weapon.AIRating > 0.5) )
		desire *= 1.7;
	if (( Bot.Health < 45 ) || Bot.bOnFire)
		return ( FMin(0.03 * desire, 2.2) );
	else
	{
		if ( desire > 6 )
			desire = FMax(desire,25);
		return ( FMin(0.017 * desire, 2.0) ); 
	}
}

// ----------------------------------------------------------------------
state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if ( player != None )
		{
                     		player.HealPlayer(healAmount, True);
		     	player.StopPoison();
		     	player.drugEffectTimer = 0;
		}
		UseOnce();
	}
Begin:
}


// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local DeusExPlayer player;
	local String outText;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		winInfo.SetTitle(itemName);
		winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

		if (!bNoPrintMustBeUsed)
		{
			winInfo.AppendText(winInfo.CR() $ MustBeUsedOn $ winInfo.CR());
		}
		else
		{
			bNoPrintMustBeUsed = False;
		}

		// Print the number of copies
		outText = CountLabel @ String(NumCopies);

		winInfo.AppendText(winInfo.CR() $ outText);
	}

	return True;
}

// ----------------------------------------------------------------------
// NoPrintMustBeUsed()
// ----------------------------------------------------------------------

function NoPrintMustBeUsed()
{
	bNoPrintMustBeUsed = True;
}

// ----------------------------------------------------------------------
// GetHealAmount()
//
// Arms and legs get healing bonuses
// ----------------------------------------------------------------------

function float GetHealAmount(int bodyPart, optional float pointsToHeal)
{
	local float amt;
	
	if (pointsToHeal == 0)
		pointsToHeal = healAmount;

	return pointsToHeal;

}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     healAmount=30
     mphealAmount=25
     MustBeUsedOn="Use to heal critical body parts, or use on character screen to direct healing at a certain body part."
     HealedString="Healed "
     PointString=" points"
     maxCopies=10
     bIsHealth=True
     HealPriority=7
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Medkit"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.MedKit'
     PickupViewMesh=LodMesh'DeusExItems.MedKit'
     ThirdPersonMesh=LodMesh'DeusExItems.MedKit3rd'
     MaxDesireability=0.500000
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconMedKit'
     largeIcon=Texture'DeusExUI.Icons.LargeIconMedKit'
     largeIconWidth=39
     largeIconHeight=46
     Description="A first-aid kit.|n|n<UNATCO OPS FILE NOTE JR095-VIOLET> The nanomachines of an augmented agent will automatically metabolize the contents of a medkit to efficiently heal damaged areas. An agent with medical training could greatly expedite this process. -- Jaime Reyes <END NOTE>"
     beltDescription="MEDKIT"
     Mesh=LodMesh'DeusExItems.MedKit'
     CollisionRadius=7.500000
     CollisionHeight=3.000000
     Mass=10.000000
     Buoyancy=8.000000
     RotationRate=(Yaw=5000)
}
