//=============================================================================
// Mission01.
//=============================================================================
class Mission01 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local PaulDenton Paul;
	local UNATCOTroop troop;
	local TerroristCommander cmdr;
        Local Pawn P;

	Super.FirstFrame();

	if (localURL == "01_NYC_UNATCOISLAND")
	{
		// delete Paul and company after final briefing
		if (flags.GetBool('M02Briefing_Played'))
		{
                        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
                                if (P.IsA('PaulDenton'))
					P.Destroy();
			        else if (P.IsA('UNATCOTroop') && (P.BindName == "custodytroop"))
				        P.Destroy();
                                else if (P.IsA('TerroristCommander'))
					P.Destroy();
			}
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local Terrorist T;
	local TerroristCarcass carc;
	local SpawnPoint SP;
	local DeusExMover M;
	local PaulDenton Paul;
	local AutoTurret turret;
	local LaserTrigger laser;
	local SecurityCamera cam;
	local int count;
	local Inventory item, nextItem;
        local Pawn P;
        
	Super.Timer();

	if (localURL == "01_NYC_UNATCOISLAND")
	{
                // count the number of dead terrorists
		if (!flags.GetBool('M01PlayerAggressive'))
		{
			count = 0;

			// count the living
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.IsA('Terrorist'))
				      count++;

			// add the unconscious ones to the not dead count
			// there are 28 terrorists total on the island
			foreach AllActors(class'TerroristCarcass', carc)
			{
				if ((carc.KillerBindName == "JCDenton") && (carc.itemName == "Unconscious"))
					count++;
				else if (carc.KillerBindName != "JCDenton")
					count++;
			}

			// if the player killed more than 5, set the flag
			if (count < 23)
				flags.SetBool('M01PlayerAggressive', True,, 6);		// don't expire until mission 6
		}

		// check for the leader being killed
		if (!flags.GetBool('MS_DL_Played'))
		{
			if (flags.GetBool('TerroristCommander_Dead'))
			{
				if (!flags.GetBool('DL_LeaderNotKilled_Played'))
					Player.StartDataLinkTransmission("DL_LeaderKilled");
				else
					Player.StartDataLinkTransmission("DL_LeaderKilledInSpite");

				flags.SetBool('MS_DL_Played', True,, 2);
			}
		}

		// check for player not killing leader
		if (!flags.GetBool('PlayerAttackedStatueTerrorist') &&
			flags.GetBool('MeetTerrorist_Played') &&
			!flags.GetBool('MS_DL2_Played'))
		{
			Player.StartDataLinkTransmission("DL_LeaderNotKilled");
			flags.SetBool('MS_DL2_Played', True,, 2);
		}

		// remove guys and move Paul
		if (!flags.GetBool('MS_MissionComplete'))
		{
			if (flags.GetBool('StatueMissionComplete'))
			{
				// open the HQ blast doors and unlock some other doors
				foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'UN_maindoor')
					{
						M.bLocked = False;
						M.lockStrength = 0.0;
						M.Trigger(None, None);
					}
					else if ((M.Tag == 'StatueRuinDoors') || (M.Tag == 'temp_celldoor'))
					{
						M.bLocked = False;
						M.lockStrength = 0.0;
					}
				}

				// unhide the troop, delete the terrorists, Gunther, and teleport Paul
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				{
					if (P.IsA('UNATCOTroop') && (P.BindName == "custodytroop"))
						UNATCOTroop(P).EnterWorld();
					else if (P.IsA('UNATCOTroop') && (P.BindName == "postmissiontroops"))
						UNATCOTroop(P).EnterWorld();
					else if ( P.IsA('ThugMale2') || P.IsA('SecurityBot3') )
						P.Destroy();
					else if (P.IsA('Terrorist') && (P.BindName != "TerroristCommander"))
					{
						// delete their inventories as well
						if (P.Inventory != None)
						{
							do
							{
								item = P.Inventory;
								nextItem = item.Inventory;
								P.DeleteInventory(item);
								item.Destroy();
								item = nextItem;
							}
							until (item == None);
						}
						// actually kill the terrorists instead of destroying them
						P.HealthTorso = 0;
						P.Health = 0;
						P.TakeDamage(1, P, P.Location, vect(0,0,0), 'Shot');
					}
					else if ( P.IsA('TerroristA') || P.IsA('TerroristB') || P.IsA('TerroristC') )
					{
						// delete their inventories as well
						if (P.Inventory != None)
						{
							do
							{
								item = P.Inventory;
								nextItem = item.Inventory;
								P.DeleteInventory(item);
								item.Destroy();
								item = nextItem;
							}
							until (item == None);
						}
						// actually kill the terrorists instead of destroying them
						P.HealthTorso = 0;
						P.Health = 0;
						P.TakeDamage(1, P, P.Location, vect(0,0,0), 'Shot');
					}
					else if (P.BindName == "GuntherHermann")
						P.Destroy();
					else if (P.IsA('PaulDenton') && (P.BindName == "PaulDenton"))
					{
						SP = GetSpawnPoint('PaulTeleport');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							PaulDenton(P).SetOrders('Standing',, True);
							PaulDenton(P).SetHomeBase(SP.Location, SP.Rotation);
						}
					}
				}

				// delete all tagged turrets
				foreach AllActors(class'AutoTurret', turret)
					if ((turret.Tag == 'NSFTurret01') || (turret.Tag == 'NSFTurret02'))
						turret.Destroy();

				// delete all tagged lasertriggers
				foreach AllActors(class'LaserTrigger', laser, 'statue_lasertrap')
					laser.Destroy();

				// turn off all tagged cameras
				foreach AllActors(class'SecurityCamera', cam)
					if ((cam.Tag == 'NSFCam01') || (cam.Tag == 'NSFCam02') || (cam.Tag == 'NSFCam03'))
						cam.bNoAlarm = True;

				flags.SetBool('MS_MissionComplete', True,, 2);
			}
		}
	}
	else if (localURL == "01_NYC_UNATCOHQ")
	{
		// unhide Paul
		if (!flags.GetBool('MS_ReadyForBriefing'))
		{
			if (flags.GetBool('M01ReadyForBriefing'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                           if (P.IsA('PaulDenton'))
					      PaulDenton(P).EnterWorld();

				flags.SetBool('MS_ReadyForBriefing', True,, 2);
			}
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
       	local int i;
       	local Pawn P;
       	local bool bImportantWeapon;
       	local ScriptedPawn sp;
       	local inventory Inv;
       
       	Clear();
           
       	if (localURL == "01_NYC_UNATCOHQ")
            		return;
                         
       	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
       	{
           		sp = ScriptedPawn(P);
           		if (sp != None)
           		{ 
                 			if (sp.IsA('HumanMilitary') && !sp.IsA('GuntherHermann') && !sp.IsA('PaulDenton') )
                 			{
                     			i = Rand(3);

                     			bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 

                                    		for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       			{
                           				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               					Inv.Destroy();
                       			}

				if ( bImportantWeapon )
					AddInventory(sp, "DeusEx.WeaponMiniCrossbow");
				else
				                     AddInventory(sp, WeaponClasses[i]);
				
				if ( sp.IsA('UNATCOTroop') )
				{
					sp.SetAlliance('Player');
                     				sp.ChangeAlly('Player', 1.0, true);
				}
			}
                 			else if (sp.IsA('SecurityBot2'))
                 			{
                     			//sp.Health = 10000;
				//SecurityBot2(sp).EMPHitPoints = 10000;
				sp.bInvincible = True;
                     			sp.SetAlliance('Player');
                     			sp.ChangeAlly('Player', 1.0, true);
                 			}   
           		}
      	}
}

function Surprise()
{
      	local Pawn P;
      	local ScriptedPawn sp;

      	if (localURL == "01_NYC_UNATCOISLAND")  
      	{         
              		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode526','UNATCO',1.0,'DefendPosition',,true);
              		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode522','UNATCO',1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode350','NSF',-1.0,'DefendPosition',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode71','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristC','PathNode133','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode174','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode132','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristC','HidePoint3','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode840','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode373','NSF',-1.0,'DefendPosition',,true);
              		SpawnExtraEnemy(Class'TerroristC','PathNode843','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode557','NSF',-1.0,'DefendPosition',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode558','NSF',-1.0,'DefendPosition',,true);
	      	SpawnExtraEnemy(Class'TerroristC','HidePoint8','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode1021','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode1018','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristC','PathNode272','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode891','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode877','NSF',-1.0,'DefendPosition',,true);
              		SpawnExtraEnemy(Class'TerroristC','PathNode747','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristA','PathNode728','NSF',-1.0,'Standing',,true);
              		SpawnExtraEnemy(Class'TerroristB','PathNode20','NSF',-1.0,'Standing',,true);
		SpawnExtraEnemy(Class'TerroristC','PathNode551','NSF',-1.0,'DefendPosition',,true);

              		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                   		if (P.IsA('BumFemale'))
                        			P.Destroy();                    
      	}

      	else if (localURL == "01_NYC_UNATCOHQ")  
      	{	 
              		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint3','UNATCO',0.0,,,,"Trooper3");
              		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
              		{
                   		sp = ScriptedPawn(P);
                   		if ((sp != None) && !sp.IsA('Terrorist'))
                   		{
                        			sp.SetAlliance('Player');
                        			sp.ChangeAlly('Player', 1.0, true);
                   		}
              		}
      	}
}

function Clear()
{
	local Pawn P;
	local ScriptedPawn sp;
      	local inventory Inv, Del;
      	local CrateBreakableMedCombat cont;
	local CrateBreakableMedGeneral cont2;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  		{
                       			if ( Inv.IsA('Binoculars') )
		           			Inv.Destroy();
                  		}
		}
	}

      	ForEach AllActors(Class'Inventory', Del)
      	{
            		if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)) )
            		{
                  		if ( Del.IsA('Ammo762mm') || Del.IsA('WeaponAssaultGun') || Del.IsA('Binoculars')
			|| Del.IsA('Ammo3006') || Del.IsA('WeaponRifle') || Del.IsA('AmmoSabot') )
                      			Del.Destroy();
            		}
      	} 

      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
            		if ( (cont != None) && (cont.contents != None) )
            		{
                  		if ( (cont.contents == Class'WeaponSawedOffShotgun') ||
                     		(cont.contents == Class'DeusEx.WeaponModLaser') || (cont.contents == Class'DeusEx.WeaponModClip') )
                  		{
				if ( (cont.contents == Class'DeusEx.WeaponModLaser') && (Level.Game.Difficulty == 3) )
					cont.contents = Class'DeusEx.WeaponModClip';
                  		}
                  		else
                  		{
                       			cont.contents = InCrates[Rand(9)];
                       			cont.numThings = Rand(1) + 1;
                  		}
            		}
      	}

	ForEach AllActors(Class'CrateBreakableMedGeneral', cont2)
      	{
            		if ( (cont2 != None) && (cont2.contents != None) )
            		{
                  		if ( cont2.contents == Class'DeusEx.Binoculars' )
				cont2.contents = Class'DeusEx.WeaponModClip';
		}
	}	 
}
     
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(2)="DeusEx.WeaponHideAGun"
     InCrates(0)=Class'DeusEx.Ammo10mm'
     InCrates(1)=Class'DeusEx.AmmoDartPoison'
     InCrates(2)=Class'DeusEx.WeaponEMPGrenade'
     InCrates(3)=Class'DeusEx.WeaponPepperGun'
     InCrates(4)=Class'DeusEx.AmmoBattery'
     InCrates(5)=Class'DeusEx.WeaponShuriken'
     InCrates(6)=Class'DeusEx.WeaponHideAGun'
     InCrates(7)=Class'DeusEx.WeaponBaton'
     InCrates(8)=Class'DeusEx.WeaponMiniCrossbow'
}
