//=============================================================================
// Mission02.
//=============================================================================
class Mission02 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local ScriptedPawn pawn;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "02_NYC_STREET")
	{
		flags.SetBool('M02StreetLoaded', True,, 3);

		// if you went to the warehouse without finishing the streets,
		// set some flags
		if (!flags.GetBool('MS_GuardsWandering') &&
			flags.GetBool('WarehouseDistrictEntered'))
		{
			if (!flags.GetBool('StreetOpened') ||
				!flags.GetBool('ClinicCleared'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				{
                                    if (P.IsA('ScriptedPawn'))
                                    {
					if (P.Tag == 'ClinicGuards')
						ScriptedPawn(P).SetOrders('Wandering', '', True);
					else if (P.Tag == 'HotelGuards')
						ScriptedPawn(P).SetOrders('Wandering', '', True);
                                    }
				}
			}

			flags.SetBool('MS_GuardsWandering', True,, 3);
		}

		// Manderley will be disappointed if you don't finish the streets
		if (!flags.GetBool('M02ManderleyDisappointed') &&
			!flags.GetBool('BatteryParkComplete'))
		{
			flags.SetBool('M02ManderleyDisappointed', True,, 3);
		}

		// get rid of Sandra if you've talked to her already
		if (flags.GetBool('MeetSandraRenton_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('SandraRenton'))
					P.Destroy();
		}

		// unhide some hostages if you've rescued them
		if (flags.GetBool('EscapeSuccessful'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
                            if (P.IsA('ScriptedPawn'))
                            {
				if (P.IsA('BumMale') && (P.Tag == 'hostageMan'))
					ScriptedPawn(P).EnterWorld();
				else if (P.IsA('BumFemale') && (P.Tag == 'hostageWoman'))
					ScriptedPawn(P).EnterWorld();
                            }
			}
		}
	}
	else if (localURL == "02_NYC_BAR")
	{
		// unhide Sandra if you've talked to her already
		if (flags.GetBool('MeetSandraRenton_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('SandraRenton'))
				{
					SandraRenton(P).EnterWorld();
					flags.SetBool('MS_SandraInBar', True,, 3);
				}
		}
	}
	else if (localURL == "02_NYC_SMUG")
	{
		// unhide Ford if you've rescued him
		if (flags.GetBool('FordSchickRescued'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('FordSchick'))
					FordSchick(P).EnterWorld();

			flags.SetBool('SchickThankedPlayer', True);
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	if (localURL == "02_NYC_BATTERYPARK")
	{
		// if you leave without finishing, set some flags and remove the terrorists
		if (!flags.GetBool('MS_MapLeftEarly'))
		{
			if (!flags.GetBool('AmbrosiaTagged') ||
				!flags.GetBool('SubTerroristsDead'))
			{
				flags.SetBool('MS_MapLeftEarly', True,, 3);
			}
		}
	}
	else if (localURL == "02_NYC_UNDERGROUND")
	{
		// if you leave the level with Ford Schick, set a flag
		if (flags.GetBool('MS_FordFollowing') &&
			!flags.GetBool('FordSchick_Dead'))
		{
			flags.SetBool('FordSchickRescued', True,, 9);
		}
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local Terrorist T;
	local TerroristCarcass carc;
	local UNATCOTroop guard;
	local ThugMale thug;
	local ThugMale2 thug2;
	local BumMale bum;
	local BlackHelicopter chopper;
	local Doctor doc;
	local BarrelAmbrosia barrel;
	local ScriptedPawn pawn;
	local DeusExCarcass carc2;
	local GuntherHermann Gunther;
	local Actor A;
	local SandraRenton Sandra;
	local int count;
        local Pawn P;

	Super.Timer();

	if (localURL == "02_NYC_BATTERYPARK")
	{
		// after terrorists are dead, set guards to wandering
		if (!flags.GetBool('BatteryParkSlaughter'))
		{
			count = 0;

			// count the number of living terrorists
                        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.IsA('Terrorist') && (P.Tag == 'ClintonTerrorist'))
					count++;

			// count the number of unconscious terrorists
			foreach AllActors(class'TerroristCarcass', carc, 'ClintonTerrorist')
				if (carc.itemName == "Unconscious")
					count++;

			// there are 5 total, player must have killed 2 or more, so
			// check to see if there are fewer than 3 still alive or unconscious
			if (count <= 3)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('UNATCOTroop') && (P.Tag == 'ClintonGuard'))
					   UNATCOTroop(P).SetOrders('Wandering', '', True);

				flags.SetBool('BatteryParkSlaughter', True,, 6);
			}
		}

		// set guards to wandering after sub terrorists are dead
		if (!flags.GetBool('SubTerroristsDead'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.Tag == 'SubTerrorist'))
				        count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('UNATCOTroop') && (P.Tag == 'SubGuards'))
					   UNATCOTroop(P).SetOrders('Wandering', '', True);	

				Player.GoalCompleted('LiberateBatteryParkSubway');
				flags.SetBool('SubTerroristsDead', True,, 6);
			}
		}

		// check to see if hostages are dead
		if (!flags.GetBool('HostagesKilled') && flags.GetBool('SubHostageMale_Dead') &&
			flags.GetBool('SubHostageFemale_Dead'))
		{
			flags.SetBool('HostagesKilled', True,, 3);
		}

		// check a bunch of flags, and start a datalink
		if (!flags.GetBool('MS_MapLeftEarly') &&
			!flags.GetBool('MS_DL_Played'))
		{
			if (!flags.GetBool('SubTerroristsDead') &&
				flags.GetBool('EscapeSuccessful') &&
				!flags.GetBool('HostagesKilled'))
			{
				Player.StartDataLinkTransmission("DL_SubwayComplete3");
				flags.SetBool('MS_DL_Played', True,, 3);
			}
			else if (flags.GetBool('HostagesKilled'))
			{
				Player.StartDataLinkTransmission("DL_SubwayComplete2");
				flags.SetBool('MS_DL_Played', True,, 3);
			}
			else if (flags.GetBool('SubTerroristsDead') ||
				flags.GetBool('EscapeSuccessful'))
			{
				Player.StartDataLinkTransmission("DL_SubwayComplete");
				flags.SetBool('MS_DL_Played', True,, 3);
			}
		}

		if (!flags.GetBool('ShantyTownSecure'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.Tag == 'ShantyTerrorists'))
				count++;

			if (count == 0)
				flags.SetBool('ShantyTownSecure', True);
		}
	}
	else if (localURL == "02_NYC_STREET")
	{
		// set guards to wandering after clinc terrorists are dead
		if (!flags.GetBool('ClinicCleared'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.Tag == 'ClinicTerrorist'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('UNATCOTroop') && (P.Tag == 'ClinicGuards'))
					   UNATCOTroop(P).SetOrders('Wandering', '', True);	

				flags.SetBool('ClinicCleared', True,, 6);
			}
		}

		// set guards to wandering after street terrorists are dead
		if (!flags.GetBool('StreetOpened'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.Tag == 'StreetTerrorist'))
				           count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('UNATCOTroop') && (P.Tag == 'HotelGuards'))
					   UNATCOTroop(P).SetOrders('Wandering', '', True);	
	
				flags.SetBool('StreetOpened', True,, 6);
/*
				// there are 5 terrorists total
				// if player killed 1 or more, call it a slaughter
				foreach AllActors(class'TerroristCarcass', carc, 'StreetTerrorist')
				{
					if ((carc.KillerBindName == "JCDenton") && (carc.itemName != "Unconscious"))
						count++;
				}

				if (count >= 1)*/
					flags.SetBool('TenderloinSlaughter', True,, 6);
			}
		}

		// check to see if player rescued bum
		if (!flags.GetBool('MS_ThugsDead'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('ThugMale2') && (P.Tag == 'AlleyThug'))
				      count++;

			// set the resuced flag if the bum is still alive
			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                       if (P.IsA('BumMale') && (P.Tag == 'AlleyBum'))
					   flags.SetBool('AlleyBumRescued', True,, 3);

				flags.SetBool('MS_ThugsDead', True,, 3);
			}
		}

		// if the pimp is dead, set a flag
		if (!flags.GetBool('SandrasPimpDone'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('ThugMale') && (P.Tag == 'Pimp'))
				     count++;

			if (count == 0)
			{
				flags.SetBool('SandrasPimpDone', True,, 3);
				Player.GoalCompleted('HelpJaneysFriend');
			}
		}

		// if Sandra is dead, set a flag
		if (!flags.GetBool('MS_SandraDead'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('SandraRenton'))
				count++;

			if (count == 0)
			{
				flags.SetBool('MS_SandraDead', True,, 3);
				Player.GoalCompleted('HelpJaneysFriend');
			}
		}

		if (flags.GetBool('OverhearAlleyThug_Played') &&
			!flags.GetBool('MS_ThugAttacks'))
		{
			foreach AllActors(class'Actor', A, 'ThugAttacks')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ThugAttacks', True,, 3);
		}
	}
	else if (localURL == "02_NYC_WAREHOUSE")
	{
		// start infolink after generator blown
		// also unhide the helicopter and Gunther on the roof
		if (!flags.GetBool('MS_GeneratorStuff'))
		{
			if (!flags.GetBool('DL_Pickup_Played') &&
				flags.GetBool('GeneratorBlown'))
			{
				Player.StartDataLinkTransmission("DL_Pickup");

				foreach AllActors(class'BlackHelicopter', chopper, 'Helicopter')
					chopper.EnterWorld();

				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                        if (P.IsA('GuntherHermann'))
					       GuntherHermann(P).EnterWorld();

				flags.SetBool('MS_GeneratorStuff', True,, 3);
			}
		}
	}
	else if (localURL == "02_NYC_FREECLINIC")
	{
		// make the bum disappear when he gets to his destination
		if (flags.GetBool('MS_BumLeaving') &&
			!flags.GetBool('MS_BumRemoved'))
		{
			foreach AllActors(class'BumMale', bum, 'SickBum1')
				if (bum.IsInState('Standing'))
					bum.Destroy();

			flags.SetBool('MS_BumRemoved', True,, 3);
			flags.DeleteFlag('MS_BumLeaving', FLAG_Bool);
		}

		// make the bum leave after talking to the doctor
		if (flags.GetBool('Doctor2_Saved') &&
			!flags.GetBool('MS_BumRemoved') &&
			!flags.GetBool('MS_BumLeaving'))
		{
			foreach AllActors(class'BumMale', bum, 'SickBum1')
				bum.SetOrders('GoingTo', 'SickBumDestination', True);

			flags.SetBool('MS_BumLeaving', True,, 3);
		}

		// make the bum face the doctor
		if (flags.GetBool('SickBumInterrupted_Played') &&
			!flags.GetBool('Doctor2_Saved') &&
			!flags.GetBool('MS_BumTurned'))
		{
			foreach AllActors(class'Doctor', doc, 'Doctor2')
				foreach AllActors(class'BumMale', bum, 'SickBum1')
				{
					bum.DesiredRotation = Rotator(doc.Location - bum.Location);
					break;
				}

			flags.SetBool('MS_BumTurned', True,, 3);
		}
	}
	else if (localURL == "02_NYC_BAR")
	{
		// if the player kills anybody in the bar, set a flag
		if (!flags.GetBool('M02ViolenceInBar'))
		{
			count = 0;

			foreach AllActors(class'DeusExCarcass', carc2)
				count++;

			if (count > 0)
				flags.SetBool('M02ViolenceInBar', True,, 4);
		}
	}
	else if (localURL == "02_NYC_HOTEL")
	{
		// if the player kills all the terrorists, set a flag
		if (!flags.GetBool('M02HostagesRescued'))
		{
			count = 0;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.Tag == 'SecondFloorTerrorist'))
					count++;

			if (count == 0)
				flags.SetBool('M02HostagesRescued', True,, 3);
		}
	}
	else if (localURL == "02_NYC_UNDERGROUND")
	{
		if (flags.GetBool('FordSchick_Dead') &&
			!flags.GetBool('FordSchickRescueDone'))
		{
			flags.SetBool('FordSchickRescueDone', True,, 9);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;

    	Clear();
            
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if ( sp != None )
          		{ 
               			if ( sp.IsA('HumanMilitary') && !sp.IsA('Researcher') && !sp.IsA('Terrorist') && !sp.IsA('TerroristB') && !sp.IsA('TerroristC') )
               			{
                       			i = Rand(4);      
          
                       			bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 
                   
                   			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       			{
                           				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               					Inv.Destroy();
                       			}
					if ( bImportantWeapon )
						AddInventory(sp, "DeusEx.WeaponMiniCrossbow");
					else
					{
						if ( Level.Game.Difficulty == 3 )
							AddInventory(sp, WeaponClasses[i]);
						else
						{
							if ( FRand() < 0.25 )
								AddInventory(sp, "DeusEx.WeaponDXQuadShot");							
							else
                       						AddInventory(sp, WeaponClasses[i]);
						}
					}
                    			
                       			if (sp.IsA('UnatcoTroop') || sp.IsA('AnnaNavarre') || sp.IsA('GuntherHermann'))
					{
                              				sp.ChangeAlly(Player.Alliance, 1.0, true);  
							if ( sp.IsA('GuntherHermann') )
								AddInventory(sp, "DeusEx.WeaponHideAGun");
					}
               			} 

               			else if ( sp.IsA('Terrorist') )
               			{
                       			i = Rand(2);

					bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None);    
            
                       			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                              			if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                    			Inv.Destroy();

                       			if ( bImportantWeapon )
						AddInventory(sp, "DeusEx.WeaponMiniCrossbow");
					else
					{
						if ( Level.Game.Difficulty == 3 )
							AddInventory(sp, WeaponClasses[i]);
						else
						{
							if ( FRand() < 0.2 )
								AddInventory(sp, "DeusEx.WeaponDXQuadShot");															
							else
                       						AddInventory(sp, WeaponClasses[i]);
						}
					}
               			} 

				else if ( sp.IsA('TerroristB') || sp.IsA('TerroristC') )
               			{
                       			i = Rand(3);
                
                       			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                              			if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                    			Inv.Destroy();

					if ( FRand() < 0.5 )
                       				AddInventory(sp, WeaponClasses[i]);
					else
						AddInventory(sp, "DeusEx.WeaponHideAGun");
               			} 
               
               			else if ( sp.IsA('GilbertRenton') )
               			{
                       			sp.ChangeAlly('NSF', 0.0, true);
                       			sp.ChangeAlly(Player.Alliance, 0.0, true); 
               			} 

               			else if ( sp.IsA('Researcher') )
               			{
					if ( Researcher(sp).bDefendPosition )
						AddInventory(sp, "DeusEx.WeaponLAW");
					else //Burn baby!!!
                       				AddInventory(sp, "DeusEx.WeaponFlamethrower");
               			}                 
          		}
    	}
}

function Surprise()
{
   	if (localURL == "02_NYC_BATTERYPARK")  
   	{	 
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode156','UNATCO',1.0,'Standing',,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode93','UNATCO',1.0,'Standing',,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode122','UNATCO',1.0,,,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode53','UNATCO',1.0,,,true,"SubGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint4','UNATCO',1.0,,,true,"SubGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode57','UNATCO',1.0,'Standing',,true,"SubGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode27','UNATCO',1.0,'Standing',,true,"SubGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode22','UNATCO',1.0,'Standing',,true,"UnatcoTroop"); 
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode113','UNATCO',1.0,'Standing',,true,"UnatcoTroop");                              
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode120','UNATCO',1.0,'Standing',,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode242','UNATCO',1.0,,,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode241','UNATCO',1.0,,,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode240','UNATCO',1.0,,,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint18','UNATCO',1.0,'Standing',,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode77','UNATCO',1.0,,,true,"UnatcoTroop");
            		SpawnExtraEnemy(Class'TerroristA','PathNode17','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode16','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode177','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode173','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode90','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristC','HidePoint1','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode214','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode224','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode167','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'Terrorist','HidePoint11','NSF',-1.0,'DefendPosition',,true);
   	}

   	else if (localURL == "02_NYC_HOTEL")  
   	{ 
            		SpawnExtraEnemy(Class'TerroristB','PathNode47','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode37','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode25','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode34','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode35','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode55','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode54','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode61','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode51','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode5','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode10','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode62','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode63','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'Terrorist','HidePoint0','NSF',-1.0,,,true);
   	}

   	else if (localURL == "02_NYC_UNDERGROUND")
   	{
            		SpawnExtraEnemy(Class'Researcher','PathNode15','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','PathNode16','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'ScubaDiver','HidePoint3','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','PathNode21','mj12',-1.0,'DefendPosition');
            		SpawnExtraEnemy(Class'ScubaDiver','PathNode3','mj12',-1.0);
   	}

   	else if (localURL == "02_NYC_WAREHOUSE")
   	{
            		SpawnExtraActor(Class'MachineGunBase', 'PathNode127');
            		SpawnExtraEnemy(Class'TerroristA','PathNode101','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode102','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode267','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode256','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode263','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode256','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode145','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode136','NSF',-1.0,'DefendPosition',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode135','NSF',-1.0,,,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode68','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode158','NSF',-1.0,'Standing',,true);  
            		SpawnExtraEnemy(Class'TerroristC','PathNode12','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristA','PathNode38','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristB','PathNode39','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'TerroristC','PathNode155','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode151','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode144','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode130','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode261','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode99','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode268','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode11','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode66','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode120','NSF',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Terrorist','PathNode80','NSF',-1.0,'Standing',,true);
   	}

   	else if (localURL == "02_NYC_STREET")
   	{
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode215','UNATCO',1.0,,,true,"HotelGuards"); 
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode214','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode135','UNATCO',1.0,,,true,"HotelGuards"); 
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode136','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode137','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode106','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode107','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode108','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode242','UNATCO',1.0,,,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode28','UNATCO',1.0,,,true,"HotelGuards"); 
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint6','UNATCO',1.0,'Standing',,true,"HotelGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint1','UNATCO',1.0,'Standing',,true,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint5','UNATCO',1.0,'Standing',,true,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode4','UNATCO',1.0,'Standing',,true,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode0','UNATCO',1.0,'Standing',,true,"ClinicGuards");
            		SpawnExtraEnemy(Class'SecurityBot2','PathNode87','UNATCO',1.0,'Standing');                   
            		SpawnExtraEnemy(Class'TerroristA','PathNode199','NSF',-1.0,'DefendPosition');
            		SpawnExtraEnemy(Class'TerroristB','PathNode202','NSF',-1.0,'Standing');
            		SpawnExtraEnemy(Class'TerroristC','PathNode207','NSF',-1.0,'DefendPosition');
            		SpawnExtraEnemy(Class'Terrorist','PathNode203','NSF',-1.0);
            		SpawnExtraEnemy(Class'Terrorist','PathNode206','NSF',-1.0);
   	}	 

   	else if (localURL == "02_NYC_FREECLINIC")
   	{
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode201','UNATCO',1.0,,,,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint0','UNATCO',1.0,,,,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint1','UNATCO',1.0,,,,"ClinicGuards");              
   	}

   	else if (localURL == "02_NYC_BAR")
   	{
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint1','UNATCO',1.0,'Standing',,,"ClinicGuards");
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint2','UNATCO',1.0,'Standing',,,"ClinicGuards"); 
            		SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint4','UNATCO',1.0,'Standing',,,"ClinicGuards");             
   	}
}

function Clear()
{
	local Pawn P;
      	local inventory Inv, Del;
	local ScriptedPawn sp;
      	local CrateBreakableMedCombat cont;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  		{
                       			if ( Inv.IsA('Binoculars') )
		           			Inv.Destroy();
                  		}
		}
	}

      	ForEach AllActors(Class'Inventory', Del)
      	{
            		if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)))
            		{
                  		if ( Del.IsA('Ammo762mm') || Del.IsA('WeaponAssaultGun') || Del.IsA('Binoculars')
			|| Del.IsA('Ammo3006') || Del.IsA('WeaponRifle') || Del.IsA('AmmoSabot') )
                      			Del.Destroy();
            		}
      	} 

      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
            		if ( (cont != None) && (cont.contents != None) )
            		{
                  		if (cont.contents != Class'WeaponSawedOffShotgun')
                  		{
					cont.contents = InCrates[Rand(7)];
                       			cont.numThings = Rand(1) + 1;
                  		}
            		}
      	} 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(2)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(3)="DeusEx.WeaponPepperGun"
     InCrates(0)=Class'DeusEx.Ammo10mm'
     InCrates(1)=Class'DeusEx.AmmoPepper'
     InCrates(2)=Class'DeusEx.AmmoDartPoison'
     InCrates(3)=Class'DeusEx.AmmoShell'
     InCrates(4)=Class'DeusEx.AmmoBattery'
     InCrates(5)=Class'DeusEx.AmmoDart'
     InCrates(6)=Class'DeusEx.AmmoDartFlare'
}
