//=============================================================================
// Mission03.
//=============================================================================
class Mission03 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local Terrorist T;
        local TerroristB TB;
        local BlackHelicopter chopper;
	local SecurityBot3 bot;
	local PaulDenton Paul;
	local SecurityCamera cam;
	local AutoTurret turret;
	local GuntherHermann Gunther;
	local UNATCOTroop troop;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "03_NYC_AIRFIELDHELIBASE")
	{
		// delete terrorists and unhide reinforcements
		if (flags.GetBool('MeetLebedev_Played') ||
			flags.GetBool('JuanLebedev_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        			{
                                				if (P.IsA('Terrorist'))
				     		P.Destroy();
					else if (P.IsA('TerroristA'))
                                     				P.Destroy();
                                				else if (P.IsA('TerroristB'))
                                     				P.Destroy();
                                				else if (P.IsA('TerroristC'))
                                     				P.Destroy();
                                				else if (P.IsA('SecurityBot3'))
                                     				P.Destroy();
			        		else if (P.IsA('UnatcoTroop') && (P.Tag == 'UNATCOTroop'))                                        
				     		UnatcoTroop(P).EnterWorld();
                        			}
			}
	}
	else if (localURL == "03_NYC_AIRFIELD")
	{
		// delete terrorists and unhide reinforcements and unhide the helicopter
		// also, turn off all security cameras
		if (flags.GetBool('MeetLebedev_Played') ||
			flags.GetBool('JuanLebedev_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        			{
                                				if (P.IsA('Terrorist'))
				    		P.Destroy();
					else if (P.IsA('TerroristA'))
                                     				P.Destroy();
                                				else if (P.IsA('TerroristB'))
                                     				P.Destroy();
                                				else if (P.IsA('TerroristC'))
                                     				P.Destroy();
                                				else if (P.IsA('SecurityBot3'))
                                     				P.Destroy();
			        		else if (P.IsA('UnatcoTroop') && (P.Tag == 'UNATCOTroop'))                                        
				     		UnatcoTroop(P).EnterWorld();
                                				else if (P.IsA('GuntherHermann'))                                        
				     		GuntherHermann(P).EnterWorld();
                        			}

				foreach AllActors(class'BlackHelicopter', chopper)
					chopper.EnterWorld();

				foreach AllActors(class'SecurityCamera', cam)
					cam.UnTrigger(None, None);

				foreach AllActors(class'AutoTurret', turret)
					turret.Destroy();
			}
	}
	else if (localURL == "03_NYC_HANGAR")
	{
		// delete terrorists and unhide reinforcements
		if (flags.GetBool('MeetLebedev_Played') ||
			flags.GetBool('JuanLebedev_Dead'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
                                if (P.IsA('Terrorist'))
				     P.Destroy();
                                else if (P.IsA('PaulDenton'))
                                     P.Destroy();
                                else if (P.IsA('SecurityBot3'))
                                     P.Destroy();
			        else if (P.IsA('UnatcoTroop') && (P.Tag == 'UNATCOTroop'))                                        
				     UnatcoTroop(P).EnterWorld();
                        }
		}
	}
	else if (localURL == "03_NYC_747")
	{
		// delete terrorists
		if (flags.GetBool('MeetLebedev_Played') ||
			flags.GetBool('JuanLebedev_Dead'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
                                if (P.IsA('Terrorist'))
				     P.Destroy();
                                else if (P.IsA('SecurityBot3'))
                                     P.Destroy();
                        }
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local WaltonSimons Walton;
	local AnnaNavarre Anna;
	local GuntherHermann Gunther;
	local JuanLebedev Juan;
	local JuanLebedevCarcass carc;
	local ThugMale Thug;
	local ThugMale2 Thug2;
	local ScriptedPawn pawn;
	local Terrorist T;
	local int count;
	local DeusExMover M;
        Local Pawn P;
	local bool bCarcFound, bJuanFound;
        
	Super.Timer();

	if (localURL == "03_NYC_UNATCOHQ")
	{
                // make Walton Simons walk to the cell
		if (!flags.GetBool('MS_SimonsWalking'))
		{
			if (flags.GetBool('SimonsOverheard_Played'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                      If (P.IsA('WaltonSimons'))
					  WaltonSimons(P).SetOrders('GoingTo', 'SimonsInterrogating', True);

				flags.SetBool('MS_SimonsWalking', True,, 4);
			}
		}

		// set a flag when Walton Simons gets to his point
		if (!flags.GetBool('SimonsInterrogating'))
		{
			if (flags.GetBool('MS_SimonsWalking'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                      if (P.IsA('WaltonSimons'))
                                           if (WaltonSimons(P).IsInState('Standing'))
						flags.SetBool('SimonsInterrogating', True,, 4);
			}
		}

		// unlock a door when a flag is set
		if (!flags.GetBool('MS_MoverUnlocked') && flags.GetBool('UnlockDoor'))
		{
			foreach AllActors(class'DeusExMover', M, 'Manderley_Office')
			{
				M.bLocked = False;
				M.lockStrength = 0.0;
			}

			flags.SetBool('MS_MoverUnlocked', True,, 4);
		}

		if (flags.GetBool('AnnaAtDesk') &&
			!flags.GetBool('MS_AnnaDeskHome'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              If (P.IsA('AnnaNavarre'))
				AnnaNavarre(P).SetHomeBase(AnnaNavarre(P).Location, AnnaNavarre(P).Rotation);
			flags.SetBool('MS_AnnaDeskHome', True,, 4);
		}

		if (flags.GetBool('AnnaInOffice') &&
			!flags.GetBool('MS_AnnaOfficeHome'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              If (P.IsA('AnnaNavarre'))
				AnnaNavarre(P).SetHomeBase(AnnaNavarre(P).Location, AnnaNavarre(P).Rotation);
			flags.SetBool('MS_AnnaOfficeHome', True,, 4);
		}
	}
	else if (localURL == "03_NYC_AIRFIELDHELIBASE")
	{
		// check for Ambrosia Barrels being tagged
		if (!flags.GetBool('Barrel1Checked'))
		{
			if (flags.GetBool('HelicopterBaseAmbrosia'))
			{
				count = 1;
				if (flags.GetBool('BoatDocksAmbrosia'))
					count++;
				if (flags.GetBool('747Ambrosia'))
					count++;

				if (count == 1)
					Player.StartDataLinkTransmission("DL_TaggedOne");
				else if (count == 2)
					Player.StartDataLinkTransmission("DL_TaggedTwo");
				else if (count == 3)
					Player.StartDataLinkTransmission("DL_TaggedThree");
					
				flags.SetBool('Barrel1Checked', True,, 4);
			}
		}
	}
	else if (localURL == "03_NYC_AIRFIELD")
	{
		// check for Ambrosia Barrels being tagged
		if (!flags.GetBool('Barrel2Checked'))
		{
			if (flags.GetBool('BoatDocksAmbrosia'))
			{
				count = 1;
				if (flags.GetBool('HelicopterBaseAmbrosia'))
					count++;
				if (flags.GetBool('747Ambrosia'))
					count++;

				if (count == 1)
					Player.StartDataLinkTransmission("DL_TaggedOne");
				else if (count == 2)
					Player.StartDataLinkTransmission("DL_TaggedTwo");
				else if (count == 3)
					Player.StartDataLinkTransmission("DL_TaggedThree");
					
				flags.SetBool('Barrel2Checked', True,, 4);
			}
		}

		// unhide Gunther
		if (!flags.GetBool('MS_GuntherUnhidden'))
		{
			if (flags.GetBool('MeetLebedev_Played') ||
				flags.GetBool('JuanLebedev_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('GuntherHermann'))                                        
				          GuntherHermann(P).EnterWorld();
				flags.SetBool('MS_GuntherUnhidden', True,, 4);
			}
		}
	}
	else if (localURL == "03_NYC_747")
	{
		// check for Lebedev's death
		if (flags.GetBool('JuanLebedev_Dead') &&
			!flags.GetBool('MS_Anna747Unhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('AnnaNavarre'))                                        
				          AnnaNavarre(P).EnterWorld();

			flags.SetBool('MS_Anna747Unhidden', True,, 4);
		}

		// check for Ambrosia Barrels being tagged
		if (!flags.GetBool('Barrel3Checked'))
		{
			if (flags.GetBool('747Ambrosia'))
			{
				count = 1;
				if (flags.GetBool('HelicopterBaseAmbrosia'))
					count++;
				if (flags.GetBool('BoatDocksAmbrosia'))
					count++;

				if (count == 1)
					Player.StartDataLinkTransmission("DL_TaggedOne");
				else if (count == 2)
					Player.StartDataLinkTransmission("DL_TaggedTwo");
				else if (count == 3)
					Player.StartDataLinkTransmission("DL_TaggedThree");
					
				flags.SetBool('Barrel3Checked', True,, 4);
			}
		}

		// unhide Anna
		if (!flags.GetBool('MS_AnnaUnhidden'))
		{
			if (flags.GetBool('MeetLebedev_Played') ||
				flags.GetBool('JuanLebedev_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('AnnaNavarre'))                                        
				          AnnaNavarre(P).EnterWorld();
				flags.SetBool('MS_AnnaUnhidden', True,, 4);
			}
		}

		// check to see if the player has killed Lebedev
		if (!flags.GetBool('PlayerKilledLebedev') &&
			!flags.GetBool('AnnaKilledLebedev'))
		{
			bCarcFound = False;
			foreach AllActors(class'JuanLebedevCarcass', carc)
			{
				bCarcFound = True;

				if ((carc.KillerBindName == "JCDenton") || (carc.KillerBindName == ""))
				{
					Player.GoalCompleted('AssassinateLebedev');
					flags.SetBool('PlayerKilledLebedev', True,, 6);
				}
				else if (carc.KillerBindName == "AnnaNavarre")
					flags.SetBool('AnnaKilledLebedev', True,, 6);
				else
					flags.SetBool('JuanLebedev_Dead', True,, 0);
			}

			bJuanFound = False;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                     if (P.IsA('JuanLebedev')) 
				            bJuanFound = True;

			if (!bCarcFound && !bJuanFound && flags.GetBool('JuanLebedev_Dead'))
				flags.SetBool('PlayerKilledLebedev', True,, 6);
		}
	}
	else if (localURL == "03_NYC_MOLEPEOPLE")
	{
		// set a flag when there are less than 4 mole people alive
		if (!flags.GetBool('MolePeopleSlaughtered'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.Tag == 'MolePeople')
				count++;

			if (count < 4)
				flags.SetBool('MolePeopleSlaughtered', True,, 4);
		}

		// set a flag when there are less than 3 terrorists alive
		if (!flags.GetBool('MoleTerroristsDefeated'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.IsA('Terrorist') && (P.Tag == 'MoleTerrorist'))
				count++;

			if (count < 3)
				flags.SetBool('MoleTerroristsDefeated', True,, 4);
		}
	}
	else if (localURL == "03_NYC_BROOKLYNBRIDGESTATION")
	{
		// set a flag when the gang's all dead
		if (!flags.GetBool('JugHeadGangDefeated'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.IsA('ThugMale2') && (P.Tag == 'ThugMale2'))
				 count++;

			 if (count == 0)
				flags.SetBool('JugHeadGangDefeated', True,, 4);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
       	local int i;
       	local Pawn P;
       	local bool bImportantWeapon;
       	local ScriptedPawn sp;
       	local inventory Inv;

       	Clear();
       
       	if (localURL == "03_NYC_UNATCOHQ")
                		return;
        
       	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
       	{
               		sp = ScriptedPawn(P);
               		if (sp != None)
               		{ 
                    		if (sp.IsA('HumanMilitary'))
                    		{
                        			i = Rand(5);

                        			bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 
                   
                   			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       			{
                           				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               					Inv.Destroy();
                       			}

					if ( bImportantWeapon )
						AddInventory(sp, "DeusEx.WeaponLAW");
					else
					{
						if ( Level.Game.Difficulty == 3 )
							AddInventory(sp, WeaponClasses[i]);
						else
						{
							if ( FRand() < 0.25 )
							{
								if ( FRand() < 0.5 )
									AddInventory(sp, "DeusEx.WeaponSMG");
								else
									AddInventory(sp, "DeusEx.WeaponDXQuadShot");
							}
							else
                       						AddInventory(sp, WeaponClasses[i]);
						}
					}

                        			if (sp.IsA('UnatcoTroop') || sp.IsA('GuntherHermann'))
                              				sp.ChangeAlly(Player.Alliance, 1.0, true);  
                    		}
               		}              
       	}
}

function Surprise()
{
       	local Pawn P;
       	local ScriptedPawn sp;

       	if (localURL == "03_NYC_AIRFIELDHELIBASE")
       	{         
               		SpawnExtraEnemy(Class'TerroristA','PathNode92','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'TerroristB','PathNode105','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristC','PathNode102','Terrorist',-1.0,,,true); 
               		SpawnExtraEnemy(Class'TerroristA','HidePoint1','Terrorist',-1.0,'Standing',,true);              
               		SpawnExtraEnemy(Class'TerroristB','HidePoint2','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'TerroristC','PathNode150','Terrorist',-1.0,'DefendPosition',,true); 
               		SpawnExtraEnemy(Class'TerroristA','PathNode41','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristB','PathNode19','Terrorist',-1.0,,,true);
               		SpawnExtraEnemy(Class'TerroristC','PathNode15','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'TerroristA','PathNode144','Terrorist',-1.0,'DefendPosition',,true); 
               		SpawnExtraEnemy(Class'TerroristB','PathNode93','Terrorist',-1.0,,,true);
               		SpawnExtraEnemy(Class'TerroristC','PathNode91','Terrorist',-1.0,'DefendPosition',,true);
       	}   

       	else if (localURL == "03_NYC_AIRFIELD")
       	{
               		//SpawnExtraActor(Class'MachineGunBase', 'PathNode87');
               		SpawnExtraActor(Class'MachineGunBase', 'PathNode88');
               		SpawnExtraEnemy(Class'TerroristA','PathNode375','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristB','PathNode374','Terrorist',-1.0,'Standing',,true);                         
               		SpawnExtraEnemy(Class'TerroristC','PathNode115','Terrorist',-1.0,'Standing',,true);             
               		SpawnExtraEnemy(Class'TerroristA','PathNode31','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristB','PathNode32','Terrorist',-1.0,'DefendPosition',,true);                         
               		SpawnExtraEnemy(Class'TerroristC','PathNode27','Terrorist',-1.0,,,true); 
               		SpawnExtraEnemy(Class'TerroristA','PathNode206','Terrorist',-1.0,'DefendPosition',,true);                         
               		SpawnExtraEnemy(Class'TerroristB','PathNode93','Terrorist',-1.0,'Standing',,true);             
               		SpawnExtraEnemy(Class'TerroristC','HidePoint7','Terrorist',-1.0,'Standing',,true);             
               		SpawnExtraEnemy(Class'TerroristA','PathNode127','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'TerroristB','PathNode332','Terrorist',-1.0,,,true);             
               		SpawnExtraEnemy(Class'TerroristC','PathNode395','Terrorist',-1.0,,,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode333','Terrorist',-1.0,,,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode387','Terrorist',-1.0,,,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode97','Terrorist',-1.0,'DefendPosition',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode98','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode99','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode241','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode246','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode28','Terrorist',-1.0,'DefendPosition',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode29','Terrorist',-1.0,'DefendPosition',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode30','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','PathNode383','Terrorist',-1.0,'Standing',,true);
               		SpawnExtraEnemy(Class'Terrorist','HidePoint3','Terrorist',-1.0,'Standing',,true);
       	}

       	else if (localURL == "03_NYC_MOLEPEOPLE")
       	{
               		SpawnExtraEnemy(Class'TerroristA','PathNode1','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristB','HidePoint1','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristC','PathNode72','Terrorist',-1.0,'DefendPosition',,true);
               		SpawnExtraEnemy(Class'TerroristA','HidePoint2','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'TerroristB','PathNode68','Terrorist',-1.0,'DefendPosition',,true); 
               		SpawnExtraEnemy(Class'TerroristC','HidePoint3','Terrorist',-1.0,'Standing',,true); 
               		SpawnExtraEnemy(Class'Terrorist','PathNode45','Terrorist',-1.0,'DefendPosition',,true); 
               		SpawnExtraEnemy(Class'Terrorist','PathNode1107','Terrorist',-1.0,'DefendPosition',,true); 
       	}        

       	else if (localURL == "03_NYC_BATTERYPARK")  
       	{ 
               		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode23','UNATCO',1.0,,,true,"ClintonGuard");
               		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode22','UNATCO',1.0,,,true,"ClintonGuard");
               		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode31','UNATCO',1.0,,,true,"ClintonGuard");
               		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode155','UNATCO',1.0,,,true,"CokeTroop");
               		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode103','UNATCO',1.0,,,true,"CokeTroop");
       	}

       	else if (localURL == "03_NYC_BROOKLYNBRIDGESTATION")
       	{
               		SpawnExtraEnemy(Class'TerroristA','HidePoint1','Terrorist',-1.0,'DefendPosition',,true); 
       	}
 
       	else if (localURL == "03_NYC_UNATCOHQ")  
       	{ 
              		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
              		{
                   		sp = ScriptedPawn(P);
                   		if (sp != None)  
                   		{
                       			if (sp.IsA('Terrorist') || sp.IsA('WaltonSimons'))
                       			{
                       			}
                       			else
                             				sp.ChangeAlly('Player', 1.0, true);
                   		}
              		} 
       	}
}

function Clear()
{
      	local inventory Del;
	local Binoculars Dog;
      	local CrateBreakableMedCombat cont;
      
      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
             		if ( (cont != None) && (cont.contents != None) )
             		{
			if ( (localURL == "03_NYC_AIRFIELDHELIBASE") && (cont.contents == Class'DeusEx.Ammo762mm') )
				cont.contents = Class'DeusEx.Binoculars';
			else
			{
                   			cont.contents = InCrates[Rand(10)];
                   			cont.numThings = Rand(1) + 1;
			}
             		}
      	} 

	 if ( localURL == "03_NYC_AIRFIELD" )
       	{
		ForEach AllActors(Class'Binoculars', Dog)
      		{
            			if ( (Dog != None) && (Dog.IsInState('Pickup') || (Dog.Owner == None)) )
            			{
                  			Dog.SetLocation(Dog.Location + 20*vect(0,0,1));
					Dog.SetPhysics(Phys_Falling);
            			}
      		} 
	}

	else
	{
		ForEach AllActors(Class'Inventory', Del)
      		{
            			if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)) )
            			{
                  			if ( Del.IsA('WeaponAssaultGun') || Del.IsA('Binoculars') 
				|| Del.IsA('WeaponRifle') || Del.IsA('AmmoSabot') )
				{
					if ( localURL != "03_NYC_747" )
                      					Del.Destroy();
				}
            			}
      		} 
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(2)="DeusEx.WeaponFlamethrower"
     WeaponClasses(3)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(4)="DeusEx.WeaponHideAGun"
     InCrates(0)=Class'DeusEx.Ammo10mm'
     InCrates(1)=Class'DeusEx.AmmoShell'
     InCrates(2)=Class'DeusEx.AmmoBattery'
     InCrates(3)=Class'DeusEx.WeaponNanoVirusGrenade'
     InCrates(4)=Class'DeusEx.AmmoNapalm'
     InCrates(5)=Class'DeusEx.AmmoDart'
     InCrates(6)=Class'DeusEx.Ammo762mm'
     InCrates(7)=Class'DeusEx.Ammo3006'
     InCrates(8)=Class'DeusEx.WeaponModClip'
     InCrates(9)=Class'DeusEx.AmmoDartFlare'
}
