//=============================================================================
// Mission04.
//=============================================================================
class Mission04 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local ScriptedPawn pawn;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "04_NYC_STREET")
	{
		// unhide a bunch of stuff on this flag
		if (flags.GetBool('TalkedToPaulAfterMessage_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
                                if (P.IsA('SecurityBot2'))
                                     SecurityBot2(P).EnterWorld();
			        else if (P.IsA('UnatcoTroop'))                                        
				     UnatcoTroop(P).EnterWorld();
                        }
		}
	}
	else if (localURL == "04_NYC_FREECLINIC")
	{
		// unhide a bunch of stuff on this flag
		if (flags.GetBool('TalkedToPaulAfterMessage_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
                                if (P.IsA('UnatcoTroop'))                                        
				     UnatcoTroop(P).EnterWorld();
                        }
		}
	}
	else if (localURL == "04_NYC_HOTEL")
	{
		// unhide the correct JoJo
		if (flags.GetBool('SandraRenton_Dead') ||
			flags.GetBool('GilbertRenton_Dead'))
		{
			if (!flags.GetBool('JoJoFine_Dead'))
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                      if (P.IsA('JoJoFine') && (P.Tag == 'JoJoInLobby'))                                        
			                      JoJoFine(P).EnterWorld();        
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local ScriptedPawn pawn;
	local SatelliteDish dish;
	local SandraRenton Sandra;
	local GilbertRenton Gilbert;
	local GilbertRentonCarcass GilbertCarc;
	local SandraRentonCarcass SandraCarc;
	local UNATCOTroop troop;
	local Actor A;
	local PaulDenton Paul;
        local Pawn P;
	local int count;

	Super.Timer();

	// do this for every map in this mission
	// if the player is "killed" after a certain flag, he is sent to mission 5
	if (!flags.GetBool('MS_PlayerCaptured'))
	{
		if (flags.GetBool('TalkedToPaulAfterMessage_Played'))
		{
			if (Player.IsInState('Dying'))
			{
				flags.SetBool('MS_PlayerCaptured', True,, 5);
				Player.GoalCompleted('EscapeToBatteryPark');
				Level.Game.SendPlayer(Player, "05_NYC_UNATCOMJ12Lab");
			}
		}
	}

	if (localURL == "04_NYC_HOTEL")
	{
		// check to see if the player has killed either Sandra or Gilbert
		if (!flags.GetBool('PlayerKilledRenton'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                             if (P.IsA('SandraRenton'))  
				  count++;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                             if (P.IsA('GilbertRenton'))  
				  count++;

			foreach AllActors(class'SandraRentonCarcass', SandraCarc)
				if (SandraCarc.KillerBindName == "JCDenton")
					count = 0;

			foreach AllActors(class'GilbertRentonCarcass', GilbertCarc)
				if (GilbertCarc.KillerBindName == "JCDenton")
					count = 0;

			if (count < 2)
			{
				flags.SetBool('PlayerKilledRenton', True,, 5);
				foreach AllActors(class'Actor', A, 'RentonsHatePlayer')
					A.Trigger(Self, Player);
			}
		}

		if (!flags.GetBool('M04RaidTeleportDone') &&
			flags.GetBool('ApartmentEntered'))
		{
			if (flags.GetBool('NSFSignalSent'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				{
                                     if (P.IsA('ScriptedPawn'))
                                     {
					if (p.IsA('UNATCOTroop') || p.IsA('MIB'))
						ScriptedPawn(P).EnterWorld();
					else if (p.IsA('SandraRenton') || p.IsA('GilbertRenton') || p.IsA('HarleyFilben'))
						ScriptedPawn(P).LeaveWorld();
                                     } 
				}

				foreach AllActors(class'PaulDenton', Paul)
				{
					Player.StartConversationByName('TalkedToPaulAfterMessage', Paul, False, False);
					break;
				}

				flags.SetBool('M04RaidTeleportDone', True,, 5);
			}
		}

		// make the MIBs mortal
		if (!flags.GetBool('MS_MIBMortal'))
		{
			if (flags.GetBool('TalkedToPaulAfterMessage_Played'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
					if (p.IsA('MIB'))
						MIB(p).bInvincible = False;

				flags.SetBool('MS_MIBMortal', True,, 5);
			}
		}

		// unhide the correct JoJo
		if (!flags.GetBool('MS_JoJoUnhidden') &&
			(flags.GetBool('SandraWaitingForJoJoBarks_Played') ||
			flags.GetBool('GilbertWaitingForJoJoBarks_Played')))
		{
			if (!flags.GetBool('JoJoFine_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                      if (P.IsA('JoJoFine') && (P.Tag == 'JoJoUpstairs') )                                       
			                      JoJoFine(P).EnterWorld();    

				flags.SetBool('MS_JoJoUnhidden', True,, 5);
			}
		}

		// unhide the correct JoJo
		if (!flags.GetBool('MS_JoJoUnhidden') &&
			(flags.GetBool('M03OverhearSquabble_Played') &&
			!flags.GetBool('JoJoOverheard_Played') &&
			flags.GetBool('JoJoEntrance')))
		{
			if (!flags.GetBool('JoJoFine_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                      if (P.IsA('JoJoFine') && (P.Tag == 'JoJoUpstairs'))                                        
			                      JoJoFine(P).EnterWorld();      
					
				flags.SetBool('MS_JoJoUnhidden', True,, 5);
			}
		}

		// trigger some stuff based on convo flags
		if (flags.GetBool('JoJoOverheard_Played') && !flags.GetBool('MS_JoJo1Triggered'))
		{
			if (flags.GetBool('GaveRentonGun'))
			{
				foreach AllActors(class'Actor', A, 'GilbertAttacksJoJo')
					A.Trigger(Self, Player);
			}
			else
			{
				foreach AllActors(class'Actor', A, 'JoJoAttacksGilbert')
					A.Trigger(Self, Player);
			}

			flags.SetBool('MS_JoJo1Triggered', True,, 5);
		}

		// trigger some stuff based on convo flags
		if (flags.GetBool('JoJoAndSandraOverheard_Played') && !flags.GetBool('MS_JoJo2Triggered'))
		{
			foreach AllActors(class'Actor', A, 'SandraLeaves')
				A.Trigger(Self, Player);

			flags.SetBool('MS_JoJo2Triggered', True,, 5);
		}

		// trigger some stuff based on convo flags
		if (flags.GetBool('JoJoAndGilbertOverheard_Played') && !flags.GetBool('MS_JoJo3Triggered'))
		{
			foreach AllActors(class'Actor', A, 'JoJoAttacksGilbert')
				A.Trigger(Self, Player);

			flags.SetBool('MS_JoJo3Triggered', True,, 5);
		}
	}
	else if (localURL == "04_NYC_NSFHQ")
	{
		// rotate the dish when the computer sets the flag
		if (!flags.GetBool('MS_Dish1Rotated'))
		{
			if (flags.GetBool('Dish1InPosition'))
			{
				foreach AllActors(class'SatelliteDish', dish, 'Dish1')
					dish.DesiredRotation.Yaw = 49152;

				flags.SetBool('MS_Dish1Rotated', True,, 5);
			}
		}

		// rotate the dish when the computer sets the flag
		if (!flags.GetBool('MS_Dish2Rotated'))
		{
			if (flags.GetBool('Dish2InPosition'))
			{
				foreach AllActors(class'SatelliteDish', dish, 'Dish2')
					dish.DesiredRotation.Yaw = 0;

				flags.SetBool('MS_Dish2Rotated', True,, 5);
			}
		}

		// rotate the dish when the computer sets the flag
		if (!flags.GetBool('MS_Dish3Rotated'))
		{
			if (flags.GetBool('Dish3InPosition'))
			{
				foreach AllActors(class'SatelliteDish', dish, 'Dish3')
					dish.DesiredRotation.Yaw = 16384;

				flags.SetBool('MS_Dish3Rotated', True,, 5);
			}
		}

		// set a flag when all dishes are rotated
		if (!flags.GetBool('CanSendSignal'))
		{
			if (flags.GetBool('Dish1InPosition') &&
				flags.GetBool('Dish2InPosition') &&
				flags.GetBool('Dish3InPosition'))
				flags.SetBool('CanSendSignal', True,, 5);
		}

		// count non-living troops
		if (!flags.GetBool('MostWarehouseTroopsDead'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              If (P.IsA('UNATCOTroop'))
				   count++;

			// if two or less are still alive
			if (count <= 2)
				flags.SetBool('MostWarehouseTroopsDead', True);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
        local int i;
        local Pawn P;
        local bool bImportantWeapon;
        local ScriptedPawn sp;
        local inventory Inv;

        Clear();
                
        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        {
               sp = ScriptedPawn(P);
               if (sp != None)
               { 
                      if (sp.IsA('HumanMilitary') && !sp.IsA('PaulDenton') && !sp.IsA('AnnaNavarre') && !sp.IsA('GuntherHermann') && !sp.IsA('MJ12Sergeant'))
                      {
                           i = Rand(6);
                           for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                                   if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                          Inv.Destroy();
				
				if ( Level.Game.Difficulty == 3 )
					AddInventory(sp, WeaponClasses[i]);
				else
				{
					if ( FRand() < 0.33 )
					{
						if ( FRand() < 0.5 )
							AddInventory(sp, "DeusEx.WeaponSMG");
						else
							AddInventory(sp, "DeusEx.WeaponDXQuadShot");
					}
					else
                       				AddInventory(sp, WeaponClasses[i]);
				}
                      } 

                      else if (sp.IsA('PaulDenton'))
                      {
                           i = Rand(8);
                           for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                                   if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                            Inv.Destroy();
                           AddInventory(sp, "DeusEx.WeaponAssaultShotgun");
                           AddInventory(sp, WeaponClasses[i]);
                      } 

                      else if (sp.IsA('MJ12Sergeant'))
                      {
                           for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                                    if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                            Inv.Destroy();
                           AddInventory(sp, "DeusEx.WeaponPistol");
                      }                                 
           }
    }
}

function Surprise()
{
    local Pawn P;
    local ScriptedPawn sp;

   if (localURL == "04_NYC_NSFHQ")
   {             
            SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint7','UNATCO',0.0,'Standing',true,,"UNATCOCrimeSceneGuard",'UNATCOTroop');
            SpawnExtraEnemy(Class'UNATCOOfficer','HidePoint10','UNATCO',0.0,'Standing',true,,"UNATCOCrimeSceneGuard",'UNATCOTroop');
            SpawnExtraEnemy(Class'UNATCOOfficer','PathNode75','UNATCO',0.0,,true,,"UNATCOCrimeSceneGuard",'UNATCOTroop');
   } 

   else if (localURL == "04_NYC_UNDERGROUND")
   {             
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode20','mj12',-1.0,'Standing',,true);
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode18','mj12',-1.0,'Standing',,true); 
   } 

   else if (localURL == "04_NYC_BAR")
   {             
            SpawnExtraEnemy(Class'RiotCop','HidePoint1','Cop',0.0,'Standing',,,"RiotCop2");
            SpawnExtraEnemy(Class'RiotCop','HidePoint2','Cop',0.0,'Standing',,,"RiotCop2");
            SpawnExtraEnemy(Class'RiotCop','HidePoint4','Cop',0.0,'Standing',,,"RiotCop2"); 
   } 

   if (localURL == "04_NYC_STREET")
   {
            SpawnExtraEnemy(Class'UNATCOOfficer','PatrolPoint2','Metro',-1.0,'DefendPosition',,true);
            SpawnExtraEnemy(Class'UNATCOOfficer','PatrolPoint1','Metro',-1.0,'DefendPosition',,true);
   }  

   else if (localURL == "04_NYC_UNATCOHQ")  
   { 
              for ( P=Level.PawnList; P!=None; P=P.NextPawn )
              {
                   sp = ScriptedPawn(P);
                   if ((sp != None) && !sp.IsA('Terrorist'))
                   {
                        sp.SetAlliance('Player');
                        sp.ChangeAlly('Player', 1.0, true);
                   }
              } 
   }       
}  

function Clear()
{
      	local inventory Del;
      	local CrateBreakableMedCombat cont;
      
      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
             		if ( (cont != None) && (cont.contents != None) )
             		{
                   		cont.contents = InCrates[Rand(8)];
                   		cont.numThings = Rand(1) + 1;
             		}
      	} 

	ForEach AllActors(Class'Inventory', Del)
      	{
            		if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)))
            		{
                  		if ( Del.IsA('AmmoSabot') )
                      			Del.Destroy();
            		}
      	} 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponFlamethrower"
     WeaponClasses(1)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(2)="DeusEx.WeaponAssaultGun"
     WeaponClasses(3)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(4)="DeusEx.WeaponPistol"
     WeaponClasses(5)="DeusEx.WeaponHideAGun"
     InCrates(0)=Class'DeusEx.Ammo10mm'
     InCrates(1)=Class'DeusEx.Ammo762mm'
     InCrates(2)=Class'DeusEx.AmmoBattery'
     InCrates(3)=Class'DeusEx.AmmoShell'
     InCrates(4)=Class'DeusEx.AmmoDart'
     InCrates(5)=Class'DeusEx.AmmoDartFlare'
     InCrates(6)=Class'DeusEx.WeaponLAM'
     InCrates(7)=Class'DeusEx.WeaponGEPGun'
}
