//=============================================================================
// Mission05.
//=============================================================================
class Mission05 extends MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local PaulDentonCarcass carc;
	local PaulDenton Paul;
	local Terrorist T;
	local Inventory item, nextItem, Inv;
	local SpawnPoint SP;
	local AnnaNavarre Anna;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "05_NYC_UNATCOMJ12LAB")
	{
		// make sure this goal is completed
		Player.GoalCompleted('EscapeToBatteryPark');

		// delete Paul's carcass if he's still alive
		if (!flags.GetBool('PaulDenton_Dead'))
		{
			foreach AllActors(class'PaulDentonCarcass', carc)
				carc.Destroy();
		}

		// if the player has already talked to Paul, delete him
		if (flags.GetBool('M05PaulDentonDone') ||
			flags.GetBool('PlayerBailedOutWindow'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('PaulDenton'))
				PaulDenton(P).Destroy();
		}

		// if Miguel is not following the player, delete him
		if (flags.GetBool('MeetMiguel_Played') &&
			!flags.GetBool('MiguelFollowing'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.BindName == "Miguel"))
				P.Destroy();
		}

		// remove the player's inventory and put it in a room
		// also, heal the player up to 50% of his total health
		if (!flags.GetBool('MS_InventoryRemoved'))
		{
			Player.HealthHead = Max(50, Player.HealthHead);
			Player.HealthTorso =  Max(50, Player.HealthTorso);
			Player.HealthLegLeft =  Max(50, Player.HealthLegLeft);
			Player.HealthLegRight =  Max(50, Player.HealthLegRight);
			Player.HealthArmLeft =  Max(50, Player.HealthArmLeft);
			Player.HealthArmRight =  Max(50, Player.HealthArmRight);
			Player.GenerateTotalHealth();

			/*for( Inv=Player.Inventory; Inv!=None; Inv=Inv.Inventory )
			{
				if ( Inv.IsA('Binoculars') )
				{
					Player.DeleteInventory(Inv);
					Inv.Destroy();
				}
				else if ( !Inv.bDisplayableInv )
				{
					Player.DeleteInventory(Inv);
					foreach AllActors(class'SpawnPoint', SP, 'player_inv')
						Inv.DropFrom(SP.Location);
					log("Deleting "$Inv);
				}
			}*/

			if (Player.Inventory != None)
			{
				item      = Player.Inventory;
				nextItem  = None;
				foreach AllActors(class'SpawnPoint', SP, 'player_inv')
				{
					// Find the next item we can process.
					while((item != None) && (item.IsA('NanoKeyRing') || (!item.bDisplayableInv)))
						item = item.Inventory;

					if (item != None)
					{
						nextItem = item.Inventory;
						Player.DeleteInventory(item);
						if ( item.IsA('Binoculars') || item.IsA('HealthPickup') || item.IsA('MedKit') || item.IsA('BioelectricCell')
						|| item.IsA('FireExtinguisher') || item.IsA('Flare') )
							item.Destroy();
						else
							item.DropFrom(SP.Location);

						// restore any ammo amounts for a weapon to default
						/*if (item.IsA('Weapon') && (Weapon(item).AmmoType != None))
							Weapon(item).PickupAmmoCount = Weapon(item).Default.PickupAmmoCount;*/
					}
					
					if (nextItem == None)
						break;	
					else
						item = nextItem;
				}
			}
			
			flags.SetBool('MS_InventoryRemoved', True,, 6);
		}
	}
	else if (localURL == "05_NYC_UNATCOHQ")
	{
		// if Miguel is following the player, unhide him
		if (flags.GetBool('MiguelFollowing'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.BindName == "Miguel"))
				{
					Terrorist(P).EnterWorld();
                                        Terrorist(P).SetAlliance('Player');
                                        Terrorist(P).ChangeAlly('Player', 1.0, true);
                                }
		}

	}
	else if (localURL == "05_NYC_UNATCOISLAND")
	{
		// if Miguel is following the player, unhide him
		if (flags.GetBool('MiguelFollowing'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (P.IsA('Terrorist') && (P.BindName == "Miguel"))
				{
					Terrorist(P).EnterWorld();
                                        Terrorist(P).SetAlliance('Player');
                                        Terrorist(P).ChangeAlly('Player', 1.0, true);
                                }
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local AnnaNavarre Anna;
	local WaltonSimons Walton;
	local DeusExMover M;
        local Pawn P;

	Super.Timer();

	if (localURL == "05_NYC_UNATCOHQ")
	{
		// unlock a door
		if (flags.GetBool('CarterUnlock') &&
			!flags.GetBool('MS_DoorUnlocked'))
		{
			foreach AllActors(class'DeusExMover', M, 'supplydoor')
			{
				M.bLocked = False;
				M.lockStrength = 0.0;
			}

			flags.SetBool('MS_DoorUnlocked', True,, 6);
		}

		// kill Anna when a flag is set
		if (flags.GetBool('annadies') &&
			!flags.GetBool('MS_AnnaKilled'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
                             if (P.IsA('AnnaNavarre'))
                             {
				 P.HealthTorso = 0;
				 P.Health = 0;
				 P.TakeDamage(100, AnnaNavarre(P), AnnaNavarre(P).Location, vect(0,0,0), 'Shot');
                             }
			}

			flags.SetBool('MS_AnnaKilled', True,, 6);
		}

		// make Anna attack the player after a convo is played
		if (flags.GetBool('M05AnnaAtExit_Played') &&
			!flags.GetBool('MS_AnnaAttacking'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('AnnaNavarre'))
                            	AnnaNavarre(P).SetOrders('Attacking', '', True);

			flags.SetBool('MS_AnnaAttacking', True,, 6);
		}

		// unhide Walton Simons
		if (flags.GetBool('simonsappears') &&
			!flags.GetBool('MS_SimonsUnhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				WaltonSimons(P).EnterWorld();

			flags.SetBool('MS_SimonsUnhidden', True,, 6);
		}

		// hide Walton Simons
		if ((flags.GetBool('M05MeetManderley_Played') ||
			flags.GetBool('M05SimonsAlone_Played')) &&
			!flags.GetBool('MS_SimonsHidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				WaltonSimons(P).LeaveWorld();
				
			flags.SetBool('MS_SimonsHidden', True,, 6);
		}

		// mark a goal as completed
		if (flags.GetBool('KnowsAnnasKillphrase1') &&
			flags.GetBool('KnowsAnnasKillphrase2') &&
			!flags.GetBool('MS_KillphraseGoalCleared'))
		{
			Player.GoalCompleted('FindAnnasKillphrase');
			flags.SetBool('MS_KillphraseGoalCleared', True,, 6);
		}

		// clear a goal when anna is out of commision
		if (flags.GetBool('AnnaNavarre_Dead') &&
			!flags.GetBool('MS_EliminateAnna'))
		{
			Player.GoalCompleted('EliminateAnna');
			flags.SetBool('MS_EliminateAnna', True,, 6);
		}
	}
	else if (localURL == "05_NYC_UNATCOMJ12LAB")
	{
		// After the player talks to Paul, start a datalink
		if (!flags.GetBool('MS_DL_Played') &&
			flags.GetBool('PaulInMedLab_Played'))
		{
			Player.StartDataLinkTransmission("DL_Paul");
			flags.SetBool('MS_DL_Played', True,, 6);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;

    	Clear();
                            
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
              			if (sp.IsA('HumanMilitary') && !sp.IsA('AnnaNavarre') && !sp.IsA('SamCarter'))
              			{
                  			i = Rand(8);                      
                  			bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 
                   			if (!bImportantWeapon)
                   			{
                       				for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       				{
                           					if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               						Inv.Destroy();
                       				}
						if ( sp.IsA('Researcher') )
						{
							if ( FRand() < 0.2 )
								AddInventory(sp, "DeusEx.WeaponPistol");
							else if ( FRand() < 0.5 )
								AddInventory(sp, "DeusEx.WeaponAssaultGun");
							else if ( FRand() < 0.75 )
								AddInventory(sp, "DeusEx.WeaponAssaultShotgun");
							else 							
								AddInventory(sp, "DeusEx.WeaponSawedOffShotgun");
						}
						else
						{	
							if ( Level.Game.Difficulty == 3 )
								AddInventory(sp, WeaponClasses[i]);
							else
							{
								if ( FRand() < 0.25 )
								{
									if ( FRand() < 0.5 )
										AddInventory(sp, "DeusEx.WeaponSMG");
									else
										AddInventory(sp, "DeusEx.WeaponDXQuadShot");
								}
								else
                       							AddInventory(sp, WeaponClasses[i]);
							}
						}
					}
              			}              
          		}
    	}
}

function Surprise()
{
   	local Pawn P;

   	if (localURL == "05_NYC_UNATCOMJ12LAB")
   	{             
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode400','mj12',-1.0,,,true);
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode383','mj12',-1.0,,,true);
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode163','mj12',-1.0,,,true);
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode173','mj12',-1.0,,,true);
            		SpawnExtraEnemy(Class'Researcher','PathNode116','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode106','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode143','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode156','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode399','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode109','mj12',-1.0);
            		SpawnExtraEnemy(Class'Researcher','PathNode358','mj12',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Researcher','PathNode361','mj12',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'Researcher','PathNode431','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Mechanic2','PathNode439','Greasel',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','PathNode360','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','Hidepoint6','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','Hidepoint11','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','Hidepoint12','mj12',-1.0,'Standing');
            		SpawnExtraEnemy(Class'Researcher','Hidepoint13','mj12',-1.0,'Standing');

   	} 
   	else if (localURL == "05_NYC_UNATCOISLAND")
   	{             
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode151','UNATCO',-1.0,,,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode152','UNATCO',-1.0,,,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode153','UNATCO',-1.0,,,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode154','UNATCO',-1.0,,,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode155','UNATCO',-1.0,,,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode160','UNATCO',-1.0,'Standing',,true);
            		SpawnExtraEnemy(Class'UNATCOOfficer','PathNode107','UNATCO',-1.0,,,true);
   	} 
}  

function Clear()
{
	local Pawn P;
      	local Inventory Inv;
	local Binoculars Del;
	local ScriptedPawn sp;
      	local CrateBreakableMedCombat cont;
	local CrateBreakableMedGeneral cont2;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  		{
                       			if ( Inv.IsA('Binoculars') )
		           			Inv.Destroy();
                  		}
			// don't let them call for help in this mission
			sp.bCanCommunicate = False;
		}
	}

      	ForEach AllActors(Class'Binoculars', Del)
      	{
            		if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)) )
            		                    Del.Destroy();	
      	} 

      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
            		if ( (cont != None) && (cont.contents != None) )
            		{
                  		if ( (cont != None) && (cont.contents != None) )
            			{
                  			if ( cont.contents == Class'DeusEx.Binoculars' )
					cont.contents = Class'DeusEx.AmmoDart';
			}
            		}
      	}

	ForEach AllActors(Class'CrateBreakableMedGeneral', cont2)
      	{
            		if ( (cont2 != None) && (cont2.contents != None) )
            		{
                  		if ( cont2.contents == Class'DeusEx.Binoculars' )
				cont2.contents = Class'DeusEx.AmmoDartFlare';
		}
	}	 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponAssaultGun"
     WeaponClasses(2)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(3)="DeusEx.WeaponFlamethrower"
     WeaponClasses(4)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(5)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(6)="DeusEx.WeaponHideAGun"
     WeaponClasses(7)="DeusEx.WeaponPepperGun"
}
