//=============================================================================
// Mission06.
//=============================================================================
class Mission06 expands MissionScript;

var float fireTime;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local ScriptedPawn pawn;
	local BlackHelicopter chopper;
	local MJ12Commando commando;
	local DeusExCarcass carc;
	local DeusExDecoration deco;
	local HKMilitary mil;
	local SpiderBot bot;
	local BookOpen book;
	local float rnd;
	local Keypad3 pad;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "06_HONGKONG_VERSALIFE")
	{
		if (flags.GetBool('M07Briefing_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Commando'))
				MJ12Commando(P).EnterWorld();
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_CANAL")
	{
		if (!flags.GetBool('Supervisor01_Dead') &&
			flags.GetBool('HaveROM'))
		{
			foreach AllActors(class'DeusExCarcass', carc, 'John_Smith_Body')
				carc.bHidden = False;
		}
	}
	else if (localURL == "06_HONGKONG_MJ12LAB")
	{
		if (flags.GetBool('M07Briefing_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
			      if (P.IsA('MJ12Commando'))
				  MJ12Commando(P).EnterWorld();
                              else if (P.IsA('SpiderBot'))
			          SpiderBot(P).EnterWorld();
                        }
			foreach AllActors(class'Keypad3', pad)
			{
				if (pad.Tag == 'DummyKeypad_02')
					pad.Destroy();
				else if (pad.Tag == 'RealKeypad_02')
					pad.bHidden = False;
			}    
		}
	}
	else if (localURL == "06_HONGKONG_TONGBASE")
	{
		if (flags.GetBool('Versalife_Done'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
                             	if (p.IsA('PaulDenton'))
					PaulDenton(p).EnterWorld();
				else if (p.IsA('TriadRedArrow') && (p.Tag == 'TriadRedArrow'))
					TriadRedArrow(p).EnterWorld();
			}
		}

		if (flags.GetBool('JaimeRecruited') &&
			flags.GetBool('Versalife_Done'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		        	if (p.IsA('JaimeReyes'))
					JaimeReyes(p).EnterWorld();
		}

		if (flags.GetBool('JacobsonRecruited'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		        	if (p.IsA('AlexJacobson'))
					AlexJacobson(p).EnterWorld();
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_UNDERWORLD")
	{
		if (flags.GetBool('QuickLetPlayerIn'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Commando'))
				MJ12Commando(P).EnterWorld();
		}

		if (flags.GetBool('TriadCeremony_Played'))
		{
			flags.SetBool('DragonHeadsInLuckyMoney', True,, 8);

			foreach AllActors(class'DeusExCarcass', carc)
				carc.Destroy();
		}

		if (flags.GetBool('DragonHeadsInLuckyMoney') &&
			!flags.GetBool('MS_ChenTeleported'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if (p.IsA('GordonQuick'))
					GordonQuick(p).EnterWorld();
				else if (p.IsA('MaxChen'))
					TeleportPawn(MaxChen(p), 'ChenAtBar', 'Standing');
			}

			flags.SetBool('MS_ChenTeleported', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_GARAGE")
	{
		if (flags.GetBool('M07Briefing_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                              if (P.IsA('HKMilitary') && (P.Tag == 'RumbleCops'))
				    P.Destroy();

			foreach AllActors(class'DeusExCarcass', carc)
			{
				if (carc.IsA('HKMilitaryCarcass'))
					carc.Destroy();
				else if (carc.IsA('TriadLumPathCarcass'))
					carc.Destroy();
				else if (carc.IsA('TriadLumPath2Carcass'))
					carc.Destroy();
			}
			foreach AllActors(class'DeusExDecoration', deco)
			{
				if (deco.IsA('Van') && (deco.Tag == 'Van01'))
					deco.Destroy();
				else if (deco.IsA('CarWrecked'))
					deco.Destroy();
				else if (deco.IsA('RoadBlock'))
					deco.Destroy();
			}
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_MARKET")
	{
		// prepare for the ceremony
		if (flags.GetBool('Have_ROM') &&
			flags.GetBool('MeetTracerTong_Played') &&
			!flags.GetBool('TriadCeremony_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
                            if (P.IsA('ScriptedPawn'))
                            {
				if (p.IsA('GordonQuick'))
					TeleportPawn(GordonQuick(p), 'QuickInTemple', 'Standing');
				else if (p.IsA('MaxChen'))
					TeleportPawn(MaxChen(p), 'ChenInTemple', 'Standing');
				else if (p.Tag == 'MarketMonk01')
					ScriptedPawn(p).EnterWorld();
				else if (p.Tag == 'MarketKid')
					p.Destroy();
                            }
			}

			flags.SetBool('CeremonyReadyToBegin', True,, 8);
		}

		// remove the secretary
		if (flags.GetBool('MarketShopperOverheard_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (p.Tag == 'MarketShopperFlowers')
					p.Destroy();
		}

		// set up the catering situation
		if (flags.GetBool('CatererConvo_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'TeaHouseRedArrow'))
				    TeleportPawn(ScriptedPawn(p), 'TalkToCaterer', 'Wandering');
		}
		else if (flags.GetBool('TeaHouseDrama_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'TeaHouseRedArrow'))
				    TeleportPawn(ScriptedPawn(p), 'TalkToCaterer', 'Standing');

			flags.SetBool('ReadyForCaterer', True,, 8);
		}

		// remove some people after tea house drama has been played
		if (flags.GetBool('TeaHouseDrama_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if (p.Tag == 'TeaHouseCustomer')
					p.Destroy();
				else if (p.Tag == 'TeaHouseWoman')
					p.Destroy();
			}
		}

		// move the kid around to the correct spot
		if (flags.GetBool('KidGetsMoney_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketKid'))
				     TeleportPawn(ScriptedPawn(p), 'KidAtNewsStand', 'Wandering');
		}
		else if (flags.GetBool('KidSetsFire_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketKid'))
				     TeleportPawn(ScriptedPawn(p), 'KidAtNewsStand', 'Standing');

			flags.SetBool('MarketKidReadyForFifth', True,, 8);
		}
		else if (flags.GetBool('M06_Fire_Set'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketKid'))
				     TeleportPawn(ScriptedPawn(p), 'KidAtLumPath', 'Standing');

			flags.SetBool('MarketKidReadyForFourth', True,, 8);
		}
		else if (flags.GetBool('KidAsksForHelp_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketKid'))
				     TeleportPawn(ScriptedPawn(p), 'KidSettingFire', 'Standing');

			flags.SetBool('MarketKidReadyForThird', True,, 8);
		}
		else if (flags.GetBool('KidAsksForWork_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketKid'))
				     TeleportPawn(ScriptedPawn(p), 'KidAtLumPath', 'Standing');

			flags.SetBool('MarketKidReadyForSecond', True,, 8);
		}

		// unhide the helicopter if it's time
		if (flags.GetBool('M08Briefing_Played'))
		{
			foreach AllActors(class'BlackHelicopter', chopper)
				chopper.EnterWorld();
		}

		// unhide a book
		if (flags.GetBool('M07Briefing_Played'))
		{
			foreach AllActors(class'BookOpen', book, 'TempleBook')
				book.bHidden = False;
		}

		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if (P.IsA('ScriptedPawn') && (p.Tag == 'MarketGoth'))
		{
			rnd = FRand();

			if (rnd < 0.33)
			{
				TeleportPawn(ScriptedPawn(p), 'GothAtFlower', 'Standing');
				flags.SetBool('GothAtFlower', True,, 8);
				flags.SetBool('GothAtButcher', False,, 8);
				flags.SetBool('GothAtVase', False,, 8);
			}
			else if (rnd < 0.67)
			{
				TeleportPawn(ScriptedPawn(p), 'GothAtButcher', 'Standing');
				flags.SetBool('GothAtFlower', False,, 8);
				flags.SetBool('GothAtButcher', True,, 8);
				flags.SetBool('GothAtVase', False,, 8);
			}
			else
			{
				TeleportPawn(ScriptedPawn(p), 'GothAtVase', 'Standing');
				flags.SetBool('GothAtFlower', False,, 8);
				flags.SetBool('GothAtButcher', False,, 8);
				flags.SetBool('GothAtVase', True,, 8);
			}
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local DeusExMover M;
	local AlarmUnit unit;
	local Dispatcher disp;
	local MJ12Commando commando;
	local HKMilitary hkm;
	local TriadRedArrow triadred;
	local TriadLumPath triadlum;
	local WaltonSimons walton;
	local RatGenerator gen;
	local LowerClassFemale fem;
	local Actor A;
	local PatrolPoint PP;
	local Keypad1 pad;
        local Pawn P;

	Super.Timer();

	if (localURL == "06_HONGKONG_WANCHAI_STREET")
	{
		// unhide Walton Simons
		if (flags.GetBool('WaltonAppears') &&
			!flags.GetBool('MS_WaltonUnhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).EnterWorld();

			flags.SetBool('MS_WaltonUnhidden', True,, 8);
		}

		// hide Walton Simons
		if (flags.GetBool('M06WaltonHolo_Played') &&
			!flags.GetBool('MS_WaltonHidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).LeaveWorld();

			flags.SetBool('MS_WaltonHidden', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_UNDERWORLD")
	{
		if (flags.GetBool('MaxChenConvinced') &&
			!flags.GetBool('MS_CommandosUnhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Commando') && (P.Tag == 'RaidingCommando'))
				   MJ12Commando(P).EnterWorld();

			flags.SetBool('MS_CommandosUnhidden', True,, 8);
		}

		// set a flag to False when all the commandos are dead
		if (flags.GetBool('Raid_Underway'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Commando') && (P.Tag == 'RaidingCommando'))
				count++;

			if (count == 0)
			{
				flags.SetBool('Raid_Underway', False,, 8);
				flags.SetBool('M06AmbushDone', True,, 8);
			}
		}

		// set a home base
		if (flags.GetBool('ReadyForMercedes2') &&
			!flags.GetBool('MS_HomeBaseSet'))
		{
			PP = GetPatrolPoint('PartyGirlInClub02');
			if (PP != None)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('LowerClassFemale') && (P.Tag == 'ClubTessa'))
				LowerClassFemale(P).SetHomeBase(PP.Location, PP.Rotation);
			}
			flags.SetBool('MS_HomeBaseSet', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_GARAGE")
	{
		// count the number of military guys
		if (!flags.GetBool('RumbleCops_Lost'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('HKMilitary') && (P.Tag == 'RumbleCops'))
				    count++;

			if (count == 0)
				flags.SetBool('RumbleCops_Lost', True,, 8);
		}

		// count the number of triads
		if (!flags.GetBool('RumbleRedArrow_Lost'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('TriadRedArrow') && (P.Tag == 'RumbleRedArrow'))
				count++;

			if (count == 0)
				flags.SetBool('RumbleRedArrow_Lost', True,, 8);
		}

		// count the number of triads
		if (!flags.GetBool('RumbleLumPath_Lost'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('TriadLumPath') && (P.Tag == 'RumbleLumPath')) 
				count++;

			if (count == 0)
				flags.SetBool('RumbleLumPath_Lost', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_MARKET")
	{
		// release rats
		if (flags.GetBool('TeaHouseDrama_Played') &&
			!flags.GetBool('MS_RatsReleased'))
		{
			foreach AllActors(class'RatGenerator', gen)
				gen.Trigger(Self, Player);

			flags.SetBool('MS_RatsReleased', True,, 8);
		}

		// trigger something
		if (flags.GetBool('CatererConvo_Played') &&
			!flags.GetBool('MS_ConvoTrigger1'))
		{
			foreach AllActors(class'Actor', A, 'TeaHouseRedArrowWanders')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger1', True,, 8);
		}

		// trigger something
		if (flags.GetBool('TeaHouseDrama_Played') &&
			!flags.GetBool('MS_ConvoTrigger2'))
		{
			foreach AllActors(class'Actor', A, 'TeaHouseRedArrowPatrol')
				A.Trigger(Self, Player);

			foreach AllActors(class'Actor', A, 'MarketWaiterWanders')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger2', True,, 8);
		}

		// trigger something
		if (flags.GetBool('FlowerShopperOverheard_Played') &&
			!flags.GetBool('MS_ConvoTrigger3'))
		{
			foreach AllActors(class'Actor', A, 'MarketShopperFlowersWanders')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger3', True,, 8);
		}

		// move the kid around to the correct spot
		if (flags.GetBool('KidGetsMoney_Played') &&
			!flags.GetBool('MS_ConvoTrigger4'))
		{
			foreach AllActors(class'Actor', A, 'KidWanders')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger4', True,, 8);
		}
		else if (flags.GetBool('KidSetsFire_Played') &&
			!flags.GetBool('MS_ConvoTrigger5'))
		{
			foreach AllActors(class'Actor', A, 'KidGoesToNewsStand')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger5', True,, 8);
		}
		else if (flags.GetBool('KidStealsSomething_Played') &&
			!flags.GetBool('MS_ConvoTrigger6'))
		{
			foreach AllActors(class'Actor', A, 'KidGoesToLumPath')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger6', True,, 8);
		}
		else if (flags.GetBool('KidAsksForHelp_Played') &&
			!flags.GetBool('MS_ConvoTrigger7'))
		{
			foreach AllActors(class'Actor', A, 'KidGoesToNewsStand')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger7', True,, 8);
		}
		else if (flags.GetBool('KidAsksForWork_Played') &&
			!flags.GetBool('MS_ConvoTrigger8'))
		{
			foreach AllActors(class'Actor', A, 'KidGoesToLumPath')
				A.Trigger(Self, Player);

			flags.SetBool('MS_ConvoTrigger8', True,, 8);
		}

		// hide/unhide some keypads
		if (flags.GetBool('QuickLetPlayerIn') &&
			!flags.GetBool('MS_KeypadsMoved'))
		{
			foreach AllActors(class'Keypad1', pad)
			{
				if (pad.Tag == 'DummyKeypad01')
					pad.Destroy();
				else if (pad.Tag == 'GateKeypad')
					pad.bHidden = False;
				else if (pad.Tag == 'BasementKeypad')
					pad.bHidden = False;
			}

			flags.SetBool('MS_KeypadsMoved', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_HELIBASE")
	{
		// start an InfoLink when helicopter is armed
		if (flags.GetBool('helicopter_armed') &&
			!flags.GetBool('MS_JockInfoLink'))
		{
			Player.StartDataLinkTransmission("DL_Jock_02");
			flags.SetBool('MS_JockInfoLink', True,, 8);
		}

		// set the door rubble to be bBreakable
		if (flags.GetBool('MS_DoorsBlown') && !flags.GetBool('MS_RubbleBreakable'))
		{
			// make the rubble breakable
			foreach AllActors(class'DeusExMover', M, 'DoorWreckage')
				M.bBreakable = True;

			flags.SetBool('MS_RubbleBreakable', True,, 8);
		}

		// check to see if the doors are blown
		if (flags.GetBool('MS_HelicopterFired') &&
			!flags.GetBool('MS_DoorsBlown'))
		{
			fireTime += checkTime;
			count = 0;
			foreach AllActors(class'DeusExMover', M, 'Blast_doors')
				if (!M.bDestroyed)
					count++;

			if (count == 0)
			{
				// have Jock bark at the player
				Player.StartDataLinkTransmission("DL_Jock_03");

				// turn on the alarm
				foreach AllActors(class'AlarmUnit', unit, 'AlarmUnit')
					unit.Trigger(None, None);

				// trigger the dispatcher
				foreach AllActors(class'Dispatcher', disp, 'Go')
					disp.Trigger(None, None);

				flags.SetBool('MS_DoorsBlown', True,, 8);
			}
			else
			{
				// keep firing every 3 seconds until the doors are gone
				if (fireTime > 3)
				{
					FireMissilesAt('Blast_doors');
					fireTime = 0;
				}
			}
		}

		// start the helicopter firing sequence when triggered
		if (flags.GetBool('helicopter_fire') &&
			!flags.GetBool('MS_HelicopterFired'))
		{
			// have Jock bark at the player
			Player.StartDataLinkTransmission("DL_Jock_Fired");

			// set the blast doors to be breakable
			foreach AllActors(class'DeusExMover', M, 'Blast_doors')
				M.bBreakable = True;

			fireTime = 0;
			FireMissilesAt('Blast_doors');

			flags.SetBool('MS_HelicopterFired', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_STORAGE")
	{
		// make the AUC destroyable
		if (flags.GetBool('ReadyToDestroyAUC') &&
			!flags.GetBool('MS_ReadyAUC'))
		{
			foreach AllActors(class'DeusExMover', M)
				if ((M.Tag == 'Pod01') || (M.Tag == 'Pod02') ||
					(M.Tag == 'Pod03') || (M.Tag == 'Pod04') ||
					(M.Tag == 'AUC'))
					M.bBreakable = True;

			flags.SetBool('MS_ReadyAUC', True,, 8);
		}
	}
	else if (localURL == "06_HONGKONG_WANCHAI_CANAL")
	{
		if (flags.GetBool('Overhear_Canal_Thug1_Played') &&
			!flags.GetBool('MS_DrugDealersAttacking'))
		{
			foreach AllActors(class'Actor', A, 'CanalDrugDealersAttack')
				A.Trigger(Self, Player);

			flags.SetBool('MS_DrugDealersAttacking', True,, 8);
		}
	}
}

function FireMissilesAt(name targetTag)
{
	local int i;
	local Vector loc;
	local BlackHelicopter chopper;
	local RocketLAW rocket;
	local Actor A, Target;

	foreach AllActors(class'Actor', A, targetTag)
		Target = A;

	// fire missiles from the helicopter
	foreach AllActors(class'BlackHelicopter', chopper, 'chopper')
	{
		for (i=-1; i<=1; i+=2)
		{
			loc = (i*chopper.CollisionRadius * vect(0,0.15,0)) >> chopper.Rotation;
			loc += chopper.Location;
			rocket = Spawn(class'RocketLAW', chopper,, loc, chopper.Rotation);
			if (rocket != None)
			{
				rocket.bTracking = True;
				rocket.Target = Target;
				rocket.PlaySound(sound'RocketIgnite', SLOT_None, 2.0,, 2048);
			}
		}
	}
}

function TeleportPawn(ScriptedPawn pawn, name patrolTag, name orders, optional bool bRandom)
{
	local PatrolPoint point;

	if (pawn != None)
	{
		point = GetPatrolPoint(patrolTag, bRandom);
		if (point != None)
		{
			pawn.SetLocation(point.Location);
			pawn.SetRotation(point.Rotation);
			pawn.SetOrders(orders,, True);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;

	Clear();
                
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
              			if (sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando') && !sp.IsA('DarkMaiden') 
                 			&& !sp.IsA('Cop') && !sp.IsA('SecurityForce'))
              			{
                     			i = Rand(12);                      
                     			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                     			{
                                				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                        			Inv.Destroy();
                     			}
					if ( sp.IsA('Researcher') )
					{
						if ( FRand() < 0.25 )
							AddInventory(sp, "DeusEx.WeaponAssaultGun");
						else if ( FRand() < 0.5 )
							AddInventory(sp, "DeusEx.WeaponPlasmaRifle");
						else if ( FRand() < 0.75 )
							AddInventory(sp, "DeusEx.WeaponFlamethrower");
						else
							AddInventory(sp, "DeusEx.WeaponAssaultShotgun");			
					}
					else
					{
                     				if ( Level.Game.Difficulty == 3 )
							AddInventory(sp, WeaponClasses[i]);
						else
						{
							if ( FRand() < 0.33 )
							{
								if ( FRand() < 0.5 )
									AddInventory(sp, "DeusEx.WeaponSMG");
								else
									AddInventory(sp, "DeusEx.WeaponDXQuadShot");
							}
							else
                       						AddInventory(sp, WeaponClasses[i]);
						}
					}
              			}  
              			else if (sp.IsA('Cop') || sp.IsA('SecurityForce'))  
              			{
                     			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                     			{
                                		if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		                        		Inv.Destroy();
                     			}
                     			if ( FRand() < 0.33 )
                                		AddInventory(sp, "DeusEx.WeaponPistol"); 
					else if ( FRand() < 0.67 )
						AddInventory(sp, "DeusEx.WeaponHideAGun");
                     			else
						AddInventory(sp, "DeusEx.WeaponSawedOffShotgun"); 
              			}
          		}
    	}
}

function Surprise()
{
   local Pawn P;

   if (localURL == "06_HONGKONG_HELIBASE")
   {             
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode17','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint3','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint6','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode93','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode3','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode2','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode51','mj12',-1.0);
   } 

   else if (localURL == "06_HONGKONG_WANCHAI_STREET")
   {
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode93','mj12',-1.0,'DefendPosition');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode94','mj12',-1.0,'DefendPosition');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode51','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode170','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode50','mj12',-1.0);
   }
   
   else if (localURL == "06_HONGKONG_WANCHAI_CANAL")
   {
            SpawnExtraEnemy(Class'ScubaDiver','PathNode150','Karkian',-1.0);
            SpawnExtraEnemy(Class'ScubaDiver','PathNode148','Karkian',-1.0);
            SpawnExtraEnemy(Class'ScubaDiver','PathNode149','Karkian',-1.0);
   }

   else if (localURL == "06_HONGKONG_MJ12LAB")
   {
            SpawnExtraEnemy(Class'Researcher','PathNode29','Security',0.0,'Shadowing',true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode60','Security',0.0,'Shadowing',true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','HidePoint8','Security',0.0,'Standing',true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode33','Security',0.0,'Sitting',true,,"MJ12Lab_Physics",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode30','Security',0.0,'Sitting',true,,"MJ12Lab_BioTech",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode128','Security',0.0,,true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','HidePoint1','Security',0.0,'Standing',true,,"MJ12Lab_NanoTech",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode84','Security',0.0,'Standing',true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','HidePoint3','Security',0.0,'Standing',true,,"MJ12Lab_Doctor",'ScientistMale');
            SpawnExtraEnemy(Class'Researcher','PathNode104','Security',0.0,'Standing',true,,"MJ12Lab_NanoTech",'ScientistMale');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode20','Security',0.0,,true,,"MJ12Lab_Troop",'MJ12Commando');
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode92','Security',0.0,,true,,"MJ12Lab_Troop",'MJ12Commando');
            for ( P=Level.PawnList; P!=None; P=P.NextPawn )
            {
                 /*if ( P.IsA('HumanMilitary') )
                        HumanMilitary(P).bHateWeapon = True;
                 else */if (P.IsA('ScientistMale') || P.IsA('Doctor'))
                        P.Destroy();
            }
   }

   else if (localURL == "06_HONGKONG_VERSALIFE")
   {
            SpawnExtraEnemy(Class'SecurityForce','PathNode73','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','PathNode50','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'SecurityForce','PathNode82','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','PathNode184','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'SecurityForce','PathNode212','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','PathNode224','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'SecurityForce','PathNode182','mj12',0.0,,true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','PathNode44','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'SecurityForce','HidePoint9','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','HidePoint2','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'SecurityForce','HidePoint8','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
            SpawnExtraEnemy(Class'Cop','HidePoint0','mj12',0.0,'Standing',true,,"VL_Cop",'MJ12Troop');
                        
            for ( P=Level.PawnList; P!=None; P=P.NextPawn )
            {
                  if ( (P.UnfamiliarName != "") && ((P.UnfamiliarName == "Cop") || (P.UnfamiliarName == "Security Agent")) )
                  {
                        P.UnfamiliarName = "VersaLife Security Guard";
                        P.FamiliarName = "VersaLife Security Guard";
                        /*if ( P.IsA('HumanMilitary') )
                                 HumanMilitary(P).bHateWeapon = True;*/
                  }
            }
   }

   else if (localURL == "06_HONGKONG_STORAGE")
   {
            SpawnExtraEnemy(Class'Researcher','HidePoint0','mj12',-1.0,'DefendPosition');
            SpawnExtraEnemy(Class'Researcher','HidePoint12','mj12',-1.0,,,true);
            SpawnExtraEnemy(Class'Researcher','PathNode89','mj12',-1.0,,,true);
            SpawnExtraEnemy(Class'Researcher','PathNode83','mj12',-1.0,,,true);
            SpawnExtraEnemy(Class'Researcher','PathNode40','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'Researcher','PathNode30','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'Researcher','PathNode81','mj12',-1.0,'Standing');
            SpawnExtraEnemy(Class'Researcher','PathNode36','mj12',-1.0,'DefendPosition',,true);
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode10','mj12',-1.0,,,true);
            SpawnExtraEnemy(Class'MJ12Sergeant','PathNode16','mj12',-1.0,,,true);
   } 

   else if (localURL == "06_HONGKONG_WANCHAI_UNDERWORLD")
   {
            for ( P=Level.PawnList; P!=None; P=P.NextPawn )
            {
                  if ( P.IsA('HKMilitary') )
                  {
                       P.Tag = 'NoAttack';
                       HKMilitary(P).ChangeAlly('Player', 0.0, true);               
                  }
            }
   }

   else if (localURL == "06_HONGKONG_WANCHAI_GARAGE")
   {
            SpawnExtraEnemy(Class'BadDenton','PathNode39','Bad',-1.0,,,true);
   }
}

function Clear()
{
	local Pawn P;
      	local Inventory Inv;
	local Binoculars Del;
	local ScriptedPawn sp;
      	local CrateBreakableMedCombat cont;
	local CrateBreakableMedGeneral cont2;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  		{
                       			if ( Inv.IsA('Binoculars') )
		           			Inv.Destroy();
                  		}
		}
	}

      	ForEach AllActors(Class'Binoculars', Del)
      	{
            		if ( (Del != None) && (Del.IsInState('Pickup') || (Del.Owner == None)) )
            		                    Del.Destroy();	
      	} 

      	ForEach AllActors(Class'CrateBreakableMedCombat', cont)
      	{
            		if ( (cont != None) && (cont.contents != None) )
            		{
                  		if ( (cont != None) && (cont.contents != None) )
            			{
                  			if ( cont.contents == Class'DeusEx.Binoculars' )
					cont.contents = Class'DeusEx.AmmoDart';
			}
            		}
      	}

	ForEach AllActors(Class'CrateBreakableMedGeneral', cont2)
      	{
            		if ( (cont2 != None) && (cont2.contents != None) )
            		{
                  		if ( cont2.contents == Class'DeusEx.Binoculars' )
				cont2.contents = Class'DeusEx.AmmoDartFlare';
		}
	}	 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(2)="DeusEx.WeaponLAW"
     WeaponClasses(3)="DeusEx.WeaponAssaultGun"
     WeaponClasses(4)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(5)="DeusEx.WeaponRifle"
     WeaponClasses(6)="DeusEx.WeaponPlasmaRifle"
     WeaponClasses(7)="DeusEx.WeaponGEPGun"
     WeaponClasses(8)="DeusEx.WeaponPepperGun"
     WeaponClasses(9)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(10)="DeusEx.WeaponFlamethrower"
     WeaponClasses(11)="DeusEx.WeaponHideAGun"
}
