//=============================================================================
// Mission08.
//=============================================================================
class Mission08 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local SandraRenton Sandra;
	local FordSchick Ford;
        local Pawn P;

	Super.FirstFrame();

	if (flags.GetBool('SandraWentToCalifornia'))
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if (P.IsA('SandraRenton'))
			P.Destroy();
	}

	if (localURL == "08_NYC_SMUG")
	{
		// unhide Ford if you've rescued him
		if (flags.GetBool('FordSchickRescued'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if (P.IsA('FordSchick'))
				FordSchick(P).EnterWorld();
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	local BlackHelicopter chopper;

	Super.PreTravel();

	if (localURL == "08_NYC_STREET")
	{
		// make sure that damn helicopter is gone
		foreach AllActors(class'BlackHelicopter', chopper, 'EntranceCopter')
			chopper.Destroy();
	}
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local ScriptedPawn pawn;
	local RiotCop cop;
	local UNATCOTroop troop;
	local MJ12Troop mj12;
	local StantonDowd Stanton;
	local ThugMale Thug;
	local BlackHelicopter chopper;
	local int count;
        local Pawn P;

	Super.Timer();

	if (localURL == "08_NYC_FREECLINIC")
	{
		if (flags.GetBool('JoeGreene_Dead') &&
			!flags.GetBool('MS_GreeneGoalSet'))
		{
			Player.GoalCompleted('KillGreene');
			flags.SetBool('MS_GreeneGoalSet', True,, 9);
		}
	}
	else if (localURL == "08_NYC_STREET")
	{
		// spawn reinforcements as cops are killed
		if (!flags.GetBool('MS_UnhideTroop1'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop1'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('UNATCOTroop') && (p.Tag == 'troop1'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop1', True,, 9);
			}
		}
		if (!flags.GetBool('MS_UnhideTroop2'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop2'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('UNATCOTroop') && (p.Tag == 'troop2'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop2', True,, 9);
			}
		}
		if (!flags.GetBool('MS_UnhideTroop3'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop3'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('UNATCOTroop') && (p.Tag == 'troop3'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop3', True,, 9);
			}
		}
		if (!flags.GetBool('MS_UnhideTroop4'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop4'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('UNATCOTroop') && (p.Tag == 'troop4'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop4', True,, 9);
			}
		}
		if (!flags.GetBool('MS_UnhideTroop5'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop5'))
				count++;

			if (count == 0)
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('UNATCOTroop') && (p.Tag == 'troop5'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop5', True,, 9);
			}
		}
		if (!flags.GetBool('MS_UnhideTroop6'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('RiotCop') && (p.Tag == 'Cop6'))
				count++;

			if (count == 0)
			{
                                for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if (p.IsA('UNATCOTroop') && (p.Tag == 'troop6'))
					UNATCOTroop(P).EnterWorld();

				flags.SetBool('MS_UnhideTroop6', True,, 9);
			}
		}

		// unhide Thomas Dieter
		if (!flags.GetBool('MS_ThomasUnhidden'))
		{
			if (flags.GetBool('HarleyFilben_Dead'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('Janitor') && (p.Tag == 'ThomasDieter'))
					Janitor(P).EnterWorld();

				flags.SetBool('MS_ThomasUnhidden', True,, 9);
			}
		}

		// unhide Stanton Dowd
		if (!flags.GetBool('MS_StantonUnhidden'))
		{
			if (flags.GetBool('M08MeetHarleyFilben_Played') ||
				flags.GetBool('MeetThomasDieter_Played'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('StantonDowd') && (p.Tag == 'StantonDowd'))
					StantonDowd(P).EnterWorld();

				flags.SetBool('MS_StantonUnhidden', True,, 9);
			}
		}

		// unhide shady guy
		if (!flags.GetBool('MS_ShadyGuyUnhidden'))
		{
			if (flags.GetBool('MS_StantonUnhidden'))
			{
				if ((flags.GetBool('GreenKnowsAboutDowd') &&
					!flags.GetBool('JoeGreen_Dead')) ||
					flags.GetBool('SheaKnowsAboutDowd'))
				{
					 for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                         if (p.IsA('ThugMale') && (p.Tag == 'ShadyGuy'))
					 ThugMale(P).EnterWorld();

					flags.SetBool('MS_ShadyGuyUnhidden', True,, 9);
				}
			}
		}

		// spawn MJ12 attack force when Shady Guy gets close (8 feet) to Dowd
		if (!flags.GetBool('StantonAmbush'))
		{
			Stanton = None;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('StantonDowd') && (p.Tag == 'StantonDowd'))
					Stanton = StantonDowd(p);

			if (Stanton != None)
			{
				Thug = None;
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                         if (p.IsA('ThugMale') && (p.Tag == 'ShadyGuy'))
					       Thug = ThugMale(p);

				if (Thug != None)
				{
					if (VSize(Thug.Location - Stanton.Location) <= 128)
					{
						for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                                if (p.IsA('MJ12Troop') && (p.Tag == 'MJ12AttackForce'))
					        MJ12Troop(P).EnterWorld(); 

						flags.SetBool('StantonAmbush', True,, 9);
					}
				}
			}
		}

		// spawn MJ12 attack force when a flag is set
		if (!flags.GetBool('StantonAmbush') &&
			flags.GetBool('MJ12Converging'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('MJ12Troop') && (p.Tag == 'MJ12AttackForce'))
			MJ12Troop(P).EnterWorld(); 

			flags.SetBool('StantonAmbush', True,, 9);
		}

		// if the MJ12 attack force is killed, set a flag
		if (flags.GetBool('StantonAmbush') &&
			!flags.GetBool('StantonAmbushDefeated'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('MJ12Troop') && (p.Tag == 'MJ12AttackForce'))
				count++;

			if (count == 0)
				flags.SetBool('StantonAmbushDefeated', True,, 9);
		}

                if (flags.GetBool('StantonAmbushDefeated') && 
                         !flags.GetBool('MS_BadDentonsSpawned'))
                {
                         SuperSurprise();
                         flags.SetBool('MS_BadDentonsSpawned', True,, 9);
                } 

		// unhide the helicopter when its time
		if (flags.GetBool('StantonDowd_Played') &&
			flags.GetBool('DL_Exit_Played') &&
			!flags.GetBool('MS_Helicopter_Unhidden'))
		{
			foreach AllActors(class'BlackHelicopter', chopper, 'CopterExit')
				chopper.EnterWorld();

			flags.SetBool('MS_Helicopter_Unhidden', True,, 9);
		}       
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;

	Clear();
                
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
              			if (sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando') && !sp.IsA('DarkMaiden'))
              			{
                  			i = Rand(5);                      
                  			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  			{
                       				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		           				Inv.Destroy();
                  			}
                  			if ( Level.Game.Difficulty == 3 )
						AddInventory(sp, WeaponClasses[i]);
					else
					{
						if ( FRand() < 0.25 )
						{
							if ( FRand() < 0.33 )
								AddInventory(sp, "DeusEx.WeaponSMG");
							else if ( FRand() < 0.67 )
								AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
							else
								AddInventory(sp, "DeusEx.WeaponDXQuadShot");
						}
						else
                       					AddInventory(sp, WeaponClasses[i]);
					}
              			} 
                          
          		}
    	}
}

function Surprise()
{
	local Pawn P;

   	if (localURL == "08_NYC_HOTEL")
   	{             
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		{
			if ( P.IsA('RiotCop') || P.IsA('BumFemale') )
				P.TakeDamage(500, P, P.Location, vect(0,0,0), 'KnockedOut');
		}
            		
            		SpawnExtraEnemy(Class'DarkMaiden','PathNode82','Dark',-1.0,'DefendPosition',,true);
		SpawnExtraEnemy(Class'DarkMaiden','HidePoint14','Dark',-1.0,'Standing',,true);
		SpawnExtraEnemy(Class'DarkMaiden','HidePoint15','Dark',-1.0,'Standing',,true);
		SpawnExtraEnemy(Class'DarkMaiden','PathNode83','Dark',-1.0,'DefendPosition',,true);
		SpawnExtraEnemy(Class'DarkMaiden','PathNode25','Dark',-1.0,'Standing',,true);
		SpawnExtraEnemy(Class'DarkMaiden','PathNode61','Dark',-1.0,'WaitingFor',,true);
		SpawnExtraEnemy(Class'DarkMaiden','PathNode50','Dark',-1.0,'WaitingFor',,true);
   	} 

   	else if (localURL == "08_NYC_FREECLINIC")
   	{
            		SpawnExtraEnemy(Class'TerroristA','HidePoint3','Player',1.0,'Standing',,,"AlleyBum1");
            		SpawnExtraEnemy(Class'TerroristC','PathNode197','Player',1.0,,,,"AlleyBum2");
            		SpawnExtraEnemy(Class'Terrorist','PathNode352','Player',1.0,,,,"AlleyBum2");
            		SpawnExtraEnemy(Class'TerroristB','PathNode1','Player',1.0,'Standing',,,"AlleyBum1");
   	}

   	else if (localURL == "08_NYC_UNDERGROUND")
   	{
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode18','mj12',-1.0,'DefendPosition');
            		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode20','mj12',-1.0,'Standing');
   	}

   	else if (localURL == "08_NYC_STREET")
   	{
            		SpawnExtraEnemy(Class'Terrorist','PathNode34','Player',1.0,,,true,"AlleyBum1"); 
            		SpawnExtraEnemy(Class'TerroristC','PathNode35','Player',1.0,,,true,"AlleyBum2"); 
            		SpawnExtraEnemy(Class'Terrorist','PathNode36','Player',1.0,,,true,"AlleyBum1");
            		SpawnExtraEnemy(Class'Terrorist','PathNode37','Player',1.0,,,true,"AlleyBum2");
            		SpawnExtraEnemy(Class'Terrorist','PathNode197','Player',1.0,'Standing',,true,"AlleyBum1");
            		SpawnExtraEnemy(Class'Terrorist','PathNode198','Player',1.0,'Standing',,true,"AlleyBum1");
            		SpawnExtraEnemy(Class'Terrorist','PathNode201','Player',1.0,'Standing',,true,"AlleyBum2");
            		SpawnExtraEnemy(Class'Terrorist','PathNode202','Player',1.0,'Standing',,true,"AlleyBum1"); 
            		SpawnExtraEnemy(Class'TerroristA','PathNode206','Player',1.0,'Standing',,true,"AlleyBum2"); 
            		SpawnExtraEnemy(Class'TerroristB','PathNode207','Player',1.0,'Standing',,true,"AlleyBum1");
   	}

   	else if (localURL == "08_NYC_BAR")
   	{
            		SpawnExtraEnemy(Class'TerroristC','PathNode71','Player',1.0,,,,"AlleyBum2"); 
            		SpawnExtraEnemy(Class'TerroristB','PathNode72','Player',1.0,,,,"AlleyBum1"); 
   	}
}

function SuperSurprise()
{
   	local Pawn P;

   	if (localURL == "08_NYC_STREET")
   	{
            		SpawnExtraEnemy(Class'BadDenton','PathNode77','mj12',-1.0,'Attacking'); 
            		SpawnExtraEnemy(Class'BadDenton','PathNode137','mj12',-1.0,'Attacking');   
            		SpawnExtraEnemy(Class'BadDenton','PathNode65','mj12',-1.0,'Attacking');
            		SpawnExtraEnemy(Class'BadDenton','PathNode50','mj12',-1.0,'Attacking');
            		SpawnExtraEnemy(Class'BadDenton','PathNode3','mj12',-1.0,'Attacking');
            		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
            			if (P.IsA('BadDenton'))
            				AddInventory(BadDenton(P), "DeusEx.WeaponAssaultGun");                        
   	}
}

function Clear()
{
      	local CrateBreakableMedGeneral cont2;

	if ( localURL == "08_NYC_SMUG" )
      	{
		ForEach AllActors(Class'CrateBreakableMedGeneral', cont2)
      		{
            			if ( cont2 != None )
            				cont2.contents = Class'DeusEx.Binoculars';	
		}
		SpawnExtraActor(Class'Binoculars', 'PathNode72');
	}	 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(2)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(3)="DeusEx.WeaponAssaultGun"
     WeaponClasses(4)="DeusEx.WeaponRifle"
}
