//=============================================================================
// Mission09.
//=============================================================================
class Mission09 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local DeusExMover M;
	local BlackHelicopter chopper;

	Super.FirstFrame();

	if (localURL == "09_NYC_SHIP")
	{
		if (flags.GetBool('ShipBreech'))
		{
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'SewerGrate') || (M.Tag == 'FrontDoor'))
				{
					// close and lock the door
					if (M.KeyNum != 0)
						M.Trigger(None, None);
					M.bBreakable = False;
					M.bPickable = False;
					M.bFrobbable = False;
					M.bLocked = True;
				}
			}
		}
	}
	else if (localURL == "09_NYC_DOCKYARD")
	{
		if (flags.GetBool('MS_ShipBreeched'))
		{
			foreach AllActors(class'BlackHelicopter', chopper, 'BlackHelicopter')
				chopper.EnterWorld();
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local DeusExMover M;
	local BlackHelicopter chopper;
	local MJ12Troop troop;
	local Trigger trig;
	local MJ12Commando commando;
	local WaltonSimons Walton;
        local Pawn P;

	Super.Timer();

	if (localURL == "09_NYC_SHIP")
	{
		// unhide Walton Simons
		if (!flags.GetBool('MS_SimonsAppeared') &&
			flags.GetBool('SummonSimons'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).EnterWorld();

			flags.SetBool('MS_SimonsAppeared', True,, 10);
		}

		// hide Walton Simons, and make this convo retriggerable
		if (flags.GetBool('MS_SimonsAppeared') &&
			flags.GetBool('M09SimonsDisappears'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).LeaveWorld();
				
			flags.SetBool('M09SimonsDisappears', False,, 10);
			flags.SetBool('MS_SimonsAppeared', False,, 10);
			flags.SetBool('SummonSimons', False,, 10);
		}

		// randomly play explosions and shake the view
		// if the ship has been breeched
		if (flags.GetBool('MS_ShipBreeched'))
			ShipExplosionEffects(False);
	}
	else if (localURL == "09_NYC_SHIPBELOW")
	{
		// check for blown up ship
		if (!flags.GetBool('MS_ShipBreeched'))
		{
			count = 0;
			foreach AllActors(class'DeusExMover', M, 'ShipBreech')
				if (!M.bDestroyed)
					count++;

			if (count == 0)
			{
				if (flags.GetBool('Bilge'))
				{
					Player.StartDataLinkTransmission("DL_AllDone");
					flags.SetBool('MS_ShipBreeched', True,, 10);
				}
				else if (!flags.GetBool('DL_AllPlaced_Played'))
				{
					Player.StartDataLinkTransmission("DL_AllPlaced");
				}
			}
		}

		// randomly play explosions and shake the view
		// if the ship has been breeched
		if (flags.GetBool('MS_ShipBreeched'))
			ShipExplosionEffects(True);
	}
	else if (localURL == "09_NYC_GRAVEYARD")
	{
		// unhide the helicopter when the "little device" is destroyed
		if (!flags.GetBool('MS_UnhideHelicopter'))
		{
			if (flags.GetBool('deviceDestroyed') &&
				flags.GetBool('M09MeetStantonDowd_Played'))
			{
				foreach AllActors(class'BlackHelicopter', chopper, 'BlackHelicopter')
					chopper.EnterWorld();

				Player.StartDataLinkTransmission("DL_ComingIn");

                                for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('MJ12Troop') && (p.Tag == 'TroopSupport'))
			        MJ12Troop(P).EnterWorld(); 

				flags.SetBool('MS_UnhideHelicopter', True,, 10);
			}
		}

		// activate a trigger and unhide some troops
		// once Stanton Dowd has been talked to
		if (!flags.GetBool('MS_TriggerOn') &&
			flags.GetBool('M09MeetStantonDowd_Played'))
		{
			foreach AllActors(class'Trigger', trig, 'TunnelTrigger')
				trig.SetCollision(True);
			
                        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('MJ12Troop') && (p.Tag == 'TroopInsertion'))
			        MJ12Troop(P).EnterWorld(); 

			flags.SetBool('MS_TriggerOn', True,, 10);
		}

		// spawn some commandos
		if (flags.GetBool('GreenKnowsAboutDowd') &&
			flags.GetBool('suprisePoint') &&
			!flags.GetBool('MS_UnhideCommandos'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                                if (p.IsA('MJ12Commando') && (p.Tag == 'paratroop'))
			        MJ12Commando(P).EnterWorld();

			flags.SetBool('MS_UnhideCommandos', True,, 10);
		}
	}
}

function ShipExplosionEffects(bool bFragments)
{
	local float shakeTime, shakeRoll, shakeVert;
	local float size, explosionFreq;
	local int i;
	local Vector bobble, loc, endloc, HitLocation, HitNormal;
	local Actor HitActor;
	local HangingDecoration deco;
	local Cart cart;
	local MetalFragment frag;

	if (bFragments)
		explosionFreq = 0.33;
	else
		explosionFreq = 0.1;

	if (FRand() < explosionFreq)
	{
		// pick a random explosion size and modify everything accordingly
		size = FRand();
		shakeTime = 0.5 + size;
		shakeRoll = 512.0 + 1024.0 * size;
		shakeVert = 8.0 + 16.0 * size;

		// play a sound
		if (size < 0.2)
			Player.PlaySound(Sound'SmallExplosion1', SLOT_None, 2.0,, 16384);
		else if (size < 0.4)
			Player.PlaySound(Sound'MediumExplosion1', SLOT_None, 2.0,, 16384);
		else if (size < 0.6)
			Player.PlaySound(Sound'MediumExplosion2', SLOT_None, 2.0,, 16384);
		else if (size < 0.8)
			Player.PlaySound(Sound'LargeExplosion1', SLOT_None, 2.0,, 16384);
		else
			Player.PlaySound(Sound'LargeExplosion2', SLOT_None, 2.0,, 16384);

		// shake the view
		Player.ShakeView(shakeTime, shakeRoll, shakeVert);

		// bobble the player around
		bobble = vect(300.0,300.0,200.0) + 500.0 * size * VRand();
		Player.Velocity += bobble;

		// make all the hanging decorations sway randomly
		foreach AllActors(class'HangingDecoration', deco)
		{
			deco.CalculateHit(deco.Location + 10.0 * FRand() * VRand(), 0.5 * bobble);
			deco.bSwaying = True;
		}

		// make all the carts move randomly
		foreach AllActors(class'Cart', cart)
			cart.StartRolling(vect(100.0,100.0,0.0) + 200.0 * size * VRand());

		// have random metal fragments fall from the ceiling
		if (bFragments)
		{
			for (i=0; i<Int(size*20.0); i++)
			{
				loc = Player.Location + 256.0 * VRand();
				loc.Z = Player.Location.Z;
				endloc = loc;
				endloc.Z += 1024.0;
				HitActor = Trace(HitLocation, HitNormal, endloc, loc, False);
				if (HitActor == None)
					HitLocation = endloc;
				frag = Spawn(class'MetalFragment',,, HitLocation);
				if (frag != None)
				{
					frag.CalcVelocity(vect(20000,0,0),256);
					frag.DrawScale = 0.5 + 2.0 * FRand();
					if (FRand() < 0.25)
						frag.bSmoking = True;
				}
			}
		}
	}

	// make sure the player's zone has an alarm ambient sound
	if (Player.HeadRegion.Zone != None)
	{
		Player.HeadRegion.Zone.AmbientSound = sound'Klaxon';
		Player.HeadRegion.Zone.SoundRadius = 255;
		Player.HeadRegion.Zone.SoundVolume = 255;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;
                
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{ 
              			if (sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando'))
              			{
                  			i = Rand(9);                      
                  			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  			{
                       				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		           				Inv.Destroy();
                  			}
                 			if ( Level.Game.Difficulty == 3 )
						AddInventory(sp, WeaponClasses[i]);
					else
					{
						if ( FRand() < 0.25 )
						{
							if ( FRand() < 0.33 )
								AddInventory(sp, "DeusEx.WeaponSMG");
							else if ( FRand() < 0.67 )
								AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
							else
								AddInventory(sp, "DeusEx.WeaponDXQuadShot");
						}
						else
                       					AddInventory(sp, WeaponClasses[i]);
					}
              			} 

              			else if (sp.IsA('Sailor'))
              			{                  
                  			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                  			{
                      				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
		           				Inv.Destroy();
                  			}
                  			if (FRand() < 0.5)
                       				AddInventory(sp, "DeusEx.WeaponHideAGun");
                  			else
                       				AddInventory(sp, "DeusEx.WeaponPepperGun");
              			}                 
           		}
     	}
}

function Surprise()
{
   	if (localURL == "09_NYC_SHIP")
   	{    
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode161','Guards',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode162','Guards',-1.0,'Standing');
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode192','Guards',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode189','Guards',-1.0,'Standing');
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode190','Guards',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode60','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode59','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode74','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode75','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode76','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode48','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode39','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode95','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode52','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode51','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode54','Sailors',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Sailor','PathNode53','Sailors',-1.0);
   	}

   	else if (localURL == "09_NYC_SHIPBELOW")
   	{
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode1','mj12',-1.0,'Standing');
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode2','mj12',-1.0,'Standing');
        		SpawnExtraEnemy(Class'MIB','PathNode0','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode46','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode55','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode53','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode23','mj12',-1.0,'Standing',,true);
        		SpawnExtraActor(Class'MachineGunBase', 'PathNode159');
		if ( Level.Game.Difficulty == 3 )
		{
			SpawnExtraEnemy(Class'CleanerBot2','PathNode171','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode178','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode183','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode185','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode187','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode129','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode131','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode132','mj12',-1.0);
			SpawnExtraEnemy(Class'CleanerBot2','PathNode208','mj12',-1.0);
		}
   	}

   	else if (localURL == "09_NYC_SHIPFAN")
   	{
        		SpawnExtraEnemy(Class'Soldier','PathNode34','bots',-1.0,'DefendPosition',,true,"UNATCOTroop");
        		SpawnExtraEnemy(Class'Soldier','PathNode35','bots',-1.0,'DefendPosition',,true,"UNATCOTroop");
        		SpawnExtraEnemy(Class'Soldier','PathNode36','bots',-1.0,'DefendPosition',,true,"UNATCOTroop");
        		SpawnExtraEnemy(Class'Soldier','PathNode37','bots',-1.0,'DefendPosition',,true,"UNATCOTroop");
        		SpawnExtraEnemy(Class'Soldier','PathNode29','bots',-1.0,'DefendPosition',,true,"UNATCOTroop");
   	}

   	else if (localURL == "09_NYC_DOCKYARD")
   	{
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode211','bots',-1.0,'Standing');
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode144','bots',-1.0,'Standing');
        		SpawnExtraEnemy(Class'BadDenton','PathNode37','DockGuargs',-1.0);
        		SpawnExtraEnemy(Class'BadDenton','PathNode33','DockGuargs',-1.0);
        		SpawnExtraEnemy(Class'Soldier','PathNode144','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode69','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode67','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode250','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode65','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode58','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode55','DockGuargs',-1.0,'Standing');
        		SpawnExtraEnemy(Class'Soldier','PathNode247','DockGuargs',-1.0);
        		SpawnExtraEnemy(Class'Doberman','PathNode238','DockGuargs',-1.0);
        		SpawnExtraEnemy(Class'Doberman','PathNode249','DockGuargs',-1.0);
   	}    
}   

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponFlamethrower"
     WeaponClasses(1)="DeusEx.WeaponAssaultGun"
     WeaponClasses(2)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(3)="DeusEx.WeaponRifle"
     WeaponClasses(4)="DeusEx.WeaponGEPGun"
     WeaponClasses(5)="DeusEx.WeaponPistol"
     WeaponClasses(6)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(7)="DeusEx.WeaponHideAGun"
     WeaponClasses(8)="DeusEx.WeaponLAW"
}
